/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog.configurexml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jmri.CatalogTree;
import jmri.CatalogTreeLeaf;
import jmri.CatalogTreeManager;
import jmri.CatalogTreeNode;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalogTreeManagerXml
extends XmlFile {
    private static final String DEFAULT_FILE_NAME = String.valueOf(FileUtil.getUserFilesPath()) + "catalogTrees.xml";
    private static final Logger log = LoggerFactory.getLogger(DefaultCatalogTreeManagerXml.class);

    public void writeCatalogTrees() throws IOException {
        log.debug("entered writeCatalogTreeValues");
        CatalogTreeManager manager = InstanceManager.getDefault(CatalogTreeManager.class);
        SortedSet<CatalogTree> trees = manager.getNamedBeanSet();
        boolean found = false;
        for (CatalogTree tree : manager.getNamedBeanSet()) {
            String sname = tree.getSystemName();
            if (log.isDebugEnabled()) {
                log.debug("Tree: sysName= {}, userName= {}", (Object)sname, (Object)tree.getUserName());
                CatalogTreeNode root = tree.getRoot();
                log.debug("enumerateTree called for root= {}, has {} children", (Object)root, (Object)root.getChildCount());
                Enumeration<TreeNode> e = root.depthFirstEnumeration();
                while (e.hasMoreElements()) {
                    CatalogTreeNode n = (CatalogTreeNode)e.nextElement();
                    log.debug("nodeName= {} has {} leaves and {} subnodes.", new Object[]{n.getUserObject(), n.getLeaves().size(), n.getChildCount()});
                }
            }
            if (sname.charAt(1) != 'X') continue;
            found = true;
            break;
        }
        if (found) {
            Element root = new Element("catalogTrees");
            Document doc = DefaultCatalogTreeManagerXml.newDocument(root, String.valueOf(this.dtdLocation) + "catalogTree.dtd");
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", "text/xsl");
            m.put("href", "/xml/XSLT/panelfile.xsl");
            ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
            doc.addContent(0, (Content)p);
            this.store(root, trees);
            try {
                File file;
                if (!this.checkFile(DEFAULT_FILE_NAME) && !(file = new File(DEFAULT_FILE_NAME)).createNewFile()) {
                    log.error("createNewFile failed");
                }
                this.writeXML(this.findFile(DEFAULT_FILE_NAME), doc);
                InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(false);
            }
            catch (IOException ioe) {
                log.error("IO Exception writing CatalogTrees", (Throwable)ioe);
                throw ioe;
            }
        }
    }

    public void store(Element cat, Set<CatalogTree> trees) {
        cat.setAttribute("class", "jmri.jmrit.catalog.DefaultCatalogTreeManagerConfigXML");
        for (CatalogTree ct : trees) {
            String sname = ct.getSystemName();
            log.debug("system name is {}", (Object)sname);
            if (sname.charAt(1) != 'X') continue;
            Element elem = new Element("catalogTree");
            elem.setAttribute("systemName", sname);
            String uname = ct.getUserName();
            if (uname != null) {
                elem.setAttribute("userName", uname);
            }
            this.storeNode(elem, ct.getRoot());
            log.debug("store CatalogTree {}", (Object)sname);
            cat.addContent((Content)elem);
        }
    }

    public void storeNode(Element parent, CatalogTreeNode node) {
        log.debug("storeNode {}, has {} leaves.", (Object)node, (Object)node.getLeaves().size());
        Element element = new Element("node");
        element.setAttribute("nodeName", node.toString());
        ArrayList<CatalogTreeLeaf> leaves = node.getLeaves();
        for (CatalogTreeLeaf leaf : leaves) {
            Element el = new Element("leaf");
            el.setAttribute("name", leaf.getName());
            el.setAttribute("path", leaf.getPath());
            element.addContent((Content)el);
        }
        parent.addContent((Content)element);
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            CatalogTreeNode n = (CatalogTreeNode)e.nextElement();
            this.storeNode(element, n);
        }
    }

    public Element store(Object o) {
        return null;
    }

    public void readCatalogTrees() {
        log.debug("entered readCatalogTrees");
        try {
            if (this.checkFile(DEFAULT_FILE_NAME)) {
                Element root = this.rootFromName(DEFAULT_FILE_NAME);
                if (root != null) {
                    this.load(root);
                }
            } else {
                log.debug("File: {} not Found", (Object)DEFAULT_FILE_NAME);
            }
        }
        catch (IOException | JDOMException jde) {
            log.error("Exception reading CatalogTrees", jde);
        }
    }

    public boolean load(Element catalogTrees) {
        this.loadCatalogTrees(catalogTrees);
        return true;
    }

    public void loadCatalogTrees(Element catalogTrees) {
        List catList = catalogTrees.getChildren("catalogTree");
        log.debug("loadCatalogTrees: found {} CatalogTree objects", (Object)catList.size());
        CatalogTreeManager mgr = InstanceManager.getDefault(CatalogTreeManager.class);
        for (Element elem : catList) {
            Attribute attr = elem.getAttribute("systemName");
            if (attr == null) {
                log.warn("unexpected null systemName. elem= {}, attrs= {}", (Object)elem, (Object)elem.getAttributes());
                continue;
            }
            String sysName = attr.getValue();
            attr = elem.getAttribute("userName");
            if (attr == null) {
                log.warn("unexpected null userName. attrs= {}", (Object)elem.getAttributes());
                continue;
            }
            String userName = attr.getValue();
            CatalogTree ct = mgr.getBySystemName(sysName);
            if (ct != null) continue;
            try {
                ct = mgr.newCatalogTree(sysName, userName);
            }
            catch (IllegalArgumentException ex) {
                log.error("Could not create CatalogTree: {}", (Object)ex.getMessage());
                continue;
            }
            if (!(ct instanceof DefaultTreeModel)) continue;
            log.debug("CatalogTree: sysName= {}, userName= {}", (Object)sysName, (Object)userName);
            CatalogTreeNode root = ct.getRoot();
            elem = elem.getChild("node");
            this.loadNode(elem, root, (DefaultTreeModel)((Object)ct));
        }
    }

    public void loadNode(Element element, CatalogTreeNode parent, DefaultTreeModel model) {
        List nodeList = element.getChildren("node");
        log.debug("Found {} CatalogTreeNode objects", (Object)nodeList.size());
        int i = 0;
        while (i < nodeList.size()) {
            Element elem = (Element)nodeList.get(i);
            Attribute attr = elem.getAttribute("nodeName");
            if (attr == null) {
                log.warn("unexpected null nodeName. elem= {}, attrs= {}", (Object)elem, (Object)elem.getAttributes());
            } else {
                String nodeName = attr.getValue();
                CatalogTreeNode n = new CatalogTreeNode(nodeName);
                this.addLeaves(elem, n);
                model.insertNodeInto(n, parent, parent.getChildCount());
                this.loadNode(elem, n, model);
            }
            ++i;
        }
    }

    private void addLeaves(Element element, CatalogTreeNode node) {
        List leafList = element.getChildren("leaf");
        for (Element elem : leafList) {
            Attribute attr = elem.getAttribute("name");
            if (attr == null) {
                log.error("unexpected null leaf name. elem= {}, attrs= {}", (Object)elem, (Object)elem.getAttributes());
                continue;
            }
            String name = attr.getValue();
            attr = elem.getAttribute("path");
            if (attr == null) {
                log.error("unexpected null leaf path. elem= {}, attrs= {}", (Object)elem, (Object)elem.getAttributes());
                continue;
            }
            String path = attr.getValue();
            node.addLeaf(new CatalogTreeLeaf(name, path, 0));
        }
    }
}

