/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.util.FileUtil;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedIcon
extends ImageIcon {
    private static final String DEFAULTURL = "resources/icons/misc/X-red.gif";
    private String mName = null;
    private String mURL = null;
    private GIFMetadataImages mGifInfo = null;
    private final Image mDefaultImage;
    int mRotation;
    private int _degrees = 0;
    private double _scale = 1.0;
    private AffineTransform _transformS = new AffineTransform();
    private AffineTransform _transformF = new AffineTransform();
    public static final int NOFLIP = 0;
    public static final int HORIZONTALFLIP = 1;
    public static final int VERTICALFLIP = 2;
    private static final Logger log = LoggerFactory.getLogger(NamedIcon.class);

    public NamedIcon(NamedIcon pOld) {
        this(pOld.mURL, pOld.mName, pOld.mGifInfo);
    }

    public NamedIcon(NamedIcon pOld, Component comp) {
        this(pOld.mURL, pOld.mName, pOld.mGifInfo);
        this.setLoad(pOld._degrees, pOld._scale, comp);
        this.setRotation(pOld.mRotation, comp);
    }

    public NamedIcon(String pUrl, String pName) {
        this(pUrl, pName, null);
        try {
            int numFrames;
            GIFMetadataImages gifState = new GIFMetadataImages();
            Iterator<ImageReader> rIter = ImageIO.getImageReadersByFormatName("gif");
            ImageReader gifReader = rIter.next();
            InputStream is = FileUtil.findInputStream(pUrl);
            if (is == null) {
                log.warn("NamedIcon can't scan {} for animated status", (Object)pUrl);
                return;
            }
            ImageInputStream iis = ImageIO.createImageInputStream(is);
            gifReader.setInput(iis, false);
            ImageReaderSpi spiProv = gifReader.getOriginatingProvider();
            if (spiProv != null && spiProv.canDecodeInput(iis) && (numFrames = gifReader.getNumImages(true)) > 1) {
                gifState.mStreamMd = gifReader.getStreamMetadata();
                gifState.mFrames = new IIOImage[numFrames];
                gifState.mWidth = 0;
                gifState.mHeight = 0;
                int i = 0;
                while (i < numFrames) {
                    ((GIFMetadataImages)gifState).mFrames[i] = gifReader.readAll(i, null);
                    RenderedImage image = gifState.mFrames[i].getRenderedImage();
                    gifState.mHeight = Math.max(gifState.mHeight, image.getHeight());
                    gifState.mWidth = Math.max(gifState.mWidth, image.getWidth());
                    ++i;
                }
                this.mGifInfo = gifState;
            }
        }
        catch (IOException ioe) {
            log.debug("Exception extracting GIF Info: ", (Throwable)ioe);
            this.mGifInfo = null;
        }
    }

    public NamedIcon(String pUrl, String pName, GIFMetadataImages pGifState) {
        super(NamedIcon.substituteDefaultUrl(pUrl));
        URL u = FileUtil.findURL(pUrl);
        if (u == null) {
            log.warn("Could not load image from {} (file does not exist)", (Object)pUrl);
        }
        this.mDefaultImage = this.getImage();
        if (this.mDefaultImage == null) {
            log.warn("Could not load image from {} (image is null)", (Object)pUrl);
        }
        this.mName = pName;
        this.mGifInfo = pGifState;
        this.mURL = FileUtil.getPortableFilename(pUrl);
        this.mRotation = 0;
    }

    private static URL substituteDefaultUrl(String pUrl) {
        URL url = FileUtil.findURL(pUrl);
        if (url == null) {
            url = FileUtil.findURL(DEFAULTURL);
            log.error("Did not find \"{}\" for NamedIcon, substitute {}", (Object)pUrl, (Object)url);
        }
        return url;
    }

    public NamedIcon(URL pUrl, String pName) {
        this(pUrl.toString(), pName);
    }

    public NamedIcon(Image im) {
        super(im);
        this.mDefaultImage = this.getImage();
    }

    public static NamedIcon getIconByName(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        if (FileUtil.findURL(path) == null) {
            return null;
        }
        return new NamedIcon(path, path);
    }

    @CheckForNull
    public String getName() {
        return this.mName;
    }

    public void setName(@CheckForNull String name) {
        this.mName = name;
    }

    @CheckForNull
    public String getURL() {
        return this.mURL;
    }

    public void setURL(@CheckForNull String url) {
        this.mURL = url;
    }

    public int getRotation() {
        return this.mRotation;
    }

    public void setRotation(int pRotation, Component comp) {
        if (pRotation == 0) {
            return;
        }
        if (pRotation > 3) {
            pRotation = 0;
        }
        if (pRotation < 0) {
            pRotation = 3;
        }
        this.mRotation = pRotation;
        this.setImage(this.createRotatedImage(this.mDefaultImage, comp, this.mRotation));
        this._degrees = 0;
        if (Math.abs(this._scale - 1.0) > 1.0E-5) {
            int w = (int)Math.ceil(this._scale * (double)this.getIconWidth());
            int h = (int)Math.ceil(this._scale * (double)this.getIconHeight());
            this.transformImage(w, h, this._transformS, comp);
        }
    }

    public Image createRotatedImage(Image pImage, Component pComponent, int pRotation) {
        log.debug("createRotatedImage: pRotation= {}, mRotation= {}", (Object)pRotation, (Object)this.mRotation);
        if (pRotation == 0) {
            return pImage;
        }
        MediaTracker mt = new MediaTracker(pComponent);
        mt.addImage(pImage, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        int w = pImage.getWidth(null);
        int h = pImage.getHeight(null);
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(pImage, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        int[] newPixels = new int[w * h];
        MemoryImageSource imageSource = null;
        switch (pRotation) {
            case 1: {
                int y = 0;
                while (y < h) {
                    int x = 0;
                    while (x < w) {
                        newPixels[x * h + y] = pixels[y * w + (w - 1 - x)];
                        ++x;
                    }
                    ++y;
                }
                imageSource = new MemoryImageSource(h, w, ColorModel.getRGBdefault(), newPixels, 0, h);
                break;
            }
            case 2: {
                int y = 0;
                while (y < h) {
                    int x = 0;
                    while (x < w) {
                        newPixels[x * h + y] = pixels[(w - 1 - x) * h + (h - 1 - y)];
                        ++x;
                    }
                    ++y;
                }
                imageSource = new MemoryImageSource(w, h, ColorModel.getRGBdefault(), newPixels, 0, w);
                break;
            }
            case 3: {
                int y = 0;
                while (y < h) {
                    int x = 0;
                    while (x < w) {
                        newPixels[x * h + y] = pixels[(h - 1 - y) * w + x];
                        ++x;
                    }
                    ++y;
                }
                imageSource = new MemoryImageSource(h, w, ColorModel.getRGBdefault(), newPixels, 0, h);
                break;
            }
            default: {
                log.warn("Unhandled rotation code: {}", (Object)pRotation);
            }
        }
        Image myImage = pComponent.createImage(imageSource);
        mt.addImage(myImage, 1);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        return myImage;
    }

    public int getDegrees() {
        return this._degrees;
    }

    public double getScale() {
        return this._scale;
    }

    public void setLoad(int d, double s, Component comp) {
        if (d != 0 || s != 1.0) {
            this.setImage(this.createRotatedImage(this.mDefaultImage, comp, 0));
        }
        this._scale = s;
        this._transformS = AffineTransform.getScaleInstance(s, s);
        this.rotate(d, comp);
    }

    public void transformImage(int w, int h, AffineTransform t, Component comp) {
        if (w <= 0 || h <= 0) {
            if (comp instanceof Positionable) {
                log.debug("transformImage bad coords {}", (Object)((Positionable)((Object)comp)).getNameString());
            }
            return;
        }
        if (this.mGifInfo == null) {
            this.setImage(this.transformFrame(this.getImage(), w, h, t, comp));
        } else {
            try {
                String streamFormat = this.mGifInfo.mStreamMd.getNativeMetadataFormatName();
                IIOMetadataNode streamTree = (IIOMetadataNode)this.mGifInfo.mStreamMd.getAsTree(streamFormat);
                IIOMetadataNode logicalScreenDesc = NamedIcon.getNode("LogicalScreenDescriptor", streamTree);
                logicalScreenDesc.setAttribute("logicalScreenWidth", "" + w);
                logicalScreenDesc.setAttribute("logicalScreenHeight", "" + h);
                ByteArrayOutputStream oStream = new ByteArrayOutputStream();
                Iterator<ImageWriter> wIter = ImageIO.getImageWritersByFormatName("gif");
                ImageWriter writer = wIter.next();
                ImageOutputStream ios = ImageIO.createImageOutputStream(oStream);
                writer.setOutput(ios);
                IIOMetadata newStreamMd = writer.getDefaultStreamMetadata(null);
                newStreamMd.setFromTree(streamFormat, streamTree);
                writer.prepareWriteSequence(newStreamMd);
                int i = 0;
                while (i < this.mGifInfo.mFrames.length) {
                    IIOMetadataNode colorTable;
                    BufferedImage image = (BufferedImage)this.mGifInfo.mFrames[i].getRenderedImage();
                    ImageTypeSpecifier imgType = new ImageTypeSpecifier(image);
                    IIOMetadata imageMd = this.mGifInfo.mFrames[i].getMetadata();
                    BufferedImage bufIm = this.transformFrame(image, w, h, t, comp);
                    String imageFormat = imageMd.getNativeMetadataFormatName();
                    IIOMetadataNode imageMdTree = (IIOMetadataNode)imageMd.getAsTree(imageFormat);
                    IIOMetadataNode imageDesc = NamedIcon.getNode("ImageDescriptor", imageMdTree);
                    if (imageDesc != null) {
                        imageDesc.setAttribute("imageWidth", "" + w);
                        imageDesc.setAttribute("imageHeight", "" + h);
                    }
                    if ((colorTable = NamedIcon.getNode("LocalColorTable", imageMdTree)) != null) {
                        imageMdTree.removeChild(colorTable);
                    }
                    IIOMetadata newImageMd = writer.getDefaultImageMetadata(imgType, null);
                    newImageMd.setFromTree(imageFormat, imageMdTree);
                    IIOImage newImage = new IIOImage(bufIm, null, newImageMd);
                    writer.writeToSequence(newImage, null);
                    ++i;
                }
                writer.endWriteSequence();
                ios.close();
                ImageIcon imageIcon = new ImageIcon(oStream.toByteArray());
                this.setImage(imageIcon.getImage());
            }
            catch (IOException ioe) {
                log.error("Exception rotating animated GIF Image: ", (Throwable)ioe);
            }
        }
    }

    private BufferedImage transformFrame(Image frame, int w, int h, AffineTransform t, Component comp) {
        BufferedImage bufIm = new BufferedImage(w, h, 2);
        Graphics2D g2d = bufIm.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.drawImage(frame, t, comp);
        g2d.dispose();
        return bufIm;
    }

    private static IIOMetadataNode getNode(String name, IIOMetadataNode root) {
        int i = 0;
        while (i < root.getLength()) {
            if (root.item(i).getNodeName().compareToIgnoreCase(name) == 0) {
                return (IIOMetadataNode)root.item(i);
            }
            ++i;
        }
        return null;
    }

    public void scale(double scale, Component comp) {
        this._scale = scale;
        this._transformS = AffineTransform.getScaleInstance(scale, scale);
        this.rotate(this._degrees, comp);
    }

    public void rotate(int degree, Component comp) {
        this.setImage(this.mDefaultImage);
        this.mRotation = 0;
        this._degrees = MathUtil.wrap(degree, 0, 360);
        if (this._degrees == 0) {
            if (Math.abs(this._scale - 1.0) > 1.0E-5) {
                int w = (int)Math.ceil(this._scale * (double)this.getIconWidth());
                int h = (int)Math.ceil(this._scale * (double)this.getIconHeight());
                this.transformImage(w, h, this._transformS, comp);
            }
            return;
        }
        double rad = Math.toRadians(this._degrees);
        double w = this.getIconWidth();
        double h = this.getIconHeight();
        int width = (int)Math.ceil(Math.abs(h * this._scale * Math.sin(rad)) + Math.abs(w * this._scale * Math.cos(rad)));
        int heigth = (int)Math.ceil(Math.abs(h * this._scale * Math.cos(rad)) + Math.abs(w * this._scale * Math.sin(rad)));
        AffineTransform t = this._degrees < 90 ? AffineTransform.getTranslateInstance(h * Math.sin(rad), 0.0) : (this._degrees < 180 ? AffineTransform.getTranslateInstance(h * Math.sin(rad) - w * Math.cos(rad), -h * Math.cos(rad)) : (this._degrees < 270 ? AffineTransform.getTranslateInstance(-w * Math.cos(rad), -w * Math.sin(rad) - h * Math.cos(rad)) : AffineTransform.getTranslateInstance(0.0, -w * Math.sin(rad))));
        if (Math.abs(this._scale - 1.0) > 1.0E-5) {
            t.preConcatenate(this._transformS);
        }
        AffineTransform r = AffineTransform.getRotateInstance(rad);
        t.concatenate(r);
        this.transformImage(width, heigth, t, comp);
        if (comp instanceof PositionableLabel) {
            ((PositionableLabel)comp).setDegrees(this._degrees);
        }
    }

    public double reduceTo(int width, int height, double limit) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        double scale = 1.0;
        if (w > width) {
            scale = (double)width / (double)w;
        }
        if (h > height) {
            scale = Math.min(scale, (double)height / (double)h);
        }
        if (scale < 1.0) {
            if (limit > 0.0) {
                scale = Math.max(scale, limit);
            }
            AffineTransform t = AffineTransform.getScaleInstance(scale, scale);
            this.transformImage((int)Math.ceil(scale * (double)w), (int)Math.ceil(scale * (double)h), t, null);
        }
        return scale;
    }

    public void flip(int flip, Component comp) {
        if (flip == 0) {
            this.setImage(this.mDefaultImage);
            this._transformF = new AffineTransform();
            this._degrees = 0;
            int w = (int)Math.ceil(this._scale * (double)this.getIconWidth());
            int h = (int)Math.ceil(this._scale * (double)this.getIconHeight());
            this.transformImage(w, h, this._transformF, comp);
            return;
        }
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        if (flip == 1) {
            this._transformF = AffineTransform.getScaleInstance(-1.0, 1.0);
            this._transformF.translate(-w, 0.0);
        } else {
            this._transformF = AffineTransform.getScaleInstance(1.0, -1.0);
            this._transformF.translate(0.0, -h);
        }
        this.transformImage(w, h, this._transformF, null);
    }

    private static class GIFMetadataImages {
        private int mHeight;
        private int mWidth;
        private IIOImage[] mFrames = null;
        private IIOMetadata mStreamMd;

        private GIFMetadataImages() {
        }
    }
}

