/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jmri.CatalogTree;
import jmri.CatalogTreeManager;
import jmri.CatalogTreeNode;
import jmri.InstanceManager;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrit.catalog.Bundle;
import jmri.jmrit.catalog.CatalogPanel;
import jmri.jmrit.catalog.DirectorySearcher;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageIndexEditor
extends JmriJFrame {
    private static final String RESOURCES = "resources";
    private static final String MESSAGE_TITLE = "MessageTitle";
    private CatalogPanel _index;
    private JTree _indexTree;
    public static final String IconDataFlavorMime = "application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon";
    private static final Logger log = LoggerFactory.getLogger(ImageIndexEditor.class);

    private ImageIndexEditor() {
    }

    private ImageIndexEditor(String name) {
        super(name);
    }

    private void init() {
        JMenuBar menuBar = new JMenuBar();
        JMenu findIcon = new JMenu(Bundle.getMessage("MenuFile"));
        menuBar.add(findIcon);
        JMenuItem storeItem = new JMenuItem(Bundle.getMessage("MIStoreImageIndex"));
        findIcon.add(storeItem);
        storeItem.addActionListener(event -> InstanceManager.getDefault(CatalogTreeManager.class).storeImageIndex());
        findIcon.addSeparator();
        JMenuItem openItem = new JMenuItem(Bundle.getMessage("openDirMenu"));
        openItem.addActionListener(e -> InstanceManager.getDefault(DirectorySearcher.class).openDirectory());
        findIcon.add(openItem);
        JMenuItem searchItem = new JMenuItem(Bundle.getMessage("searchFSMenu"));
        searchItem.addActionListener(e -> InstanceManager.getDefault(DirectorySearcher.class).searchFS());
        findIcon.add(searchItem);
        JMenu editMenu = new JMenu(Bundle.getMessage("MenuEdit"));
        menuBar.add(editMenu);
        this.addMenuItems(editMenu, null);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.catalog.ImageIndex", true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel labelPanel = new JPanel();
        labelPanel.add(new JLabel(Bundle.getMessage("dragIconsInstr"), 2));
        mainPanel.add(labelPanel);
        JPanel catalogsPanel = new JPanel();
        catalogsPanel.setLayout(new BoxLayout(catalogsPanel, 0));
        JSplitPane splitPane = new JSplitPane(1, this.makeCatalogPanel(), this.makeIndexPanel());
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        catalogsPanel.add(splitPane);
        mainPanel.add(catalogsPanel);
        this.getContentPane().add(mainPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InstanceManager.getDefault(DirectorySearcher.class).close();
            }
        });
        this.setLocation(10, 200);
        this.pack();
        this.setVisible(true);
    }

    private JPanel makeCatalogPanel() {
        CatalogPanel _catalog = CatalogPanel.makeCatalog("defaultCatalog", "selectNode", true, false, true);
        log.debug("init the new CatalogPanel for ImageIndexEditor.makeCatalogPanel()");
        CatalogTreeManager manager = InstanceManager.getDefault(CatalogTreeManager.class);
        for (CatalogTree tree : manager.getNamedBeanSet()) {
            if (!tree.getSystemName().startsWith("IF")) continue;
            _catalog.addTree(tree);
            log.debug("added item to tree");
        }
        _catalog.createNewBranch("IFJAR", "Program Directory", RESOURCES);
        FileUtil.createDirectory(String.valueOf(FileUtil.getUserFilesPath()) + RESOURCES);
        _catalog.createNewBranch("IFPREF", "Preferences Directory", String.valueOf(FileUtil.getUserFilesPath()) + RESOURCES);
        return _catalog;
    }

    private void showTreePopUp(MouseEvent evt) {
        int row = this._indexTree.getRowForLocation(evt.getX(), evt.getY());
        if (row <= 0) {
            return;
        }
        TreePath path = this._indexTree.getPathForLocation(evt.getX(), evt.getY());
        String nodeName = path.getLastPathComponent().toString();
        log.debug("showTreePopUp node= {}", (Object)nodeName);
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem(nodeName));
        popup.add(new JPopupMenu.Separator());
        this.addMenuItems(popup, (CatalogTreeNode)path.getLastPathComponent());
        popup.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void addMenuItems(JComponent editMenu, CatalogTreeNode node) {
        JMenuItem addItem = new JMenuItem(Bundle.getMessage("addNode"));
        addItem.addActionListener(e -> this.addNode(node));
        editMenu.add(addItem);
        JMenuItem renameItem = new JMenuItem(Bundle.getMessage("renameNode"));
        renameItem.addActionListener(e -> this.renameNode(node));
        editMenu.add(renameItem);
        JMenuItem deleteItem = new JMenuItem(Bundle.getMessage("deleteNode"));
        deleteItem.addActionListener(e -> this.deleteNode(node));
        editMenu.add(deleteItem);
    }

    private JPanel makeIndexPanel() {
        this._index = CatalogPanel.makeCatalog("ImageIndex", "selectIndexNode", true, true, false);
        log.debug("init the new CatalogPanel for ImageIndexEditor.makeIndexPanel()");
        boolean found = false;
        CatalogTreeManager manager = InstanceManager.getDefault(CatalogTreeManager.class);
        for (CatalogTree tree : manager.getNamedBeanSet()) {
            if (!tree.getSystemName().startsWith("IX")) continue;
            this._index.addTree(tree);
            found = true;
        }
        if (!found) {
            this._index.createNewBranch("IXII", Bundle.getMessage("ImageIndexRoot"), "ImageIndexRoot");
        }
        this._indexTree = this._index.getTree();
        this._indexTree.setSelectionRow(0);
        this._indexTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || e.isMetaDown() || e.isAltDown()) {
                    ImageIndexEditor.this.showTreePopUp(e);
                }
            }
        });
        return this._index;
    }

    void addNode(CatalogTreeNode selectedNode) {
        if (selectedNode == null) {
            selectedNode = this._index.getSelectedNode();
        }
        if (selectedNode == null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("selectAddNode"), Bundle.getMessage(MESSAGE_TITLE), 1);
        } else {
            String name = JOptionPane.showInputDialog(this, Bundle.getMessage("nameAddNode"), Bundle.getMessage("QuestionTitle"), 3);
            if (name != null && !this._index.insertNodeIntoModel(name, selectedNode)) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("duplicateNodeName", name), Bundle.getMessage("ErrorTitle"), 0);
            }
        }
        this.invalidate();
    }

    private void renameNode(CatalogTreeNode selectedNode) {
        if (selectedNode == null) {
            selectedNode = this._index.getSelectedNode();
        }
        if (selectedNode == null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("selectRenameNode"), Bundle.getMessage(MESSAGE_TITLE), 1);
        } else {
            String name = JOptionPane.showInputDialog(this, Bundle.getMessage("newNameNode"), selectedNode.getUserObject());
            if (name != null && !this._index.renameNode(selectedNode, name)) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("duplicateNodeName", name), Bundle.getMessage("ErrorTitle"), 0);
            }
        }
        this.invalidate();
    }

    private void deleteNode(CatalogTreeNode selectedNode) {
        if (selectedNode == null) {
            selectedNode = this._index.getSelectedNode();
        }
        if (selectedNode == null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("selectDeleteNode"), Bundle.getMessage(MESSAGE_TITLE), 1);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("delete node \"{}\" level= {}.", (Object)selectedNode, (Object)selectedNode.getLevel());
        }
        if (selectedNode.getLevel() <= 1) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("deleteRootNode"), Bundle.getMessage(MESSAGE_TITLE), 1);
        } else {
            int numNodes = this.countSubNodes(selectedNode);
            int numIcons = this.countIcons(selectedNode);
            int response = JOptionPane.showConfirmDialog(this, Bundle.getMessage("confirmDeleteNode", selectedNode.getUserObject(), numNodes, numIcons), Bundle.getMessage("QuestionTitle"), 0, 3);
            if (response == 0) {
                CatalogTreeNode parent = (CatalogTreeNode)selectedNode.getParent();
                this._index.removeNodeFromModel(selectedNode);
                this._index.setSelectedNode(parent);
            }
        }
    }

    int countSubNodes(CatalogTreeNode node) {
        int cnt = 0;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            CatalogTreeNode n = (CatalogTreeNode)e.nextElement();
            cnt += this.countSubNodes(n) + 1;
        }
        return cnt;
    }

    private int countIcons(CatalogTreeNode node) {
        int cnt = 0;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            CatalogTreeNode n = (CatalogTreeNode)e.nextElement();
            cnt += this.countIcons(n);
        }
        return cnt += node.getNumLeaves();
    }

    /* synthetic */ ImageIndexEditor(String string, ImageIndexEditor imageIndexEditor) {
        this(string);
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(ImageIndexEditor.class)) {
                ImageIndexEditor instance = new ImageIndexEditor(Bundle.getMessage("editIndexFrame"), null);
                instance.init();
                return instance;
            }
            return super.getDefault(type);
        }

        @Override
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(ImageIndexEditor.class);
            return set;
        }
    }
}

