/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.IOException;
import javax.swing.JLabel;
import jmri.jmrit.catalog.NamedIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragJLabel
extends JLabel
implements DragGestureListener,
DragSourceListener,
Transferable {
    protected DataFlavor _dataFlavor;
    private static final Logger log = LoggerFactory.getLogger(DragJLabel.class);

    public DragJLabel(DataFlavor flavor) {
        this.init(flavor);
    }

    public DragJLabel(DataFlavor flavor, NamedIcon icon) {
        super(icon);
        this.init(flavor);
    }

    public DragJLabel(DataFlavor flavor, String text) {
        super(text);
        this.init(flavor);
    }

    private void init(DataFlavor flavor) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this._dataFlavor = flavor;
    }

    protected boolean okToDrag() {
        return true;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        log.debug("DragJLabel.dragGestureRecognized ");
        if (this.okToDrag()) {
            e.startDrag(DragSource.DefaultCopyDrop, this, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        log.debug("DragJLabel.dragDropEnd ");
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this._dataFlavor, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return true;
        }
        return this._dataFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        log.debug("DragJLabel.getTransferData ");
        if (this._dataFlavor.equals(flavor)) {
            return this.getIcon();
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            NamedIcon icon = (NamedIcon)this.getIcon();
            return icon.getURL();
        }
        return null;
    }
}

