/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import jmri.CatalogTreeManager;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.catalog.Bundle;
import jmri.jmrit.catalog.PreviewDialog;
import jmri.util.ThreadingUtil;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectorySearcher
implements InstanceManagerAutoDefault {
    private JFileChooser _directoryChooser = null;
    PreviewDialog _previewDialog = null;
    Seacher _searcher;
    JFrame _waitDialog;
    JLabel _waitText;
    private static final Logger log = LoggerFactory.getLogger(DirectorySearcher.class);

    public static DirectorySearcher instance() {
        return InstanceManager.getDefault(DirectorySearcher.class);
    }

    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="false postive, guarded by logic")
    private File getDirectory(String msg, boolean recurse) {
        File dir;
        if (this._directoryChooser == null) {
            this._directoryChooser = new JFileChooser(FileSystemView.getFileSystemView());
            this._directoryChooser.setFileFilter(new FileNameExtensionFilter("Graphics Files", CatalogTreeManager.IMAGE_FILTER));
        }
        this._directoryChooser.setDialogTitle(Bundle.getMessage(msg));
        this._directoryChooser.rescanCurrentDirectory();
        this._directoryChooser.setFileSelectionMode(1);
        block4: while (true) {
            int retVal;
            if ((retVal = this._directoryChooser.showOpenDialog(null)) != 0) {
                return null;
            }
            dir = this._directoryChooser.getSelectedFile();
            if (dir == null) continue;
            if (!recurse) {
                return dir;
            }
            int cnt = DirectorySearcher.numImageFiles(dir);
            if (cnt > 0) {
                return dir;
            }
            int choice = JOptionPane.showOptionDialog(null, Bundle.getMessage("NoImagesInDir", dir), Bundle.getMessage("QuestionTitle"), -1, 3, null, new String[]{Bundle.getMessage("ButtonStop"), Bundle.getMessage("ButtonKeepLooking")}, 1);
            switch (choice) {
                case 0: {
                    return null;
                }
                case 1: {
                    this._directoryChooser.setCurrentDirectory(dir);
                    continue block4;
                }
            }
            break;
        }
        return dir;
    }

    protected static int numImageFiles(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < files.length) {
            String ext = FilenameUtils.getExtension((String)files[i].getName());
            int k = 0;
            while (k < CatalogTreeManager.IMAGE_FILTER.length) {
                if (ext != null && ext.equalsIgnoreCase(CatalogTreeManager.IMAGE_FILTER[k])) {
                    ++count;
                }
                ++k;
            }
            ++i;
        }
        return count;
    }

    private void showWaitFrame(String msgkey, File dir) {
        if (this._waitDialog == null) {
            this._waitDialog = new JFrame();
            this._waitDialog.setUndecorated(true);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true));
            panel.add(new JLabel(Bundle.getMessage("waitWarning")));
            this._waitText = new JLabel();
            panel.add(this._waitText);
            panel.setBackground(this._waitText.getBackground());
            this._waitDialog.getContentPane().add(panel);
            this._waitDialog.setLocationRelativeTo(null);
            this._waitDialog.setVisible(false);
        }
        if (dir != null) {
            this._waitText.setText(Bundle.getMessage(msgkey, dir.getName()));
            this._waitDialog.setVisible(true);
            this._waitDialog.pack();
            this._waitDialog.toFront();
        }
    }

    private void closeWaitFrame() {
        if (this._waitDialog != null) {
            this._waitDialog.dispose();
            this._waitDialog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSearch() {
        if (this._previewDialog != null) {
            this._previewDialog.dispose();
        }
        if (this._searcher != null) {
            Seacher seacher = this._searcher;
            synchronized (seacher) {
                this._searcher.notify();
            }
        }
    }

    public void openDirectory() {
        this.clearSearch();
        File dir = this.getDirectory("openDirMenu", true);
        if (dir != null) {
            this.doPreviewDialog(dir, new MActionListener(dir, true), null, new CActionListener(), 0);
            this.closeWaitFrame();
        }
    }

    public void searchFS() {
        this.clearSearch();
        File dir = this.getDirectory("searchFSMenu", false);
        this.showWaitFrame("searchWait", dir);
        if (dir != null) {
            this._searcher = new Seacher(dir);
            this._searcher.start();
        }
    }

    void searcherDone(File dir, int count) {
        if (this._previewDialog != null) {
            this._previewDialog.dispose();
        }
        this.closeWaitFrame();
        JOptionPane.showMessageDialog(null, Bundle.getMessage("numFound", count, dir.getAbsolutePath()), Bundle.getMessage("MessageTitle"), 1);
    }

    private void doPreviewDialog(File dir, ActionListener moreAction, ActionListener lookAction, ActionListener cancelAction, int startNum) {
        this.showWaitFrame("previewWait", dir);
        if (log.isDebugEnabled()) {
            log.debug("doPreviewDialog dir= {}", (Object)dir.getAbsolutePath());
        }
        this._previewDialog = new PreviewDialog(null, "previewDir", dir, CatalogTreeManager.IMAGE_FILTER);
        this._previewDialog.init(moreAction, lookAction, cancelAction, startNum);
        this._waitDialog.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayMore(File dir, boolean oneDir) {
        if (log.isDebugEnabled()) {
            log.debug("displayMore: dir= {} has {} files", (Object)dir.getName(), (Object)DirectorySearcher.numImageFiles(dir));
        }
        if (this._previewDialog != null) {
            int numFilesShown = this._previewDialog.getNumFilesShown();
            ActionListener lookAction = this._previewDialog.getLookActionListener();
            this._previewDialog.dispose();
            if (numFilesShown > 0) {
                this.doPreviewDialog(dir, new MActionListener(dir, oneDir), lookAction, new CActionListener(), numFilesShown);
            }
        } else {
            Seacher seacher = this._searcher;
            synchronized (seacher) {
                this._searcher.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepLooking(File dir) {
        if (log.isDebugEnabled()) {
            log.debug("keepLooking: dir= {} has {} files", (Object)dir.getName(), (Object)DirectorySearcher.numImageFiles(dir));
        }
        if (this._previewDialog != null) {
            this._previewDialog.dispose();
            this._previewDialog = null;
        }
        if (this._searcher != null) {
            Seacher seacher = this._searcher;
            synchronized (seacher) {
                this._searcher.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelLooking() {
        this.closeWaitFrame();
        if (this._previewDialog != null) {
            this._previewDialog.dispose();
            this._previewDialog = null;
        }
        if (this._searcher != null) {
            Seacher seacher = this._searcher;
            synchronized (seacher) {
                this._searcher.quit();
                this._searcher.notify();
            }
        }
    }

    public void close() {
        this.closeWaitFrame();
        this.cancelLooking();
    }

    class CActionListener
    implements ActionListener {
        CActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            DirectorySearcher.this.cancelLooking();
        }
    }

    class LActionListener
    implements ActionListener {
        File dir;

        public LActionListener(File d) {
            this.dir = d;
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            DirectorySearcher.this.keepLooking(this.dir);
        }
    }

    class MActionListener
    implements ActionListener {
        File dir;
        boolean oneDir;

        public MActionListener(File d, boolean o) {
            this.dir = d;
            this.oneDir = o;
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            DirectorySearcher.this.displayMore(this.dir, this.oneDir);
        }
    }

    class Seacher
    extends Thread {
        File dir;
        boolean quit = false;
        int count;

        Seacher(File d) {
            this.dir = d;
        }

        void quit() {
            this.quit = true;
        }

        @Override
        public void run() {
            this.getImageDirectory(this.dir, CatalogTreeManager.IMAGE_FILTER);
            if (log.isDebugEnabled()) {
                log.debug("Searcher done for directory {}  quit={}", (Object)this.dir.getAbsolutePath(), (Object)this.quit);
            }
            ThreadingUtil.runOnGUI(() -> DirectorySearcher.this.searcherDone(this.dir, this.count));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"WA_NOT_IN_LOOP", "UW_UNCOND_WAIT"}, justification="Waiting for single possible event")
        private void getImageDirectory(File dir, String[] filter) {
            File[] files;
            if (ThreadingUtil.isGUIThread() || ThreadingUtil.isLayoutThread()) {
                log.error("getImageDirectory called on wrong thread");
            }
            if ((files = dir.listFiles()) == null || this.quit) {
                return;
            }
            int cnt = DirectorySearcher.numImageFiles(dir);
            if (log.isDebugEnabled()) {
                log.debug("getImageDirectory dir= {} has {} files", (Object)dir.getAbsolutePath(), (Object)cnt);
            }
            this.count += cnt;
            if (cnt > 0) {
                ThreadingUtil.runOnGUI(() -> DirectorySearcher.this.doPreviewDialog(dir, new MActionListener(dir, false), new LActionListener(dir), new CActionListener(), 0));
                Seacher seacher = this;
                synchronized (seacher) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        log.error("InterruptedException at _waitForSync {}", (Throwable)ie);
                    }
                    catch (IllegalArgumentException iae) {
                        log.error("IllegalArgumentException {}", (Throwable)iae);
                    }
                }
            }
            int k = 0;
            while (k < files.length) {
                if (files[k].isDirectory()) {
                    if (this.quit) {
                        return;
                    }
                    File f = files[k];
                    ThreadingUtil.runOnGUI(() -> DirectorySearcher.this.showWaitFrame("searchWait", f));
                    this.getImageDirectory(files[k], filter);
                }
                ++k;
            }
        }
    }
}

