/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jmri.InstanceManagerAutoDefault;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogTreeModel
extends DefaultTreeModel
implements InstanceManagerAutoDefault {
    DefaultMutableTreeNode dRoot = (DefaultMutableTreeNode)super.getRoot();
    static final String resourceRoot = "resources";
    static final String fileRoot = FileUtil.getUserResourcePath();
    private static final Logger log = LoggerFactory.getLogger(CatalogTreeModel.class);

    public CatalogTreeModel() {
        super(new DefaultMutableTreeNode("Root"));
        this.insertResourceNodes(resourceRoot, resourceRoot, this.dRoot);
        FileUtil.createDirectory(FileUtil.getUserResourcePath());
        this.insertFileNodes("files", fileRoot, this.dRoot);
    }

    void insertResourceNodes(String pName, String pPath, DefaultMutableTreeNode pParent) {
        File fp = new File(pPath);
        if (!fp.exists()) {
            return;
        }
        if (fp.getName().startsWith(".")) {
            return;
        }
        if (fp.getName().equals("CVS")) {
            return;
        }
        DefaultMutableTreeNode newElement = new DefaultMutableTreeNode(pName);
        this.insertNodeInto(newElement, pParent, pParent.getChildCount());
        if (fp.isDirectory()) {
            String[] sp = fp.list();
            if (sp == null) {
                log.warn("unexpected null list() in insertResourceNodes from \"{}\"", (Object)pPath);
                return;
            }
            String[] stringArray = sp;
            int n = sp.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                log.trace("Descend into resource: {}", (Object)item);
                this.insertResourceNodes(item, String.valueOf(pPath) + "/" + item, newElement);
                ++n2;
            }
        }
    }

    void insertFileNodes(String name, String path, DefaultMutableTreeNode parent) {
        String[] sp;
        File fp = new File(path);
        if (!fp.exists()) {
            return;
        }
        if (fp.getName().startsWith(".")) {
            return;
        }
        if (fp.getName().equals("CVS")) {
            return;
        }
        DefaultMutableTreeNode newElement = new DefaultMutableTreeNode(name);
        this.insertNodeInto(newElement, parent, parent.getChildCount());
        if (fp.isDirectory() && (sp = fp.list()) != null) {
            String[] stringArray = sp;
            int n = sp.length;
            int n2 = 0;
            while (n2 < n) {
                String sp1 = stringArray[n2];
                log.debug("Descend into file: {}", (Object)sp1);
                this.insertFileNodes(sp1, String.valueOf(path) + "/" + sp1, newElement);
                ++n2;
            }
        }
    }
}

