/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import jmri.CatalogTreeNode;
import jmri.jmrit.catalog.AbstractCatalogTree;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogTreeFS
extends AbstractCatalogTree {
    String[] _filter;
    int count = 0;
    int leafcount = 0;
    HashMap<String, Object> parameters = null;
    private static final Logger log = LoggerFactory.getLogger(CatalogTreeFS.class);

    public CatalogTreeFS(String sysName, String userName) {
        super(sysName, userName);
    }

    public void setFilter(String[] filter) {
        this._filter = new String[filter.length];
        int i = 0;
        while (i < filter.length) {
            this._filter[i] = filter[i];
            ++i;
        }
    }

    public String[] getFilter() {
        String[] filter = new String[this._filter.length];
        int i = 0;
        while (i < this._filter.length) {
            filter[i] = this._filter[i];
            ++i;
        }
        return filter;
    }

    boolean filter(String ext) {
        if (ext == null) {
            return false;
        }
        if (this._filter == null || this._filter.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this._filter.length) {
            if (ext.equals(this._filter[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void insertNodes(String pName, String pPath, CatalogTreeNode pParent) {
        File fp = new File(pPath);
        if (!fp.exists()) {
            return;
        }
        String filename = fp.getName();
        if (filename.startsWith(".")) {
            return;
        }
        if (filename.equals("CVS")) {
            return;
        }
        if (fp.isDirectory()) {
            CatalogTreeNode newElement = new CatalogTreeNode(pName);
            this.insertNodeInto(newElement, pParent, pParent.getChildCount());
            String[] sp = fp.list();
            if (sp != null) {
                if (sp.length > 0) {
                    ArrayList<String> aList = new ArrayList<String>(Arrays.asList(sp));
                    Collections.sort(aList);
                    sp = aList.toArray(sp);
                }
                int i = 0;
                while (i < sp.length) {
                    log.debug("Descend into resource: {} count {}", (Object)sp[i], (Object)this.count++);
                    this.insertNodes(sp[i], String.valueOf(pPath) + File.separator + sp[i], newElement);
                    ++i;
                }
            }
        } else {
            String ext = FilenameUtils.getExtension((String)fp.getName());
            if (!this.filter(ext)) {
                return;
            }
            int index = filename.indexOf(46);
            if (index > 0) {
                filename = filename.substring(0, index);
            }
            log.debug("add leaf: {} count {}", (Object)filename, (Object)this.leafcount++);
            pParent.addLeaf(filename, pPath);
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        return this.parameters.get(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        return this.parameters.keySet();
    }

    @Override
    public void removeProperty(String key) {
        if (this.parameters == null) {
            return;
        }
        this.parameters.remove(key);
    }
}

