/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import jmri.InstanceManager;
import jmri.jmrit.catalog.Bundle;
import jmri.jmrit.catalog.CatalogTreeModel;
import jmri.jmrit.catalog.NamedIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogPane
extends JPanel {
    JLabel preview = new JLabel();
    JTree dTree = new JTree(InstanceManager.getDefault(CatalogTreeModel.class));
    private static final Logger log = LoggerFactory.getLogger(CatalogPane.class);

    public CatalogPane() {
        super(true);
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JScrollPane(this.dTree));
        this.dTree.setRootVisible(false);
        this.dTree.setShowsRootHandles(true);
        this.dTree.setScrollsOnExpand(true);
        this.dTree.setExpandsSelectedPaths(true);
        this.dTree.getSelectionModel().setSelectionMode(1);
        this.dTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!CatalogPane.this.dTree.isSelectionEmpty() && CatalogPane.this.dTree.getSelectionPath() != null) {
                    CatalogPane.this.preview.setIcon(CatalogPane.this.getSelectedIcon());
                } else {
                    CatalogPane.this.preview.setIcon(null);
                }
            }
        });
        if (log.isDebugEnabled()) {
            this.dTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    if (!CatalogPane.this.dTree.isSelectionEmpty() && CatalogPane.this.dTree.getSelectionPath() != null) {
                        log.debug("Selection event with {}", (Object)CatalogPane.this.dTree.getSelectionPath());
                        log.debug("          icon: {}", (Object)CatalogPane.this.getSelectedIcon());
                    }
                }
            });
        }
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BoxLayout(previewPanel, 0));
        previewPanel.add(new JLabel(Bundle.getMessage("FilePreviewLabel")));
        JScrollPane js = new JScrollPane(this.preview);
        previewPanel.add(js);
        this.add(previewPanel);
    }

    public NamedIcon getSelectedIcon() {
        StringBuilder buf;
        TreePath path;
        int level;
        if (this.dTree.isSelectionEmpty() || this.dTree.getSelectionPath() == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getSelectedIcon with {}", (Object)this.dTree.getSelectionPath());
        }
        if ((level = (path = this.dTree.getSelectionPath()).getPathCount()) < 3) {
            return null;
        }
        if (((DefaultMutableTreeNode)path.getPathComponent(1)).getUserObject().equals("resources")) {
            buf = new StringBuilder("resources");
            int i = 2;
            while (i < level) {
                buf.append("/");
                buf.append((String)((DefaultMutableTreeNode)path.getPathComponent(i)).getUserObject());
                ++i;
            }
        } else if (((DefaultMutableTreeNode)path.getPathComponent(1)).getUserObject().equals("files")) {
            buf = new StringBuilder(CatalogTreeModel.fileRoot);
            buf.append(File.separator);
            buf.append((String)((DefaultMutableTreeNode)path.getPathComponent(2)).getUserObject());
            int i = 3;
            while (i < level) {
                buf.append(File.separator);
                buf.append((String)((DefaultMutableTreeNode)path.getPathComponent(i)).getUserObject());
                ++i;
            }
        } else {
            log.error("unexpected first element on getSelectedIcon: {}", path.getPathComponent(1));
            return null;
        }
        String name = buf.toString();
        if (log.isDebugEnabled()) {
            log.debug("attempt to load file from {}", (Object)name);
        }
        return NamedIcon.getIconByName(name);
    }
}

