/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.cabsignals;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.DefaultFormatter;
import jmri.CabSignalListListener;
import jmri.CabSignalManager;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.jmrit.DccLocoAddressSelector;
import jmri.jmrit.cabsignals.Bundle;
import jmri.jmrit.cabsignals.CabSignalTableModel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.roster.swing.GlobalRosterEntryComboBox;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.managers.DefaultCabSignalManager;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.StayOpenCheckBoxItem;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import jmri.util.table.JTableWithColumnToolTips;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CabSignalPane
extends JmriPanel
implements CabSignalListListener {
    private CabSignalManager cabSignalManager = InstanceManager.getNullableDefault(CabSignalManager.class);
    private JScrollPane slotScroll;
    private CabSignalTableModel slotModel;
    private JTable _slotTable;
    private XTableColumnModel tcm;
    private JMenu cabSigColMenu;
    private List<JCheckBoxMenuItem> colMenuList;
    private JToggleButton masterPauseButton;
    private JLabel textLocoLabel;
    private DccLocoAddressSelector locoSelector;
    private RosterEntryComboBox locoRosterBox;
    private JButton addLocoButton;
    private JButton resetLocoButton;
    private int _rotationOffset;
    private int _defaultRowHeight;
    private static final Logger log = LoggerFactory.getLogger(CabSignalPane.class);

    public CabSignalPane() {
        if (this.cabSignalManager == null) {
            log.info("creating new DefaultCabSignalManager");
            InstanceManager.store(new DefaultCabSignalManager(), CabSignalManager.class);
            this.cabSignalManager = InstanceManager.getNullableDefault(CabSignalManager.class);
        }
    }

    @Override
    public void initComponents() {
        super.initComponents();
        if (this.cabSignalManager != null) {
            this.cabSignalManager.addCabSignalListListener(this);
        }
        this.slotModel = new CabSignalTableModel(5, 9);
        this.tcm = new XTableColumnModel();
        this.cabSigColMenu = new JMenu(Bundle.getMessage("SigDataCol"));
        this.colMenuList = new ArrayList<JCheckBoxMenuItem>();
        this.textLocoLabel = new JLabel();
        this.locoSelector = new DccLocoAddressSelector();
        this.addLocoButton = new JButton();
        this.resetLocoButton = new JButton();
        this._defaultRowHeight = 26;
        this.init();
    }

    public void init() {
        int colnumber;
        this._slotTable = new JTableWithColumnToolTips((TableModel)this.slotModel, CabSignalTableModel.COLUMNTOOLTIPS);
        this._slotTable.setColumnModel(this.tcm);
        this._slotTable.createDefaultColumnsFromModel();
        int i = 0;
        while (i < this._slotTable.getColumnCount()) {
            colnumber = i;
            String colName = this._slotTable.getColumnName(colnumber);
            StayOpenCheckBoxItem showcol = new StayOpenCheckBoxItem(colName);
            showcol.setToolTipText(CabSignalTableModel.COLUMNTOOLTIPS[i]);
            this.colMenuList.add(showcol);
            this.cabSigColMenu.add(showcol);
            ++i;
        }
        i = 0;
        while (i < 9) {
            colnumber = i;
            TableColumn column = this.tcm.getColumnByModelIndex(colnumber);
            if (Arrays.stream(CabSignalTableModel.STARTUPCOLUMNS).anyMatch(j -> j == colnumber)) {
                this.colMenuList.get(colnumber).setSelected(true);
                this.tcm.setColumnVisible(column, true);
            } else {
                this.colMenuList.get(colnumber).setSelected(false);
                this.tcm.setColumnVisible(column, false);
            }
            this.colMenuList.get(colnumber).addActionListener(e -> {
                TableColumn column1;
                boolean visible1 = this.tcm.isColumnVisible(column1 = this.tcm.getColumnByModelIndex(colnumber));
                this.tcm.setColumnVisible(column1, !visible1);
            });
            ++i;
        }
        this._slotTable.setAutoCreateRowSorter(true);
        TableRowSorter<CabSignalTableModel> sorter = new TableRowSorter<CabSignalTableModel>(this.slotModel);
        this._slotTable.setRowSorter(sorter);
        this._slotTable.setRowHeight(this._defaultRowHeight);
        this.slotModel.configureTable(this._slotTable);
        this.tcm.getColumnByModelIndex(4).setCellRenderer(new ButtonRenderer());
        this.tcm.getColumnByModelIndex(4).setCellEditor(new ButtonEditor(new JButton()));
        this.tcm.getColumnByModelIndex(8).setCellRenderer(this.tableSignalAspectRenderer());
        this.slotScroll = new JScrollPane(this._slotTable);
        this.slotScroll.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BoxLayout(this, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        JPanel toppanelcontainer = new JPanel();
        this.masterPauseButton = new JToggleButton();
        this.masterPauseButton.setSelected(false);
        this.refreshMasterPauseButton();
        this.masterPauseButton.setVisible(true);
        this.masterPauseButton.addActionListener(e -> this.refreshMasterPauseButton());
        toppanelcontainer.add(this.masterPauseButton);
        JPanel locoSelectContainer = new JPanel();
        this.textLocoLabel.setText(Bundle.getMessage("LocoLabelText"));
        this.textLocoLabel.setVisible(true);
        this.locoSelector.setToolTipText(Bundle.getMessage("LocoSelectorToolTip"));
        this.locoSelector.setVisible(true);
        this.textLocoLabel.setLabelFor(this.locoSelector);
        locoSelectContainer.add(this.textLocoLabel);
        locoSelectContainer.add(this.locoSelector);
        this.locoSelector.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                CabSignalPane.this.locoRosterBox.setSelectedIndex(0);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.locoRosterBox = new GlobalRosterEntryComboBox();
        this.locoRosterBox.setNonSelectedItem("");
        this.locoRosterBox.setSelectedIndex(0);
        this.locoRosterBox.addPropertyChangeListener("selectedRosterEntries", pce -> this.locoSelected());
        this.locoRosterBox.setVisible(true);
        locoSelectContainer.add(this.locoRosterBox);
        this.addLocoButton.setText(Bundle.getMessage("ButtonAddText"));
        this.addLocoButton.setVisible(true);
        this.addLocoButton.setToolTipText(Bundle.getMessage("AddButtonToolTip"));
        this.addLocoButton.addActionListener(e -> this.addLocoButtonActionPerformed(e));
        locoSelectContainer.add(this.addLocoButton);
        this.resetLocoButton.setText(Bundle.getMessage("ButtonReset"));
        this.resetLocoButton.setVisible(true);
        this.resetLocoButton.setToolTipText(Bundle.getMessage("ResetButtonToolTip"));
        this.resetLocoButton.addActionListener(e -> {
            this.locoSelector.reset();
            this.locoRosterBox.setSelectedIndex(0);
        });
        locoSelectContainer.add(this.resetLocoButton);
        locoSelectContainer.setBorder(BorderFactory.createEtchedBorder());
        locoSelectContainer.setVisible(true);
        toppanelcontainer.add(locoSelectContainer);
        p1.add((Component)toppanelcontainer, "First");
        p1.add((Component)this.slotScroll, "Center");
        this.add(p1);
        Dimension p1size = new Dimension(450, 200);
        p1.setMinimumSize(p1size);
        p1.setVisible(true);
        log.debug("class name {} ", (Object)CabSignalPane.class.getName());
    }

    private void refreshMasterPauseButton() {
        if (this.masterPauseButton.isSelected()) {
            this.masterPauseButton.setText(Bundle.getMessage("SigDataResume"));
            this.masterPauseButton.setToolTipText(Bundle.getMessage("SigDataResumeTip"));
            this.slotModel.setPanelPauseButton(true);
        } else {
            this.masterPauseButton.setText(Bundle.getMessage("SigDataPause"));
            this.masterPauseButton.setToolTipText(Bundle.getMessage("SigDataPauseTip"));
            this.slotModel.setPanelPauseButton(false);
        }
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("CabSignalPaneTitle");
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        menuList.add(this.cabSigColMenu);
        JMenu displayMenu = new JMenu(Bundle.getMessage("DisplayMenu"));
        JMenu iconMenu = new JMenu(Bundle.getMessage("AspectIconMenu"));
        ButtonGroup offsetGroup = new ButtonGroup();
        JRadioButtonMenuItem offset0MenuItem = new JRadioButtonMenuItem(Bundle.getMessage("IconDegrees", 0));
        JRadioButtonMenuItem offset1MenuItem = new JRadioButtonMenuItem(Bundle.getMessage("IconDegrees", 90));
        JRadioButtonMenuItem offset2MenuItem = new JRadioButtonMenuItem(Bundle.getMessage("IconDegrees", 180));
        JRadioButtonMenuItem offset3MenuItem = new JRadioButtonMenuItem(Bundle.getMessage("IconDegrees", 270));
        offsetGroup.add(offset0MenuItem);
        offsetGroup.add(offset1MenuItem);
        offsetGroup.add(offset2MenuItem);
        offsetGroup.add(offset3MenuItem);
        iconMenu.add(offset0MenuItem);
        iconMenu.add(offset1MenuItem);
        iconMenu.add(offset2MenuItem);
        iconMenu.add(offset3MenuItem);
        displayMenu.add(iconMenu);
        this._rotationOffset = 0;
        offset0MenuItem.setSelected(true);
        ActionListener iconMenuListener = ae -> {
            if (offset0MenuItem.isSelected()) {
                this._rotationOffset = 0;
            } else if (offset1MenuItem.isSelected()) {
                this._rotationOffset = 1;
            } else if (offset2MenuItem.isSelected()) {
                this._rotationOffset = 2;
            } else if (offset3MenuItem.isSelected()) {
                this._rotationOffset = 3;
            }
            this.notifyCabSignalListChanged();
        };
        offset0MenuItem.addActionListener(iconMenuListener);
        offset1MenuItem.addActionListener(iconMenuListener);
        offset2MenuItem.addActionListener(iconMenuListener);
        offset3MenuItem.addActionListener(iconMenuListener);
        ActionListener rowHeightMenuListener = ae -> {
            JSpinner delaySpinner = this.getNewRowHeightSpinner();
            int option = JOptionPane.showOptionDialog(this, delaySpinner, Bundle.getMessage("RowHeightOption"), 2, 3, null, null, null);
            if (option == 0) {
                this._defaultRowHeight = (Integer)delaySpinner.getValue();
            } else {
                this._slotTable.setRowHeight(this._defaultRowHeight);
            }
        };
        JMenuItem searchForNodesMenuItem = new JMenuItem(Bundle.getMessage("RowHeightOption"));
        searchForNodesMenuItem.addActionListener(rowHeightMenuListener);
        displayMenu.add(searchForNodesMenuItem);
        menuList.add(displayMenu);
        return menuList;
    }

    private JSpinner getNewRowHeightSpinner() {
        JSpinner rqnnSpinner = new JSpinner(new SpinnerNumberModel(this._defaultRowHeight, 10, 150, 1));
        JComponent rqcomp = rqnnSpinner.getEditor();
        JFormattedTextField rqfield = (JFormattedTextField)rqcomp.getComponent(0);
        DefaultFormatter rqformatter = (DefaultFormatter)rqfield.getFormatter();
        rqformatter.setCommitsOnValidEdit(true);
        rqnnSpinner.addChangeListener(e -> this._slotTable.setRowHeight((Integer)rqnnSpinner.getValue()));
        return rqnnSpinner;
    }

    public void addLocoButtonActionPerformed(ActionEvent e) {
        if (this.locoSelector.getAddress() == null) {
            return;
        }
        DccLocoAddress locoaddress = this.locoSelector.getAddress();
        this.cabSignalManager.getCabSignal(locoaddress).setMasterCabSigPauseActive(this.masterPauseButton.isSelected());
    }

    public void locoSelected() {
        if (this.locoRosterBox.getSelectedRosterEntries().length == 1) {
            this.locoSelector.setAddress(this.locoRosterBox.getSelectedRosterEntries()[0].getDccLocoAddress());
        }
    }

    private TableCellRenderer tableSignalAspectRenderer() {
        return new TableCellRenderer(){
            JLabel f = new JLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.f.setIcon(null);
                if (!value.toString().isEmpty()) {
                    NamedIcon tmpIcon = new NamedIcon(value.toString(), value.toString());
                    tmpIcon.setRotation(tmpIcon.getRotation() + CabSignalPane.this._rotationOffset, CabSignalPane.this.slotScroll);
                    this.f.setIcon(tmpIcon);
                }
                this.f.setText("");
                this.f.setHorizontalAlignment(0);
                if (isSelected) {
                    this.f.setBackground(table.getSelectionBackground());
                } else {
                    this.f.setBackground(null);
                }
                return this.f;
            }
        };
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrit.cabsignals.CabSignalPane";
    }

    @Override
    public void dispose() {
        this.cabSignalManager.removeCabSignalListListener(this);
        this._slotTable = null;
        this.slotModel.dispose();
        this.cabSignalManager = null;
        super.dispose();
    }

    @Override
    public void notifyCabSignalListChanged() {
        this.slotModel.fireTableDataChanged();
    }
}

