/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.usermessagepreferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AudioTableAction;
import jmri.jmrit.beantable.BlockTableAction;
import jmri.jmrit.beantable.LRouteTableAction;
import jmri.jmrit.beantable.LightTableAction;
import jmri.jmrit.beantable.LogixTableAction;
import jmri.jmrit.beantable.MemoryTableAction;
import jmri.jmrit.beantable.ReporterTableAction;
import jmri.jmrit.beantable.RouteTableAction;
import jmri.jmrit.beantable.SensorTableAction;
import jmri.jmrit.beantable.SignalGroupTableAction;
import jmri.jmrit.beantable.SignalHeadTableAction;
import jmri.jmrit.beantable.SignalMastTableAction;
import jmri.jmrit.beantable.TransitTableAction;
import jmri.jmrit.beantable.TurnoutTableAction;
import jmri.jmrit.beantable.usermessagepreferences.Bundle;
import jmri.swing.PreferencesPanel;
import jmri.util.javaworld.GridLayout2;
import jmri.util.swing.JmriPanel;

public class UserMessagePreferencesPane
extends JmriPanel
implements PreferencesPanel {
    UserPreferencesManager p;
    JTabbedPane tab = new JTabbedPane();
    private HashMap<JComboBox<Object>, ListItems> _comboBoxes = new HashMap();
    private HashMap<JCheckBox, ListItems> _checkBoxes = new HashMap();
    boolean updating = false;

    public UserMessagePreferencesPane() {
        this.p = InstanceManager.getDefault(UserPreferencesManager.class);
        this.p.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("PreferencesUpdated")) {
                this.refreshOptions();
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumMessagePref();
        this.add(this.tab);
    }

    private synchronized void setMinimumMessagePref() {
        this.p.setClassDescription(AudioTableAction.class.getName());
        this.p.setClassDescription(BlockTableAction.class.getName());
        this.p.setClassDescription(LightTableAction.class.getName());
        this.p.setClassDescription(LogixTableAction.class.getName());
        this.p.setClassDescription(LRouteTableAction.class.getName());
        this.p.setClassDescription(MemoryTableAction.class.getName());
        this.p.setClassDescription(ReporterTableAction.class.getName());
        this.p.setClassDescription(RouteTableAction.class.getName());
        this.p.setClassDescription(SensorTableAction.class.getName());
        this.p.setClassDescription(SignalGroupTableAction.class.getName());
        this.p.setClassDescription(SignalHeadTableAction.class.getName());
        this.p.setClassDescription(SignalMastTableAction.class.getName());
        this.p.setClassDescription(TransitTableAction.class.getName());
        this.p.setClassDescription(TurnoutTableAction.class.getName());
        this.newMessageTab();
    }

    private synchronized void newMessageTab() {
        ArrayList acb;
        ArrayList a;
        this.remove(this.tab);
        this.tab = new JTabbedPane();
        this._comboBoxes = new HashMap();
        this._checkBoxes = new HashMap();
        ArrayList<String> preferenceClassList = this.p.getPreferencesClasses();
        for (String strClass : preferenceClassList) {
            JPanel classholder = new JPanel();
            classholder.setLayout(new BorderLayout());
            boolean add = false;
            boolean addtoindependant = false;
            if (this.p.getPreferencesSize(strClass) > 1) {
                addtoindependant = true;
            }
            JPanel classPanel = new JPanel();
            classPanel.setLayout(new BoxLayout(classPanel, 1));
            classPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            int j = 0;
            while (j < this.p.getMultipleChoiceSize(strClass)) {
                String itemName = this.p.getChoiceName(strClass, j);
                HashMap<Integer, String> hashMap = this.p.getChoiceOptions(strClass, itemName);
                if (hashMap != null) {
                    JComboBox<String> optionBox = new JComboBox<String>();
                    ListItems li = new ListItems(strClass, itemName);
                    this._comboBoxes.put(optionBox, li);
                    li.isIncluded(addtoindependant);
                    optionBox.removeAllItems();
                    for (String value : hashMap.values()) {
                        optionBox.addItem(value);
                    }
                    int current = this.p.getMultipleChoiceOption(strClass, itemName);
                    if (hashMap.containsKey(current)) {
                        optionBox.setSelectedItem(hashMap.get(current));
                    }
                    if (addtoindependant) {
                        JPanel optionPanel = new JPanel();
                        JLabel _comboLabel = new JLabel(this.p.getChoiceDescription(strClass, itemName), 2);
                        _comboLabel.setAlignmentX(0.5f);
                        optionPanel.add(_comboLabel);
                        optionPanel.add(optionBox);
                        add = true;
                        classPanel.add(optionPanel);
                    }
                }
                ++j;
            }
            ArrayList<String> singleList = this.p.getPreferenceList(strClass);
            if (!singleList.isEmpty()) {
                int i = 0;
                while (i < singleList.size()) {
                    String itemName = this.p.getPreferenceItemName(strClass, i);
                    String description = this.p.getPreferenceItemDescription(strClass, itemName);
                    if (description != null && !description.isEmpty()) {
                        JCheckBox check = new JCheckBox(description);
                        check.setSelected(this.p.getPreferenceState(strClass, itemName));
                        ListItems li = new ListItems(strClass, itemName);
                        this._checkBoxes.put(check, li);
                        li.isIncluded(addtoindependant);
                        if (addtoindependant) {
                            classPanel.add(check);
                            add = true;
                        }
                    }
                    ++i;
                }
            }
            if (!add) continue;
            classholder.add((Component)classPanel, "North");
            if (this.p.getPreferencesSize(strClass) <= 1) continue;
            JScrollPane scrollPane = new JScrollPane(classholder);
            scrollPane.setPreferredSize(new Dimension(300, 300));
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.tab.add((Component)scrollPane, this.p.getClassDescription(strClass));
        }
        HashMap countOfItems = new HashMap();
        HashMap countOfItemsCheck = new HashMap();
        HashMap countOfItemsCombo = new HashMap();
        for (Map.Entry<JComboBox<Object>, ListItems> entry : this._comboBoxes.entrySet()) {
            if (entry.getValue().isIncluded()) continue;
            String strItem = entry.getValue().getItem();
            if (!countOfItems.containsKey(strItem)) {
                countOfItems.put(strItem, new ArrayList());
                countOfItemsCombo.put(strItem, new ArrayList());
            }
            a = (ArrayList)countOfItems.get(strItem);
            a.add(entry.getValue());
            acb = (ArrayList)countOfItemsCombo.get(strItem);
            acb.add(entry.getKey());
        }
        for (Map.Entry<JComponent, ListItems> entry : this._checkBoxes.entrySet()) {
            if (entry.getValue().isIncluded()) continue;
            String strItem = entry.getValue().getItem();
            if (!countOfItems.containsKey(strItem)) {
                countOfItems.put(strItem, new ArrayList());
                countOfItemsCheck.put(strItem, new ArrayList());
            }
            a = (ArrayList)countOfItems.get(strItem);
            a.add(entry.getValue());
            acb = (ArrayList)countOfItemsCheck.get(strItem);
            acb.add((JCheckBox)entry.getKey());
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel mischolder = new JPanel();
        mischolder.setLayout(new BorderLayout());
        mischolder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (Map.Entry entry : countOfItems.entrySet()) {
            ArrayList a2 = (ArrayList)entry.getValue();
            ArrayList chb = (ArrayList)countOfItemsCheck.get(entry.getKey());
            ArrayList cob = (ArrayList)countOfItemsCombo.get(entry.getKey());
            if (a2.size() > 1) {
                JPanel tableDeleteTabPanel = new JPanel();
                tableDeleteTabPanel.setLayout(new BoxLayout(tableDeleteTabPanel, 1));
                JLabel tableDeleteInfoLabel = new JLabel(this.p.getChoiceDescription(((ListItems)a2.get(0)).getClassName(), ((ListItems)a2.get(0)).getItem()), 0);
                tableDeleteInfoLabel.setAlignmentX(0.5f);
                tableDeleteTabPanel.add(tableDeleteInfoLabel);
                JPanel inside = new JPanel();
                if (cob != null) {
                    JPanel insideCombo = new JPanel();
                    int gridsize = (int)Math.ceil((double)cob.size() / 2.0);
                    insideCombo.setLayout(new GridLayout2(gridsize, 4, 10, 2));
                    for (JComboBox combo : cob) {
                        JLabel _comboLabel = new JLabel(this.p.getClassDescription(this._comboBoxes.get(combo).getClassName()), 4);
                        this._comboBoxes.get(combo).isIncluded(true);
                        insideCombo.add(_comboLabel);
                        insideCombo.add(combo);
                    }
                    inside.add(insideCombo);
                }
                if (chb != null) {
                    JPanel insideCheck = new JPanel();
                    insideCheck.setLayout(new GridLayout2(chb.size(), 1));
                    for (JCheckBox check : chb) {
                        JLabel _checkLabel = new JLabel(this.p.getClassDescription(this._checkBoxes.get(check).getClassName()), 4);
                        this._checkBoxes.get(check).isIncluded(true);
                        insideCheck.add(_checkLabel);
                        insideCheck.add(check);
                    }
                    inside.add(insideCheck);
                }
                tableDeleteTabPanel.add(inside);
                JScrollPane scrollPane = new JScrollPane(tableDeleteTabPanel);
                scrollPane.setPreferredSize(new Dimension(300, 300));
                this.tab.add((Component)scrollPane, entry.getKey());
                continue;
            }
            JPanel itemPanel = new JPanel();
            JPanel subItem = new JPanel();
            subItem.setLayout(new BoxLayout(subItem, 1));
            subItem.add(new JLabel(this.p.getClassDescription(((ListItems)a2.get(0)).getClassName()), 0));
            if (!countOfItemsCheck.containsKey(entry.getKey())) continue;
            subItem.add((Component)((ArrayList)countOfItemsCheck.get(entry.getKey())).get(0));
            itemPanel.add(subItem);
            jPanel.add(itemPanel);
        }
        this.add(this.tab);
        mischolder.add((Component)jPanel, "North");
        JScrollPane miscScrollPane = new JScrollPane(mischolder);
        miscScrollPane.setPreferredSize(new Dimension(300, 300));
        this.tab.add((Component)miscScrollPane, "Misc items");
        this.revalidate();
    }

    @Override
    public String getPreferencesItem() {
        return "MESSAGES";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuMessages");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return null;
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        this.updateManager();
    }

    @Override
    public synchronized boolean isDirty() {
        String strItem;
        String strClass;
        for (Map.Entry<JComboBox<Object>, ListItems> entry : this._comboBoxes.entrySet()) {
            strClass = entry.getValue().getClassName();
            if (this.p.getChoiceOptions(strClass, strItem = entry.getValue().getItem()).get(this.p.getMultipleChoiceOption(strClass, strItem)).equals(entry.getKey().getSelectedItem())) continue;
            return true;
        }
        for (Map.Entry<JComponent, ListItems> entry : this._checkBoxes.entrySet()) {
            strClass = entry.getValue().getClassName();
            if (this.p.getPreferenceState(strClass, strItem = entry.getValue().getItem()) == ((JCheckBox)entry.getKey()).isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRestartRequired() {
        return false;
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    public synchronized void updateManager() {
        String strItem;
        String strClass;
        this.updating = true;
        this.p.setLoading();
        for (Map.Entry<JComboBox<Object>, ListItems> entry : this._comboBoxes.entrySet()) {
            strClass = entry.getValue().getClassName();
            strItem = entry.getValue().getItem();
            String strSelection = (String)entry.getKey().getSelectedItem();
            this.p.setMultipleChoiceOption(strClass, strItem, strSelection);
        }
        for (Map.Entry<JComponent, ListItems> entry : this._checkBoxes.entrySet()) {
            strClass = entry.getValue().getClassName();
            strItem = entry.getValue().getItem();
            this.p.setPreferenceState(strClass, strItem, ((JCheckBox)entry.getKey()).isSelected());
        }
        this.updating = false;
        this.p.finishLoading();
        this.refreshOptions();
    }

    private void refreshOptions() {
        if (this.updating) {
            return;
        }
        this.newMessageTab();
    }

    static class ListItems {
        String strClass;
        String item;
        boolean included = false;

        ListItems(String strClass, String item) {
            this.strClass = strClass;
            this.item = item;
        }

        String getClassName() {
            return this.strClass;
        }

        String getItem() {
            return this.item;
        }

        boolean isIncluded() {
            return this.included;
        }

        void isIncluded(boolean boo) {
            this.included = boo;
        }
    }
}

