/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.turnout;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.jmrit.beantable.turnout.TurnoutTableDataModel;
import jmri.swing.NamedBeanComboBox;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutTableJTable
extends JTable {
    final TurnoutTableDataModel model;
    final Hashtable<Turnout, TableCellRenderer> rendererMapSensor1 = new Hashtable();
    final Hashtable<Turnout, TableCellEditor> editorMapSensor1 = new Hashtable();
    final Hashtable<Turnout, TableCellRenderer> rendererMapSensor2 = new Hashtable();
    final Hashtable<Turnout, TableCellEditor> editorMapSensor2 = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(TurnoutTableJTable.class);

    public TurnoutTableJTable(TurnoutTableDataModel mdl) {
        super(mdl);
        this.model = mdl;
    }

    @Override
    public String getToolTipText(@Nonnull MouseEvent e) {
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realRowIndex = this.convertRowIndexToModel(rowIndex);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        return this.model.getCellToolTip(this, realRowIndex, realColumnIndex);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (e instanceof KeyEvent && (((KeyEvent)e).getKeyCode() == 524 || ((KeyEvent)e).getKeyCode() == 157)) {
            return false;
        }
        return super.editCellAt(row, column, e);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int modelColumn = this.convertColumnIndexToModel(column);
        if (modelColumn == 10 || modelColumn == 11) {
            return this.getRenderer(row, modelColumn);
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        int modelColumn = this.convertColumnIndexToModel(column);
        if (modelColumn == 10 || modelColumn == 11) {
            return this.getEditor(row, modelColumn);
        }
        return super.getCellEditor(row, column);
    }

    TableCellRenderer getRenderer(int row, int column) {
        TableCellRenderer retval;
        Turnout t = (Turnout)this.getModel().getValueAt(row, 0);
        Objects.requireNonNull(t, "SYSNAMECOL column content must be nonnull");
        switch (column) {
            case 10: {
                retval = this.rendererMapSensor1.get(t);
                break;
            }
            case 11: {
                retval = this.rendererMapSensor2.get(t);
                break;
            }
            default: {
                return null;
            }
        }
        if (retval == null) {
            if (column == 10) {
                this.loadRenderEditMaps(this.rendererMapSensor1, this.editorMapSensor1, t, t.getFirstSensor());
            } else {
                this.loadRenderEditMaps(this.rendererMapSensor2, this.editorMapSensor2, t, t.getSecondSensor());
            }
            retval = this.rendererMapSensor1.get(t);
        }
        log.debug("fetched for Turnout \"{}\" renderer {}", (Object)t, (Object)retval);
        return retval;
    }

    TableCellEditor getEditor(int row, int column) {
        TableCellEditor retval;
        Turnout t = (Turnout)this.getModel().getValueAt(row, 0);
        Objects.requireNonNull(t, "SYSNAMECOL column content must be nonnull");
        switch (column) {
            case 10: {
                retval = this.editorMapSensor1.get(t);
                break;
            }
            case 11: {
                retval = this.editorMapSensor2.get(t);
                break;
            }
            default: {
                return null;
            }
        }
        if (retval == null) {
            if (column == 10) {
                this.loadRenderEditMaps(this.rendererMapSensor1, this.editorMapSensor1, t, t.getFirstSensor());
                retval = this.editorMapSensor1.get(t);
            } else {
                this.loadRenderEditMaps(this.rendererMapSensor2, this.editorMapSensor2, t, t.getSecondSensor());
                retval = this.editorMapSensor2.get(t);
            }
        }
        log.debug("fetched for Turnout \"{}\" editor {}", (Object)t, (Object)retval);
        return retval;
    }

    protected void loadRenderEditMaps(Hashtable<Turnout, TableCellRenderer> r, Hashtable<Turnout, TableCellEditor> e, Turnout t, Sensor s) {
        NamedBeanComboBox<Sensor> c = new NamedBeanComboBox<Sensor>(InstanceManager.getDefault(SensorManager.class), s, NamedBean.DisplayOptions.DISPLAYNAME);
        c.setAllowNull(true);
        JComboBoxUtil.setupComboBoxMaxRows(c);
        BeanBoxRenderer renderer = new BeanBoxRenderer();
        renderer.setSelectedItem(s);
        r.put(t, renderer);
        BeanComboBoxEditor editor = new BeanComboBoxEditor(c);
        e.put(t, editor);
        log.debug("initialize for Turnout \"{}\" Sensor \"{}\"", (Object)t, (Object)s);
    }

    static class BeanBoxRenderer
    extends NamedBeanComboBox<Sensor>
    implements TableCellRenderer {
        public BeanBoxRenderer() {
            super(InstanceManager.getDefault(SensorManager.class));
            this.setAllowNull(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (value instanceof Sensor) {
                this.setSelectedItem(value);
            } else {
                this.setSelectedItem(null);
            }
            return this;
        }
    }

    static class BeanComboBoxEditor
    extends DefaultCellEditor {
        public BeanComboBoxEditor(NamedBeanComboBox<Sensor> beanBox) {
            super(beanBox);
        }
    }
}

