/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.signalmast;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.SignalAppearanceMap;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SignalSystem;
import jmri.Turnout;
import jmri.implementation.TurnoutSignalMast;
import jmri.jmrit.beantable.signalmast.Bundle;
import jmri.jmrit.beantable.signalmast.SignalMastAddPane;
import jmri.util.javaworld.GridLayout2;
import jmri.util.swing.BeanSelectCreatePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutSignalMastAddPane
extends SignalMastAddPane {
    JPanel turnoutMastPanel = new JPanel();
    JScrollPane turnoutMastScroll;
    JCheckBox resetPreviousState = new JCheckBox(Bundle.getMessage("ResetPrevious"));
    JCheckBox allowUnLit = new JCheckBox();
    LinkedHashMap<String, TurnoutAspectPanel> turnoutAspect = new LinkedHashMap(12);
    JPanel disabledAspectsPanel = new JPanel();
    TurnoutSignalMast currentMast = null;
    String stateThrown = InstanceManager.turnoutManagerInstance().getThrownText();
    String stateClosed = InstanceManager.turnoutManagerInstance().getClosedText();
    String[] turnoutStates = new String[]{this.stateClosed, this.stateThrown};
    int[] turnoutStateValues = new int[]{2, 4};
    BeanSelectCreatePanel<Turnout> turnoutUnLitBox = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    JComboBox<String> turnoutUnLitState = new JComboBox<String>(this.turnoutStates);
    DecimalFormat paddedNumber = new DecimalFormat("0000");
    private static final Logger log = LoggerFactory.getLogger(TurnoutSignalMastAddPane.class);

    public TurnoutSignalMastAddPane() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(String.valueOf(Bundle.getMessage("AllowUnLitLabel")) + ": "));
        p.add(this.allowUnLit);
        p.setAlignmentX(0.0f);
        this.add(p);
        this.turnoutMastScroll = new JScrollPane(this.turnoutMastPanel);
        this.turnoutMastScroll.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.turnoutMastScroll);
    }

    @Override
    @Nonnull
    public String getPaneName() {
        return Bundle.getMessage("TurnCtlMast");
    }

    @Override
    public void setAspectNames(@Nonnull SignalAppearanceMap map, @Nonnull SignalSystem sigSystem) {
        Enumeration<String> aspects = map.getAspects();
        log.debug("setAspectNames(...)");
        this.turnoutAspect.clear();
        while (aspects.hasMoreElements()) {
            String aspect = aspects.nextElement();
            TurnoutAspectPanel aPanel = new TurnoutAspectPanel(aspect);
            this.turnoutAspect.put(aspect, aPanel);
        }
        this.turnoutMastPanel.removeAll();
        for (Map.Entry<String, TurnoutAspectPanel> entry : this.turnoutAspect.entrySet()) {
            log.trace("   aspect: {}", (Object)entry.getKey());
            this.turnoutMastPanel.add(entry.getValue().getPanel());
        }
        this.turnoutMastPanel.add(this.resetPreviousState);
        this.resetPreviousState.setToolTipText(Bundle.getMessage("ResetPreviousToolTip"));
        this.turnoutMastPanel.setLayout(new GridLayout2(0, 2));
        this.turnoutMastPanel.revalidate();
        this.turnoutMastScroll.revalidate();
    }

    @Override
    public boolean canHandleMast(@Nonnull SignalMast mast) {
        return mast instanceof TurnoutSignalMast;
    }

    @Override
    public void setMast(SignalMast mast) {
        log.trace("setMast({}) start", (Object)mast);
        if (mast == null) {
            this.currentMast = null;
            return;
        }
        if (!(mast instanceof TurnoutSignalMast)) {
            log.error("mast was wrong type: {} {}", (Object)mast.getSystemName(), (Object)mast.getClass().getName());
            return;
        }
        this.currentMast = (TurnoutSignalMast)mast;
        SignalAppearanceMap appMap = mast.getAppearanceMap();
        if (appMap != null) {
            Enumeration<String> aspects = appMap.getAspects();
            while (aspects.hasMoreElements()) {
                String key = aspects.nextElement();
                Objects.requireNonNull(key, "only non-null keys are expected");
                TurnoutAspectPanel turnPanel = this.turnoutAspect.get(key);
                Objects.requireNonNull(turnPanel, "a panel should exist for each aspect");
                turnPanel.setSelectedTurnout(this.currentMast.getTurnoutName(key));
                turnPanel.setTurnoutState(this.currentMast.getTurnoutState(key));
                turnPanel.setAspectDisabled(this.currentMast.isAspectDisabled(key));
            }
        }
        if (this.currentMast.resetPreviousStates()) {
            this.resetPreviousState.setSelected(true);
        }
        if (this.currentMast.allowUnLit()) {
            this.turnoutUnLitBox.setDefaultNamedBean(this.currentMast.getUnLitTurnout());
            if (this.currentMast.getUnLitTurnoutState() == 2) {
                this.turnoutUnLitState.setSelectedItem(this.stateClosed);
            } else {
                this.turnoutUnLitState.setSelectedItem(this.stateThrown);
            }
        }
        this.allowUnLit.setSelected(this.currentMast.allowUnLit());
        log.trace("setMast({}) end", (Object)mast);
    }

    @Override
    public boolean createMast(@Nonnull String sigsysname, @Nonnull String mastname, @Nonnull String username) {
        String name;
        log.debug("createMast({},{})", (Object)sigsysname, (Object)mastname);
        if (this.currentMast == null) {
            name = "IF$tsm:" + sigsysname + ":" + mastname.substring(11, mastname.length() - 4);
            name = String.valueOf(name) + "($" + this.paddedNumber.format(TurnoutSignalMast.getLastRef() + 1) + ")";
            this.currentMast = new TurnoutSignalMast(name);
            InstanceManager.getDefault(SignalMastManager.class).register(this.currentMast);
        }
        name = this.currentMast.getSystemName();
        for (Map.Entry<String, TurnoutAspectPanel> entry : this.turnoutAspect.entrySet()) {
            entry.getValue().setReference(String.valueOf(name) + ":" + entry.getKey());
            this.turnoutMastPanel.add(entry.getValue().getPanel());
            if (entry.getValue().isAspectDisabled()) {
                this.currentMast.setAspectDisabled(entry.getKey());
                continue;
            }
            this.currentMast.setAspectEnabled(entry.getKey());
            this.currentMast.setTurnout(entry.getKey(), entry.getValue().getTurnoutName(), entry.getValue().getTurnoutState());
        }
        this.currentMast.resetPreviousStates(this.resetPreviousState.isSelected());
        if (!username.isEmpty()) {
            this.currentMast.setUserName(username);
        }
        this.currentMast.setAllowUnLit(this.allowUnLit.isSelected());
        if (this.allowUnLit.isSelected()) {
            this.currentMast.setUnLitTurnout(this.turnoutUnLitBox.getDisplayName(), this.turnoutStateValues[this.turnoutUnLitState.getSelectedIndex()]);
        }
        return true;
    }

    public static class SignalMastAddPaneProvider
    extends SignalMastAddPane.SignalMastAddPaneProvider {
        @Override
        @Nonnull
        public String getPaneName() {
            return Bundle.getMessage("TurnCtlMast");
        }

        @Override
        @Nonnull
        public SignalMastAddPane getNewPane() {
            return new TurnoutSignalMastAddPane();
        }
    }

    class TurnoutAspectPanel {
        BeanSelectCreatePanel<Turnout> beanBox = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
        JCheckBox disabledCheck = new JCheckBox(Bundle.getMessage("DisableAspect"));
        JLabel turnoutStateLabel = new JLabel(Bundle.getMessage("SetState"));
        JComboBox<String> turnoutState;
        String aspect;
        JPanel panel;

        TurnoutAspectPanel(String aspect) {
            this.turnoutState = new JComboBox<String>(TurnoutSignalMastAddPane.this.turnoutStates);
            this.aspect = "";
            this.aspect = aspect;
        }

        TurnoutAspectPanel(String turnoutName, int state) {
            this.turnoutState = new JComboBox<String>(TurnoutSignalMastAddPane.this.turnoutStates);
            this.aspect = "";
            if (turnoutName == null || turnoutName.isEmpty()) {
                return;
            }
            this.beanBox.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(turnoutName));
        }

        void setReference(String reference) {
            this.beanBox.setReference(reference);
        }

        int getTurnoutState() {
            return TurnoutSignalMastAddPane.this.turnoutStateValues[this.turnoutState.getSelectedIndex()];
        }

        void setSelectedTurnout(String name) {
            if (name == null || name.isEmpty()) {
                return;
            }
            this.beanBox.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(name));
        }

        void setTurnoutState(int state) {
            if (state == 2) {
                this.turnoutState.setSelectedItem(TurnoutSignalMastAddPane.this.stateClosed);
            } else {
                this.turnoutState.setSelectedItem(TurnoutSignalMastAddPane.this.stateThrown);
            }
        }

        void setAspectDisabled(boolean boo) {
            this.disabledCheck.setSelected(boo);
            if (boo) {
                this.beanBox.setEnabled(false);
                this.turnoutStateLabel.setEnabled(false);
                this.turnoutState.setEnabled(false);
            } else {
                this.beanBox.setEnabled(true);
                this.turnoutStateLabel.setEnabled(true);
                this.turnoutState.setEnabled(true);
            }
        }

        boolean isAspectDisabled() {
            return this.disabledCheck.isSelected();
        }

        String getTurnoutName() {
            return this.beanBox.getDisplayName();
        }

        NamedBean getTurnout() {
            try {
                return this.beanBox.getNamedBean();
            }
            catch (JmriException jmriException) {
                log.warn("skipping creation of turnout");
                return null;
            }
        }

        JPanel getPanel() {
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new BoxLayout(this.panel, 1));
                JPanel turnDetails = new JPanel();
                turnDetails.add(this.beanBox);
                turnDetails.add(this.turnoutStateLabel);
                turnDetails.add(this.turnoutState);
                this.panel.add(turnDetails);
                this.panel.add(this.disabledCheck);
                TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
                border.setTitle(this.aspect);
                this.panel.setBorder(border);
                this.disabledCheck.addActionListener(e -> this.setAspectDisabled(this.disabledCheck.isSelected()));
            }
            return this.panel;
        }
    }
}

