/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.signalmast;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.implementation.SignalMastRepeater;
import jmri.jmrit.beantable.signalmast.Bundle;
import jmri.managers.DefaultSignalMastManager;
import jmri.swing.NamedBeanComboBox;
import jmri.swing.RowSorterUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriPanel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastRepeaterPanel
extends JmriPanel
implements PropertyChangeListener {
    final DefaultSignalMastManager dsmm;
    SignalMastRepeaterModel _RepeaterModel;
    JScrollPane _SignalAppearanceScrollPane;
    NamedBeanComboBox<SignalMast> _MasterBox;
    NamedBeanComboBox<SignalMast> _SlaveBox;
    JButton _addRepeater;
    JmriJFrame signalMastLogicFrame = null;
    JLabel sourceLabel = new JLabel();
    private ArrayList<SignalMastRepeater> _signalMastRepeaterList;
    private static final Logger log = LoggerFactory.getLogger(SignalMastRepeaterPanel.class);

    public SignalMastRepeaterPanel() {
        this.dsmm = (DefaultSignalMastManager)InstanceManager.getDefault(SignalMastManager.class);
        this.init();
    }

    final void init() {
        this.dsmm.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        JPanel sourcePanel = new JPanel();
        header.add(sourcePanel);
        this.add((Component)header, "North");
        this._RepeaterModel = new SignalMastRepeaterModel();
        JTable _RepeaterTable = new JTable(this._RepeaterModel);
        TableRowSorter<SignalMastRepeaterModel> sorter = new TableRowSorter<SignalMastRepeaterModel>(this._RepeaterModel);
        RowSorterUtil.setSortOrder(sorter, 1, SortOrder.ASCENDING);
        _RepeaterTable.setRowSorter(sorter);
        _RepeaterTable.setRowSelectionAllowed(false);
        _RepeaterTable.setPreferredScrollableViewportSize(new Dimension(526, 120));
        this._RepeaterModel.configureTable(_RepeaterTable);
        this._SignalAppearanceScrollPane = new JScrollPane(_RepeaterTable);
        this._RepeaterModel.fireTableDataChanged();
        this.add((Component)this._SignalAppearanceScrollPane, "Center");
        JPanel footer = new JPanel();
        this.updateDetails();
        this._MasterBox = new NamedBeanComboBox<SignalMast>(this.dsmm);
        this._MasterBox.addActionListener(e -> this.setSlaveBoxLists());
        this._SlaveBox = new NamedBeanComboBox<SignalMast>(this.dsmm);
        this._SlaveBox.setEnabled(false);
        footer.add(new JLabel(String.valueOf(Bundle.getMessage("Master")) + " : "));
        footer.add(this._MasterBox);
        footer.add(new JLabel(String.valueOf(Bundle.getMessage("Slave")) + " : "));
        footer.add(this._SlaveBox);
        this._addRepeater = new JButton(Bundle.getMessage("ButtonAddText"));
        this._addRepeater.setEnabled(false);
        this._addRepeater.addActionListener(e -> {
            SignalMastRepeater rp = new SignalMastRepeater((SignalMast)this._MasterBox.getSelectedItem(), (SignalMast)this._SlaveBox.getSelectedItem());
            try {
                this.dsmm.addRepeater(rp);
            }
            catch (JmriException ex) {
                log.error(ex.toString());
                JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("MessageAddFailed"), this._MasterBox.getSelectedItemDisplayName(), this._SlaveBox.getSelectedItemDisplayName()), Bundle.getMessage("TitleAddFailed"), 0);
            }
        });
        footer.add(this._addRepeater);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        border.setTitle(Bundle.getMessage("AddRepeater"));
        footer.setBorder(border);
        this.add((Component)footer, "South");
    }

    void setSlaveBoxLists() {
        SignalMast masterMast = (SignalMast)this._MasterBox.getSelectedItem();
        if (masterMast == null) {
            this._SlaveBox.setEnabled(false);
            this._addRepeater.setEnabled(false);
            return;
        }
        Iterator iter = this.dsmm.getNamedBeanSet().iterator();
        if (!iter.hasNext()) {
            return;
        }
        HashSet<SignalMast> excludedSignalMasts = new HashSet<SignalMast>();
        while (iter.hasNext()) {
            SignalMast s = (SignalMast)iter.next();
            if (s.getAppearanceMap() != masterMast.getAppearanceMap()) {
                excludedSignalMasts.add(s);
                continue;
            }
            if (s != masterMast) continue;
            excludedSignalMasts.add(s);
        }
        this._SlaveBox.setExcludedItems(excludedSignalMasts);
        if (excludedSignalMasts.size() == this.dsmm.getNamedBeanSet().size()) {
            this._SlaveBox.setEnabled(false);
            this._addRepeater.setEnabled(false);
        } else {
            this._SlaveBox.setEnabled(true);
            this._addRepeater.setEnabled(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    private void updateDetails() {
        this._signalMastRepeaterList = new ArrayList<SignalMastRepeater>(this.dsmm.getRepeaterList());
        this._RepeaterModel.fireTableDataChanged();
    }

    public class SignalMastRepeaterModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int MASTER_COLUMN = 0;
        public static final int DIR_COLUMN = 1;
        public static final int SLAVE_COLUMN = 2;
        public static final int ENABLE_COLUMN = 3;
        public static final int DEL_COLUMN = 4;

        SignalMastRepeaterModel() {
            this.init();
        }

        final void init() {
            SignalMastRepeaterPanel.this.dsmm.addPropertyChangeListener(this);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 1: 
                case 4: {
                    return JButton.class;
                }
                case 3: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        public void configureTable(JTable table) {
            table.getTableHeader().setReorderingAllowed(true);
            table.setAutoResizeMode(0);
            int i = 0;
            while (i < table.getColumnCount()) {
                int width = this.getPreferredWidth(i);
                table.getColumnModel().getColumn(i).setPreferredWidth(width);
                ++i;
            }
            table.sizeColumnsToFit(-1);
            this.configEditColumn(table);
        }

        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
        public int getPreferredWidth(int col) {
            switch (col) {
                case 1: 
                case 3: {
                    return new JTextField((int)5).getPreferredSize().width;
                }
                case 2: {
                    return new JTextField((int)15).getPreferredSize().width;
                }
                case 0: {
                    return new JTextField((int)15).getPreferredSize().width;
                }
                case 4: {
                    return new JTextField((int)22).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnMaster");
                }
                case 1: {
                    return Bundle.getMessage("ColumnDir");
                }
                case 2: {
                    return Bundle.getMessage("ColumnSlave");
                }
                case 3: {
                    return Bundle.getMessage("ColumnHeadEnabled");
                }
            }
            return "";
        }

        public void dispose() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("repeaterlength")) {
                SignalMastRepeaterPanel.this.updateDetails();
            }
        }

        protected void configEditColumn(JTable table) {
            JButton b = new JButton("< >");
            b.putClientProperty("JComponent.sizeVariant", "small");
            b.putClientProperty("JButton.buttonType", "square");
            this.setColumnToHoldButton(table, 1, b);
            this.setColumnToHoldButton(table, 4, new JButton(Bundle.getMessage("ButtonDelete")));
        }

        protected void setColumnToHoldButton(JTable table, int column, JButton sample) {
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            table.setDefaultRenderer(JButton.class, buttonRenderer);
            ButtonEditor buttonEditor = new ButtonEditor(new JButton());
            table.setDefaultEditor(JButton.class, buttonEditor);
            table.setRowHeight(sample.getPreferredSize().height);
            table.getColumnModel().getColumn(column).setPreferredWidth(sample.getPreferredSize().width + 4);
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                case 1: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        protected void deleteRepeater(int r) {
            SignalMastRepeaterPanel.this.dsmm.removeRepeater((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r));
        }

        public void setSetToState(String x) {
        }

        @Override
        public int getRowCount() {
            return SignalMastRepeaterPanel.this._signalMastRepeaterList == null ? 0 : SignalMastRepeaterPanel.this._signalMastRepeaterList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (r >= SignalMastRepeaterPanel.this._signalMastRepeaterList.size()) {
                log.debug("row is greater than turnout list size");
                return null;
            }
            switch (c) {
                case 0: {
                    return ((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).getMasterMastName();
                }
                case 1: {
                    switch (((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).getDirection()) {
                        case 0: {
                            return "< >";
                        }
                        case 1: {
                            return " > ";
                        }
                        case 2: {
                            return " < ";
                        }
                    }
                    return "< >";
                }
                case 2: {
                    return ((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).getSlaveMastName();
                }
                case 3: {
                    return ((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).getEnabled();
                }
                case 4: {
                    return Bundle.getMessage("ButtonDelete");
                }
            }
            return null;
        }

        @Override
        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
        public void setValueAt(Object type, int r, int c) {
            switch (c) {
                case 1: {
                    switch (((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).getDirection()) {
                        case 0: {
                            ((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).setDirection(1);
                            break;
                        }
                        case 1: {
                            ((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).setDirection(2);
                            break;
                        }
                        case 2: {
                            ((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).setDirection(0);
                            break;
                        }
                        default: {
                            ((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).setDirection(0);
                        }
                    }
                    SignalMastRepeaterPanel.this._RepeaterModel.fireTableDataChanged();
                    break;
                }
                case 4: {
                    this.deleteRepeater(r);
                    break;
                }
                case 3: {
                    boolean b = (Boolean)type;
                    ((SignalMastRepeater)SignalMastRepeaterPanel.this._signalMastRepeaterList.get(r)).setEnabled(b);
                    break;
                }
            }
        }
    }
}

