/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.signalmast;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.SignalAppearanceMap;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SignalSystem;
import jmri.implementation.DefaultSignalAppearanceMap;
import jmri.implementation.SignalHeadSignalMast;
import jmri.jmrit.beantable.signalmast.Bundle;
import jmri.jmrit.beantable.signalmast.SignalMastAddPane;
import jmri.swing.NamedBeanComboBox;
import jmri.util.StringUtil;
import jmri.util.javaworld.GridLayout2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadSignalMastAddPane
extends SignalMastAddPane {
    JPanel signalHeadPanel = new JPanel();
    ArrayList<NamedBeanComboBox<SignalHead>> headList = new ArrayList(5);
    private final JCheckBox includeUsed = new JCheckBox(Bundle.getMessage("IncludeUsedHeads"));
    private final JCheckBox allowUnLit = new JCheckBox();
    LinkedHashMap<String, JCheckBox> disabledAspects = new LinkedHashMap(12);
    JPanel disabledAspectsPanel = new JPanel();
    SignalHeadSignalMast currentMast = null;
    Set<SignalHead> alreadyUsed = new HashSet<SignalHead>();
    DefaultSignalAppearanceMap map;
    private static final Logger log = LoggerFactory.getLogger(SignalHeadSignalMastAddPane.class);

    public SignalHeadSignalMastAddPane() {
        this.initPane();
    }

    final void initPane() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(String.valueOf(Bundle.getMessage("AllowUnLitLabel")) + ": "));
        p.add(this.allowUnLit);
        p.setAlignmentX(0.0f);
        this.add(p);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        border.setTitle(Bundle.getMessage("MenuItemSignalTable"));
        this.signalHeadPanel.setBorder(border);
        this.add(this.signalHeadPanel);
        this.includeUsed.addActionListener(e -> this.refreshHeadComboBox());
        TitledBorder disableborder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        disableborder.setTitle(Bundle.getMessage("DisableAspectsLabel"));
        JScrollPane disabledAspectsScroll = new JScrollPane(this.disabledAspectsPanel);
        disabledAspectsScroll.setBorder(disableborder);
        this.add(disabledAspectsScroll);
    }

    @Override
    @Nonnull
    public String getPaneName() {
        return Bundle.getMessage("HeadCtlMast");
    }

    @Override
    public void setAspectNames(@Nonnull SignalAppearanceMap newMap, @Nonnull SignalSystem sigSystem) {
        log.debug("setAspectNames(...)");
        this.map = (DefaultSignalAppearanceMap)newMap;
        int count = this.map.getAspectSettings(this.map.getAspects().nextElement()).length;
        log.trace(" head count is {}", (Object)count);
        Enumeration<String> aspects = this.map.getAspects();
        this.headList = new ArrayList(count);
        this.signalHeadPanel.removeAll();
        int i = 0;
        while (i < count) {
            NamedBeanComboBox<SignalHead> head = new NamedBeanComboBox<SignalHead>(InstanceManager.getDefault(SignalHeadManager.class));
            head.setExcludedItems(this.alreadyUsed);
            this.headList.add(head);
            this.signalHeadPanel.add(head);
            ++i;
        }
        this.signalHeadPanel.add(this.includeUsed);
        this.signalHeadPanel.setLayout(new GridLayout2(0, 1));
        this.signalHeadPanel.revalidate();
        this.disabledAspects = new LinkedHashMap(10);
        this.disabledAspectsPanel.removeAll();
        while (aspects.hasMoreElements()) {
            String aspect = aspects.nextElement();
            JCheckBox disabled = new JCheckBox(aspect);
            this.disabledAspects.put(aspect, disabled);
        }
        for (Map.Entry<String, JCheckBox> entry : this.disabledAspects.entrySet()) {
            this.disabledAspectsPanel.add(entry.getValue());
        }
        this.disabledAspectsPanel.setLayout(new GridLayout2(0, 1));
        this.disabledAspectsPanel.revalidate();
    }

    @Override
    public boolean canHandleMast(@Nonnull SignalMast mast) {
        return mast instanceof SignalHeadSignalMast;
    }

    @Override
    public void setMast(SignalMast mast) {
        log.debug("setMast({})", (Object)mast);
        if (mast == null) {
            this.currentMast = null;
            return;
        }
        if (!(mast instanceof SignalHeadSignalMast)) {
            log.error("mast was wrong type: {} {}", (Object)mast.getSystemName(), (Object)mast.getClass().getName());
            return;
        }
        this.currentMast = (SignalHeadSignalMast)mast;
        int count = this.map.getAspectSettings(this.map.getAspects().nextElement()).length;
        log.trace(" head count is {}", (Object)count);
        this.signalHeadPanel.removeAll();
        this.signalHeadPanel.setLayout(new GridLayout2(count + 1, 1));
        int i = 0;
        while (i < count) {
            NamedBeanComboBox<SignalHead> head = new NamedBeanComboBox<SignalHead>(InstanceManager.getDefault(SignalHeadManager.class));
            head.setExcludedItems(this.alreadyUsed);
            this.headList.add(head);
            head.setEnabled(false);
            head.setSelectedItem(this.currentMast.getHeadsUsed().get(i).getBean());
            this.signalHeadPanel.add(head);
            ++i;
        }
        this.signalHeadPanel.add(this.includeUsed);
        this.signalHeadPanel.revalidate();
        List<String> disabled = this.currentMast.getDisabledAspects();
        if (disabled != null) {
            for (String aspect : disabled) {
                if (!this.disabledAspects.containsKey(aspect)) continue;
                this.disabledAspects.get(aspect).setSelected(true);
            }
        }
        this.allowUnLit.setSelected(this.currentMast.allowUnLit());
        log.trace("setMast {} end", (Object)mast);
    }

    @Override
    public boolean createMast(@Nonnull String sigsysname, @Nonnull String mastname, @Nonnull String username) {
        log.debug("createMast({},{})", (Object)sigsysname, (Object)mastname);
        if (this.currentMast == null) {
            StringBuilder build = new StringBuilder();
            build.append("IF$shsm:").append(sigsysname).append(":").append(mastname.substring(11, mastname.length() - 4));
            for (NamedBeanComboBox<SignalHead> head : this.headList) {
                if (head == null || head.getSelectedItemDisplayName() == null) continue;
                build.append("(").append(StringUtil.parenQuote(head.getSelectedItemDisplayName())).append(")");
            }
            String name = build.toString();
            log.debug("add signal: {}", (Object)name);
            SignalMast m = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(name);
            if (m != null) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("DuplicateMast"), m.getDisplayName()), Bundle.getMessage("DuplicateMastTitle"), 1);
                return false;
            }
            try {
                this.currentMast = (SignalHeadSignalMast)InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleCreateException(name);
                return false;
            }
        }
        for (Map.Entry<String, JCheckBox> entry : this.disabledAspects.entrySet()) {
            if (entry.getValue().isSelected()) {
                this.currentMast.setAspectDisabled(entry.getKey());
                continue;
            }
            this.currentMast.setAspectEnabled(entry.getKey());
        }
        if (!username.isEmpty()) {
            this.currentMast.setUserName(username);
        }
        this.currentMast.setAllowUnLit(this.allowUnLit.isSelected());
        return true;
    }

    protected void refreshHeadComboBox() {
        log.trace("refreshHeadComboBox");
        if (this.includeUsed.isSelected()) {
            this.alreadyUsed = new HashSet<SignalHead>();
        } else {
            List<SignalHead> alreadyUsedHeads = SignalHeadSignalMast.getSignalHeadsUsed();
            this.alreadyUsed = new HashSet<SignalHead>();
            log.trace("   found {}", (Object)alreadyUsedHeads.size());
            for (SignalHead head : alreadyUsedHeads) {
                this.alreadyUsed.add(head);
            }
        }
        for (NamedBeanComboBox<SignalHead> head : this.headList) {
            head.setExcludedItems(this.alreadyUsed);
        }
    }

    void handleCreateException(String sysName) {
        JOptionPane.showMessageDialog(null, String.valueOf(Bundle.getMessage("ErrorSignalMastAddFailed", sysName)) + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), Bundle.getMessage("ErrorTitle"), 0);
    }

    public static class SignalMastAddPaneProvider
    extends SignalMastAddPane.SignalMastAddPaneProvider {
        @Override
        @Nonnull
        public String getPaneName() {
            return Bundle.getMessage("HeadCtlMast");
        }

        @Override
        @Nonnull
        public SignalMastAddPane getNewPane() {
            return new SignalHeadSignalMastAddPane();
        }
    }
}

