/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.signalmast;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalAppearanceMap;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SignalSystem;
import jmri.Turnout;
import jmri.UserPreferencesManager;
import jmri.implementation.DefaultSignalAppearanceMap;
import jmri.implementation.MatrixSignalMast;
import jmri.jmrit.beantable.signalmast.Bundle;
import jmri.jmrit.beantable.signalmast.SignalMastAddPane;
import jmri.util.JmriJFrame;
import jmri.util.javaworld.GridLayout2;
import jmri.util.swing.BeanSelectCreatePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatrixSignalMastAddPane
extends SignalMastAddPane {
    private DefaultSignalAppearanceMap map;
    private MatrixSignalMast currentMast;
    private JCheckBox resetPreviousState = new JCheckBox(Bundle.getMessage("ResetPrevious"));
    private UserPreferencesManager prefs = InstanceManager.getDefault(UserPreferencesManager.class);
    private String matrixBitNumSelectionCombo = String.valueOf(this.getClass().getName()) + ".matrixBitNumSelected";
    private JCheckBox allowUnLit = new JCheckBox();
    private JScrollPane matrixMastScroll;
    private JPanel matrixMastBitnumPanel;
    private JPanel matrixMastPanel = new JPanel();
    private char[] unLitPanelBits;
    private int numberOfActiveAspects;
    private JLabel bitNumLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("MatrixBitsLabel")));
    private JComboBox<String> columnChoice = new JComboBox<String>(this.choiceArray());
    private JSpinner timeDelay = new JSpinner();
    private LinkedHashMap<String, MatrixAspectPanel> matrixAspect = new LinkedHashMap(12);
    private DecimalFormat paddedNumber = new DecimalFormat("0000");
    public static final int MAXMATRIXBITS = 10;
    private String emptyChars = "0000000000";
    private char[] emptyBits = this.emptyChars.toCharArray();
    private BeanSelectCreatePanel<Turnout> turnoutBox1 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private BeanSelectCreatePanel<Turnout> turnoutBox2 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private BeanSelectCreatePanel<Turnout> turnoutBox3 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private BeanSelectCreatePanel<Turnout> turnoutBox4 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private BeanSelectCreatePanel<Turnout> turnoutBox5 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private BeanSelectCreatePanel<Turnout> turnoutBox6 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private BeanSelectCreatePanel<Turnout> turnoutBox7 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private BeanSelectCreatePanel<Turnout> turnoutBox8 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private BeanSelectCreatePanel<Turnout> turnoutBox9 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private BeanSelectCreatePanel<Turnout> turnoutBox10 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
    private int bitNum;
    private JPanel matrixUnLitPanel = new JPanel();
    private JCheckBox[] unlitCheckArray = new JCheckBox[10];
    private static final Logger log = LoggerFactory.getLogger(MatrixSignalMastAddPane.class);

    public MatrixSignalMastAddPane() {
        int i = 0;
        while (i < 10) {
            this.unlitCheckArray[i] = new JCheckBox();
            ++i;
        }
        this.init();
    }

    final void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("AllowUnLitLabel"))));
        p.add(this.allowUnLit);
        p.setAlignmentX(0.0f);
        this.add(p);
        this.add(this.matrixUnLitPanel);
        this.matrixUnLitPanel();
        this.matrixMastBitnumPanel = this.makeMatrixMastBitnumPanel();
        this.add(this.matrixMastBitnumPanel);
        if (this.prefs.getComboBoxLastSelection(this.matrixBitNumSelectionCombo) != null) {
            this.columnChoice.setSelectedItem(this.prefs.getComboBoxLastSelection(this.matrixBitNumSelectionCombo));
        }
        this.matrixMastScroll = new JScrollPane(this.matrixMastPanel);
        this.matrixMastScroll.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.matrixMastScroll);
    }

    private String[] choiceArray() {
        Object[] numberOfOutputs = new String[10];
        int i = 0;
        while (i < 10) {
            numberOfOutputs[i] = String.valueOf(i + 1);
            ++i;
        }
        log.debug("Created output combo box: {}", (Object)Arrays.toString(numberOfOutputs));
        return numberOfOutputs;
    }

    @Override
    @Nonnull
    public String getPaneName() {
        return Bundle.getMessage("MatrixCtlMast");
    }

    @Override
    public void setAspectNames(@Nonnull SignalAppearanceMap newMap, @Nonnull SignalSystem sigSystem) {
        log.debug("setAspectNames(...)");
        this.unLitPanelBits = Arrays.copyOf(this.emptyBits, 10);
        this.map = (DefaultSignalAppearanceMap)newMap;
        this.updateMatrixMastPanel();
        this.columnChoice.setSelectedIndex(this.bitNum - 1);
    }

    @Override
    public boolean canHandleMast(@Nonnull SignalMast mast) {
        return mast instanceof MatrixSignalMast;
    }

    @Override
    public void setMast(SignalMast mast) {
        log.debug("setMast({})", (Object)mast);
        if (mast == null) {
            this.currentMast = null;
            return;
        }
        if (!(mast instanceof MatrixSignalMast)) {
            log.error("mast was wrong type: {} {}", (Object)mast.getSystemName(), (Object)mast.getClass().getName());
            return;
        }
        this.currentMast = (MatrixSignalMast)mast;
        this.bitNum = this.currentMast.getBitNum();
        this.updateMatrixMastPanel();
        if (this.map != null) {
            Enumeration<String> aspects = this.map.getAspects();
            while (aspects.hasMoreElements()) {
                String key = aspects.nextElement();
                MatrixAspectPanel matrixPanel = this.matrixAspect.get(key);
                matrixPanel.setAspectDisabled(this.currentMast.isAspectDisabled(key));
                if (this.currentMast.isAspectDisabled(key)) continue;
                char[] mastBits = this.currentMast.getBitsForAspect(key);
                char[] panelAspectBits = Arrays.copyOf(mastBits, 10);
                matrixPanel.updateAspectBits(panelAspectBits);
                matrixPanel.setAspectBoxes(panelAspectBits);
            }
        }
        this.columnChoice.setSelectedIndex(this.bitNum - 1);
        this.columnChoice.setEnabled(false);
        if (!this.currentMast.getOutputName(1).isEmpty()) {
            this.turnoutBox1.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(1)));
        }
        if (this.bitNum > 1 && !this.currentMast.getOutputName(2).isEmpty()) {
            this.turnoutBox2.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(2)));
        }
        if (this.bitNum > 2 && !this.currentMast.getOutputName(3).isEmpty()) {
            this.turnoutBox3.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(3)));
        }
        if (this.bitNum > 3 && !this.currentMast.getOutputName(4).isEmpty()) {
            this.turnoutBox4.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(4)));
        }
        if (this.bitNum > 4 && !this.currentMast.getOutputName(5).isEmpty()) {
            this.turnoutBox5.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(5)));
        }
        if (this.bitNum > 5 && !this.currentMast.getOutputName(6).isEmpty()) {
            this.turnoutBox6.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(6)));
        }
        if (this.bitNum > 6 && !this.currentMast.getOutputName(6).isEmpty()) {
            this.turnoutBox7.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(7)));
        }
        if (this.bitNum > 7 && !this.currentMast.getOutputName(6).isEmpty()) {
            this.turnoutBox8.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(8)));
        }
        if (this.bitNum > 8 && !this.currentMast.getOutputName(6).isEmpty()) {
            this.turnoutBox9.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(9)));
        }
        if (this.bitNum > 9 && !this.currentMast.getOutputName(6).isEmpty()) {
            this.turnoutBox10.setDefaultNamedBean(InstanceManager.turnoutManagerInstance().getTurnout(this.currentMast.getOutputName(10)));
        }
        if (this.currentMast.resetPreviousStates()) {
            this.resetPreviousState.setSelected(true);
        }
        this.unLitPanelBits = Arrays.copyOf(this.currentMast.getUnLitBits(), 10);
        int i = 0;
        while (i < 10) {
            this.unlitCheckArray[i].setSelected(this.unLitPanelBits[i] == '1');
            ++i;
        }
        this.allowUnLit.setSelected(this.currentMast.allowUnLit());
        this.timeDelay.setValue(this.currentMast.getMatrixMastCommandDelay());
        log.trace("setMast {} end", (Object)mast);
    }

    @Override
    public boolean createMast(@Nonnull String sigsysname, @Nonnull String mastname, @Nonnull String username) {
        String newMastName;
        log.debug("createMast({},{})", (Object)sigsysname, (Object)mastname);
        if (this.turnoutBox1.isEmpty() || this.bitNum > 1 && this.turnoutBox2.isEmpty() || this.bitNum > 2 && this.turnoutBox3.isEmpty() || this.bitNum > 3 && this.turnoutBox4.isEmpty() || this.bitNum > 4 && this.turnoutBox5.isEmpty() || this.bitNum > 5 && this.turnoutBox6.isEmpty() || this.bitNum > 6 && this.turnoutBox7.isEmpty() || this.bitNum > 7 && this.turnoutBox8.isEmpty() || this.bitNum > 8 && this.turnoutBox9.isEmpty() || this.bitNum > 9 && this.turnoutBox10.isEmpty()) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("MatrixOutputEmpty", mastname), Bundle.getMessage("WarningTitle"), 0);
            log.warn("Empty output on panel");
            return false;
        }
        if (this.identicalBits()) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("AspectMastBitsWarning", (int)Math.sqrt(this.numberOfActiveAspects), this.numberOfActiveAspects), Bundle.getMessage("WarningTitle"), 0);
            log.warn("Identical bits on panel");
            return false;
        }
        if (this.currentMast == null) {
            newMastName = "IF$xsm:" + sigsysname + ":" + mastname.substring(11, mastname.length() - 4);
            newMastName = String.valueOf(newMastName) + "($" + this.paddedNumber.format(MatrixSignalMast.getLastRef() + 1);
            newMastName = String.valueOf(newMastName) + ")-" + this.bitNum + "t";
            this.currentMast = new MatrixSignalMast(newMastName);
            InstanceManager.getDefault(SignalMastManager.class).register(this.currentMast);
        } else {
            newMastName = this.currentMast.getSystemName();
        }
        this.currentMast.setBitNum(this.bitNum);
        log.debug("newMastName = {}", (Object)newMastName);
        this.currentMast.setOutput("output1", this.turnoutBox1.getDisplayName());
        try {
            this.turnoutBox1.updateComment(this.turnoutBox1.getNamedBean(), String.valueOf(newMastName) + ":output1");
            if (this.bitNum > 1) {
                this.currentMast.setOutput("output2", this.turnoutBox2.getDisplayName());
                this.turnoutBox2.updateComment(this.turnoutBox2.getNamedBean(), String.valueOf(newMastName) + ":output2");
                if (this.bitNum > 2) {
                    this.currentMast.setOutput("output3", this.turnoutBox3.getDisplayName());
                    this.turnoutBox3.updateComment(this.turnoutBox3.getNamedBean(), String.valueOf(newMastName) + ":output3");
                    if (this.bitNum > 3) {
                        this.currentMast.setOutput("output4", this.turnoutBox4.getDisplayName());
                        this.turnoutBox4.updateComment(this.turnoutBox4.getNamedBean(), String.valueOf(newMastName) + ":output4");
                        if (this.bitNum > 4) {
                            this.currentMast.setOutput("output5", this.turnoutBox5.getDisplayName());
                            this.turnoutBox5.updateComment(this.turnoutBox5.getNamedBean(), String.valueOf(newMastName) + ":output5");
                            if (this.bitNum > 5) {
                                this.currentMast.setOutput("output6", this.turnoutBox6.getDisplayName());
                                this.turnoutBox6.updateComment(this.turnoutBox6.getNamedBean(), String.valueOf(newMastName) + ":output6");
                                if (this.bitNum > 6) {
                                    this.currentMast.setOutput("output7", this.turnoutBox7.getDisplayName());
                                    this.turnoutBox7.updateComment(this.turnoutBox7.getNamedBean(), String.valueOf(newMastName) + ":output7");
                                    if (this.bitNum > 7) {
                                        this.currentMast.setOutput("output8", this.turnoutBox8.getDisplayName());
                                        this.turnoutBox8.updateComment(this.turnoutBox8.getNamedBean(), String.valueOf(newMastName) + ":output8");
                                        if (this.bitNum > 8) {
                                            this.currentMast.setOutput("output9", this.turnoutBox9.getDisplayName());
                                            this.turnoutBox9.updateComment(this.turnoutBox9.getNamedBean(), String.valueOf(newMastName) + ":output9");
                                            if (this.bitNum > 9) {
                                                this.currentMast.setOutput("output10", this.turnoutBox10.getDisplayName());
                                                this.turnoutBox10.updateComment(this.turnoutBox10.getNamedBean(), String.valueOf(newMastName) + ":output10");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (JmriException jmriException) {
            log.warn("bean not found");
        }
        for (Map.Entry<String, MatrixAspectPanel> entry : this.matrixAspect.entrySet()) {
            this.matrixMastPanel.add(entry.getValue().getPanel());
            if (this.matrixAspect.get(entry.getKey()).isAspectDisabled()) {
                this.currentMast.setAspectDisabled(entry.getKey());
                continue;
            }
            this.currentMast.setAspectEnabled(entry.getKey());
            this.currentMast.setBitsForAspect(entry.getKey(), this.matrixAspect.get(entry.getKey()).trimAspectBits());
        }
        this.currentMast.resetPreviousStates(this.resetPreviousState.isSelected());
        this.currentMast.setAllowUnLit(this.allowUnLit.isSelected());
        try {
            this.currentMast.setUnLitBits(this.trimUnLitBits());
        }
        catch (Exception exception) {
            log.error("failed to read and copy unLitPanelBits");
        }
        if (!username.isEmpty()) {
            this.currentMast.setUserName(username);
        }
        this.prefs.setComboBoxLastSelection(this.matrixBitNumSelectionCombo, (String)this.columnChoice.getSelectedItem());
        this.currentMast.setAllowUnLit(this.allowUnLit.isSelected());
        int addDelay = (Integer)this.timeDelay.getValue();
        this.currentMast.setMatrixMastCommandDelay(addDelay);
        log.debug("mast create completed successfully");
        return true;
    }

    private JPanel makeMatrixMastBitnumPanel() {
        JPanel bitnumpanel = new JPanel();
        bitnumpanel.setLayout(new FlowLayout(3));
        bitnumpanel.add(this.bitNumLabel);
        bitnumpanel.add(this.columnChoice);
        if (this.bitNum < 1 || this.bitNum > 10) {
            this.bitNum = 4;
        }
        this.columnChoice.setSelectedIndex(this.bitNum - 1);
        this.columnChoice.addActionListener(e -> {
            String newBitnumString = (String)this.columnChoice.getSelectedItem();
            if (newBitnumString == null) {
                newBitnumString = "4";
                log.debug("null newBitnumString in makeMatrixMastBitnumPanel()");
            }
            this.bitNumChanged(Integer.valueOf(newBitnumString));
        });
        return bitnumpanel;
    }

    private char[] trimUnLitBits() {
        if (this.unLitPanelBits != null) {
            return Arrays.copyOf(this.unLitPanelBits, this.bitNum);
        }
        return Arrays.copyOf(this.emptyBits, this.bitNum);
    }

    private void updateMatrixMastPanel() {
        this.matrixAspect = new LinkedHashMap(12);
        if (this.map == null) {
            return;
        }
        Enumeration<String> aspects = this.map.getAspects();
        while (aspects.hasMoreElements()) {
            String aspect = aspects.nextElement();
            MatrixAspectPanel aspectpanel = new MatrixAspectPanel(aspect);
            this.matrixAspect.put(aspect, aspectpanel);
        }
        this.matrixMastPanel.removeAll();
        JPanel turnoutpanel = new JPanel();
        JPanel output1panel = this.makeOutputPanel(this.turnoutBox1, 1);
        turnoutpanel.add(output1panel);
        output1panel.setVisible(true);
        turnoutpanel.add(this.makeOutputPanel(this.turnoutBox2, 2));
        turnoutpanel.add(this.makeOutputPanel(this.turnoutBox3, 3));
        turnoutpanel.add(this.makeOutputPanel(this.turnoutBox4, 4));
        this.matrixMastPanel.add(turnoutpanel);
        turnoutpanel = new JPanel();
        turnoutpanel.add(this.makeOutputPanel(this.turnoutBox5, 5));
        turnoutpanel.add(this.makeOutputPanel(this.turnoutBox6, 6));
        turnoutpanel.add(this.makeOutputPanel(this.turnoutBox7, 7));
        turnoutpanel.add(this.makeOutputPanel(this.turnoutBox8, 8));
        this.matrixMastPanel.add(turnoutpanel);
        turnoutpanel = new JPanel();
        turnoutpanel.add(this.makeOutputPanel(this.turnoutBox9, 9));
        turnoutpanel.add(this.makeOutputPanel(this.turnoutBox10, 10));
        this.matrixMastPanel.add(turnoutpanel);
        int i = 0;
        while (i < 10) {
            this.unlitCheckArray[i].setVisible(i < this.bitNum);
            ++i;
        }
        JPanel matrixHeader = new JPanel();
        JLabel matrixHeaderLabel = new JLabel(Bundle.getMessage("AspectMatrixHeaderLabel", this.bitNum), 0);
        matrixHeader.add(matrixHeaderLabel);
        matrixHeaderLabel.setToolTipText(Bundle.getMessage("AspectMatrixHeaderTooltip"));
        this.matrixMastPanel.add(matrixHeader);
        for (Map.Entry<String, MatrixAspectPanel> entry : this.matrixAspect.entrySet()) {
            this.matrixMastPanel.add(entry.getValue().getPanel());
        }
        if ((this.matrixAspect.size() & 1) == 1) {
            this.matrixMastPanel.add(new JLabel());
        }
        this.matrixMastPanel.add(this.resetPreviousState);
        this.resetPreviousState.setToolTipText(Bundle.getMessage("ResetPreviousToolTip"));
        JPanel matrixCopyPanel = new JPanel();
        matrixCopyPanel.setLayout(new FlowLayout(3));
        matrixCopyPanel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("MatrixMastCopyAspectBits"))));
        matrixCopyPanel.add(this.copyFromMastSelection());
        this.matrixMastPanel.add(matrixCopyPanel);
        JPanel delayPanel = new JPanel();
        delayPanel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelTurnoutDelay"))));
        this.timeDelay.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        this.timeDelay.setPreferredSize(new JTextField(5).getPreferredSize());
        delayPanel.add(this.timeDelay);
        this.timeDelay.setToolTipText(Bundle.getMessage("TooltipTurnoutDelay"));
        delayPanel.add(new JLabel(Bundle.getMessage("LabelMilliseconds")));
        this.matrixMastPanel.add(delayPanel);
        this.matrixMastPanel.setLayout(new GridLayout2(0, 1));
        this.matrixMastPanel.revalidate();
    }

    JPanel makeOutputPanel(JPanel turnoutPanel, int index) {
        JPanel outputpanel = new JPanel();
        outputpanel.add(turnoutPanel);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        border.setTitle(Bundle.getMessage("MatrixOutputLabel", index));
        outputpanel.setBorder(border);
        outputpanel.setVisible(index <= this.bitNum);
        return outputpanel;
    }

    private void bitNumChanged(Integer newColNum) {
        if (newColNum < 1 || newColNum > 10 || newColNum == this.bitNum) {
            return;
        }
        this.bitNum = newColNum;
        this.updateMatrixMastPanel();
        this.validate();
        Container ancestor = this.getTopLevelAncestor();
        if (ancestor instanceof JmriJFrame) {
            ancestor.setSize(ancestor.getPreferredSize());
            ((JmriJFrame)ancestor).pack();
        }
        this.repaint();
    }

    private void copyFromAnotherMatrixMastAspect(String strMast) {
        int i;
        MatrixSignalMast mast = (MatrixSignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(strMast);
        if (mast == null) {
            log.error("Cannot copy from mast {} which doesn't exist", (Object)strMast);
            return;
        }
        if (this.bitNum != mast.getBitNum() && (i = JOptionPane.showConfirmDialog(null, Bundle.getMessage("MatrixColWarning", mast.getBitNum(), this.bitNum), Bundle.getMessage("MatrixColWarningTitle"), 0)) != 0) {
            return;
        }
        for (Map.Entry<String, MatrixAspectPanel> entry : this.matrixAspect.entrySet()) {
            MatrixAspectPanel matrixPanel = entry.getValue();
            matrixPanel.setAspectDisabled(mast.isAspectDisabled(entry.getKey()));
            if (mast.isAspectDisabled(entry.getKey())) continue;
            char[] mastBits = mast.getBitsForAspect(entry.getKey());
            char[] panelAspectBits = Arrays.copyOf(mastBits, 10);
            matrixPanel.updateAspectBits(panelAspectBits);
            matrixPanel.setAspectBoxes(panelAspectBits);
        }
    }

    private void matrixUnLitPanel() {
        if (this.bitNum < 1 || this.bitNum > 10) {
            this.bitNum = 4;
        }
        JPanel matrixUnLitDetails = new JPanel();
        matrixUnLitDetails.setLayout(new GridLayout2(1, 1));
        int i = 0;
        while (i < 10) {
            matrixUnLitDetails.add(this.unlitCheckArray[i]);
            ++i;
        }
        this.matrixUnLitPanel.add(matrixUnLitDetails);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        border.setTitle(Bundle.getMessage("MatrixUnLitDetails"));
        this.matrixUnLitPanel.setBorder(border);
        this.matrixUnLitPanel.setToolTipText(Bundle.getMessage("MatrixUnlitTooltip"));
        this.unlitCheckArray[0].addActionListener(e -> this.setUnLitBit(1, this.unlitCheckArray[0].isSelected()));
        this.unlitCheckArray[1].addActionListener(e -> this.setUnLitBit(2, this.unlitCheckArray[1].isSelected()));
        this.unlitCheckArray[2].addActionListener(e -> this.setUnLitBit(3, this.unlitCheckArray[2].isSelected()));
        this.unlitCheckArray[3].addActionListener(e -> this.setUnLitBit(4, this.unlitCheckArray[3].isSelected()));
        this.unlitCheckArray[4].addActionListener(e -> this.setUnLitBit(5, this.unlitCheckArray[4].isSelected()));
        this.unlitCheckArray[5].addActionListener(e -> this.setUnLitBit(6, this.unlitCheckArray[5].isSelected()));
        this.unlitCheckArray[6].addActionListener(e -> this.setUnLitBit(7, this.unlitCheckArray[6].isSelected()));
        this.unlitCheckArray[7].addActionListener(e -> this.setUnLitBit(8, this.unlitCheckArray[7].isSelected()));
        this.unlitCheckArray[8].addActionListener(e -> this.setUnLitBit(9, this.unlitCheckArray[8].isSelected()));
        this.unlitCheckArray[9].addActionListener(e -> this.setUnLitBit(10, this.unlitCheckArray[9].isSelected()));
    }

    private JComboBox<String> copyFromMastSelection() {
        JComboBox<String> mastSelect = new JComboBox<String>();
        for (SignalMast mast : InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet()) {
            if (!(mast instanceof MatrixSignalMast)) continue;
            mastSelect.addItem(mast.getDisplayName());
        }
        if (mastSelect.getItemCount() == 0) {
            mastSelect.setEnabled(false);
        } else {
            mastSelect.insertItemAt("", 0);
            mastSelect.setSelectedIndex(0);
            mastSelect.addActionListener(e -> {
                JComboBox eb = (JComboBox)e.getSource();
                String sourceMast = (String)eb.getSelectedItem();
                if (sourceMast != null && !sourceMast.isEmpty()) {
                    this.copyFromAnotherMatrixMastAspect(sourceMast);
                }
            });
        }
        return mastSelect;
    }

    private void setUnLitBit(int column, boolean state) {
        this.unLitPanelBits[column - 1] = state ? 49 : 48;
    }

    private boolean identicalBits() {
        boolean identical = false;
        this.numberOfActiveAspects = 0;
        HashSet<String> seenBits = new HashSet<String>();
        for (Map.Entry<String, MatrixAspectPanel> entry : this.matrixAspect.entrySet()) {
            if (entry.getValue().isAspectDisabled()) continue;
            if (seenBits.contains(String.valueOf(entry.getValue().trimAspectBits()))) {
                identical = true;
                log.debug("-found duplicate {}", (Object)String.valueOf(entry.getValue().trimAspectBits()));
            } else {
                seenBits.add(String.valueOf(entry.getValue().trimAspectBits()));
                log.debug("-added new {}; seenBits = {}", (Object)String.valueOf(entry.getValue().trimAspectBits()), (Object)((Object)seenBits).toString());
            }
            ++this.numberOfActiveAspects;
        }
        return identical;
    }

    class MatrixAspectPanel {
        JCheckBox disabledCheck = new JCheckBox(Bundle.getMessage("DisableAspect"));
        JCheckBox bitCheck1 = new JCheckBox();
        JCheckBox bitCheck2 = new JCheckBox();
        JCheckBox bitCheck3 = new JCheckBox();
        JCheckBox bitCheck4 = new JCheckBox();
        JCheckBox bitCheck5 = new JCheckBox();
        JCheckBox bitCheck6 = new JCheckBox();
        JCheckBox bitCheck7 = new JCheckBox();
        JCheckBox bitCheck8 = new JCheckBox();
        JCheckBox bitCheck9 = new JCheckBox();
        JCheckBox bitCheck10 = new JCheckBox();
        JTextField aspectBitsField = new JTextField(10);
        String aspect = "";
        String emptyChars = "0000000000";
        char[] aspectBits = this.emptyChars.toCharArray();
        JPanel panel;

        MatrixAspectPanel(String aspect) {
            this.aspect = aspect;
        }

        MatrixAspectPanel(String aspect, char[] panelBits) {
            if (panelBits == null || panelBits.length == 0) {
                return;
            }
            this.aspect = aspect;
            this.aspectBits = panelBits;
            this.setAspectBoxes(this.aspectBits);
        }

        void updateAspectBits(char[] newBits) {
            this.aspectBits = newBits;
        }

        boolean isAspectDisabled() {
            return this.disabledCheck.isSelected();
        }

        void setAspectDisabled(boolean boo) {
            this.disabledCheck.setSelected(boo);
            if (boo) {
                this.bitCheck1.setEnabled(false);
                if (MatrixSignalMastAddPane.this.bitNum > 1) {
                    this.bitCheck2.setEnabled(false);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 2) {
                    this.bitCheck3.setEnabled(false);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 3) {
                    this.bitCheck4.setEnabled(false);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 4) {
                    this.bitCheck5.setEnabled(false);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 5) {
                    this.bitCheck6.setEnabled(false);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 6) {
                    this.bitCheck7.setEnabled(false);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 7) {
                    this.bitCheck8.setEnabled(false);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 8) {
                    this.bitCheck9.setEnabled(false);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 9) {
                    this.bitCheck10.setEnabled(false);
                }
            } else {
                this.bitCheck1.setEnabled(true);
                if (MatrixSignalMastAddPane.this.bitNum > 1) {
                    this.bitCheck2.setEnabled(true);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 2) {
                    this.bitCheck3.setEnabled(true);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 3) {
                    this.bitCheck4.setEnabled(true);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 4) {
                    this.bitCheck5.setEnabled(true);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 5) {
                    this.bitCheck6.setEnabled(true);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 6) {
                    this.bitCheck7.setEnabled(true);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 7) {
                    this.bitCheck8.setEnabled(true);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 8) {
                    this.bitCheck9.setEnabled(true);
                }
                if (MatrixSignalMastAddPane.this.bitNum > 9) {
                    this.bitCheck10.setEnabled(true);
                }
            }
        }

        void setBit(int column, boolean state) {
            this.aspectBits[column - 1] = state ? 49 : 48;
            String value = String.valueOf(this.aspectBits);
            this.aspectBitsField.setText(value);
        }

        char[] trimAspectBits() {
            try {
                return Arrays.copyOf(this.aspectBits, MatrixSignalMastAddPane.this.bitNum);
            }
            catch (Exception exception) {
                log.error("failed to read and copy aspectBits");
                return new char[0];
            }
        }

        private void setAspectBoxes(char[] aspectBits) {
            this.bitCheck1.setSelected(aspectBits[0] == '1');
            if (MatrixSignalMastAddPane.this.bitNum > 1) {
                this.bitCheck2.setSelected(aspectBits[1] == '1');
            }
            if (MatrixSignalMastAddPane.this.bitNum > 2) {
                this.bitCheck3.setSelected(aspectBits[2] == '1');
            }
            if (MatrixSignalMastAddPane.this.bitNum > 3) {
                this.bitCheck4.setSelected(aspectBits[3] == '1');
            }
            if (MatrixSignalMastAddPane.this.bitNum > 4) {
                this.bitCheck5.setSelected(aspectBits[4] == '1');
            }
            if (MatrixSignalMastAddPane.this.bitNum > 5) {
                this.bitCheck6.setSelected(aspectBits[5] == '1');
            }
            if (MatrixSignalMastAddPane.this.bitNum > 6) {
                this.bitCheck7.setSelected(aspectBits[6] == '1');
            }
            if (MatrixSignalMastAddPane.this.bitNum > 7) {
                this.bitCheck8.setSelected(aspectBits[7] == '1');
            }
            if (MatrixSignalMastAddPane.this.bitNum > 8) {
                this.bitCheck9.setSelected(aspectBits[8] == '1');
            }
            if (MatrixSignalMastAddPane.this.bitNum > 9) {
                this.bitCheck10.setSelected(aspectBits[9] == '1');
            }
            String value = String.valueOf(aspectBits);
            this.aspectBitsField.setText(value);
        }

        JPanel getPanel() {
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new BoxLayout(this.panel, 1));
                JPanel matrixDetails = new JPanel();
                matrixDetails.add(this.disabledCheck);
                matrixDetails.add(this.bitCheck1);
                matrixDetails.add(this.bitCheck2);
                matrixDetails.add(this.bitCheck3);
                matrixDetails.add(this.bitCheck4);
                matrixDetails.add(this.bitCheck5);
                matrixDetails.add(this.bitCheck6);
                matrixDetails.add(this.bitCheck7);
                matrixDetails.add(this.bitCheck8);
                matrixDetails.add(this.bitCheck9);
                matrixDetails.add(this.bitCheck10);
                this.bitCheck2.setVisible(MatrixSignalMastAddPane.this.bitNum > 1);
                this.bitCheck3.setVisible(MatrixSignalMastAddPane.this.bitNum > 2);
                this.bitCheck4.setVisible(MatrixSignalMastAddPane.this.bitNum > 3);
                this.bitCheck5.setVisible(MatrixSignalMastAddPane.this.bitNum > 4);
                this.bitCheck6.setVisible(MatrixSignalMastAddPane.this.bitNum > 5);
                this.bitCheck7.setVisible(MatrixSignalMastAddPane.this.bitNum > 6);
                this.bitCheck8.setVisible(MatrixSignalMastAddPane.this.bitNum > 7);
                this.bitCheck9.setVisible(MatrixSignalMastAddPane.this.bitNum > 8);
                this.bitCheck10.setVisible(MatrixSignalMastAddPane.this.bitNum > 9);
                matrixDetails.add(this.aspectBitsField);
                this.aspectBitsField.setEnabled(false);
                this.aspectBitsField.setVisible(false);
                this.panel.add(matrixDetails);
                TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
                border.setTitle(this.aspect);
                this.panel.setBorder(border);
                this.disabledCheck.addActionListener(e -> this.setAspectDisabled(this.disabledCheck.isSelected()));
                this.bitCheck1.addActionListener(e -> this.setBit(1, this.bitCheck1.isSelected()));
                this.bitCheck2.addActionListener(e -> this.setBit(2, this.bitCheck2.isSelected()));
                this.bitCheck3.addActionListener(e -> this.setBit(3, this.bitCheck3.isSelected()));
                this.bitCheck4.addActionListener(e -> this.setBit(4, this.bitCheck4.isSelected()));
                this.bitCheck5.addActionListener(e -> this.setBit(5, this.bitCheck5.isSelected()));
                this.bitCheck6.addActionListener(e -> this.setBit(6, this.bitCheck6.isSelected()));
                this.bitCheck7.addActionListener(e -> this.setBit(7, this.bitCheck7.isSelected()));
                this.bitCheck8.addActionListener(e -> this.setBit(8, this.bitCheck8.isSelected()));
                this.bitCheck9.addActionListener(e -> this.setBit(9, this.bitCheck9.isSelected()));
                this.bitCheck10.addActionListener(e -> this.setBit(10, this.bitCheck10.isSelected()));
            }
            return this.panel;
        }
    }

    public static class SignalMastAddPaneProvider
    extends SignalMastAddPane.SignalMastAddPaneProvider {
        @Override
        @Nonnull
        public String getPaneName() {
            return Bundle.getMessage("MatrixCtlMast");
        }

        @Override
        @Nonnull
        public SignalMastAddPane getNewPane() {
            return new MatrixSignalMastAddPane();
        }
    }
}

