/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.signalmast;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.SignalAppearanceMap;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SignalSystem;
import jmri.implementation.DccSignalMast;
import jmri.jmrit.beantable.signalmast.Bundle;
import jmri.jmrit.beantable.signalmast.SignalMastAddPane;
import jmri.util.ConnectionNameFromSystemName;
import jmri.util.javaworld.GridLayout2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccSignalMastAddPane
extends SignalMastAddPane {
    JScrollPane dccMastScroll;
    JPanel dccMastPanel = new JPanel();
    JLabel systemPrefixBoxLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("DCCSystem")));
    JComboBox<String> systemPrefixBox = new JComboBox();
    JLabel dccAspectAddressLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("DCCMastAddress")));
    JTextField dccAspectAddressField = new JTextField(5);
    JCheckBox dccOffSetAddress = new JCheckBox(Bundle.getMessage("DccAccessoryAddressOffSet"));
    JCheckBox allowUnLit = new JCheckBox();
    LinkedHashMap<String, DCCAspectPanel> dccAspect = new LinkedHashMap(12);
    DccSignalMast currentMast = null;
    SignalSystem sigsys;
    JSpinner packetSendCountSpinner = new JSpinner();
    JSpinner unlitIdSpinner = new JSpinner();
    private static final Logger log = LoggerFactory.getLogger(DccSignalMastAddPane.class);

    public DccSignalMastAddPane() {
        this.init();
    }

    final void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.unLitOption());
        this.add(this.connectionData());
        this.dccMastScroll = new JScrollPane(this.dccMastPanel);
        this.dccMastScroll.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.dccMastScroll);
    }

    JPanel connectionData() {
        JPanel p = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        border.setTitle(Bundle.getMessage("DCCMastConnection"));
        p.setBorder(border);
        p.setLayout(new GridLayout2(3, 3));
        p.add(this.systemPrefixBoxLabel);
        p.add(this.systemPrefixBox);
        p.add(new JLabel());
        p.add(this.dccAspectAddressLabel);
        this.dccAspectAddressField.setText("");
        this.dccOffSetAddress.setToolTipText(Bundle.getMessage("DccOffsetTooltip"));
        p.add(this.dccAspectAddressField);
        p.add(this.dccOffSetAddress);
        p.add(new JLabel(Bundle.getMessage("DCCMastPacketSendCount")));
        this.packetSendCountSpinner.setModel(new SpinnerNumberModel(3, 1, 4, 1));
        p.add(this.packetSendCountSpinner);
        this.packetSendCountSpinner.setToolTipText(Bundle.getMessage("DCCMastPacketSendCountToolTip"));
        return p;
    }

    JPanel unLitOption() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("AllowUnLitLabel"))));
        p.add(this.allowUnLit);
        p.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("DCCUnlitAspectId"))));
        this.unlitIdSpinner.setModel(new SpinnerNumberModel(31, 0, 31, 1));
        p.add(this.unlitIdSpinner);
        return p;
    }

    @Override
    @Nonnull
    public String getPaneName() {
        return Bundle.getMessage("DCCMast");
    }

    protected boolean usableCommandStation(CommandStation cs) {
        return true;
    }

    @Override
    public void setAspectNames(@Nonnull SignalAppearanceMap map, @Nonnull SignalSystem sigSystem) {
        log.trace("setAspectNames(...) start");
        this.dccAspect.clear();
        Enumeration<String> aspects = map.getAspects();
        this.sigsys = map.getSignalSystem();
        while (aspects.hasMoreElements()) {
            String aspect = aspects.nextElement();
            DCCAspectPanel aPanel = new DCCAspectPanel(aspect);
            this.dccAspect.put(aspect, aPanel);
            log.trace(" in loop, dccAspect: {} ", (Object)map.getProperty(aspect, "dccAspect"));
            aPanel.setAspectId((String)sigSystem.getProperty(aspect, "dccAspect"));
        }
        this.systemPrefixBox.removeAllItems();
        List<CommandStation> connList = InstanceManager.getList(CommandStation.class);
        if (!connList.isEmpty()) {
            int x = 0;
            while (x < connList.size()) {
                CommandStation station = connList.get(x);
                if (this.usableCommandStation(station)) {
                    this.systemPrefixBox.addItem(station.getUserName());
                }
                ++x;
            }
        } else {
            this.systemPrefixBox.addItem("None");
        }
        this.dccMastPanel.removeAll();
        for (Map.Entry<String, DCCAspectPanel> entry : this.dccAspect.entrySet()) {
            log.trace("   aspect: {}", (Object)entry.getKey());
            this.dccMastPanel.add(entry.getValue().getPanel());
        }
        if (this.dccAspect.size() % 2 > 0) {
            this.dccMastPanel.add(new JLabel());
        }
        this.dccMastPanel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("DCCMastCopyAspectId"))));
        this.dccMastPanel.add(this.copyFromMastSelection());
        this.dccMastPanel.setLayout(new GridLayout2(0, 2));
        this.dccMastPanel.revalidate();
        this.dccMastScroll.revalidate();
        log.trace("setAspectNames(...) end");
    }

    @Override
    public boolean canHandleMast(@Nonnull SignalMast mast) {
        return mast.getClass().getCanonicalName().equals(DccSignalMast.class.getCanonicalName());
    }

    @Override
    public void setMast(SignalMast mast) {
        List<CommandStation> connList;
        log.debug("setMast({}) start", (Object)mast);
        if (mast == null) {
            this.currentMast = null;
            log.debug("setMast() end early with null");
            return;
        }
        if (!(mast instanceof DccSignalMast)) {
            log.error("mast was wrong type: {} {}", (Object)mast.getSystemName(), (Object)mast.getClass().getName());
            log.debug("setMast({}) end early: wrong type", (Object)mast);
            return;
        }
        this.currentMast = (DccSignalMast)mast;
        SignalAppearanceMap appMap = mast.getAppearanceMap();
        if (appMap != null) {
            Enumeration<String> aspects = appMap.getAspects();
            while (aspects.hasMoreElements()) {
                String key = aspects.nextElement();
                DCCAspectPanel dccPanel = this.dccAspect.get(key);
                dccPanel.setAspectDisabled(this.currentMast.isAspectDisabled(key));
                if (this.currentMast.isAspectDisabled(key)) continue;
                dccPanel.setAspectId(this.currentMast.getOutputForAppearance(key));
            }
        }
        if (!(connList = InstanceManager.getList(CommandStation.class)).isEmpty()) {
            int x = 0;
            while (x < connList.size()) {
                CommandStation station = connList.get(x);
                if (this.usableCommandStation(station)) {
                    this.systemPrefixBox.addItem(station.getUserName());
                }
                ++x;
            }
        } else {
            this.systemPrefixBox.addItem("None");
        }
        this.dccAspectAddressField.setText("" + this.currentMast.getDccSignalMastAddress());
        this.dccOffSetAddress.setSelected(this.currentMast.useAddressOffSet());
        this.systemPrefixBox.setSelectedItem(this.currentMast.getCommandStation().getUserName());
        this.systemPrefixBoxLabel.setEnabled(false);
        this.systemPrefixBox.setEnabled(false);
        this.dccAspectAddressLabel.setEnabled(false);
        this.dccAspectAddressField.setEnabled(false);
        this.allowUnLit.setSelected(this.currentMast.allowUnLit());
        if (this.currentMast.allowUnLit()) {
            this.unlitIdSpinner.setValue(this.currentMast.getUnlitId());
        }
        this.packetSendCountSpinner.setValue(this.currentMast.getDccSignalMastPacketSendCount());
        log.debug("setMast({}) end", (Object)mast);
    }

    static boolean validateAspectId(@Nonnull String strAspect) {
        int aspect;
        try {
            aspect = Integer.parseInt(strAspect.trim());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("DCCMastAspectNumber"));
            return false;
        }
        if (aspect < 0 || aspect > 31) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("DCCMastAspectOutOfRange"));
            log.error("invalid aspect {}", (Object)aspect);
            return false;
        }
        return true;
    }

    @Nonnull
    protected String getNamePrefix() {
        return "F$dsm:";
    }

    protected DccSignalMast constructMast(@Nonnull String name) {
        return new DccSignalMast(name);
    }

    @Override
    public boolean createMast(@Nonnull String sigsysname, @Nonnull String mastname, @Nonnull String username) {
        log.debug("createMast({},{} start)", (Object)sigsysname, (Object)mastname);
        if (this.currentMast == null) {
            log.trace("Creating new mast");
            if (!this.validateDCCAddress()) {
                log.trace("validateDCCAddress failed, return from createMast");
                return false;
            }
            String systemNameText = ConnectionNameFromSystemName.getPrefixFromName((String)this.systemPrefixBox.getSelectedItem());
            if (systemNameText == null || systemNameText.isEmpty()) {
                systemNameText = "I";
            }
            systemNameText = String.valueOf(systemNameText) + this.getNamePrefix();
            String name = String.valueOf(systemNameText) + sigsysname + ":" + mastname.substring(11, mastname.length() - 4);
            name = String.valueOf(name) + "(" + this.dccAspectAddressField.getText() + ")";
            this.currentMast = this.constructMast(name);
            InstanceManager.getDefault(SignalMastManager.class).register(this.currentMast);
        }
        for (Map.Entry<String, DCCAspectPanel> entry : this.dccAspect.entrySet()) {
            this.dccMastPanel.add(entry.getValue().getPanel());
            this.currentMast.setOutputForAppearance(entry.getKey(), entry.getValue().getAspectId());
            if (entry.getValue().isAspectDisabled()) {
                this.currentMast.setAspectDisabled(entry.getKey());
                continue;
            }
            this.currentMast.setAspectEnabled(entry.getKey());
        }
        if (!username.isEmpty()) {
            this.currentMast.setUserName(username);
        }
        this.currentMast.useAddressOffSet(this.dccOffSetAddress.isSelected());
        this.currentMast.setAllowUnLit(this.allowUnLit.isSelected());
        if (this.allowUnLit.isSelected()) {
            this.currentMast.setUnlitId((Integer)this.unlitIdSpinner.getValue());
        }
        int sendCount = (Integer)this.packetSendCountSpinner.getValue();
        this.currentMast.setDccSignalMastPacketSendCount(sendCount);
        log.debug("createMast({},{} end)", (Object)sigsysname, (Object)mastname);
        return true;
    }

    private boolean validateDCCAddress() {
        int address;
        if (this.dccAspectAddressField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("DCCMastAddressBlank"));
            return false;
        }
        try {
            address = Integer.parseInt(this.dccAspectAddressField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("DCCMastAddressNumber"));
            return false;
        }
        if (address < 1 || address > 2048) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("DCCMastAddressOutOfRange"));
            log.error("invalid address {}", (Object)address);
            return false;
        }
        if (DccSignalMast.isDCCAddressUsed(address) != null) {
            String msg = Bundle.getMessage("DCCMastAddressAssigned", this.dccAspectAddressField.getText(), DccSignalMast.isDCCAddressUsed(address));
            JOptionPane.showMessageDialog(null, msg);
            return false;
        }
        return true;
    }

    @Nonnull
    JComboBox<String> copyFromMastSelection() {
        JComboBox<String> mastSelect = new JComboBox<String>();
        for (SignalMast mast : InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet()) {
            if (!(mast instanceof DccSignalMast)) continue;
            mastSelect.addItem(mast.getDisplayName());
        }
        if (mastSelect.getItemCount() == 0) {
            mastSelect.setEnabled(false);
        } else {
            mastSelect.insertItemAt("", 0);
            mastSelect.setSelectedIndex(0);
            mastSelect.addActionListener(e -> {
                JComboBox eb = (JComboBox)e.getSource();
                String sourceMast = (String)eb.getSelectedItem();
                if (sourceMast != null && !sourceMast.isEmpty()) {
                    this.copyFromAnotherDCCMastAspect(sourceMast);
                }
            });
        }
        return mastSelect;
    }

    void copyFromAnotherDCCMastAspect(@Nonnull String strMast) {
        DccSignalMast mast = (DccSignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(strMast);
        if (mast == null) {
            log.error("can't copy from another mast because {} doesn't exist", (Object)strMast);
            return;
        }
        Vector<String> validAspects = mast.getValidAspects();
        for (Map.Entry<String, DCCAspectPanel> entry : this.dccAspect.entrySet()) {
            if (validAspects.contains(entry.getKey()) || mast.isAspectDisabled(entry.getKey())) {
                entry.getValue().setAspectId(mast.getOutputForAppearance(entry.getKey()));
                entry.getValue().setAspectDisabled(mast.isAspectDisabled(entry.getKey()));
                continue;
            }
            log.info("Can't get aspect \"{}\" from head \"{}\", leaving unchanged", (Object)entry.getKey(), (Object)mast);
        }
    }

    static class DCCAspectPanel {
        String aspect = "";
        JCheckBox disabledCheck = new JCheckBox(Bundle.getMessage("DisableAspect"));
        JLabel aspectLabel = new JLabel(String.valueOf(Bundle.getMessage("DCCMastSetAspectId")) + ":");
        JTextField aspectId = new JTextField(5);
        JPanel panel;

        DCCAspectPanel(String aspect) {
            this.aspect = aspect;
        }

        void setAspectDisabled(boolean boo) {
            this.disabledCheck.setSelected(boo);
            if (boo) {
                this.aspectLabel.setEnabled(false);
                this.aspectId.setEnabled(false);
            } else {
                this.aspectLabel.setEnabled(true);
                this.aspectId.setEnabled(true);
            }
        }

        boolean isAspectDisabled() {
            return this.disabledCheck.isSelected();
        }

        int getAspectId() {
            try {
                String value = this.aspectId.getText();
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                log.error("failed to convert DCC number");
                return -1;
            }
        }

        void setAspectId(int i) {
            this.aspectId.setText("" + i);
        }

        void setAspectId(String s) {
            this.aspectId.setText(s);
        }

        JPanel getPanel() {
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new BoxLayout(this.panel, 1));
                JPanel dccDetails = new JPanel();
                dccDetails.add(this.aspectLabel);
                dccDetails.add(this.aspectId);
                this.panel.add(dccDetails);
                this.panel.add(this.disabledCheck);
                TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
                border.setTitle(this.aspect);
                this.panel.setBorder(border);
                this.aspectId.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (aspectId.getText().isEmpty()) {
                            return;
                        }
                        if (!DccSignalMastAddPane.validateAspectId(aspectId.getText())) {
                            aspectId.requestFocusInWindow();
                        }
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                    }
                });
                this.disabledCheck.addActionListener(e -> this.setAspectDisabled(this.disabledCheck.isSelected()));
            }
            return this.panel;
        }
    }

    public static class SignalMastAddPaneProvider
    extends SignalMastAddPane.SignalMastAddPaneProvider {
        @Override
        @Nonnull
        public String getPaneName() {
            return Bundle.getMessage("DCCMast");
        }

        @Override
        @Nonnull
        public SignalMastAddPane getNewPane() {
            return new DccSignalMastAddPane();
        }
    }
}

