/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.routetable;

import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.beantable.routetable.AbstractRouteAddEditFrame;
import jmri.jmrit.beantable.routetable.RouteOutputModel;
import jmri.jmrit.beantable.routetable.RouteTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RouteTurnoutModel
extends RouteOutputModel {
    private final AbstractRouteAddEditFrame routeAddFrame;
    private static final Logger log = LoggerFactory.getLogger(RouteTurnoutModel.class);

    RouteTurnoutModel(AbstractRouteAddEditFrame routeAddFrame) {
        this.routeAddFrame = routeAddFrame;
        InstanceManager.turnoutManagerInstance().addPropertyChangeListener(this);
    }

    @Override
    public int getRowCount() {
        if (this.routeAddFrame.isShowAll()) {
            return this.routeAddFrame.get_turnoutList().size();
        }
        return this.routeAddFrame.get_includedTurnoutList().size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        List<RouteTurnout> turnoutList = this.routeAddFrame.isShowAll() ? this.routeAddFrame.get_turnoutList() : this.routeAddFrame.get_includedTurnoutList();
        if (r >= turnoutList.size()) {
            log.debug("row is greater than turnout list size");
            return null;
        }
        switch (c) {
            case 2: {
                return turnoutList.get(r).isIncluded();
            }
            case 0: {
                return turnoutList.get(r).getSysName();
            }
            case 1: {
                return turnoutList.get(r).getUserName();
            }
            case 3: {
                return turnoutList.get(r).getSetToState();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object type, int r, int c) {
        List<RouteTurnout> turnoutList = this.routeAddFrame.isShowAll() ? this.routeAddFrame.get_turnoutList() : this.routeAddFrame.get_includedTurnoutList();
        switch (c) {
            case 2: {
                turnoutList.get(r).setIncluded((Boolean)type);
                break;
            }
            case 3: {
                turnoutList.get(r).setSetToState((String)type);
                break;
            }
            default: {
                log.error("RouteTurnoutModel.setValueAt should not be called on column {}", (Object)c);
            }
        }
    }
}

