/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.routetable;

import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.beantable.routetable.AbstractRouteAddEditFrame;
import jmri.jmrit.beantable.routetable.RouteOutputModel;
import jmri.jmrit.beantable.routetable.RouteSensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RouteSensorModel
extends RouteOutputModel {
    private final AbstractRouteAddEditFrame routeAddFrame;
    private static final Logger log = LoggerFactory.getLogger(RouteSensorModel.class);

    RouteSensorModel(AbstractRouteAddEditFrame routeAddFrame) {
        this.routeAddFrame = routeAddFrame;
        InstanceManager.sensorManagerInstance().addPropertyChangeListener(this);
    }

    @Override
    public int getRowCount() {
        if (this.routeAddFrame.isShowAll()) {
            return this.routeAddFrame.get_sensorList().size();
        }
        return this.routeAddFrame.get_includedSensorList().size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        List<RouteSensor> sensorList = this.routeAddFrame.isShowAll() ? this.routeAddFrame.get_sensorList() : this.routeAddFrame.get_includedSensorList();
        if (r >= sensorList.size()) {
            log.debug("row is greater than turnout list size");
            return null;
        }
        switch (c) {
            case 2: {
                return sensorList.get(r).isIncluded();
            }
            case 0: {
                return sensorList.get(r).getSysName();
            }
            case 1: {
                return sensorList.get(r).getUserName();
            }
            case 3: {
                return sensorList.get(r).getSetToState();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object type, int r, int c) {
        List<RouteSensor> sensorList = this.routeAddFrame.isShowAll() ? this.routeAddFrame.get_sensorList() : this.routeAddFrame.get_includedSensorList();
        switch (c) {
            case 2: {
                sensorList.get(r).setIncluded((Boolean)type);
                break;
            }
            case 3: {
                sensorList.get(r).setSetToState((String)type);
                break;
            }
            default: {
                log.error("RouteSensorModel.setValueAt should not be called on column {}", (Object)c);
            }
        }
    }
}

