/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.routetable;

import jmri.jmrit.beantable.routetable.Bundle;
import jmri.jmrit.beantable.routetable.RouteElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RouteSensor
extends RouteElement {
    private static final String SET_TO_ACTIVE = String.valueOf(Bundle.getMessage("Set")) + " " + Bundle.getMessage("SensorStateActive");
    private static final String SET_TO_INACTIVE = String.valueOf(Bundle.getMessage("Set")) + " " + Bundle.getMessage("SensorStateInactive");
    private static final String SET_TO_TOGGLE = String.valueOf(Bundle.getMessage("Set")) + " " + Bundle.getMessage("Toggle");
    private static final Logger log = LoggerFactory.getLogger(RouteSensor.class);

    RouteSensor(String sysName, String userName) {
        super(sysName, userName);
    }

    @Override
    String getSetToState() {
        switch (this._setToState) {
            case 4: {
                return SET_TO_INACTIVE;
            }
            case 2: {
                return SET_TO_ACTIVE;
            }
            case 8: {
                return SET_TO_TOGGLE;
            }
        }
        log.warn("Unhandled route state: {}", (Object)this._setToState);
        return "";
    }

    @Override
    void setSetToState(String state) {
        if (SET_TO_INACTIVE.equals(state)) {
            this._setToState = 4;
        } else if (SET_TO_ACTIVE.equals(state)) {
            this._setToState = 2;
        } else if (SET_TO_TOGGLE.equals(state)) {
            this._setToState = 8;
        }
    }
}

