/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.routetable;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.Sensor;
import jmri.jmrit.beantable.routetable.AbstractRouteAddEditFrame;
import jmri.jmrit.beantable.routetable.Bundle;
import jmri.jmrit.beantable.routetable.RouteExportToLogix;
import jmri.jmrit.beantable.routetable.RouteSensor;
import jmri.jmrit.beantable.routetable.RouteTurnout;

public class RouteEditFrame
extends AbstractRouteAddEditFrame {
    private final String systemName;

    public RouteEditFrame(String systemName) {
        this(Bundle.getMessage("TitleEditRoute"), systemName);
    }

    public RouteEditFrame(String name, String systemName) {
        this(name, false, true, systemName);
    }

    public RouteEditFrame(String name, boolean saveSize, boolean savePosition, String systemName) {
        super(name, saveSize, savePosition);
        this.systemName = systemName;
        this.initComponents();
    }

    @Override
    public final void initComponents() {
        String tSysName;
        super.initComponents();
        this._systemName.setText(this.systemName);
        String sName = this._systemName.getText();
        Route g = InstanceManager.getDefault(RouteManager.class).getBySystemName(sName);
        if (g == null) {
            sName = this._userName.getText();
            g = InstanceManager.getDefault(RouteManager.class).getByUserName(sName);
            if (g == null) {
                this.status1.setText(Bundle.getMessage("RouteAddStatusErrorNotFound"));
                return;
            }
        }
        this.curRoute = g;
        this._systemName.setVisible(true);
        this._systemName.setText(sName);
        this._systemName.setEnabled(false);
        this.nameLabel.setEnabled(true);
        this._autoSystemName.setVisible(false);
        this.curRoute.deActivateRoute();
        this._userName.setText(g.getUserName());
        int setRow = 0;
        int i = this._turnoutList.size() - 1;
        while (i >= 0) {
            RouteTurnout turnout = (RouteTurnout)this._turnoutList.get(i);
            tSysName = turnout.getSysName();
            if (g.isOutputTurnoutIncluded(tSysName)) {
                turnout.setIncluded(true);
                turnout.setState(g.getOutputTurnoutSetState(tSysName));
                setRow = i;
            } else {
                turnout.setIncluded(false);
                turnout.setState(2);
            }
            --i;
        }
        if (--setRow < 0) {
            setRow = 0;
        }
        this._routeTurnoutScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._routeTurnoutModel.fireTableDataChanged();
        i = this._sensorList.size() - 1;
        while (i >= 0) {
            RouteSensor sensor = (RouteSensor)this._sensorList.get(i);
            tSysName = sensor.getSysName();
            if (g.isOutputSensorIncluded(tSysName)) {
                sensor.setIncluded(true);
                sensor.setState(g.getOutputSensorSetState(tSysName));
                setRow = i;
            } else {
                sensor.setIncluded(false);
                sensor.setState(4);
            }
            --i;
        }
        if (--setRow < 0) {
            setRow = 0;
        }
        this._routeSensorScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._routeSensorModel.fireTableDataChanged();
        this.scriptFile.setText(g.getOutputScriptName());
        this.soundFile.setText(g.getOutputSoundName());
        this.turnoutsAlignedSensor.setSelectedItem(g.getTurnoutsAlgdSensor());
        Sensor[] temNames = new Sensor[3];
        int[] temModes = new int[3];
        int k = 0;
        while (k < 3) {
            temNames[k] = g.getRouteSensor(k);
            temModes[k] = g.getRouteSensorMode(k);
            ++k;
        }
        this.sensor1.setSelectedItem(temNames[0]);
        this.setSensorModeBox(temModes[0], this.sensor1mode);
        this.sensor2.setSelectedItem(temNames[1]);
        this.setSensorModeBox(temModes[1], this.sensor2mode);
        this.sensor3.setSelectedItem(temNames[2]);
        this.setSensorModeBox(temModes[2], this.sensor3mode);
        this.cTurnout.setSelectedItem(g.getCtlTurnout());
        this.setTurnoutModeBox(g.getControlTurnoutState(), this.cTurnoutStateBox);
        this.cLockTurnout.setSelectedItem(g.getLockCtlTurnout());
        this.setTurnoutModeBox(g.getLockControlTurnoutState(), this.cLockTurnoutStateBox);
        this.timeDelay.setValue(g.getRouteCommandDelay());
        this.status1.setText(Bundle.getMessage("RouteAddStatusInitial3", Bundle.getMessage("ButtonUpdate")));
        this.status2.setText(Bundle.getMessage("RouteAddStatusInitial4", Bundle.getMessage("ButtonCancelEdit", Bundle.getMessage("ButtonEdit"))));
        this.status2.setVisible(true);
        this.setTitle(Bundle.getMessage("TitleEditRoute"));
        this.editMode = true;
    }

    @Override
    protected JPanel getButtonPanel() {
        JButton cancelEditButton = new JButton(Bundle.getMessage("ButtonCancelEdit", Bundle.getMessage("ButtonEdit")));
        JButton deleteButton = new JButton(String.valueOf(Bundle.getMessage("ButtonDelete")) + " " + Bundle.getMessage("BeanNameRoute"));
        JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
        JButton exportButton = new JButton(Bundle.getMessage("ButtonExport"));
        JPanel pb = new JPanel();
        pb.setLayout(new FlowLayout(4));
        pb.add(cancelEditButton);
        cancelEditButton.addActionListener(this::cancelPressed);
        cancelEditButton.setToolTipText(Bundle.getMessage("TooltipCancelRoute"));
        pb.add(deleteButton);
        deleteButton.addActionListener(this::deletePressed);
        deleteButton.setToolTipText(Bundle.getMessage("TooltipDeleteRoute"));
        pb.add(updateButton);
        updateButton.addActionListener(e1 -> this.updatePressed(false));
        updateButton.setToolTipText(Bundle.getMessage("TooltipUpdateRoute"));
        pb.add(exportButton);
        exportButton.addActionListener(this::exportButtonPressed);
        exportButton.setToolTipText(Bundle.getMessage("TooltipExportRoute"));
        deleteButton.setVisible(true);
        cancelEditButton.setVisible(true);
        updateButton.setVisible(true);
        exportButton.setVisible(true);
        return pb;
    }

    private void exportButtonPressed(ActionEvent e) {
        new RouteExportToLogix(this._systemName.getText()).export();
        this.status1.setText(String.valueOf(Bundle.getMessage("BeanNameRoute")) + "\"" + this._systemName.getText() + "\" " + Bundle.getMessage("RouteAddStatusExported") + " (" + this.get_includedTurnoutList().size() + Bundle.getMessage("Turnouts") + ", " + this.get_includedSensorList().size() + " " + Bundle.getMessage("Sensors") + ")");
        this.finishUpdate();
        this.closeFrame();
    }

    private void cancelPressed(ActionEvent e) {
        this.cancelEdit();
    }

    private void deletePressed(ActionEvent e) {
        this.routeManager.deleteRoute(this.curRoute);
        this.curRoute = null;
        this.finishUpdate();
        this.closeFrame();
    }
}

