/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.routetable;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.Route;
import jmri.jmrit.beantable.routetable.AbstractRouteAddEditFrame;
import jmri.jmrit.beantable.routetable.Bundle;

public class RouteAddFrame
extends AbstractRouteAddEditFrame {
    public RouteAddFrame() {
        this(Bundle.getMessage("TitleAddRoute"));
    }

    public RouteAddFrame(String name) {
        this(name, false, true);
    }

    public RouteAddFrame(String name, boolean saveSize, boolean savePosition) {
        super(name, saveSize, savePosition);
        super.initComponents();
    }

    @Override
    protected JPanel getButtonPanel() {
        JButton createButton = new JButton(Bundle.getMessage("ButtonCreate"));
        JButton editButton = new JButton(Bundle.getMessage("ButtonEdit"));
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
        JPanel pb = new JPanel();
        pb.setLayout(new FlowLayout(4));
        pb.add(cancelButton);
        cancelButton.addActionListener(this::cancelAddPressed);
        pb.add(createButton);
        createButton.addActionListener(this::createPressed);
        createButton.setToolTipText(Bundle.getMessage("TooltipCreateRoute"));
        cancelButton.setVisible(true);
        updateButton.setVisible(true);
        editButton.setVisible(true);
        createButton.setVisible(true);
        return pb;
    }

    private void cancelAddPressed(ActionEvent e) {
        this.cancelAdd();
    }

    private void cancelAdd() {
        if (this.routeDirty) {
            this.showReminderMessage();
        }
        this.curRoute = null;
        this.finishUpdate();
        this.status1.setText(Bundle.getMessage("RouteAddStatusInitial1", Bundle.getMessage("ButtonCreate")));
        this.routeDirty = false;
        this.setVisible(false);
        this._routeSensorModel.dispose();
        this._routeTurnoutModel.dispose();
        this.closeFrame();
    }

    private void createPressed(ActionEvent e) {
        if (!this._autoSystemName.isSelected() && !this.checkNewNamesOK()) {
            return;
        }
        this.updatePressed(true);
        this.pref.setSimplePreferenceState(this.systemNameAuto, this._autoSystemName.isSelected());
        if (this.curRoute != null) {
            this.curRoute.activateRoute();
        }
        this.closeFrame();
    }

    private boolean checkNewNamesOK() {
        Route g;
        String sName = this._systemName.getText();
        String uName = this._userName.getText();
        if (sName.length() == 0) {
            this.status1.setText(Bundle.getMessage("AddBeanStatusEnter"));
            this.status1.setForeground(Color.red);
            return false;
        }
        if (!uName.isEmpty() && (g = this.routeManager.getByUserName(uName)) != null) {
            this.status1.setText(Bundle.getMessage("LightError8"));
            return false;
        }
        g = this.routeManager.getBySystemName(sName = this.routeManager.makeSystemName(sName));
        if (g != null) {
            this.status1.setText(Bundle.getMessage("LightError1"));
            return false;
        }
        return true;
    }
}

