/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.SignalEditFrame;
import jmri.jmrit.beantable.oblock.TableFrames;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import jmri.util.IntlUtilities;
import jmri.util.gui.GuiLafPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int NAME_COLUMN = 0;
    public static final int FROM_BLOCK_COLUMN = 1;
    public static final int PORTAL_COLUMN = 2;
    public static final int TO_BLOCK_COLUMN = 3;
    public static final int LENGTHCOL = 4;
    public static final int UNITSCOL = 5;
    public static final int DELETE_COL = 6;
    public static final int EDIT_COL = 7;
    public static final int NUMCOLS = 7;
    int _lastIdx;
    PortalManager _portalMgr;
    TableFrames _parent;
    private SignalArray _signalList = new SignalArray();
    private final boolean _tabbed;
    private float _tempLen = 0.0f;
    private String[] tempRow;
    boolean inEditMode = false;
    DecimalFormat twoDigit = new DecimalFormat("0.00");
    private static final Logger log = LoggerFactory.getLogger(SignalTableModel.class);

    public SignalTableModel(TableFrames parent) {
        this._parent = parent;
        this._portalMgr = InstanceManager.getDefault(PortalManager.class);
        this._tabbed = InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed();
    }

    public void init() {
        this.makeList();
        this.initTempRow();
    }

    void initTempRow() {
        if (!this._tabbed) {
            this.tempRow = new String[7];
            this.tempRow[4] = this.twoDigit.format(0.0);
            this.tempRow[5] = Bundle.getMessage("in");
            this.tempRow[6] = Bundle.getMessage("ButtonClear");
        }
    }

    private void makeList() {
        SignalArray tempList = new SignalArray();
        Collection<Portal> portals = this._portalMgr.getPortalSet();
        for (Portal portal : portals) {
            OBlock fromBlock = portal.getFromBlock();
            OBlock toBlock = portal.getToBlock();
            if (fromBlock != null && toBlock != null) {
                SignalRow sr;
                NamedBean signal = portal.getFromSignal();
                if (signal != null) {
                    sr = new SignalRow(signal, fromBlock, portal, toBlock, portal.getFromSignalOffset(), toBlock.isMetric());
                    SignalTableModel.addToList(tempList, sr);
                }
                if ((signal = portal.getToSignal()) == null) continue;
                sr = new SignalRow(signal, toBlock, portal, fromBlock, portal.getToSignalOffset(), fromBlock.isMetric());
                SignalTableModel.addToList(tempList, sr);
                continue;
            }
            log.warn("Portal {} needs an OBlock on each side", (Object)portal.getName());
        }
        this._signalList = (SignalArray)tempList.clone();
        this._lastIdx = tempList.numberOfSignals();
        this._signalList.sort(new NameSorter());
    }

    private static void addToList(SignalArray array, SignalRow sr) {
        boolean add = true;
        int j = 0;
        while (j < array.numberOfSignals()) {
            if (sr.getSignal().getDisplayName().compareTo(((SignalRow)array.get(j)).getSignal().getDisplayName()) < 0) {
                array.add(j, sr);
                add = false;
                break;
            }
            ++j;
        }
        if (add) {
            array.add(sr);
        }
    }

    private String checkSignalRow(SignalRow sr) {
        Portal portal = sr.getPortal();
        OBlock fromBlock = sr.getFromBlock();
        OBlock toBlock = sr.getToBlock();
        String msg = null;
        if (portal != null) {
            if (toBlock == null && fromBlock == null) {
                msg = Bundle.getMessage("SignalDirection", portal.getName(), portal.getFromBlock().getDisplayName(), portal.getToBlock().getDisplayName());
                return msg;
            }
            OBlock pToBlk = portal.getToBlock();
            OBlock pFromBlk = portal.getFromBlock();
            if (pToBlk.equals(toBlock)) {
                if (fromBlock == null) {
                    sr.setFromBlock(pFromBlk);
                }
            } else if (pFromBlk.equals(toBlock)) {
                if (fromBlock == null) {
                    sr.setFromBlock(pToBlk);
                }
            } else if (pToBlk.equals(fromBlock)) {
                if (toBlock == null) {
                    sr.setToBlock(pFromBlk);
                }
            } else if (pFromBlk.equals(fromBlock)) {
                if (toBlock == null) {
                    sr.setToBlock(pToBlk);
                }
            } else {
                msg = Bundle.getMessage("PortalBlockConflict", portal.getName(), toBlock != null ? toBlock.getDisplayName() : "(null to-block reference)");
            }
        } else if (fromBlock != null && toBlock != null) {
            Portal p = this.getPortalWithBlocks(fromBlock, toBlock);
            if (p == null) {
                msg = Bundle.getMessage("NoSuchPortal", fromBlock.getDisplayName(), toBlock.getDisplayName());
            } else {
                sr.setPortal(p);
            }
        }
        if (msg == null && fromBlock != null && fromBlock.equals(toBlock)) {
            msg = Bundle.getMessage("SametoFromBlock", fromBlock.getDisplayName());
        }
        return msg;
    }

    private Portal getPortalWithBlocks(OBlock fromBlock, OBlock toBlock) {
        Collection<Portal> portals = this._portalMgr.getPortalSet();
        for (Portal portal : portals) {
            OBlock fromBlk = portal.getFromBlock();
            OBlock toBlk = portal.getToBlock();
            if ((!fromBlk.equals(fromBlock) || !toBlk.equals(toBlock)) && (!fromBlk.equals(toBlock) || !toBlk.equals(fromBlock))) continue;
            return portal;
        }
        return null;
    }

    protected String checkDuplicateSignal(NamedBean signal) {
        if (signal == null) {
            return null;
        }
        for (SignalRow srow : this._signalList) {
            if (!signal.equals(srow.getSignal())) continue;
            return Bundle.getMessage("DuplSignalName", signal.getDisplayName(), srow.getToBlock().getDisplayName(), srow.getPortal().getName(), srow.getFromBlock().getDisplayName());
        }
        return null;
    }

    private String checkDuplicateSignal(SignalRow row) {
        NamedBean signal = row.getSignal();
        if (signal == null) {
            return null;
        }
        for (SignalRow srow : this._signalList) {
            if (srow.equals(row) || !signal.equals(srow.getSignal())) continue;
            return Bundle.getMessage("DuplSignalName", signal.getDisplayName(), srow.getToBlock().getDisplayName(), srow.getPortal().getName(), srow.getFromBlock().getDisplayName());
        }
        return null;
    }

    private String checkDuplicateProtection(SignalRow row) {
        Portal portal = row.getPortal();
        OBlock block = row.getToBlock();
        if (block == null || portal == null) {
            return null;
        }
        for (SignalRow srow : this._signalList) {
            if (srow.equals(row) || !block.equals(srow.getToBlock()) || !portal.equals(srow.getPortal())) continue;
            return Bundle.getMessage("DuplProtection", block.getDisplayName(), portal.getName(), srow.getFromBlock().getDisplayName(), srow.getSignal().getDisplayName());
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 7 + (this._tabbed ? 1 : 0);
    }

    @Override
    public int getRowCount() {
        return this._signalList.numberOfSignals() + (this._tabbed ? 0 : 1);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("SignalName");
            }
            case 1: {
                return Bundle.getMessage("FromBlockName");
            }
            case 2: {
                return Bundle.getMessage("ThroughPortal");
            }
            case 3: {
                return Bundle.getMessage("ToBlockName");
            }
            case 4: {
                return Bundle.getMessage("Offset");
            }
            case 5: 
            case 7: {
                return "  ";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this._tabbed && rowIndex == this._signalList.numberOfSignals()) {
            if (columnIndex == 4) {
                if (this.tempRow[5].equals(Bundle.getMessage("cm"))) {
                    return this.twoDigit.format(this._tempLen / 10.0f);
                }
                return this.twoDigit.format(this._tempLen / 25.4f);
            }
            if (columnIndex == 5) {
                return this.tempRow[5].equals(Bundle.getMessage("cm"));
            }
            return this.tempRow[columnIndex];
        }
        if (rowIndex >= this._signalList.numberOfSignals() || rowIndex >= this._lastIdx) {
            return String.valueOf(columnIndex) + rowIndex + "?";
        }
        SignalRow signalRow = (SignalRow)this._signalList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (signalRow.getSignal() == null) break;
                return signalRow.getSignal().getDisplayName();
            }
            case 1: {
                if (signalRow.getFromBlock() == null) break;
                return signalRow.getFromBlock().getDisplayName();
            }
            case 2: {
                if (signalRow.getPortal() == null) break;
                return signalRow.getPortal().getName();
            }
            case 3: {
                if (signalRow.getToBlock() == null) break;
                return signalRow.getToBlock().getDisplayName();
            }
            case 4: {
                if (signalRow.isMetric()) {
                    return this.twoDigit.format(signalRow.getLength() / 10.0f);
                }
                return this.twoDigit.format(signalRow.getLength() / 25.4f);
            }
            case 5: {
                return signalRow.isMetric();
            }
            case 6: {
                return Bundle.getMessage("ButtonDelete");
            }
            case 7: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String msg = null;
        if (this._signalList.numberOfSignals() == row) {
            if (col == 6) {
                this.initTempRow();
                this.fireTableRowsUpdated(row, row);
                return;
            }
            if (col == 5) {
                this.tempRow[5] = value.equals(true) ? Bundle.getMessage("cm") : Bundle.getMessage("in");
                this.fireTableRowsUpdated(row, row);
                return;
            }
            if (col == 4) {
                try {
                    this._tempLen = IntlUtilities.floatValue(value.toString());
                    this._tempLen = this.tempRow[5].equals(Bundle.getMessage("cm")) ? (this._tempLen *= 10.0f) : (this._tempLen *= 25.4f);
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("BadNumber", this.tempRow[4]), Bundle.getMessage("ErrorTitle"), 2);
                }
                return;
            }
            String str = (String)value;
            if (str == null || str.trim().length() == 0) {
                this.tempRow[col] = null;
                return;
            }
            this.tempRow[col] = str.trim();
            OBlock fromBlock = null;
            OBlock toBlock = null;
            Portal portal = null;
            OBlockManager OBlockMgr = InstanceManager.getDefault(OBlockManager.class);
            if (this.tempRow[1] != null && (fromBlock = OBlockMgr.getOBlock(this.tempRow[1])) == null) {
                msg = Bundle.getMessage("NoSuchBlock", this.tempRow[1]);
            }
            if (msg == null && this.tempRow[3] != null && (toBlock = OBlockMgr.getOBlock(this.tempRow[3])) == null) {
                msg = Bundle.getMessage("NoSuchBlock", this.tempRow[3]);
            }
            if (msg == null) {
                if (this.tempRow[2] != null) {
                    portal = this._portalMgr.getPortal(this.tempRow[2]);
                    if (portal == null) {
                        msg = Bundle.getMessage("NoSuchPortalName", this.tempRow[2]);
                    }
                } else if (fromBlock != null && toBlock != null) {
                    portal = this.getPortalWithBlocks(fromBlock, toBlock);
                    if (portal == null) {
                        msg = Bundle.getMessage("NoSuchPortal", this.tempRow[1], this.tempRow[3]);
                    } else {
                        this.tempRow[2] = portal.getName();
                    }
                }
            }
            if (msg == null && this.tempRow[0] != null) {
                NamedBean signal = Portal.getSignal(this.tempRow[0]);
                msg = signal == null ? Bundle.getMessage("NoSuchSignal", this.tempRow[0]) : this.checkDuplicateSignal(signal);
                if (msg == null) {
                    if (fromBlock != null && toBlock != null) {
                        portal = this.getPortalWithBlocks(fromBlock, toBlock);
                        if (portal == null) {
                            msg = Bundle.getMessage("NoSuchPortal", this.tempRow[1], this.tempRow[3]);
                        } else {
                            this.tempRow[2] = portal.getName();
                        }
                    } else {
                        return;
                    }
                }
                if (msg == null) {
                    float length = 0.0f;
                    boolean isMetric = this.tempRow[5].equals(Bundle.getMessage("cm"));
                    try {
                        length = IntlUtilities.floatValue(this.tempRow[4]);
                        length = isMetric ? (length *= 10.0f) : (length *= 25.4f);
                    }
                    catch (ParseException parseException) {
                        msg = Bundle.getMessage("BadNumber", this.tempRow[4]);
                    }
                    this.tempRow[5] = isMetric ? Bundle.getMessage("cm") : Bundle.getMessage("in");
                    if (msg == null) {
                        SignalRow signalRow = new SignalRow(signal, fromBlock, portal, toBlock, length, isMetric);
                        msg = SignalTableModel.setSignal(signalRow, false);
                        this.initTempRow();
                        this.fireTableDataChanged();
                    }
                }
            }
        } else {
            SignalRow signalRow;
            try {
                signalRow = (SignalRow)this._signalList.get(row);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                log.warn("setValue out of range");
                return;
            }
            OBlockManager OBlockMgr = InstanceManager.getDefault(OBlockManager.class);
            switch (col) {
                case 0: {
                    NamedBean signal = Portal.getSignal((String)value);
                    if (signal == null) {
                        msg = Bundle.getMessage("NoSuchSignal", value);
                        break;
                    }
                    Portal portal = signalRow.getPortal();
                    if (portal == null || signalRow.getToBlock() == null) break;
                    NamedBean oldSignal = signalRow.getSignal();
                    signalRow.setSignal(signal);
                    msg = this.checkDuplicateSignal(signalRow);
                    if (msg == null) {
                        this.deleteSignal(signalRow);
                        msg = SignalTableModel.setSignal(signalRow, false);
                        this.fireTableRowsUpdated(row, row);
                        break;
                    }
                    signalRow.setSignal(oldSignal);
                    break;
                }
                case 1: {
                    OBlock block = OBlockMgr.getOBlock((String)value);
                    if (block == null) {
                        msg = Bundle.getMessage("NoSuchBlock", value);
                        break;
                    }
                    if (block.equals(signalRow.getFromBlock())) break;
                    this.deleteSignal(signalRow);
                    signalRow.setFromBlock(block);
                    Portal portal = signalRow.getPortal();
                    if (SignalTableModel.checkPortalBlock(portal, block)) {
                        signalRow.setToBlock(null);
                    } else {
                        portal = this.getPortalWithBlocks(block, signalRow.getToBlock());
                        signalRow.setPortal(portal);
                    }
                    msg = this.checkSignalRow(signalRow);
                    if (msg != null) {
                        signalRow.setPortal(null);
                        break;
                    }
                    msg = this.checkDuplicateProtection(signalRow);
                    if (msg == null && signalRow.getPortal() != null) {
                        msg = SignalTableModel.setSignal(signalRow, true);
                    } else {
                        signalRow.setPortal(null);
                    }
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                case 2: {
                    Portal portal = this._portalMgr.getPortal((String)value);
                    if (portal == null) {
                        msg = Bundle.getMessage("NoSuchPortalName", value);
                        break;
                    }
                    this.deleteSignal(signalRow);
                    signalRow.setPortal(portal);
                    OBlock block = signalRow.getToBlock();
                    if (SignalTableModel.checkPortalBlock(portal, block)) {
                        signalRow.setFromBlock(null);
                    } else {
                        block = signalRow.getFromBlock();
                        if (SignalTableModel.checkPortalBlock(portal, block)) {
                            signalRow.setToBlock(null);
                        }
                    }
                    msg = this.checkSignalRow(signalRow);
                    if (msg != null) {
                        signalRow.setToBlock(null);
                        break;
                    }
                    msg = this.checkDuplicateProtection(signalRow);
                    if (msg != null) break;
                    signalRow.setPortal(portal);
                    msg = SignalTableModel.setSignal(signalRow, false);
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                case 3: {
                    OBlock block = OBlockMgr.getOBlock((String)value);
                    if (block == null) {
                        msg = Bundle.getMessage("NoSuchBlock", value);
                        break;
                    }
                    if (block.equals(signalRow.getToBlock())) break;
                    this.deleteSignal(signalRow);
                    signalRow.setToBlock(block);
                    Portal portal = signalRow.getPortal();
                    if (SignalTableModel.checkPortalBlock(portal, block)) {
                        signalRow.setFromBlock(null);
                    } else {
                        portal = this.getPortalWithBlocks(signalRow.getFromBlock(), block);
                        signalRow.setPortal(portal);
                    }
                    msg = this.checkSignalRow(signalRow);
                    if (msg != null) {
                        signalRow.setPortal(null);
                        break;
                    }
                    msg = this.checkDuplicateProtection(signalRow);
                    if (msg == null && signalRow.getPortal() != null) {
                        msg = SignalTableModel.setSignal(signalRow, true);
                    } else {
                        signalRow.setPortal(null);
                    }
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                case 4: {
                    try {
                        float len = IntlUtilities.floatValue(value.toString());
                        if (signalRow.isMetric()) {
                            signalRow.setLength(len * 10.0f);
                        } else {
                            signalRow.setLength(len * 25.4f);
                        }
                    }
                    catch (ParseException parseException) {
                        msg = Bundle.getMessage("BadNumber", value);
                    }
                    if (msg == null && signalRow.getPortal() != null) {
                        msg = SignalTableModel.setSignal(signalRow, false);
                        break;
                    }
                    signalRow.setPortal(null);
                    break;
                }
                case 5: {
                    signalRow.setMetric((Boolean)value);
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                case 6: {
                    this.deleteSignal(signalRow);
                    this._signalList.remove(signalRow);
                    this.fireTableDataChanged();
                    break;
                }
                case 7: {
                    this.editSignal(Portal.getSignal(signalRow.getSignal().getDisplayName()), signalRow);
                    break;
                }
            }
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 2);
        }
    }

    protected void deleteSignal(SignalRow signalRow) {
        Portal portal = signalRow.getPortal();
        if (portal == null) {
            portal = this.getPortalWithBlocks(signalRow.getFromBlock(), signalRow.getToBlock());
        }
        if (portal != null) {
            portal.deleteSignal(signalRow.getSignal());
        }
    }

    private void editSignal(NamedBean signal, SignalRow sr) {
        if (this._tabbed && signal != null && !this.inEditMode) {
            this.inEditMode = true;
            SignalEditFrame sef = new SignalEditFrame(Bundle.getMessage("TitleSignalEditor", sr.getSignal().getDisplayName()), signal, sr, this);
            sef.setVisible(true);
        }
    }

    private static String setSignal(SignalRow signalRow, boolean deletePortal) {
        Portal portal = signalRow.getPortal();
        float length = signalRow.getLength();
        if (portal.setProtectSignal(signalRow.getSignal(), length, signalRow.getToBlock())) {
            if (signalRow.getFromBlock() == null) {
                signalRow.setFromBlock(portal.getOpposingBlock(signalRow.getToBlock()));
            }
        } else {
            if (deletePortal) {
                signalRow.setPortal(null);
            } else {
                signalRow.setToBlock(null);
            }
            return Bundle.getMessage("PortalBlockConflict", portal.getName(), signalRow.getToBlock().getDisplayName());
        }
        return null;
    }

    private static boolean checkPortalBlock(Portal portal, OBlock block) {
        if (block == null) {
            return false;
        }
        return block.equals(portal.getToBlock()) || block.equals(portal.getFromBlock());
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 6: 
            case 7: {
                return JButton.class;
            }
            case 5: {
                return JToggleButton.class;
            }
        }
        return String.class;
    }

    public static int getPreferredWidth(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 4: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 5: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 6: {
                return new JButton((String)"DELETE").getPreferredSize().width;
            }
            case 7: {
                return new JButton((String)"EDIT").getPreferredSize().width;
            }
        }
        return 5;
    }

    public boolean editMode() {
        return this.inEditMode;
    }

    public void setEditMode(boolean editing) {
        this.inEditMode = editing;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (property.equals("length") || property.equals("portalCount") || property.equals("UserName") || property.equals("signalChange")) {
            this.makeList();
            this.fireTableDataChanged();
        }
    }

    public static class NameSorter
    implements Comparator<SignalRow> {
        @Override
        public int compare(SignalRow o1, SignalRow o2) {
            return o2.getSignal().compareTo(o1.getSignal());
        }
    }

    static class SignalArray
    extends ArrayList<SignalRow> {
        SignalArray() {
        }

        public int numberOfSignals() {
            return this.size();
        }
    }

    protected static class SignalRow {
        NamedBean _signal;
        OBlock _fromBlock;
        Portal _portal;
        OBlock _toBlock;
        float _length;
        boolean _isMetric;

        SignalRow(NamedBean signal, OBlock fromBlock, Portal portal, OBlock toBlock, float length, boolean isMetric) {
            this._signal = signal;
            this._fromBlock = fromBlock;
            this._portal = portal;
            this._toBlock = toBlock;
            this._length = length;
            this._isMetric = isMetric;
        }

        void setSignal(NamedBean signal) {
            this._signal = signal;
        }

        NamedBean getSignal() {
            return this._signal;
        }

        void setFromBlock(OBlock fromBlock) {
            this._fromBlock = fromBlock;
        }

        OBlock getFromBlock() {
            return this._fromBlock;
        }

        void setPortal(Portal portal) {
            this._portal = portal;
        }

        Portal getPortal() {
            return this._portal;
        }

        void setToBlock(OBlock toBlock) {
            this._toBlock = toBlock;
        }

        OBlock getToBlock() {
            return this._toBlock;
        }

        void setLength(float length) {
            this._length = length;
        }

        float getLength() {
            return this._length;
        }

        void setMetric(boolean isMetric) {
            this._isMetric = isMetric;
        }

        boolean isMetric() {
            return this._isMetric;
        }
    }
}

