/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.PortalTableModel;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalEditFrame
extends JmriJFrame {
    JPanel main = new JPanel();
    PortalTableModel model;
    PortalManager pm;
    private final JLabel portalLabel = new JLabel(Bundle.getMessage("PortalNameLabel"), 11);
    private final JTextField portalUserName = new JTextField(15);
    private final JLabel fromBlockLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("FromBlockName")), 11);
    private final JLabel toBlockLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("OppBlockName")), 11);
    private final NamedBeanComboBox<OBlock> fromBlockComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(OBlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final NamedBeanComboBox<OBlock> toBlockComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(OBlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final JLabel statusBar = new JLabel(Bundle.getMessage("AddPortalStatusEnter"), 10);
    private final PortalEditFrame frame = this;
    private Portal _portal;
    private boolean _newPortal = false;
    private static final Logger log = LoggerFactory.getLogger(PortalEditFrame.class);

    public PortalEditFrame(@Nonnull String title, Portal portal, PortalTableModel model) {
        super(title, true, true);
        this.model = model;
        this.pm = InstanceManager.getDefault(PortalManager.class);
        this.layoutFrame();
        if (portal == null) {
            this.resetFrame();
            this.setTitle(Bundle.getMessage("TitleAddPortal"));
            this._newPortal = true;
        } else {
            this._portal = portal;
            this.populateFrame(portal);
        }
    }

    public void layoutFrame() {
        this.frame.addHelpMenu("package.jmri.jmrit.beantable.OBlockTable", true);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 3));
        this.frame.setSize(425, 225);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        JPanel configGrid = new JPanel();
        GridLayout layout = new GridLayout(3, 2, 10, 0);
        configGrid.setLayout(layout);
        configGrid.add(this.portalLabel);
        JPanel p1 = new JPanel();
        p1.add((Component)this.portalUserName, Float.valueOf(0.5f));
        configGrid.add(p1);
        this.fromBlockComboBox.addActionListener(e -> {
            if (this.toBlockComboBox.getItemCount() > 0 && this.fromBlockComboBox.getSelectedItem() != null && this.toBlockComboBox.getSelectedItem() != null && ((OBlock)this.toBlockComboBox.getSelectedItem()).equals(this.fromBlockComboBox.getSelectedItem())) {
                log.debug("resetting ToBlock");
                this.toBlockComboBox.setSelectedIndex(0);
            }
        });
        configGrid.add(this.fromBlockLabel);
        configGrid.add(this.fromBlockComboBox);
        this.fromBlockComboBox.setAllowNull(true);
        this.toBlockComboBox.addActionListener(e -> {
            if (this.toBlockComboBox.getItemCount() > 0 && this.fromBlockComboBox.getSelectedItem() != null && this.toBlockComboBox.getSelectedItem() != null && ((OBlock)this.toBlockComboBox.getSelectedItem()).equals(this.fromBlockComboBox.getSelectedItem())) {
                log.debug("resetting FromBlock");
                this.fromBlockComboBox.setSelectedIndex(0);
            }
        });
        configGrid.add(this.toBlockLabel);
        configGrid.add(this.toBlockComboBox);
        this.toBlockComboBox.setAllowNull(true);
        p.add(configGrid);
        p.add(Box.createVerticalGlue());
        p1 = new JPanel();
        this.statusBar.setFont(this.statusBar.getFont().deriveFont(0.9f * (float)this.portalUserName.getFont().getSize()));
        this.statusBar.setForeground(Color.gray);
        p1.add(this.statusBar);
        p.add(p1);
        JPanel p2 = new JPanel();
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        p2.add(cancel);
        cancel.addActionListener(e -> this.frame.dispose());
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        p2.add(ok);
        ok.addActionListener(e -> this.applyPressed(e));
        p.add((Component)p2, "South");
        this.main.add(p);
        this.frame.getContentPane().add(this.main);
        this.frame.setEscapeKeyClosesWindow(true);
        this.frame.getRootPane().setDefaultButton(ok);
    }

    public void resetFrame() {
        this.portalUserName.setText(null);
        this.portalUserName.setBackground(Color.white);
        if (this.fromBlockComboBox.getItemCount() > 0) {
            this.fromBlockComboBox.setSelectedIndex(0);
            this.toBlockComboBox.setSelectedIndex(0);
        }
        if (this.fromBlockComboBox.getItemCount() < 2) {
            this.status(Bundle.getMessage("NotEnoughBlocks"), true);
        } else {
            this.status(Bundle.getMessage("AddPortalStatusEnter"), false);
        }
        this._newPortal = true;
    }

    public void populateFrame(Portal p) {
        if (p == null) {
            throw new IllegalArgumentException("Null OBlock object");
        }
        this.portalUserName.setText(p.getName());
        if (p.getFromBlockName() != null) {
            this.fromBlockComboBox.setSelectedItemByName(p.getFromBlockName());
        }
        if (p.getToBlockName() != null) {
            this.toBlockComboBox.setSelectedItemByName(p.getToBlockName());
        }
        this._newPortal = false;
    }

    private void applyPressed(ActionEvent e) {
        String user = this.portalUserName.getText().trim();
        if (user.equals("")) {
            this.status(Bundle.getMessage("WarningSysNameEmpty"), true);
            this.portalUserName.setBackground(Color.red);
            return;
        }
        this.portalUserName.setBackground(Color.white);
        this.status(Bundle.getMessage("AddPortalStatusEnter"), false);
        if (this.fromBlockComboBox.getSelectedIndex() == -1 || this.toBlockComboBox.getSelectedIndex() == -1) {
            this.status(Bundle.getMessage("PortalNeedsBlock", user), true);
            return;
        }
        if (this._newPortal) {
            this._portal = this.pm.createNewPortal(user);
            if (this._portal == null) {
                this.status(Bundle.getMessage("WarningSysNameInUse"), true);
                this.portalUserName.setBackground(Color.red);
                return;
            }
        } else {
            String msg = this._portal.setName(user);
            if (msg != null) {
                this.status(msg, true);
                return;
            }
        }
        try {
            int val;
            String msg;
            OBlock block = (OBlock)this.fromBlockComboBox.getSelectedItem();
            if (block != null) {
                if (!this._portal.setFromBlock(block, false)) {
                    msg = Bundle.getMessage("BlockPathsConflict", this.fromBlockComboBox.getSelectedItemDisplayName(), this._portal.getFromBlockName());
                    val = this.model.verifyWarning(msg);
                    if (val == 2) {
                        this.status(msg, true);
                        return;
                    }
                    this.status(Bundle.getMessage("AddPortalStatusEnter"), false);
                }
                this._portal.setFromBlock(block, true);
            }
            if ((block = (OBlock)this.toBlockComboBox.getSelectedItem()) != null) {
                if (!this._portal.setToBlock(block, false)) {
                    msg = Bundle.getMessage("BlockPathsConflict", this.fromBlockComboBox.getSelectedItemDisplayName(), this._portal.getFromBlockName());
                    val = this.model.verifyWarning(msg);
                    if (val == 2) {
                        this.status(msg, true);
                        return;
                    }
                    this.status(Bundle.getMessage("AddPortalStatusEnter"), false);
                }
                this._portal.setToBlock(block, true);
            }
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), Bundle.getMessage("PortalCreateErrorTitle"), 0);
            this.status(Bundle.getMessage("AddPortalFailed", user), true);
            return;
        }
        this.model.fireTableDataChanged();
        this.dispose();
    }

    void status(String message, boolean warn) {
        this.statusBar.setText(message);
        this.statusBar.setForeground(warn ? Color.red : Color.gray);
    }
}

