/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import jmri.BeanSetting;
import jmri.Block;
import jmri.InstanceManager;
import jmri.Turnout;
import jmri.jmrit.beantable.RowComboBoxPanel;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.TableFrames;
import jmri.jmrit.logix.OPath;
import jmri.util.gui.GuiLafPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTurnoutTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int TURNOUT_NAME_COL = 0;
    public static final int STATE_COL = 1;
    public static final int DELETE_COL = 2;
    public static final int NUMCOLS = 3;
    private static final String SET_CLOSED = InstanceManager.turnoutManagerInstance().getClosedText();
    private static final String SET_THROWN = InstanceManager.turnoutManagerInstance().getThrownText();
    private OPath _path;
    private final String[] tempRow = new String[3];
    private TableFrames.PathTurnoutFrame _parent;
    private final boolean _tabbed;
    private static final Logger log = LoggerFactory.getLogger(PathTurnoutTableModel.class);

    public PathTurnoutTableModel() {
        this._tabbed = InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed();
    }

    public PathTurnoutTableModel(OPath path, @Nonnull TableFrames.PathTurnoutFrame parent) {
        this._path = path;
        this._path.getBlock().addPropertyChangeListener(this);
        this._tabbed = false;
        this._parent = parent;
    }

    public PathTurnoutTableModel(OPath path) {
        this._path = path;
        this._path.getBlock().addPropertyChangeListener(this);
        this._tabbed = true;
    }

    public void removeListener() {
        Block block = this._path.getBlock();
        if (block == null) {
            return;
        }
        try {
            this._path.getBlock().removePropertyChangeListener(this);
        }
        catch (NullPointerException nullPointerException) {}
    }

    void initTempRow() {
        int i = 0;
        while (i < 3) {
            this.tempRow[i] = null;
            ++i;
        }
        this.tempRow[2] = Bundle.getMessage("ButtonClear");
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this._path.getSettings().size() + (this._tabbed ? 0 : 1);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("LabelItemName");
            }
            case 1: {
                return Bundle.getMessage("TurnoutState");
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._path.getSettings().size() == rowIndex) {
            return this.tempRow[columnIndex];
        }
        if (rowIndex >= this._path.getSettings().size()) {
            log.debug("row greater than bean list size");
            return "Error bean list";
        }
        BeanSetting bs = this._path.getSettings().get(rowIndex);
        if (bs == null) {
            log.debug("bean is null");
            return "Error no bean";
        }
        switch (columnIndex) {
            case 0: {
                return bs.getBeanName();
            }
            case 1: {
                switch (bs.getSetting()) {
                    case 2: {
                        return SET_CLOSED;
                    }
                    case 4: {
                        return SET_THROWN;
                    }
                }
                return "";
            }
            case 2: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this._path.getSettings().size() == row) {
            int s;
            switch (col) {
                case 0: {
                    this.tempRow[0] = (String)value;
                    if (this.tempRow[1] != null) break;
                    return;
                }
                case 1: {
                    this.tempRow[1] = (String)value;
                    if (this.tempRow[0] != null) break;
                    return;
                }
                case 2: {
                    this.initTempRow();
                    this.fireTableRowsUpdated(row, row);
                    return;
                }
            }
            Turnout t = InstanceManager.turnoutManagerInstance().getTurnout(this.tempRow[0]);
            if (t == null) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("NoSuchTurnout", this.tempRow[0]), Bundle.getMessage("ErrorTitle"), 2);
                return;
            }
            if (this.tempRow[1].equals(SET_CLOSED)) {
                s = 2;
            } else {
                if (!this.tempRow[1].equals(SET_THROWN)) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("TurnoutMustBeSet", SET_CLOSED, SET_THROWN), Bundle.getMessage("ErrorTitle"), 2);
                    return;
                }
                s = 4;
            }
            BeanSetting bs = new BeanSetting(t, this.tempRow[0], s);
            this._path.addSetting(bs);
            this.fireTableRowsUpdated(row, row);
            if (this._tabbed) return;
            this.initTempRow();
            return;
        }
        BeanSetting bs = this._path.getSettings().get(row);
        switch (col) {
            case 0: {
                Turnout t = InstanceManager.turnoutManagerInstance().getTurnout((String)value);
                if (t == null) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("NoSuchTurnout", (String)value), Bundle.getMessage("ErrorTitle"), 2);
                    return;
                }
                if (!t.equals(bs.getBean())) {
                    this._path.removeSetting(bs);
                    this._path.addSetting(new BeanSetting(t, (String)value, bs.getSetting()));
                }
                this.fireTableDataChanged();
                return;
            }
            case 1: {
                String setting = (String)value;
                if (setting.equals(SET_CLOSED)) {
                    this._path.getSettings().set(row, new BeanSetting(bs.getBean(), bs.getBeanName(), 2));
                } else {
                    if (!setting.equals(SET_THROWN)) {
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("TurnoutMustBeSet", SET_CLOSED, SET_THROWN), Bundle.getMessage("ErrorTitle"), 2);
                        return;
                    }
                    this._path.getSettings().set(row, new BeanSetting(bs.getBean(), bs.getBeanName(), 4));
                }
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 2: {
                if (JOptionPane.showConfirmDialog(null, Bundle.getMessage("DeleteTurnoutConfirm"), Bundle.getMessage("WarningTitle"), 0, 3) != 0) return;
                this._path.removeSetting(bs);
                this.fireTableDataChanged();
                return;
            }
        }
        log.warn("Unhandled col: {}", (Object)col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: {
                return JButton.class;
            }
            case 1: {
                return StateComboBoxPanel.class;
            }
        }
        return String.class;
    }

    JComboBox<String> getStateEditorBox(int row) {
        JComboBox<String> editCombo = new JComboBox<String>();
        editCombo.addItem(SET_THROWN);
        editCombo.addItem(SET_CLOSED);
        editCombo.putClientProperty("JComponent.sizeVariant", "small");
        editCombo.putClientProperty("JComboBox.buttonType", "square");
        return editCombo;
    }

    protected void configTurnoutStateColumn(JTable table) {
        table.setDefaultEditor(StateComboBoxPanel.class, new StateComboBoxPanel());
        table.setDefaultRenderer(StateComboBoxPanel.class, new StateComboBoxPanel());
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)20).getPreferredSize().width;
            }
            case 1: {
                return new JTextField((int)10).getPreferredSize().width;
            }
            case 2: {
                return new JButton((String)"DELETE").getPreferredSize().width;
            }
        }
        return 5;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this._path.getBlock().equals(e.getSource())) {
            String property = e.getPropertyName();
            if (property.equals("pathCount")) {
                this.fireTableDataChanged();
                if (this._path.equals(e.getOldValue())) {
                    this.removeListener();
                    if (!this._tabbed) {
                        this._parent.dispose();
                    }
                }
            } else if (property.equals("pathName")) {
                String title = Bundle.getMessage("TitlePathTurnoutTable", this._path.getBlock().getDisplayName(), e.getOldValue());
                if (!this._tabbed && this._parent.getTitle().equals(title)) {
                    title = Bundle.getMessage("TitlePathTurnoutTable", this._path.getBlock().getDisplayName(), e.getNewValue());
                }
                if (!this._tabbed) {
                    this._parent.setTitle(title);
                }
            }
        }
    }

    void dispose() {
        InstanceManager.turnoutManagerInstance().removePropertyChangeListener(this);
    }

    public class StateComboBoxPanel
    extends RowComboBoxPanel {
        @Override
        protected final void eventEditorMousePressed() {
            this.editor.add(this.getEditorBox(this.table.convertRowIndexToModel(this.currentRow)));
            this.editor.revalidate();
            SwingUtilities.invokeLater(this.comboBoxFocusRequester);
            log.debug("eventEditorMousePressed in row: {})", (Object)this.currentRow);
        }

        @Override
        protected JComboBox<String> getEditorBox(int row) {
            return PathTurnoutTableModel.this.getStateEditorBox(row);
        }
    }
}

