/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jmri.Block;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.OBlockTableAction;
import jmri.jmrit.beantable.RowComboBoxPanel;
import jmri.jmrit.beantable.block.BlockCurvatureJComboBox;
import jmri.jmrit.beantable.oblock.BlockPathTableModel;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.PathTurnoutTableModel;
import jmri.jmrit.beantable.oblock.TableFrames;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.picker.PickListModel;
import jmri.util.IntlUtilities;
import jmri.util.NamedBeanComparator;
import jmri.util.gui.GuiLafPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBlockTableModel
extends BeanTableDataModel<OBlock> {
    public static final int SYSNAMECOL = 0;
    public static final int USERNAMECOL = 1;
    public static final int COMMENTCOL = 2;
    public static final int STATECOL = 3;
    public static final int SENSORCOL = 4;
    public static final int EDIT_COL = 5;
    public static final int DELETE_COL = 6;
    public static final int LENGTHCOL = 7;
    public static final int UNITSCOL = 8;
    public static final int REPORTERCOL = 9;
    public static final int REPORT_CURRENTCOL = 10;
    public static final int PERMISSIONCOL = 11;
    public static final int SPEEDCOL = 12;
    public static final int WARRANTCOL = 13;
    public static final int ERR_SENSORCOL = 14;
    public static final int CURVECOL = 15;
    public static final int VALUE = 16;
    public static final int NUMCOLS = 17;
    static String ZEROS = "000000000";
    DecimalFormat twoDigit = new DecimalFormat("0.00");
    OBlockManager _manager;
    private final String[] tempRow = new String[17];
    private float _tempLen = 0.0f;
    TableFrames _parent;
    private final boolean _tabbed;
    private boolean _isMetric = false;
    private static final Logger log = LoggerFactory.getLogger(OBlockTableModel.class);

    public OBlockTableModel(@Nonnull TableFrames parent) {
        this._parent = parent;
        this._tabbed = InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed();
        if (this._tabbed) {
            this._manager = InstanceManager.getDefault(OBlockManager.class);
            this._manager.addPropertyChangeListener(this);
        }
        this.updateNameList();
        if (!this._tabbed) {
            this.initTempRow();
        }
    }

    public void addHeaderListener(JTable table) {
        this.addMouseListenerToHeader(table);
    }

    void initTempRow() {
        int i = 0;
        while (i < 17) {
            this.tempRow[i] = null;
            ++i;
        }
        this.tempRow[7] = this.twoDigit.format(0.0);
        this.tempRow[8] = Bundle.getMessage("in");
        this.tempRow[15] = BlockCurvatureJComboBox.getStringFromCurvature(0);
        this.tempRow[10] = Bundle.getMessage("Current");
        this.tempRow[11] = Bundle.getMessage("Permissive");
        this.tempRow[12] = "";
        this.tempRow[6] = Bundle.getMessage("ButtonClear");
    }

    @Override
    public Manager<OBlock> getManager() {
        this._manager = InstanceManager.getDefault(OBlockManager.class);
        return this._manager;
    }

    @Override
    public OBlock getBySystemName(@Nonnull String name) {
        return (OBlock)this._manager.getBySystemName(name);
    }

    @Override
    public OBlock getByUserName(@Nonnull String name) {
        return (OBlock)this._manager.getByUserName(name);
    }

    @Override
    protected String getBeanType() {
        return "OBlock";
    }

    @Override
    public void clickOn(OBlock t) {
    }

    protected boolean isMetric() {
        return this._isMetric;
    }

    protected void changeUnits() {
        this._isMetric = !this._isMetric;
        SortedSet oblockList = this._manager.getNamedBeanSet();
        for (OBlock block : oblockList) {
            block.setMetricUnits(this._isMetric);
        }
        this.fireTableDataChanged();
    }

    @Override
    protected String getMasterClassName() {
        return this.getClassName();
    }

    protected List<OBlock> getBeanList() {
        TreeSet ts = new TreeSet(new NamedBeanComparator());
        for (String s : this.sysNameList) {
            ts.add(this.getBySystemName(s));
        }
        ArrayList<OBlock> list = new ArrayList<OBlock>(this.sysNameList.size());
        list.addAll(ts);
        return list;
    }

    @Override
    public String getValue(String name) {
        OBlock bl = (OBlock)this._manager.getBySystemName(name);
        if (bl != null) {
            return OBlockTableModel.getValue(bl.getState());
        }
        return "";
    }

    protected static String getValue(int state) {
        StringBuilder sb = new StringBuilder();
        if ((state & 0x100) != 0) {
            sb.append(Bundle.getMessage("Dark"));
        }
        if ((state & 2) != 0) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(Bundle.getMessage("Occupied"));
        }
        if ((state & 4) != 0) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(Bundle.getMessage("Unoccupied"));
        }
        if ((state & 8) != 0) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(Bundle.getMessage("BeanStateInconsistent"));
        }
        if ((state & 1) != 0) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(Bundle.getMessage("BeanStateUnknown"));
        }
        if ((state & 0x10) != 0) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(Bundle.getMessage("Allocated"));
        }
        if ((state & 0x20) != 0) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(Bundle.getMessage("Running"));
        }
        if ((state & 0x40) != 0) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(Bundle.getMessage("OutOfService"));
        }
        if ((state & 0x80) != 0) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(Bundle.getMessage("TrackError"));
        }
        if (sb.length() == 0) {
            sb.append(Bundle.getMessage("UnDefined"));
        }
        return sb.toString();
    }

    @Override
    public int getColumnCount() {
        return 17;
    }

    @Override
    public int getRowCount() {
        return super.getRowCount() + (this._tabbed ? 0 : 1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row > this.sysNameList.size()) {
            return "";
        }
        AbstractNamedBean b = null;
        if (this._tabbed && row <= this.sysNameList.size() || !this._tabbed && row < this.sysNameList.size()) {
            String name = (String)this.sysNameList.get(row);
            b = (OBlock)this._manager.getBySystemName(name);
        }
        switch (col) {
            case 0: {
                if (b != null) {
                    return b.getSystemName();
                }
                return this.tempRow[col];
            }
            case 1: {
                if (b != null) {
                    return b.getUserName();
                }
                return this.tempRow[col];
            }
            case 2: {
                if (b != null) {
                    return b.getComment();
                }
                return this.tempRow[col];
            }
            case 3: {
                int state;
                int num;
                if (b != null && (num = Integer.numberOfLeadingZeros(state = ((Block)b).getState()) - 23) >= 0) {
                    return String.valueOf(ZEROS.substring(0, num)) + Integer.toBinaryString(state);
                }
                return ZEROS;
            }
            case 4: {
                Sensor s;
                if (b != null) {
                    s = ((Block)b).getSensor();
                    if (s == null) {
                        return "";
                    }
                    return s.getDisplayName();
                }
                return this.tempRow[col];
            }
            case 7: {
                if (b != null) {
                    if (((OBlock)b).isMetric()) {
                        return this.twoDigit.format(((Block)b).getLengthCm());
                    }
                    return this.twoDigit.format(((Block)b).getLengthIn());
                }
                if (this.tempRow[8].equals(Bundle.getMessage("cm"))) {
                    return this.twoDigit.format(this._tempLen / 10.0f);
                }
                return this.twoDigit.format(this._tempLen / 25.4f);
            }
            case 8: {
                if (b != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("getValueAt: row= {}, col= {}, \"{}\" isMetric= {}", new Object[]{row, col, b.getDisplayName(), ((OBlock)b).isMetric()});
                    }
                    return ((OBlock)b).isMetric();
                }
                if (log.isDebugEnabled()) {
                    log.debug("getValueAt: row= {}, col= {}, isMetric= {}", new Object[]{row, col, this.tempRow[8].equals(Bundle.getMessage("cm"))});
                }
                return this.tempRow[8].equals(Bundle.getMessage("cm"));
            }
            case 15: {
                if (b != null) {
                    return BlockCurvatureJComboBox.getStringFromCurvature(((Block)b).getCurvature());
                }
                return this.tempRow[col];
            }
            case 14: {
                Sensor s;
                if (b != null) {
                    s = ((OBlock)b).getErrorSensor();
                    if (s == null) {
                        return "";
                    }
                    return s.getDisplayName();
                }
                return this.tempRow[col];
            }
            case 9: {
                if (b != null) {
                    Reporter r = ((Block)b).getReporter();
                    if (r == null) {
                        return "";
                    }
                    return r.getDisplayName();
                }
                return this.tempRow[col];
            }
            case 10: {
                if (b != null) {
                    if (((Block)b).getReporter() != null) {
                        return ((Block)b).isReportingCurrent();
                    }
                    return "";
                }
                return this.tempRow[10].equals(Bundle.getMessage("Current"));
            }
            case 11: {
                if (b != null) {
                    return ((Block)b).getPermissiveWorking();
                }
                return this.tempRow[11].equals(Bundle.getMessage("Permissive"));
            }
            case 12: {
                if (b != null) {
                    return ((Block)b).getBlockSpeed();
                }
                return this.tempRow[col];
            }
            case 13: {
                Warrant w;
                if (b != null && (w = ((OBlock)b).getWarrant()) != null) {
                    return w.getDisplayName();
                }
                return this.tempRow[col];
            }
            case 16: {
                if (b != null) {
                    Object obj = ((Block)b).getValue();
                    if (obj != null) {
                        return obj;
                    }
                    if ((((Block)b).getState() & 2) != 0) {
                        return Bundle.getMessage("BlockUnknown");
                    }
                    return null;
                }
                return this.tempRow[col];
            }
            case 5: {
                if (b != null) {
                    if (this._tabbed) {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    return Bundle.getMessage("ButtonEditPath");
                }
                return "";
            }
            case 6: {
                if (b != null) {
                    return Bundle.getMessage("ButtonDelete");
                }
                return Bundle.getMessage("ButtonClear");
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        log.debug("setValueAt: row= {}, col= {}, value= {}", new Object[]{row, col, value});
        if (!this._tabbed && super.getRowCount() == row) {
            switch (col) {
                case 0: {
                    if (!this._manager.isValidSystemNameFormat((String)value)) {
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("BadNameOBlock"), Bundle.getMessage("ErrorTitle"), 2);
                        return;
                    }
                    OBlock block = this._manager.createNewOBlock((String)value, this.tempRow[1]);
                    if (block == null) {
                        block = this._manager.getOBlock(this.tempRow[1]);
                        String name = value + " / " + this.tempRow[1];
                        if (block != null) {
                            name = block.getDisplayName();
                        } else {
                            block = this._manager.getOBlock((String)value);
                            if (block != null) {
                                name = block.getDisplayName();
                            }
                        }
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("CreateDuplBlockErr", name), Bundle.getMessage("ErrorTitle"), 2);
                        return;
                    }
                    if (this.tempRow[4] != null && !OBlockTableModel.sensorExists(this.tempRow[4])) {
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("NoSuchSensorErr", this.tempRow[4]), Bundle.getMessage("ErrorTitle"), 2);
                    }
                    block.setComment(this.tempRow[2]);
                    float len = 0.0f;
                    try {
                        len = IntlUtilities.floatValue(this.tempRow[7]);
                    }
                    catch (ParseException parseException) {
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("BadNumber", this.tempRow[7]), Bundle.getMessage("ErrorTitle"), 2);
                    }
                    if (this.tempRow[8].equals(Bundle.getMessage("cm"))) {
                        block.setLength(len * 10.0f);
                        block.setMetricUnits(true);
                    } else {
                        block.setLength(len * 25.4f);
                        block.setMetricUnits(false);
                    }
                    block.setCurvature(BlockCurvatureJComboBox.getCurvatureFromString(this.tempRow[15]));
                    block.setPermissiveWorking(this.tempRow[11].equals(Bundle.getMessage("Permissive")));
                    block.setBlockSpeedName(this.tempRow[12]);
                    if (this.tempRow[14] != null && this.tempRow[14].trim().length() > 0 && !OBlockTableModel.sensorExists(this.tempRow[14])) {
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("NoSuchSensorErr", this.tempRow[14]), Bundle.getMessage("ErrorTitle"), 2);
                    }
                    if (this.tempRow[9] != null) {
                        Reporter rep = null;
                        try {
                            rep = InstanceManager.getDefault(ReporterManager.class).getReporter(this.tempRow[9]);
                            if (rep != null) {
                                block.setReporter(rep);
                                block.setReportingCurrent(this.tempRow[10].equals(Bundle.getMessage("Current")));
                            }
                        }
                        catch (Exception ex) {
                            log.error("No Reporter named \"{}\" found. threw exception: {}", (Object)this.tempRow[9], (Object)ex);
                        }
                        if (rep == null) {
                            JOptionPane.showMessageDialog(null, Bundle.getMessage("NoSuchReporterErr", this.tempRow[9]), Bundle.getMessage("ErrorTitle"), 2);
                        }
                        block.setReporter(rep);
                    }
                    this.initTempRow();
                    this.fireTableDataChanged();
                    return;
                }
                case 6: {
                    this.initTempRow();
                    this.fireTableRowsUpdated(row, row);
                    return;
                }
                case 7: {
                    try {
                        this._tempLen = IntlUtilities.floatValue(value.toString());
                        this._tempLen = this.tempRow[8].equals(Bundle.getMessage("cm")) ? (this._tempLen *= 10.0f) : (this._tempLen *= 25.4f);
                    }
                    catch (ParseException parseException) {
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("BadNumber", this.tempRow[7]), Bundle.getMessage("ErrorTitle"), 2);
                    }
                    return;
                }
                case 8: {
                    this.tempRow[8] = (Boolean)value != false ? Bundle.getMessage("cm") : Bundle.getMessage("in");
                    this.fireTableRowsUpdated(row, row);
                    return;
                }
                case 10: {
                    this.tempRow[10] = (Boolean)value != false ? Bundle.getMessage("Current") : Bundle.getMessage("Last");
                    return;
                }
                case 11: {
                    this.tempRow[11] = (Boolean)value != false ? Bundle.getMessage("Permissive") : Bundle.getMessage("Absolute");
                    return;
                }
            }
            this.tempRow[col] = (String)value;
            return;
        }
        String name = (String)this.sysNameList.get(row);
        OBlock block = (OBlock)this._manager.getBySystemName(name);
        if (block == null) {
            log.error("OBlock named {} not found for OBlockTableModel", (Object)name);
            return;
        }
        switch (col) {
            case 1: {
                OBlock b = this._manager.getOBlock((String)value);
                if (b != null) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("CreateDuplBlockErr", block.getDisplayName()), Bundle.getMessage("ErrorTitle"), 2);
                    return;
                }
                block.setUserName((String)value);
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 2: {
                block.setComment((String)value);
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 4: {
                if (!block.setSensor((String)value)) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("NoSuchSensorErr", value), Bundle.getMessage("ErrorTitle"), 2);
                }
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 7: {
                try {
                    float len = IntlUtilities.floatValue(value.toString());
                    if (block.isMetric()) {
                        block.setLength(len * 10.0f);
                    } else {
                        block.setLength(len * 25.4f);
                    }
                    this.fireTableRowsUpdated(row, row);
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("BadNumber", value), Bundle.getMessage("ErrorTitle"), 2);
                }
                return;
            }
            case 8: {
                block.setMetricUnits((Boolean)value);
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 15: {
                String cName = (String)value;
                if (cName == null) {
                    return;
                }
                block.setCurvature(BlockCurvatureJComboBox.getCurvatureFromString(cName));
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 14: {
                boolean ok = false;
                try {
                    if (((String)value).trim().length() == 0) {
                        block.setErrorSensor(null);
                        ok = true;
                    } else {
                        ok = block.setErrorSensor((String)value);
                        this.fireTableRowsUpdated(row, row);
                    }
                }
                catch (Exception ex) {
                    log.error("getSensor({}) threw exception: {}", value, (Object)ex);
                }
                if (!ok) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("NoSuchSensorErr", value), Bundle.getMessage("ErrorTitle"), 2);
                }
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 9: {
                Reporter rep = null;
                try {
                    rep = InstanceManager.getDefault(ReporterManager.class).getReporter((String)value);
                    if (rep != null) {
                        block.setReporter(rep);
                        this.fireTableRowsUpdated(row, row);
                    }
                }
                catch (Exception ex) {
                    log.error("No Reporter named \"{}\" found. threw exception: {}", value, (Object)ex);
                }
                if (rep == null) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("NoSuchReporterErr", this.tempRow[9]), Bundle.getMessage("ErrorTitle"), 2);
                }
                block.setReporter(rep);
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 10: {
                if (block.getReporter() != null) {
                    block.setReportingCurrent((Boolean)value);
                    this.fireTableRowsUpdated(row, row);
                }
                return;
            }
            case 11: {
                block.setPermissiveWorking((Boolean)value);
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 12: {
                block.setBlockSpeedName((String)value);
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 5: {
                this._parent.openBlockPathPane(block.getSystemName(), null);
                return;
            }
            case 6: {
                this.deleteBean(block);
                return;
            }
        }
        super.setValueAt(value, row, col);
    }

    private static boolean sensorExists(String name) {
        Sensor sensor = InstanceManager.sensorManagerInstance().getByUserName(name);
        if (sensor == null) {
            sensor = InstanceManager.sensorManagerInstance().getBySystemName(name);
        }
        return sensor != null;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 2: {
                return Bundle.getMessage("Comment");
            }
            case 3: {
                return Bundle.getMessage("ColumnState");
            }
            case 4: {
                return Bundle.getMessage("BeanNameSensor");
            }
            case 15: {
                return Bundle.getMessage("BlockCurveColName");
            }
            case 7: {
                return Bundle.getMessage("BlockLengthColName");
            }
            case 8: {
                return Bundle.getMessage("UnitsCol");
            }
            case 5: {
                return Bundle.getMessage("MenuPaths");
            }
            case 6: {
                return Bundle.getMessage("ColumnDelete");
            }
            case 14: {
                return Bundle.getMessage("ErrorSensorCol");
            }
            case 9: {
                return Bundle.getMessage("ReporterCol");
            }
            case 10: {
                return Bundle.getMessage("RepCurrentCol");
            }
            case 11: {
                return Bundle.getMessage("PermissionCol");
            }
            case 13: {
                return Bundle.getMessage("WarrantCol");
            }
            case 16: {
                return Bundle.getMessage("ValueCol");
            }
            case 12: {
                return Bundle.getMessage("SpeedCol");
            }
        }
        return super.getColumnName(col);
    }

    void deleteBean(OBlock bean) {
        StringBuilder sb = new StringBuilder(Bundle.getMessage("DeletePrompt", bean.getSystemName()));
        PropertyChangeListener[] propertyChangeListenerArray = bean.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            if (!(listener instanceof OBlockTableModel || listener instanceof BlockPathTableModel || listener instanceof PathTurnoutTableModel || listener instanceof PickListModel || listener instanceof OBlockManager)) {
                sb.append("\n");
                sb.append(Bundle.getMessage("InUseBy", bean.getDisplayName(), listener.getClass().getName()));
            }
            ++n2;
        }
        int val = this._parent.verifyWarning(sb.toString());
        if (val == 2) {
            return;
        }
        bean.dispose();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 15: {
                return CurveComboBoxPanel.class;
            }
            case 12: {
                return SpeedComboBoxPanel.class;
            }
            case 5: 
            case 6: {
                return JButton.class;
            }
            case 8: {
                return JToggleButton.class;
            }
            case 10: {
                return JRadioButton.class;
            }
            case 11: {
                return JCheckBox.class;
            }
        }
        return String.class;
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return new JTextField((int)15).getPreferredSize().width;
            }
            case 3: {
                return new JTextField((String)OBlockTableModel.ZEROS).getPreferredSize().width;
            }
            case 2: 
            case 4: 
            case 9: 
            case 13: 
            case 14: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                return new JTextField((int)10).getPreferredSize().width;
            }
            case 7: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 8: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 5: {
                return new JButton((String)Bundle.getMessage((String)"ButtonEditPath")).getPreferredSize().width + 4;
            }
            case 6: {
                return new JButton((String)Bundle.getMessage((String)"ButtonDelete")).getPreferredSize().width + 4;
            }
        }
        return 5;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return super.getRowCount() == row;
            }
            case 3: 
            case 13: 
            case 16: {
                return false;
            }
        }
        return true;
    }

    static JComboBox<String> getCurveEditorBox(int row) {
        BlockCurvatureJComboBox j = new BlockCurvatureJComboBox();
        j.setJTableCellClientProperties();
        return j;
    }

    public void configCurveColumn(JTable table) {
        table.setDefaultEditor(CurveComboBoxPanel.class, new CurveComboBoxPanel());
        table.setDefaultRenderer(CurveComboBoxPanel.class, new CurveComboBoxPanel());
    }

    static JComboBox<String> getSpeedEditorBox(int row) {
        JComboBox<String> editCombo = new JComboBox<String>(InstanceManager.getDefault(SignalSpeedMap.class).getValidSpeedNames());
        DefaultComboBoxModel model = (DefaultComboBoxModel)editCombo.getModel();
        model.addElement("");
        editCombo.putClientProperty("JComponent.sizeVariant", "small");
        editCombo.putClientProperty("JComboBox.buttonType", "square");
        return editCombo;
    }

    public void configSpeedColumn(JTable table) {
        table.setDefaultEditor(SpeedComboBoxPanel.class, new SpeedComboBoxPanel());
        table.setDefaultRenderer(SpeedComboBoxPanel.class, new SpeedComboBoxPanel());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String property = e.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug("PropertyChange = {}", (Object)property);
        }
        if (property.equals("length") || property.equals("UserName") || property.equals("state")) {
            this._parent.updateOBlockTablesMenu();
            this.fireTableDataChanged();
        }
        this._parent.getPortalXRefTableModel().propertyChange(e);
        this._parent.getSignalTableModel().propertyChange(e);
        this._parent.getPortalTableModel().propertyChange(e);
    }

    protected String getClassName() {
        return OBlockTableAction.class.getName();
    }

    public static class CurveComboBoxPanel
    extends RowComboBoxPanel {
        @Override
        protected final void eventEditorMousePressed() {
            this.editor.add(this.getEditorBox(this.table.convertRowIndexToModel(this.currentRow)));
            this.editor.revalidate();
            SwingUtilities.invokeLater(this.comboBoxFocusRequester);
            log.debug("eventEditorMousePressed in row: {})", (Object)this.currentRow);
        }

        @Override
        protected JComboBox<String> getEditorBox(int row) {
            return OBlockTableModel.getCurveEditorBox(row);
        }
    }

    public static class SpeedComboBoxPanel
    extends RowComboBoxPanel {
        @Override
        protected final void eventEditorMousePressed() {
            this.editor.add(this.getEditorBox(this.table.convertRowIndexToModel(this.currentRow)));
            this.editor.revalidate();
            SwingUtilities.invokeLater(this.comboBoxFocusRequester);
            log.debug("eventEditorMousePressed in row: {})", (Object)this.currentRow);
        }

        @Override
        protected JComboBox<String> getEditorBox(int row) {
            return OBlockTableModel.getSpeedEditorBox(row);
        }
    }
}

