/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.EventObject;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnDJTable
extends JTable
implements DropTargetListener,
DragGestureListener,
DragSourceListener,
Transferable {
    public static final String TableCellFlavorMime = "application/x-java-jvm-local-objectref;class=jmri.jmrit.beantable.oblock.DnDJTable.TableCellSelection";
    public static final DataFlavor TABLECELL_FLAVOR = new DataFlavor(TableCellSelection.class, "application/x-jmri.jmrit.beantable.oblock.DnDJTable.TableCellSelection");
    private Point _dropPoint;
    private int[] _skipCols;
    private static final Logger log = LoggerFactory.getLogger(DnDJTable.class);

    DnDJTable(TableModel model, int[] skipCols) {
        super(model);
        this.setTransferHandler(new DnDHandler(this));
        this._skipCols = skipCols;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        new DropTarget(this, 1, this);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean res = super.editCellAt(row, column, e);
        Component c = this.getEditorComponent();
        if (c instanceof JTextField) {
            ((JTextField)c).selectAll();
        }
        return res;
    }

    Point getDropPoint() {
        return this._dropPoint;
    }

    private boolean dropOK(DropTargetDragEvent evt) {
        Transferable tr = evt.getTransferable();
        if (tr.isDataFlavorSupported(TABLECELL_FLAVOR) || tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this._dropPoint = evt.getLocation();
            int col = this.columnAtPoint(this._dropPoint);
            int row = this.rowAtPoint(this._dropPoint);
            int[] nArray = this._skipCols;
            int n = this._skipCols.length;
            int n2 = 0;
            while (n2 < n) {
                int skipCol = nArray[n2];
                if (skipCol == col) {
                    return false;
                }
                ++n2;
            }
            if (tr.isDataFlavorSupported(TABLECELL_FLAVOR)) {
                try {
                    TableCellSelection tcss = (TableCellSelection)tr.getTransferData(TABLECELL_FLAVOR);
                    if (row == tcss.getRow() && col == tcss.getCol() && this == tcss.getTable()) {
                        return false;
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    log.warn("DnDJTable.importData: at table {} e= ", (Object)this.getName(), (Object)ex);
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
        if (!this.dropOK(evt)) {
            evt.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
        if (!this.dropOK(evt)) {
            evt.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        try {
            Point pt = evt.getLocation();
            Transferable tr = evt.getTransferable();
            if (tr.isDataFlavorSupported(TABLECELL_FLAVOR) || tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                AbstractTableModel model = (AbstractTableModel)this.getModel();
                int col = this.columnAtPoint(pt);
                int row = this.rowAtPoint(pt);
                if (col >= 0 && row >= 0) {
                    row = this.convertRowIndexToModel(row);
                    TableCellSelection sel = (TableCellSelection)tr.getTransferData(TABLECELL_FLAVOR);
                    String data = (String)sel.getTransferData(DataFlavor.stringFlavor);
                    model.setValueAt(data, row, col);
                    model.fireTableDataChanged();
                    evt.dropComplete(true);
                    return;
                }
            } else {
                log.warn("TransferHandler.importData: supported DataFlavors not avaialable at table from {}", (Object)tr.getClass().getName());
            }
        }
        catch (IOException ioe) {
            log.warn("caught IOException", (Throwable)ioe);
        }
        catch (UnsupportedFlavorException ufe) {
            log.warn("caught UnsupportedFlavorException", (Throwable)ufe);
        }
        log.debug("DropJTree.drop REJECTED!");
        evt.rejectDrop();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{TABLECELL_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return TABLECELL_FLAVOR.equals(flavor);
    }

    @Override
    @Nonnull
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(TABLECELL_FLAVOR)) {
            int row = this.getSelectedRow();
            int col = this.getSelectedColumn();
            if (col >= 0 && row >= 0) {
                row = this.convertRowIndexToModel(row);
                return this.getValueAt(row, col);
            }
        }
        return "";
    }

    static class DnDHandler
    extends TransferHandler {
        JTable _table;

        DnDHandler(JTable table) {
            this._table = table;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                JTable table = (JTable)c;
                int col = table.getSelectedColumn();
                int row = table.getSelectedRow();
                if (col < 0 || row < 0) {
                    return null;
                }
                row = table.convertRowIndexToModel(row);
                TableCellSelection tcss = new TableCellSelection((String)table.getModel().getValueAt(row, col), row, col, this._table);
                return new TableCellTransferable(tcss);
            }
            return null;
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            boolean canDoIt = false;
            DataFlavor[] dataFlavorArray = transferFlavors;
            int n = transferFlavors.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor transferFlavor = dataFlavorArray[n2];
                if ((transferFlavor.equals(TABLECELL_FLAVOR) || transferFlavor.equals(DataFlavor.stringFlavor)) && comp instanceof JTable) {
                    canDoIt = true;
                    break;
                }
                ++n2;
            }
            return canDoIt;
        }

        @Override
        public boolean importData(JComponent comp, Transferable tr) {
            DataFlavor[] flavors = new DataFlavor[]{TABLECELL_FLAVOR, DataFlavor.stringFlavor};
            if (!this.canImport(comp, flavors)) {
                return false;
            }
            try {
                if ((tr.isDataFlavorSupported(TABLECELL_FLAVOR) || tr.isDataFlavorSupported(DataFlavor.stringFlavor)) && comp instanceof DnDJTable) {
                    DnDJTable table = (DnDJTable)comp;
                    AbstractTableModel model = (AbstractTableModel)table.getModel();
                    int col = table.getSelectedColumn();
                    int row = table.getSelectedRow();
                    if (col >= 0 && row >= 0) {
                        row = table.convertRowIndexToView(row);
                        String data = (String)tr.getTransferData(DataFlavor.stringFlavor);
                        model.setValueAt(data, row, col);
                        model.fireTableDataChanged();
                        Container parent = table;
                        while ((parent = parent.getParent()) != null && !(parent instanceof JInternalFrame)) {
                        }
                        if (parent != null) {
                            ((JInternalFrame)parent).moveToFront();
                        }
                        log.debug("DnDHandler.importData: data= {} dropped at ({}, {})", new Object[]{data, row, col});
                        return true;
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                log.warn("DnDHandler.importData: at table e= ", (Throwable)ex);
            }
            return false;
        }
    }

    static class TableCellSelection
    extends StringSelection {
        int _row;
        int _col;
        JTable _table;

        TableCellSelection(String data, int row, int col, JTable table) {
            super(data);
            this._row = row;
            this._col = col;
            this._table = table;
        }

        int getRow() {
            return this._row;
        }

        int getCol() {
            return this._col;
        }

        JTable getTable() {
            return this._table;
        }
    }

    static class TableCellTransferable
    implements Transferable {
        TableCellSelection _tcss;

        TableCellTransferable(TableCellSelection tcss) {
            this._tcss = tcss;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{TABLECELL_FLAVOR, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(TABLECELL_FLAVOR) || flavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        @Nonnull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(TABLECELL_FLAVOR)) {
                return this._tcss;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this._tcss.getTransferData(DataFlavor.stringFlavor);
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

