/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.OBlockTableModel;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.Portal;
import jmri.util.NamedBeanUserNameComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockPortalTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int BLOCK_NAME_COLUMN = 0;
    public static final int PORTAL_NAME_COLUMN = 1;
    public static final int OPPOSING_BLOCK_NAME = 2;
    public static final int NUMCOLS = 3;
    OBlockTableModel _oBlockModel;
    private static final Logger log = LoggerFactory.getLogger(BlockPortalTableModel.class);

    public BlockPortalTableModel(OBlockTableModel oBlockModel) {
        this._oBlockModel = oBlockModel;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        int count = 0;
        List<OBlock> list = this._oBlockModel.getBeanList();
        for (OBlock oBlock : list) {
            count += oBlock.getPortals().size();
        }
        return count;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("BlockName");
            }
            case 1: {
                return Bundle.getMessage("PortalName");
            }
            case 2: {
                return Bundle.getMessage("OppBlockName");
            }
        }
        log.warn("Unhandled column name: {}", (Object)col);
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        List<OBlock> list = this._oBlockModel.getBeanList();
        if (list.size() > 0) {
            Portal portal;
            OBlock oppBlock;
            int count = 0;
            int idx = 0;
            OBlock[] array = new OBlock[list.size()];
            array = list.toArray(array);
            Arrays.sort(array, new NamedBeanUserNameComparator());
            while (count <= row) {
                count += array[idx++].getPortals().size();
            }
            OBlock block = array[--idx];
            idx = row - (count - block.getPortals().size());
            if (col == 0) {
                if (idx == 0) {
                    return block.getDisplayName();
                }
                return "";
            }
            if (col == 1) {
                return block.getPortals().get(idx).getName();
            }
            if (col == 2 && (oppBlock = (portal = block.getPortals().get(idx)).getOpposingBlock(block)) != null) {
                return oppBlock.getDisplayName();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    public int getPreferredWidth(int col) {
        return new JTextField((int)20).getPreferredSize().width;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (property.equals("length") || property.equals("UserName") || property.equals("portalCount")) {
            this.fireTableDataChanged();
        }
    }
}

