/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.TableFrames;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import jmri.util.IntlUtilities;
import jmri.util.gui.GuiLafPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockPathTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int FROM_PORTAL_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int TO_PORTAL_COLUMN = 2;
    public static final int LENGTHCOL = 3;
    public static final int UNITSCOL = 4;
    public static final int EDIT_COL = 5;
    public static final int DELETE_COL = 6;
    public static final int NUMCOLS = 7;
    private final String[] tempRow = new String[7];
    private OBlock _block;
    private TableFrames _parent;
    private final boolean _tabbed;
    private ArrayList<Boolean> _units;
    private float _tempLen;
    DecimalFormat twoDigit = new DecimalFormat("0.00");
    private static final Logger log = LoggerFactory.getLogger(BlockPathTableModel.class);

    public BlockPathTableModel() {
        this._tabbed = InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed();
    }

    public BlockPathTableModel(@Nonnull OBlock block, @Nonnull TableFrames parent) {
        this._block = block;
        this._parent = parent;
        this._tabbed = InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed();
        this.initTempRow();
        this._block.addPropertyChangeListener(this);
    }

    public void removeListener() {
        if (this._block == null) {
            return;
        }
        try {
            this._block.removePropertyChangeListener(this);
        }
        catch (NullPointerException nullPointerException) {}
    }

    protected OBlock getBlock() {
        return this._block;
    }

    void initTempRow() {
        int i;
        if (!this._tabbed) {
            i = 0;
            while (i < 7) {
                this.tempRow[i] = null;
                ++i;
            }
            this.tempRow[3] = this.twoDigit.format(0.0);
            this.tempRow[4] = this._block.isMetric() ? Bundle.getMessage("cm") : Bundle.getMessage("in");
            this.tempRow[6] = Bundle.getMessage("ButtonClear");
        }
        this._units = new ArrayList();
        i = 0;
        while (i <= this._block.getPaths().size()) {
            this._units.add(this._block.isMetric());
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return this._block.getPaths().size() + (this._tabbed ? 0 : 1);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("FromPortal");
            }
            case 1: {
                return Bundle.getMessage("PathName");
            }
            case 2: {
                return Bundle.getMessage("ToPortal");
            }
            case 3: {
                return Bundle.getMessage("BlockLengthColName");
            }
            case 4: {
                return "  ";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        OPath path = null;
        if (rowIndex < this._block.getPaths().size()) {
            path = (OPath)this._block.getPaths().get(rowIndex);
        }
        switch (columnIndex) {
            case 0: {
                if (path != null) {
                    Portal portal = path.getFromPortal();
                    if (portal == null) {
                        return "";
                    }
                    return portal.getName();
                }
                return this.tempRow[columnIndex];
            }
            case 1: {
                if (path != null) {
                    return path.getName();
                }
                return this.tempRow[columnIndex];
            }
            case 2: {
                if (path != null) {
                    Portal portal = path.getToPortal();
                    if (portal == null) {
                        return "";
                    }
                    return portal.getName();
                }
                return this.tempRow[columnIndex];
            }
            case 3: {
                if (path != null) {
                    if (this._units.get(rowIndex).booleanValue()) {
                        return this.twoDigit.format(path.getLengthCm());
                    }
                    return this.twoDigit.format(path.getLengthIn());
                }
                if (this._units.get(rowIndex).booleanValue()) {
                    return this.twoDigit.format(this._tempLen / 10.0f);
                }
                return this.twoDigit.format(this._tempLen / 25.4f);
            }
            case 4: {
                return this._units.get(rowIndex);
            }
            case 5: {
                if (path != null) {
                    if (this._tabbed) {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    return Bundle.getMessage("ButtonEditTO");
                }
                return "";
            }
            case 6: {
                if (path != null) {
                    return Bundle.getMessage("ButtonDelete");
                }
                return Bundle.getMessage("ButtonClear");
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String msg = null;
        if (this._block.getPaths().size() == row) {
            switch (col) {
                case 1: {
                    String strValue = (String)value;
                    if (this._block.getPathByName(strValue) != null) {
                        msg = Bundle.getMessage("DuplPathName", strValue);
                        this.tempRow[col] = strValue;
                        break;
                    }
                    Portal fromPortal = this._block.getPortalByName(this.tempRow[0]);
                    Portal toPortal = this._block.getPortalByName(this.tempRow[2]);
                    if (fromPortal != null || toPortal != null) {
                        OPath path = new OPath(strValue, this._block, fromPortal, toPortal, null);
                        float len = 0.0f;
                        try {
                            len = IntlUtilities.floatValue(this.tempRow[3]);
                        }
                        catch (ParseException parseException) {
                            msg = Bundle.getMessage("BadNumber", this.tempRow[3]);
                        }
                        if (this.tempRow[4].equals(Bundle.getMessage("cm"))) {
                            path.setLength(len * 10.0f);
                        } else {
                            path.setLength(len * 25.4f);
                        }
                        if (!this._block.addPath(path)) {
                            msg = Bundle.getMessage("AddPathFailed", strValue);
                            this.tempRow[1] = strValue;
                            break;
                        }
                        this.initTempRow();
                        this._parent.updateOBlockTablesMenu();
                        this.fireTableDataChanged();
                        break;
                    }
                    this.tempRow[1] = strValue;
                    break;
                }
                case 3: {
                    try {
                        this._tempLen = IntlUtilities.floatValue(value.toString());
                        if (this.tempRow[4].equals(Bundle.getMessage("cm"))) {
                            this._tempLen *= 10.0f;
                            break;
                        }
                        this._tempLen *= 25.4f;
                    }
                    catch (ParseException parseException) {
                        msg = Bundle.getMessage("BadNumber", this.tempRow[3]);
                    }
                    break;
                }
                case 4: {
                    this._units.set(row, (Boolean)value);
                    this.fireTableRowsUpdated(row, row);
                    return;
                }
                case 6: {
                    this.initTempRow();
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
            }
            this.tempRow[col] = (String)value;
            if (msg != null) {
                JOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 2);
            }
            return;
        }
        OPath path = (OPath)this._block.getPaths().get(row);
        switch (col) {
            case 0: {
                String strValue = (String)value;
                if (strValue != null) {
                    PortalManager portalMgr = InstanceManager.getDefault(PortalManager.class);
                    Portal portal = this._block.getPortalByName(strValue);
                    if (portal == null || portalMgr.getPortal(strValue) == null) {
                        int val = this._parent.verifyWarning(Bundle.getMessage("BlockPortalConflict", value, this._block.getDisplayName()));
                        if (val == 2) break;
                        portal = portalMgr.providePortal(strValue);
                        if (portal == null) {
                            msg = Bundle.getMessage("NoSuchPortalName", strValue);
                            break;
                        }
                        if (!portal.setFromBlock(this._block, false) && (val = this._parent.verifyWarning(Bundle.getMessage("BlockPathsConflict", value, portal.getFromBlockName()))) == 2) break;
                        portal.setFromBlock(this._block, true);
                        this._parent.getPortalTableModel().fireTableDataChanged();
                    }
                    path.setFromPortal(portal);
                    if (!portal.addPath(path)) {
                        msg = Bundle.getMessage("AddPathFailed", strValue);
                    }
                } else {
                    path.setFromPortal(null);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 1: {
                String strValue = (String)value;
                if (strValue == null) break;
                if (this._block.getPathByName(strValue) != null) {
                    msg = Bundle.getMessage("DuplPathName", strValue);
                }
                path.setName(strValue);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 2: {
                String strValue = (String)value;
                if (strValue != null) {
                    PortalManager portalMgr = InstanceManager.getDefault(PortalManager.class);
                    Portal portal = this._block.getPortalByName(strValue);
                    if (portal == null || portalMgr.getPortal(strValue) == null) {
                        int val = this._parent.verifyWarning(Bundle.getMessage("BlockPortalConflict", value, this._block.getDisplayName()));
                        if (val == 2) break;
                        portal = portalMgr.providePortal(strValue);
                        if (portal == null) {
                            msg = Bundle.getMessage("NoSuchPortalName", strValue);
                            break;
                        }
                        if (!portal.setToBlock(this._block, false) && (val = this._parent.verifyWarning(Bundle.getMessage("BlockPathsConflict", value, portal.getToBlockName()))) == 2) break;
                        portal.setToBlock(this._block, true);
                        this._parent.getPortalTableModel().fireTableDataChanged();
                    }
                    path.setToPortal(portal);
                    if (!portal.addPath(path)) {
                        msg = Bundle.getMessage("AddPathFailed", strValue);
                    }
                } else {
                    path.setToPortal(null);
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 3: {
                try {
                    float len = IntlUtilities.floatValue(value.toString());
                    if (this._units.get(row).booleanValue()) {
                        path.setLength(len * 10.0f);
                    } else {
                        path.setLength(len * 25.4f);
                    }
                    this.fireTableRowsUpdated(row, row);
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("BadNumber", value), Bundle.getMessage("ErrorTitle"), 2);
                }
                return;
            }
            case 4: {
                this._units.set(row, (Boolean)value);
                this.fireTableRowsUpdated(row, row);
                return;
            }
            case 5: {
                if (this._tabbed && !this._parent.isPathEdit()) {
                    this._parent.openPathEditor(this._block.getSystemName(), path.getName(), this);
                    break;
                }
                this._parent.openPathTurnoutFrame(this._parent.makePathTurnoutName(this._block.getSystemName(), path.getName()));
                break;
            }
            case 6: {
                if (!this.deletePath(path)) break;
                this._units.remove(row);
                this.fireTableDataChanged();
                break;
            }
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 2);
        }
    }

    boolean deletePath(OPath path) {
        int val = this._parent.verifyWarning(Bundle.getMessage("DeletePathConfirm", path.getName()));
        if (val == 2) {
            return false;
        }
        return this._block.removeOPath(path);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 5: 
            case 6: {
                return JButton.class;
            }
            case 4: {
                return JToggleButton.class;
            }
        }
        return String.class;
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: {
                return new JTextField((int)25).getPreferredSize().width;
            }
            case 3: {
                return new JTextField((int)10).getPreferredSize().width;
            }
            case 4: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 5: {
                return new JButton((String)"TURNOUT").getPreferredSize().width;
            }
            case 6: {
                return new JButton((String)"DELETE").getPreferredSize().width;
            }
        }
        return 5;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this._block.equals(e.getSource())) {
            String property = e.getPropertyName();
            if (log.isDebugEnabled()) {
                log.debug("propertyChange \"{}\".  source= {}", (Object)property, e.getSource());
            }
            if (property.equals("portalCount") || property.equals("pathCount") || property.equals("pathName")) {
                this.fireTableDataChanged();
            } else if (property.equals("deleted")) {
                this._parent.disposeBlockPathFrame(this._block);
            }
        }
    }
}

