/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.light;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.Light;
import jmri.VariableLight;
import jmri.jmrit.beantable.light.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightIntensityPane
extends JPanel {
    private JPanel minPan;
    private JPanel maxPan;
    private JPanel transitionPan;
    private JSpinner minIntensity;
    private JSpinner maxIntensity;
    private JSpinner transitionTime;
    private final JLabel status1 = new JLabel();
    private static final Logger log = LoggerFactory.getLogger(LightIntensityPane.class);

    public LightIntensityPane(boolean vertical) {
        this.init(vertical);
    }

    private void init(boolean vertical) {
        this.setLayout(new BoxLayout(this, 1));
        this.minIntensity = new JSpinner();
        this.maxIntensity = new JSpinner();
        this.transitionTime = new JSpinner();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, vertical ? 1 : 0));
        this.minPan = new JPanel();
        this.minPan.add(new JLabel(" "));
        this.minPan.add(new JLabel(Bundle.getMessage("LightMinIntensity")));
        this.minIntensity.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), Double.valueOf(0.99), (Number)0.01));
        this.minIntensity.setEditor(new JSpinner.NumberEditor(this.minIntensity, "##0 %"));
        this.minIntensity.setToolTipText(Bundle.getMessage("LightMinIntensityHint"));
        this.minIntensity.setValue(0.0);
        this.minPan.add(this.minIntensity);
        this.minPan.add(new JLabel("   "));
        mainPanel.add(this.minPan);
        this.maxPan = new JPanel();
        this.maxPan.add(new JLabel(Bundle.getMessage("LightMaxIntensity")));
        this.maxIntensity.setModel(new SpinnerNumberModel((Number)1.0, Double.valueOf(0.01), Double.valueOf(1.0), (Number)0.01));
        this.maxIntensity.setEditor(new JSpinner.NumberEditor(this.maxIntensity, "##0 %"));
        this.maxIntensity.setToolTipText(Bundle.getMessage("LightMaxIntensityHint"));
        this.maxIntensity.setValue(1.0);
        this.maxPan.add(this.maxIntensity);
        this.maxPan.add(new JLabel("   "));
        mainPanel.add(this.maxPan);
        this.transitionPan = new JPanel();
        this.transitionPan.add(new JLabel(Bundle.getMessage("LightTransitionTime")));
        this.transitionTime.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), Double.valueOf(1000000.0), (Number)0.01));
        this.transitionTime.setEditor(new JSpinner.NumberEditor(this.transitionTime, "###0.00"));
        this.transitionTime.setPreferredSize(new JTextField(8).getPreferredSize());
        this.transitionTime.setToolTipText(Bundle.getMessage("LightTransitionTimeHint"));
        this.transitionTime.setValue(0.0);
        this.transitionPan.add(this.transitionTime);
        this.transitionPan.add(new JLabel(" "));
        mainPanel.add(this.transitionPan);
        this.add(mainPanel);
        JPanel statusPanel = new JPanel();
        statusPanel.add(this.status1);
        this.add(statusPanel);
    }

    public void setToLight(Light light) {
        if (light instanceof VariableLight) {
            this.minIntensity.setValue(((VariableLight)light).getMinIntensity());
            this.maxIntensity.setValue(((VariableLight)light).getMaxIntensity());
            if (((VariableLight)light).isTransitionAvailable()) {
                this.transitionTime.setValue(((VariableLight)light).getTransitionTime());
            }
            this.setupVariableDisplay(true, ((VariableLight)light).isTransitionAvailable());
        } else {
            this.setupVariableDisplay(false, false);
        }
    }

    public void setLightFromPane(VariableLight light) {
        if ((Double)this.minIntensity.getValue() >= (Double)this.maxIntensity.getValue()) {
            log.error("minInt value entered: {}", this.minIntensity.getValue());
            this.status1.setText(Bundle.getMessage("LightWarn9"));
            this.status1.setVisible(true);
        } else {
            light.setMinIntensity((Double)this.minIntensity.getValue());
            light.setMaxIntensity((Double)this.maxIntensity.getValue());
        }
        if (light.isTransitionAvailable()) {
            light.setTransitionTime((Double)this.transitionTime.getValue());
        }
    }

    private void setupVariableDisplay(boolean showIntensity, boolean showTransition) {
        this.minPan.setVisible(showIntensity);
        this.maxPan.setVisible(showIntensity);
        this.transitionPan.setVisible(showTransition);
        this.setVisible(showIntensity || showTransition);
    }
}

