/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.light;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightControl;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.Turnout;
import jmri.implementation.DefaultLightControl;
import jmri.jmrit.beantable.light.Bundle;
import jmri.jmrit.beantable.light.LightControlPane;
import jmri.jmrit.beantable.light.LightControlTableModel;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import jmri.util.swing.ComboBoxToolTipRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEditSingleLightControlFrame
extends JmriJFrame {
    final LightControl lc;
    private JComboBox<String> typeBox;
    private final JLabel status1 = new JLabel();
    private final NamedBeanComboBox<Sensor> sensor1Box = new NamedBeanComboBox<Object>(InstanceManager.sensorManagerInstance(), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final NamedBeanComboBox<Sensor> sensor2Box = new NamedBeanComboBox<Object>(InstanceManager.sensorManagerInstance(), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final JLabel f1Label = new JLabel(Bundle.getMessage("LightSensor", Bundle.getMessage("MakeLabel", "")));
    private final JLabel f1aLabel = new JLabel(Bundle.getMessage("LightSensor", Bundle.getMessage("MakeLabel", " 2")));
    private final SpinnerNumberModel fastHourSpinnerModel1 = new SpinnerNumberModel(0, 0, 23, 1);
    private final JSpinner fastHourSpinner1 = new JSpinner(this.fastHourSpinnerModel1);
    private final SpinnerNumberModel fastMinuteSpinnerModel1 = new SpinnerNumberModel(0, 0, 59, 1);
    private final JSpinner fastMinuteSpinner1 = new JSpinner(this.fastMinuteSpinnerModel1);
    private final JLabel clockSep1 = new JLabel(" : ");
    private final JLabel clockSep2 = new JLabel(" : ");
    private final SpinnerNumberModel fastHourSpinnerModel2 = new SpinnerNumberModel(0, 0, 23, 1);
    private final JSpinner fastHourSpinner2 = new JSpinner(this.fastHourSpinnerModel2);
    private final SpinnerNumberModel fastMinuteSpinnerModel2 = new SpinnerNumberModel(0, 0, 59, 1);
    private final JSpinner fastMinuteSpinner2 = new JSpinner(this.fastMinuteSpinnerModel2);
    private final NamedBeanComboBox<Turnout> turnoutBox = new NamedBeanComboBox<Object>(InstanceManager.turnoutManagerInstance(), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final NamedBeanComboBox<Sensor> sensorOnBox = new NamedBeanComboBox<Object>(InstanceManager.sensorManagerInstance(), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private JComboBox<String> stateBox;
    private ComboBoxToolTipRenderer stateBoxToolTipRenderer;
    private final SpinnerNumberModel timedOnSpinnerModel = new SpinnerNumberModel(0, 0, 1000000, 1);
    private final JSpinner timedOnSpinner = new JSpinner(this.timedOnSpinnerModel);
    private JPanel sensorTwoPanel;
    private final JLabel f2Label = new JLabel(Bundle.getMessage("LightSensorSense"));
    private final int sensorActiveIndex = 0;
    private final int sensorInactiveIndex = 1;
    private final int turnoutClosedIndex = 0;
    private final int turnoutThrownIndex = 1;
    private JButton createControl;
    private JButton updateControl;
    private JButton cancelControl;
    final LightControlPane lcp;
    private static final Logger log = LoggerFactory.getLogger(AddEditSingleLightControlFrame.class);

    public AddEditSingleLightControlFrame(@Nonnull LightControlPane pane, LightControl ctrl) {
        super(Bundle.getMessage("TitleAddLightControl"), false, true);
        this.lc = ctrl;
        this.lcp = pane;
        this.init();
    }

    private void init() {
        this.addHelpMenu("package.jmri.jmrit.beantable.LightAddEdit", true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel mainContentPanel = new JPanel();
        mainContentPanel.setLayout(new BoxLayout(mainContentPanel, 1));
        JPanel controlTypePanel = new JPanel();
        controlTypePanel.setLayout(new FlowLayout());
        controlTypePanel.add(new JLabel(Bundle.getMessage("LightControlType")));
        this.typeBox = new JComboBox<String>(LightControlTableModel.controlTypes);
        ComboBoxToolTipRenderer typeBoxToolTipRenderer = new ComboBoxToolTipRenderer();
        typeBoxToolTipRenderer.setTooltips(LightControlTableModel.getControlTypeTips());
        this.typeBox.setRenderer(typeBoxToolTipRenderer);
        this.typeBox.addActionListener(e -> this.setUpControlType(this.typeBox.getSelectedIndex()));
        this.typeBox.setToolTipText(Bundle.getMessage("LightControlTypeHint"));
        controlTypePanel.add(this.typeBox);
        JPanel mainOptionsPanel = new JPanel();
        mainOptionsPanel.setLayout(new FlowLayout());
        mainOptionsPanel.add(this.f1Label);
        mainOptionsPanel.add(this.sensor1Box);
        JSpinner.NumberEditor ne1b = new JSpinner.NumberEditor(this.fastHourSpinner1, "00");
        this.fastHourSpinner1.setEditor(ne1b);
        mainOptionsPanel.add(this.fastHourSpinner1);
        mainOptionsPanel.add(this.clockSep1);
        JSpinner.NumberEditor ne1b1 = new JSpinner.NumberEditor(this.fastMinuteSpinner1, "00");
        this.fastMinuteSpinner1.setEditor(ne1b1);
        mainOptionsPanel.add(this.fastMinuteSpinner1);
        mainOptionsPanel.add(this.turnoutBox);
        mainOptionsPanel.add(this.sensorOnBox);
        this.sensor1Box.setAllowNull(true);
        this.sensor1Box.setToolTipText(Bundle.getMessage("LightSensorHint"));
        this.sensor2Box.setAllowNull(true);
        this.sensor2Box.setToolTipText(Bundle.getMessage("LightTwoSensorHint"));
        this.fastHourSpinner1.setValue(0);
        this.fastHourSpinner1.setVisible(false);
        this.fastMinuteSpinner1.setValue(0);
        this.fastMinuteSpinner1.setVisible(false);
        this.sensorOnBox.setAllowNull(true);
        this.sensorOnBox.setVisible(false);
        this.clockSep1.setVisible(false);
        this.turnoutBox.setAllowNull(true);
        this.turnoutBox.setVisible(false);
        this.sensorTwoPanel = new JPanel();
        this.sensorTwoPanel.setLayout(new FlowLayout());
        this.sensorTwoPanel.add(this.f1aLabel);
        this.sensorTwoPanel.add(this.sensor2Box);
        JPanel panel33 = new JPanel();
        panel33.setLayout(new FlowLayout());
        panel33.add(this.f2Label);
        this.stateBox = new JComboBox<String>(new String[]{Bundle.getMessage("SensorStateActive"), Bundle.getMessage("SensorStateInactive")});
        this.stateBox.setToolTipText(Bundle.getMessage("LightSensorSenseHint"));
        this.stateBoxToolTipRenderer = new ComboBoxToolTipRenderer();
        this.stateBox.setRenderer(this.stateBoxToolTipRenderer);
        panel33.add(this.stateBox);
        JSpinner.NumberEditor ne2a = new JSpinner.NumberEditor(this.fastHourSpinner2, "00");
        this.fastHourSpinner2.setEditor(ne2a);
        panel33.add(this.fastHourSpinner2);
        panel33.add(this.clockSep2);
        JSpinner.NumberEditor ne2a1 = new JSpinner.NumberEditor(this.fastMinuteSpinner2, "00");
        this.fastMinuteSpinner2.setEditor(ne2a1);
        panel33.add(this.fastMinuteSpinner2);
        panel33.add(this.timedOnSpinner);
        this.fastHourSpinner2.setValue(0);
        this.fastHourSpinner2.setVisible(false);
        this.fastMinuteSpinner2.setValue(0);
        this.fastMinuteSpinner2.setVisible(false);
        this.timedOnSpinner.setValue(5000);
        this.timedOnSpinner.setVisible(false);
        this.clockSep2.setVisible(false);
        mainContentPanel.add(controlTypePanel);
        mainContentPanel.add(mainOptionsPanel);
        mainContentPanel.add(this.sensorTwoPanel);
        mainContentPanel.add(panel33);
        mainContentPanel.setBorder(BorderFactory.createEtchedBorder());
        contentPane.add(mainContentPanel);
        contentPane.add(this.getButtonPanel());
        JPanel statusPanel = new JPanel();
        statusPanel.add(this.status1);
        contentPane.add(statusPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddEditSingleLightControlFrame.this.cancelControlPressed(null);
            }
        });
        this.typeBox.setSelectedIndex(this.lcp.getLastSelectedControlIndex());
        if (this.lc != null) {
            this.setTitle(Bundle.getMessage("TitleEditLightControl"));
            this.setFrameToControl(this.lc);
        }
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(4));
        this.cancelControl = new JButton(Bundle.getMessage("ButtonCancel"));
        buttonPanel.add(this.cancelControl);
        this.cancelControl.addActionListener(this::cancelControlPressed);
        this.cancelControl.setToolTipText(Bundle.getMessage("LightCancelButtonHint"));
        this.createControl = new JButton(Bundle.getMessage("ButtonCreate"));
        buttonPanel.add(this.createControl);
        this.createControl.addActionListener(this::createControlPressed);
        this.createControl.setToolTipText(Bundle.getMessage("LightCreateControlButtonHint"));
        this.updateControl = new JButton(Bundle.getMessage("ButtonUpdate"));
        buttonPanel.add(this.updateControl);
        this.updateControl.addActionListener(this::updateControlPressed);
        this.updateControl.setToolTipText(Bundle.getMessage("LightUpdateControlButtonHint"));
        this.cancelControl.setVisible(true);
        this.updateControl.setVisible(this.lc != null);
        this.createControl.setVisible(this.lc == null);
        return buttonPanel;
    }

    private void setUpControlType(int ctype) {
        this.clockSep1.setVisible(false);
        this.clockSep2.setVisible(false);
        this.fastHourSpinner1.setVisible(false);
        this.fastHourSpinner2.setVisible(false);
        this.fastMinuteSpinner1.setVisible(false);
        this.fastMinuteSpinner2.setVisible(false);
        this.f1aLabel.setVisible(false);
        this.sensorOnBox.setVisible(false);
        this.sensor1Box.setVisible(false);
        this.sensor2Box.setVisible(false);
        this.stateBox.setVisible(false);
        this.timedOnSpinner.setVisible(false);
        this.turnoutBox.setVisible(false);
        this.sensorTwoPanel.setVisible(false);
        this.typeBox.setSelectedIndex(ctype);
        this.createControl.setEnabled(true);
        this.updateControl.setEnabled(true);
        this.lcp.setLastSelectedControlIndex(ctype);
        switch (ctype) {
            case 1: {
                this.f1Label.setText(Bundle.getMessage("LightSensor", Bundle.getMessage("MakeLabel", "")));
                this.sensor1Box.setToolTipText(Bundle.getMessage("LightSensorHint"));
                this.f2Label.setText(Bundle.getMessage("LightSensorSense"));
                this.stateBox.removeAllItems();
                this.stateBox.addItem(Bundle.getMessage("SensorStateActive"));
                this.stateBox.addItem(Bundle.getMessage("SensorStateInactive"));
                ArrayList<String> stateTooltips = new ArrayList<String>();
                stateTooltips.add(Bundle.getMessage("LightSensorSenseActivTip"));
                stateTooltips.add(Bundle.getMessage("LightSensorSenseInactivTip"));
                this.stateBoxToolTipRenderer.setTooltips(stateTooltips);
                this.stateBox.setToolTipText(Bundle.getMessage("LightSensorSenseHint"));
                this.f2Label.setVisible(true);
                this.sensor1Box.setVisible(true);
                this.stateBox.setVisible(true);
                break;
            }
            case 2: {
                this.f1Label.setText(Bundle.getMessage("LightScheduleOn"));
                this.fastHourSpinner1.setToolTipText(Bundle.getMessage("LightScheduleHint"));
                this.fastMinuteSpinner1.setToolTipText(Bundle.getMessage("LightScheduleHintMinutes"));
                this.f2Label.setText(Bundle.getMessage("LightScheduleOff"));
                this.fastHourSpinner2.setToolTipText(Bundle.getMessage("LightScheduleHint"));
                this.fastMinuteSpinner2.setToolTipText(Bundle.getMessage("LightScheduleHintMinutes"));
                this.clockSep1.setVisible(true);
                this.clockSep2.setVisible(true);
                this.fastHourSpinner1.setVisible(true);
                this.fastHourSpinner2.setVisible(true);
                this.fastMinuteSpinner1.setVisible(true);
                this.fastMinuteSpinner2.setVisible(true);
                this.f2Label.setVisible(true);
                break;
            }
            case 3: {
                this.f1Label.setText(Bundle.getMessage("LightTurnout"));
                this.turnoutBox.setToolTipText(Bundle.getMessage("LightTurnoutHint"));
                this.f2Label.setText(Bundle.getMessage("LightTurnoutSense"));
                this.stateBox.removeAllItems();
                this.stateBox.addItem(InstanceManager.turnoutManagerInstance().getClosedText());
                this.stateBox.addItem(InstanceManager.turnoutManagerInstance().getThrownText());
                this.stateBox.setToolTipText(Bundle.getMessage("LightTurnoutSenseHint"));
                ArrayList<String> stateTooltips = new ArrayList<String>();
                stateTooltips.add(Bundle.getMessage("LightConToClosedOrThrownTip", InstanceManager.turnoutManagerInstance().getClosedText(), InstanceManager.turnoutManagerInstance().getThrownText()));
                stateTooltips.add(Bundle.getMessage("LightConToClosedOrThrownTip", InstanceManager.turnoutManagerInstance().getThrownText(), InstanceManager.turnoutManagerInstance().getClosedText()));
                this.stateBoxToolTipRenderer.setTooltips(stateTooltips);
                this.f2Label.setVisible(true);
                this.turnoutBox.setVisible(true);
                this.stateBox.setVisible(true);
                break;
            }
            case 4: {
                this.f1Label.setText(Bundle.getMessage("LightTimedSensor"));
                this.sensorOnBox.setToolTipText(Bundle.getMessage("LightTimedSensorHint"));
                this.f2Label.setText(Bundle.getMessage("LightTimedDurationOn"));
                this.timedOnSpinner.setToolTipText(Bundle.getMessage("LightTimedDurationOnHint"));
                this.f2Label.setVisible(true);
                this.sensorOnBox.setVisible(true);
                this.timedOnSpinner.setVisible(true);
                break;
            }
            case 5: {
                this.sensorTwoPanel.setVisible(true);
                this.f1Label.setText(Bundle.getMessage("LightSensor", " " + Bundle.getMessage("MakeLabel", "1")));
                this.f1aLabel.setVisible(true);
                this.sensor1Box.setToolTipText(Bundle.getMessage("LightSensorHint"));
                this.f2Label.setText(Bundle.getMessage("LightSensorSense"));
                this.stateBox.removeAllItems();
                this.stateBox.addItem(Bundle.getMessage("SensorStateActive"));
                this.stateBox.addItem(Bundle.getMessage("SensorStateInactive"));
                this.stateBox.setToolTipText(Bundle.getMessage("LightSensorSenseHint"));
                ArrayList<String> stateTooltips = new ArrayList<String>();
                stateTooltips.add(Bundle.getMessage("Light2SensorSenseActivTip"));
                stateTooltips.add(Bundle.getMessage("Light2SensorSenseInactivTip"));
                this.stateBoxToolTipRenderer.setTooltips(stateTooltips);
                this.f2Label.setVisible(true);
                this.sensor1Box.setVisible(true);
                this.sensor2Box.setVisible(true);
                this.sensor1Box.setToolTipText(Bundle.getMessage("LightTwoSensorHint"));
                this.stateBox.setVisible(true);
                break;
            }
            case 0: {
                this.f1Label.setText(Bundle.getMessage("LightNoneSelected"));
                this.f2Label.setVisible(false);
                this.createControl.setEnabled(false);
                this.updateControl.setEnabled(false);
                break;
            }
            default: {
                log.error("Unexpected control type in controlTypeChanged: {}", (Object)ctype);
            }
        }
        this.pack();
        this.setVisible(true);
    }

    protected void cancelControlPressed(ActionEvent e) {
        this.lcp.closeEditControlWindow();
    }

    private void commitEdits() {
        try {
            this.fastHourSpinner1.commitEdit();
            this.fastHourSpinner2.commitEdit();
            this.fastMinuteSpinner1.commitEdit();
            this.fastMinuteSpinner2.commitEdit();
            this.timedOnSpinner.commitEdit();
        }
        catch (ParseException parseException) {}
    }

    protected void updateControlPressed(ActionEvent e) {
        this.commitEdits();
        DefaultLightControl newLc = new DefaultLightControl();
        ArrayList<LightControl> withoutExistingLc = new ArrayList<LightControl>(this.lcp.getControlList());
        withoutExistingLc.remove(this.lc);
        if (this.setControlInformation(newLc, withoutExistingLc)) {
            this.lcp.updateControlPressed(this.lc, newLc);
            this.cancelControlPressed(e);
        } else {
            this.pack();
            this.setVisible(true);
        }
    }

    protected void createControlPressed(ActionEvent e) {
        if (Objects.equals(this.typeBox.getSelectedItem(), LightControlTableModel.noControl)) {
            return;
        }
        this.commitEdits();
        DefaultLightControl newLc = new DefaultLightControl();
        if (this.setControlInformation(newLc, this.lcp.getControlList())) {
            this.lcp.addControlToTable(newLc);
            this.cancelControlPressed(e);
        } else {
            this.pack();
            this.setVisible(true);
        }
    }

    private void notifyUser(String message, Color color) {
        this.status1.setText(message);
        this.status1.setForeground(color);
        ThreadingUtil.runOnGUIDelayed(() -> this.status1.setText(" "), 5000);
    }

    private boolean setControlInformation(LightControl g, List<LightControl> currentList) {
        if (LightControlTableModel.sensorControl.equals(this.typeBox.getSelectedItem())) {
            g.setControlType(1);
            String sensorName = this.sensor1Box.getSelectedItemDisplayName();
            if (sensorName == null) {
                g.setControlType(0);
                this.notifyUser(Bundle.getMessage("LightWarn8"), Color.red);
                return false;
            }
            int sState = Bundle.getMessage("SensorStateInactive").equals(this.stateBox.getSelectedItem()) ? 4 : 2;
            g.setControlSensorName(sensorName);
            g.setControlSensorSense(sState);
        } else if (LightControlTableModel.fastClockControl.equals(this.typeBox.getSelectedItem())) {
            g.setControlType(2);
            int onHour = (Integer)this.fastHourSpinner1.getValue();
            int onMin = (Integer)this.fastMinuteSpinner1.getValue();
            int offHour = (Integer)this.fastHourSpinner2.getValue();
            int offMin = (Integer)this.fastMinuteSpinner2.getValue();
            g.setFastClockControlSchedule(onHour, onMin, offHour, offMin);
            if (g.onOffTimesFaulty()) {
                this.notifyUser(Bundle.getMessage("LightWarn11"), Color.red);
                return false;
            }
            if (g.areFollowerTimesFaulty(currentList)) {
                this.notifyUser(Bundle.getMessage("LightWarn12"), Color.red);
                return false;
            }
        } else if (LightControlTableModel.turnoutStatusControl.equals(this.typeBox.getSelectedItem())) {
            g.setControlType(3);
            String turnoutName = this.turnoutBox.getSelectedItemSystemName();
            if (turnoutName == null) {
                g.setControlType(0);
                this.notifyUser(Bundle.getMessage("LightWarn10"), Color.red);
                return false;
            }
            String testLightaddr = StringUtil.replaceLast(turnoutName, "T", "L");
            Light testLight = InstanceManager.getDefault(LightManager.class).getBySystemName(testLightaddr);
            if (testLight != null) {
                this.notifyUser(String.valueOf(Bundle.getMessage("LightWarn3")) + " " + testLight.getDisplayName(), Color.red);
                return false;
            }
            int tState = 2;
            if (Objects.equals(this.stateBox.getSelectedItem(), InstanceManager.turnoutManagerInstance().getThrownText())) {
                tState = 4;
            }
            g.setControlTurnout(this.turnoutBox.getSelectedItemDisplayName());
            g.setControlTurnoutState(tState);
        } else if (LightControlTableModel.timedOnControl.equals(this.typeBox.getSelectedItem())) {
            g.setControlType(4);
            String triggerSensorName = this.sensorOnBox.getSelectedItemDisplayName();
            if (triggerSensorName == null) {
                g.setControlType(0);
                this.notifyUser(Bundle.getMessage("LightWarn8"), Color.red);
                return false;
            }
            g.setControlTimedOnSensorName(triggerSensorName);
            int dur = (Integer)this.timedOnSpinner.getValue();
            g.setTimedOnDuration(dur);
        } else if (LightControlTableModel.twoSensorControl.equals(this.typeBox.getSelectedItem())) {
            g.setControlType(5);
            String sensorName = this.sensor1Box.getSelectedItemDisplayName();
            String sensor2Name = this.sensor2Box.getSelectedItemDisplayName();
            if (sensorName == null || sensor2Name == null) {
                g.setControlType(0);
                this.notifyUser(Bundle.getMessage("LightWarn8"), Color.red);
                return false;
            }
            int sState = 2;
            if (Objects.equals(this.stateBox.getSelectedItem(), Bundle.getMessage("SensorStateInactive"))) {
                sState = 4;
            }
            g.setControlSensorName(sensorName);
            g.setControlSensor2Name(sensor2Name);
            g.setControlSensorSense(sState);
        } else if (LightControlTableModel.noControl.equals(this.typeBox.getSelectedItem())) {
            g.setControlType(0);
        } else {
            log.error("Unexpected control type: {}", this.typeBox.getSelectedItem());
        }
        return true;
    }

    private void setFrameToControl(LightControl lc) {
        int ctType = lc.getControlType();
        switch (ctType) {
            case 1: {
                this.setUpControlType(1);
                this.sensor1Box.setSelectedItemByName(lc.getControlSensorName());
                this.stateBox.setSelectedIndex(lc.getControlSensorSense() == 2 ? 0 : 1);
                break;
            }
            case 2: {
                this.setUpControlType(2);
                this.fastHourSpinner1.setValue(lc.getFastClockOnHour());
                this.fastMinuteSpinner1.setValue(lc.getFastClockOnMin());
                this.fastHourSpinner2.setValue(lc.getFastClockOffHour());
                this.fastMinuteSpinner2.setValue(lc.getFastClockOffMin());
                break;
            }
            case 3: {
                this.setUpControlType(3);
                this.turnoutBox.setSelectedItemByName(lc.getControlTurnoutName());
                this.stateBox.setSelectedIndex(lc.getControlTurnoutState() == 4 ? 1 : 0);
                break;
            }
            case 4: {
                this.setUpControlType(4);
                this.sensorOnBox.setSelectedItemByName(lc.getControlTimedOnSensorName());
                this.timedOnSpinner.setValue(lc.getTimedOnDuration());
                break;
            }
            case 5: {
                this.setUpControlType(5);
                this.sensor1Box.setSelectedItemByName(lc.getControlSensorName());
                this.sensor2Box.setSelectedItemByName(lc.getControlSensor2Name());
                this.stateBox.setSelectedIndex(lc.getControlSensorSense() == 2 ? 0 : 1);
                break;
            }
            case 0: {
                this.setUpControlType(0);
                break;
            }
            default: {
                log.error("Unhandled light control type: {}", (Object)ctType);
            }
        }
    }
}

