/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.block;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.Path;
import jmri.Reportable;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.UserPreferencesManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BlockTableAction;
import jmri.jmrit.beantable.beanedit.BlockEditAction;
import jmri.jmrit.beantable.block.BlockCurvatureJComboBox;
import jmri.jmrit.beantable.block.Bundle;
import jmri.util.IntlUtilities;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTableDataModel
extends BeanTableDataModel<Block> {
    public static final int EDITCOL = 5;
    public static final int DIRECTIONCOL = 6;
    public static final int LENGTHCOL = 7;
    public static final int CURVECOL = 8;
    public static final int STATECOL = 9;
    public static final int SENSORCOL = 10;
    public static final int REPORTERCOL = 11;
    public static final int CURRENTREPCOL = 12;
    public static final int PERMISCOL = 13;
    public static final int SPEEDCOL = 14;
    private final boolean _graphicState = InstanceManager.getDefault(GuiLafPreferencesManager.class).isGraphicTableState();
    private final DecimalFormat twoDigit = new DecimalFormat("0.00");
    private Vector<String> speedList = new Vector();
    private String[] sensorList;
    private String[] reporterList;
    String defaultBlockSpeedText;
    private boolean metricUi = InstanceManager.getDefault(UserPreferencesManager.class).getSimplePreferenceState(BlockTableAction.BLOCK_METRIC_PREF);
    private static final Logger log = LoggerFactory.getLogger(BlockTableDataModel.class);

    public BlockTableDataModel(Manager<Block> mgr) {
        this.setManager(mgr);
        this.defaultBlockSpeedText = String.valueOf(Bundle.getMessage("UseGlobal", "Global")) + " " + InstanceManager.getDefault(BlockManager.class).getDefaultSpeed();
        this.speedList.add(this.defaultBlockSpeedText);
        Vector<String> _speedMap = InstanceManager.getDefault(SignalSpeedMap.class).getValidSpeedNames();
        int i = 0;
        while (i < _speedMap.size()) {
            if (!this.speedList.contains(_speedMap.get(i))) {
                this.speedList.add(_speedMap.get(i));
            }
            ++i;
        }
        this.updateSensorList();
        this.updateReporterList();
    }

    @Override
    public String getValue(String name) {
        if (name == null) {
            log.warn("requested getValue(null)");
            return "(no name)";
        }
        Block b = (Block)InstanceManager.getDefault(BlockManager.class).getBySystemName(name);
        if (b == null) {
            log.debug("requested getValue(\"{}\"), Block doesn't exist", (Object)name);
            return "(no Block)";
        }
        Object m = b.getValue();
        if (m != null) {
            if (m instanceof Reportable) {
                return ((Reportable)m).toReportString();
            }
            return m.toString();
        }
        return "";
    }

    @Override
    public Manager<Block> getManager() {
        return InstanceManager.getDefault(BlockManager.class);
    }

    @Override
    public Block getBySystemName(@Nonnull String name) {
        return (Block)InstanceManager.getDefault(BlockManager.class).getBySystemName(name);
    }

    @Override
    public Block getByUserName(@Nonnull String name) {
        return (Block)InstanceManager.getDefault(BlockManager.class).getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return BlockTableAction.class.getName();
    }

    @Override
    public void clickOn(Block t) {
    }

    @Override
    public int getColumnCount() {
        return 15;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.sysNameList.size()) {
            log.error("requested getValueAt(\"{}\"), row outside of range", (Object)row);
            return "Error table size";
        }
        Block b = this.getBySystemName((String)this.sysNameList.get(row));
        if (b == null) {
            log.error("requested getValueAt(\"{}\"), Block doesn't exist", (Object)row);
            return "(no Block)";
        }
        switch (col) {
            case 6: {
                return Path.decodeDirection(b.getDirection());
            }
            case 8: {
                BlockCurvatureJComboBox box = new BlockCurvatureJComboBox(b.getCurvature());
                box.setJTableCellClientProperties();
                return box;
            }
            case 7: {
                return this.twoDigit.format(this.metricUi ? b.getLengthCm() : b.getLengthIn());
            }
            case 13: {
                return b.getPermissiveWorking();
            }
            case 14: {
                String speed = b.getBlockSpeed();
                if (!this.speedList.contains(speed)) {
                    this.speedList.add(speed);
                }
                JComboBox<String> c = new JComboBox<String>(this.speedList);
                c.setEditable(true);
                c.setSelectedItem(speed);
                JComboBoxUtil.setupComboBoxMaxRows(c);
                return c;
            }
            case 9: {
                return this.blockDescribeState(b.getState());
            }
            case 10: {
                Sensor sensor = b.getSensor();
                JComboBox<String> cs = new JComboBox<String>(this.sensorList);
                String name = "";
                if (sensor != null) {
                    name = sensor.getDisplayName();
                }
                cs.setSelectedItem(name);
                JComboBoxUtil.setupComboBoxMaxRows(cs);
                return cs;
            }
            case 11: {
                Reporter reporter = b.getReporter();
                JComboBox<String> rs = new JComboBox<String>(this.reporterList);
                String repname = "";
                if (reporter != null) {
                    repname = reporter.getDisplayName();
                }
                rs.setSelectedItem(repname);
                JComboBoxUtil.setupComboBoxMaxRows(rs);
                return rs;
            }
            case 12: {
                return b.isReportingCurrent();
            }
            case 5: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return super.getValueAt(row, col);
    }

    private String blockDescribeState(int blockState) {
        switch (blockState) {
            case 2: {
                return Bundle.getMessage("BlockOccupied");
            }
            case 4: {
                return Bundle.getMessage("BlockUnOccupied");
            }
            case 1: {
                return Bundle.getMessage("BlockUnknown");
            }
        }
        return Bundle.getMessage("BlockInconsistent");
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Block b = this.getBySystemName((String)this.sysNameList.get(row));
        switch (col) {
            case 2: {
                b.setValue(value);
                break;
            }
            case 7: {
                float len = 0.0f;
                try {
                    len = IntlUtilities.floatValue(value.toString());
                }
                catch (ParseException parseException) {
                    log.error("Error parsing length value of \"{}\"", value);
                }
                b.setLength(this.metricUi ? len * 10.0f : len * 25.4f);
                break;
            }
            case 8: {
                b.setCurvature(BlockCurvatureJComboBox.getCurvatureFromObject(value));
                break;
            }
            case 13: {
                b.setPermissiveWorking((Boolean)value);
                break;
            }
            case 14: {
                String speed = (String)((JComboBox)value).getSelectedItem();
                try {
                    b.setBlockSpeed(speed);
                }
                catch (JmriException ex) {
                    JOptionPane.showMessageDialog(null, String.valueOf(ex.getMessage()) + "\n" + speed);
                    return;
                }
                if (this.speedList.contains(speed) || speed.contains("Global")) break;
                this.speedList.add(speed);
                break;
            }
            case 11: {
                String strReporter = (String)((JComboBox)value).getSelectedItem();
                Reporter r = InstanceManager.getDefault(ReporterManager.class).getReporter(strReporter);
                b.setReporter(r);
                break;
            }
            case 10: {
                String strSensor = (String)((JComboBox)value).getSelectedItem();
                b.setSensor(strSensor);
                break;
            }
            case 12: {
                b.setReportingCurrent((Boolean)value);
                break;
            }
            case 5: {
                SwingUtilities.invokeLater(() -> this.editButton(b));
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 6: {
                return Bundle.getMessage("BlockDirection");
            }
            case 2: {
                return Bundle.getMessage("BlockValue");
            }
            case 8: {
                return Bundle.getMessage("BlockCurveColName");
            }
            case 7: {
                return Bundle.getMessage("BlockLengthColName");
            }
            case 13: {
                return Bundle.getMessage("BlockPermColName");
            }
            case 14: {
                return Bundle.getMessage("BlockSpeedColName");
            }
            case 9: {
                return Bundle.getMessage("BlockState");
            }
            case 11: {
                return Bundle.getMessage("BlockReporter");
            }
            case 10: {
                return Bundle.getMessage("BlockSensor");
            }
            case 12: {
                return Bundle.getMessage("BlockReporterCurrent");
            }
            case 5: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: 
            case 6: 
            case 7: {
                return String.class;
            }
            case 9: {
                if (this._graphicState) {
                    return JLabel.class;
                }
                return String.class;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                return JComboBox.class;
            }
            case 12: 
            case 13: {
                return Boolean.class;
            }
            case 5: {
                return JButton.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: {
                return new JTextField((int)7).getPreferredSize().width;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return new JTextField((int)8).getPreferredSize().width;
            }
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public void configValueColumn(JTable table) {
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
            case 9: {
                return false;
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public void configureTable(JTable table) {
        InstanceManager.sensorManagerInstance().addPropertyChangeListener(this);
        InstanceManager.getDefault(ReporterManager.class).addPropertyChangeListener(this);
        this.configStateColumn(table);
        super.configureTable(table);
    }

    void editButton(Block b) {
        BlockEditAction beanEdit = new BlockEditAction();
        beanEdit.setBean(b);
        beanEdit.actionPerformed(null);
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        return true;
    }

    @Override
    public JButton configureButton() {
        log.error("configureButton should not have been called");
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() instanceof SensorManager && (e.getPropertyName().equals("length") || e.getPropertyName().equals("DisplayListName"))) {
            this.updateSensorList();
        }
        if (e.getSource() instanceof ReporterManager && (e.getPropertyName().equals("length") || e.getPropertyName().equals("DisplayListName"))) {
            this.updateReporterList();
        }
        if (e.getPropertyName().equals("DefaultBlockSpeedChange")) {
            this.updateSpeedList();
        } else {
            super.propertyChange(e);
        }
    }

    public void setMetric(boolean boo) {
        this.metricUi = boo;
        this.fireTableDataChanged();
    }

    private void updateSensorList() {
        SortedSet nameSet = InstanceManager.sensorManagerInstance().getNamedBeanSet();
        Object[] displayList = new String[nameSet.size()];
        int i = 0;
        for (Sensor nBean : nameSet) {
            if (nBean == null) continue;
            displayList[i++] = nBean.getDisplayName();
        }
        Arrays.sort(displayList);
        this.sensorList = new String[displayList.length + 1];
        this.sensorList[0] = "";
        i = 1;
        Object[] objectArray = displayList;
        int n = displayList.length;
        int n2 = 0;
        while (n2 < n) {
            Object name;
            this.sensorList[i] = name = objectArray[n2];
            ++i;
            ++n2;
        }
    }

    private void updateReporterList() {
        SortedSet nameSet = InstanceManager.getDefault(ReporterManager.class).getNamedBeanSet();
        Object[] displayList = new String[nameSet.size()];
        int i = 0;
        for (Reporter nBean : nameSet) {
            if (nBean == null) continue;
            displayList[i++] = nBean.getDisplayName();
        }
        Arrays.sort(displayList);
        this.reporterList = new String[displayList.length + 1];
        this.reporterList[0] = "";
        i = 1;
        Object[] objectArray = displayList;
        int n = displayList.length;
        int n2 = 0;
        while (n2 < n) {
            Object name;
            this.reporterList[i] = name = objectArray[n2];
            ++i;
            ++n2;
        }
    }

    private void updateSpeedList() {
        this.speedList.remove(this.defaultBlockSpeedText);
        this.defaultBlockSpeedText = String.valueOf(Bundle.getMessage("UseGlobal", "Global")) + " " + InstanceManager.getDefault(BlockManager.class).getDefaultSpeed();
        this.speedList.add(0, this.defaultBlockSpeedText);
        this.fireTableDataChanged();
    }

    public void setDefaultSpeeds(JFrame _who) {
        JComboBox<String> blockSpeedCombo = new JComboBox<String>(this.speedList);
        blockSpeedCombo.setEditable(true);
        JPanel block = new JPanel();
        block.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BlockSpeedLabel"))));
        block.add(blockSpeedCombo);
        blockSpeedCombo.removeItem(this.defaultBlockSpeedText);
        blockSpeedCombo.setSelectedItem(InstanceManager.getDefault(BlockManager.class).getDefaultSpeed());
        String title = Bundle.getMessage("BlockSpeedLabel");
        JPanel speedspanel = new JPanel();
        speedspanel.setLayout(new BoxLayout(speedspanel, 3));
        speedspanel.add(new JLabel(Bundle.getMessage("BlockSpeedSelectDialog")));
        block.setAlignmentX(0.0f);
        speedspanel.add(block);
        int retval = JOptionPane.showConfirmDialog(_who, speedspanel, title, 2, 1);
        log.debug("Retval = {}", (Object)retval);
        if (retval != 0) {
            return;
        }
        String speedValue = (String)blockSpeedCombo.getSelectedItem();
        try {
            InstanceManager.getDefault(BlockManager.class).setDefaultSpeed(speedValue);
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(_who, String.valueOf(ex.getMessage()) + "\n" + speedValue);
        }
    }

    @Override
    public synchronized void dispose() {
        InstanceManager.getDefault(SensorManager.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(ReporterManager.class).removePropertyChangeListener(this);
        super.dispose();
    }

    protected void configStateColumn(JTable table) {
        log.debug("Block configStateColumn (I am {})", (Object)super.toString());
        if (this._graphicState) {
            table.setDefaultRenderer(JLabel.class, new ImageIconRenderer());
        }
    }

    @Override
    public String getCellToolTip(JTable table, int row, int col) {
        switch (col) {
            case 9: {
                Block b = (Block)this.getValueAt(row, 0);
                return this.blockDescribeState(b.getState());
            }
            case 7: {
                return this.metricUi ? Bundle.getMessage("LengthCentimeters") : Bundle.getMessage("LengthInches");
            }
        }
        return super.getCellToolTip(table, row, col);
    }

    static class ImageIconRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        protected JLabel label;
        protected String rootPath = "resources/icons/misc/switchboard/";
        protected char beanTypeChar = (char)83;
        protected String onIconPath = String.valueOf(this.rootPath) + this.beanTypeChar + "-on-s.png";
        protected String offIconPath = String.valueOf(this.rootPath) + this.beanTypeChar + "-off-s.png";
        protected BufferedImage onImage;
        protected BufferedImage offImage;
        protected ImageIcon onIcon;
        protected ImageIcon offIcon;
        protected int iconHeight = -1;

        ImageIconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            log.debug("Renderer Item = {}, State = {}", (Object)row, value);
            if (this.iconHeight < 0) {
                this.loadIcons();
                log.debug("icons loaded");
            }
            Block b = (Block)table.getModel().getValueAt(row, 0);
            return this.updateLabel(b);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            log.debug("Renderer Item = {}, State = {}", (Object)row, value);
            if (this.iconHeight < 0) {
                this.loadIcons();
                log.debug("icons loaded");
            }
            Block b = (Block)table.getModel().getValueAt(row, 0);
            return this.updateLabel(b);
        }

        public JLabel updateLabel(final Block b) {
            if (b.getState() == 4 && this.offIcon != null) {
                this.label = new JLabel(this.offIcon);
                this.label.setVerticalAlignment(3);
            } else if (b.getState() == 2 && this.onIcon != null) {
                this.label = new JLabel(this.onIcon);
                this.label.setVerticalAlignment(3);
            } else if (b.getState() == 8) {
                this.label = new JLabel("X", 0);
                this.label.setForeground(Color.red);
                this.iconHeight = 0;
            } else {
                this.label = new JLabel("?", 0);
                this.iconHeight = 0;
            }
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public final void mousePressed(MouseEvent evt) {
                    log.debug("Clicked on icon for block {}", (Object)b);
                    this.stopCellEditing();
                }
            });
            return this.label;
        }

        @Override
        public Object getCellEditorValue() {
            log.debug("getCellEditorValue, me = {})", (Object)this.toString());
            return this.toString();
        }

        protected void loadIcons() {
            try {
                this.onImage = ImageIO.read(new File(this.onIconPath));
                this.offImage = ImageIO.read(new File(this.offIconPath));
            }
            catch (IOException ex) {
                log.error("error reading image from {} or {}", new Object[]{this.onIconPath, this.offIconPath, ex});
            }
            log.debug("Success reading images");
            int imageWidth = this.onImage.getWidth();
            int imageHeight = this.onImage.getHeight();
            Image smallOnImage = this.onImage.getScaledInstance(imageWidth / 2, imageHeight / 2, 1);
            Image smallOffImage = this.offImage.getScaledInstance(imageWidth / 2, imageHeight / 2, 1);
            this.onIcon = new ImageIcon(smallOnImage);
            this.offIcon = new ImageIcon(smallOffImage);
            this.iconHeight = this.onIcon.getIconHeight();
        }
    }
}

