/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.block;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import jmri.jmrit.beantable.block.Bundle;

public class BlockCurvatureJComboBox
extends JComboBox<String> {
    private static final String NONE_TEXT = Bundle.getMessage("BlockNone");
    private static final String GRADUAL_TEXT = Bundle.getMessage("BlockGradual");
    private static final String TIGHT_TEXT = Bundle.getMessage("BlockTight");
    private static final String SEVERE_TEXT = Bundle.getMessage("BlockSevere");
    private static final String[] CURVE_OPTIONS = new String[]{NONE_TEXT, GRADUAL_TEXT, TIGHT_TEXT, SEVERE_TEXT};

    public BlockCurvatureJComboBox() {
        super(new CurvatureComboBoxModel());
        this.setSelectedItem(NONE_TEXT);
    }

    public BlockCurvatureJComboBox(int curvature) {
        super(new CurvatureComboBoxModel());
        this.setCurvature(curvature);
    }

    public void setJTableCellClientProperties() {
        this.putClientProperty("JComponent.sizeVariant", "small");
        this.putClientProperty("JComboBox.buttonType", "square");
    }

    public final void setCurvature(int blockCurve) {
        this.setSelectedItem(BlockCurvatureJComboBox.getStringFromCurvature(blockCurve));
    }

    public static String getStringFromCurvature(int blockCurve) {
        switch (blockCurve) {
            case 1: {
                return GRADUAL_TEXT;
            }
            case 2: {
                return TIGHT_TEXT;
            }
            case 4: {
                return SEVERE_TEXT;
            }
        }
        return NONE_TEXT;
    }

    public int getCurvature() {
        return BlockCurvatureJComboBox.getCurvatureFromString((String)this.getSelectedItem());
    }

    public static int getCurvatureFromString(String s) {
        if (GRADUAL_TEXT.equals(s)) {
            return 1;
        }
        if (TIGHT_TEXT.equals(s)) {
            return 2;
        }
        if (SEVERE_TEXT.equals(s)) {
            return 4;
        }
        return 0;
    }

    public static int getCurvatureFromObject(Object obj) {
        if (obj instanceof BlockCurvatureJComboBox) {
            BlockCurvatureJComboBox jcb = (BlockCurvatureJComboBox)obj;
            return BlockCurvatureJComboBox.getCurvatureFromString((String)jcb.getSelectedItem());
        }
        return 0;
    }

    private static class CurvatureComboBoxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private String selection = null;

        private CurvatureComboBoxModel() {
        }

        @Override
        public String getElementAt(int index) {
            return CURVE_OPTIONS[index];
        }

        @Override
        public int getSize() {
            return CURVE_OPTIONS.length;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selection = (String)anItem;
        }

        @Override
        public String getSelectedItem() {
            return this.selection;
        }
    }
}

