/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.beanedit;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.RawTurnoutOperation;
import jmri.Sensor;
import jmri.Turnout;
import jmri.TurnoutOperation;
import jmri.TurnoutOperationManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.beantable.TurnoutTableAction;
import jmri.jmrit.beantable.beanedit.BeanEditAction;
import jmri.jmrit.beantable.beanedit.BeanEditItem;
import jmri.jmrit.beantable.beanedit.BeanItemPanel;
import jmri.jmrit.beantable.beanedit.Bundle;
import jmri.jmrit.turnoutoperations.TurnoutOperationConfig;
import jmri.swing.NamedBeanComboBox;

public class TurnoutEditAction
extends BeanEditAction<Turnout> {
    private JCheckBox inverted = new JCheckBox();
    private NamedBeanComboBox<Sensor> sensorFeedBack1ComboBox;
    private NamedBeanComboBox<Sensor> sensorFeedBack2ComboBox;
    private JComboBox<String> modeBox;
    private JComboBox<String> automationBox;
    private String useBlockSpeed = Bundle.getMessage("UseGlobal", "Block Speed");
    private TurnoutOperationConfig config;
    private BeanItemPanel feedback;
    private JPanel turnoutOperation = new JPanel();
    private String oldModeSelection;
    private TurnoutOperation oldAutomationSelection;
    private TurnoutOperation currentOperation;
    private JTextField operationsName = new JTextField(10);
    transient ActionListener automationSelectionListener = e -> this.updateAutomationOptions();
    private static final String bothText = "Both";
    private static final String cabOnlyText = "Cab only";
    private static final String pushbutText = "Pushbutton only";
    private static final String noneText = "None";
    private JComboBox<String> lockBox;
    private Vector<String> speedListClosed = new Vector();
    private Vector<String> speedListThrown = new Vector();
    private JComboBox<String> closedSpeedBox;
    private JComboBox<String> thrownSpeedBox;
    private String defaultThrownSpeedText;
    private String defaultClosedSpeedText;

    @Override
    public String helpTarget() {
        return "package.jmri.jmrit.beantable.TurnoutAddEdit";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.oldAutomationSelection = ((Turnout)this.bean).getTurnoutOperation();
        this.oldModeSelection = ((Turnout)this.bean).getFeedbackModeName();
        super.actionPerformed(e);
    }

    @Override
    protected void initPanels() {
        super.initPanels();
        this.feedback();
        this.lock();
        this.speed();
    }

    @Override
    public Turnout getByUserName(String name) {
        return InstanceManager.turnoutManagerInstance().getByUserName(name);
    }

    @Override
    protected BeanItemPanel basicDetails() {
        BeanItemPanel basic = super.basicDetails();
        basic.addItem(new BeanEditItem(this.inverted, Bundle.getMessage("Inverted"), Bundle.getMessage("InvertedToolTip")));
        return basic;
    }

    @Override
    protected void saveBasicItems(ActionEvent e) {
        super.saveBasicItems(e);
        Turnout turn = (Turnout)this.bean;
        turn.setInverted(this.inverted.isSelected());
    }

    @Override
    protected void resetBasicItems(ActionEvent e) {
        super.resetBasicItems(e);
        Turnout turn = (Turnout)this.bean;
        if (turn.canInvert()) {
            this.inverted.setSelected(turn.getInverted());
        }
        this.inverted.setEnabled(turn.canInvert());
    }

    private BeanItemPanel feedback() {
        this.feedback = new BeanItemPanel();
        this.feedback.setName(Bundle.getMessage("Feedback"));
        this.modeBox = new JComboBox<String>(((Turnout)this.bean).getValidFeedbackNames());
        this.modeBox.setMaximumRowCount(this.modeBox.getItemCount());
        this.oldModeSelection = ((Turnout)this.bean).getFeedbackModeName();
        this.modeBox.setSelectedItem(this.oldModeSelection);
        this.modeBox.addActionListener(e -> this.updateFeedbackOptions());
        this.feedback.addItem(new BeanEditItem(null, null, Bundle.getMessage("FeedbackToolTip")));
        this.feedback.addItem(new BeanEditItem(this.modeBox, Bundle.getMessage("FeedbackMode"), Bundle.getMessage("FeedbackModeToolTip")));
        this.sensorFeedBack1ComboBox = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance(), ((Turnout)this.bean).getFirstSensor(), NamedBean.DisplayOptions.DISPLAYNAME);
        this.sensorFeedBack1ComboBox.setAllowNull(true);
        this.feedback.addItem(new BeanEditItem(this.sensorFeedBack1ComboBox, Bundle.getMessage("FeedbackSensor1"), Bundle.getMessage("FeedbackSensorToolTip")));
        this.sensorFeedBack2ComboBox = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance(), ((Turnout)this.bean).getSecondSensor(), NamedBean.DisplayOptions.DISPLAYNAME);
        this.sensorFeedBack2ComboBox.setAllowNull(true);
        this.feedback.addItem(new BeanEditItem(this.sensorFeedBack2ComboBox, Bundle.getMessage("FeedbackSensor2"), Bundle.getMessage("FeedbackSensorToolTip")));
        String[] str = new String[]{"empty"};
        this.automationBox = new JComboBox<String>(str);
        this.feedback.addItem(new BeanEditItem(this.automationBox, Bundle.getMessage("TurnoutAutomation"), Bundle.getMessage("TurnoutAutomationToolTip")));
        this.oldAutomationSelection = ((Turnout)this.bean).getTurnoutOperation();
        if (this.oldAutomationSelection != null) {
            this.config = TurnoutOperationConfig.getConfigPanel(this.oldAutomationSelection);
        } else {
            this.config = TurnoutOperationConfig.getConfigPanel(new RawTurnoutOperation());
            this.config.setEnabled(false);
            Component[] componentArray = this.config.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component j = componentArray[n2];
                j.setEnabled(false);
                ++n2;
            }
        }
        this.turnoutOperation.add(this.config);
        this.feedback.addItem(new BeanEditItem(this.turnoutOperation, Bundle.getMessage("FeedbackOperation"), Bundle.getMessage("FeedbackOperationToolTip")));
        this.feedback.addItem(new BeanEditItem(this.operationsName, Bundle.getMessage("FeedbackNameSet"), Bundle.getMessage("FeedbackNameSetToolTip")));
        this.feedback.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String modeName = (String)TurnoutEditAction.this.modeBox.getSelectedItem();
                if (modeName != null) {
                    ((Turnout)TurnoutEditAction.this.bean).setFeedbackMode(modeName);
                }
                String newName = TurnoutEditAction.this.operationsName.getText();
                if (TurnoutEditAction.this.currentOperation != null && newName != null && !newName.isEmpty()) {
                    if (!TurnoutEditAction.this.currentOperation.rename(newName)) {
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorDuplicateUserName", newName), Bundle.getMessage("ErrorTitle"), 0);
                    } else {
                        TurnoutEditAction.this.automationBox.addItem(newName);
                        TurnoutEditAction.this.automationBox.setSelectedItem(newName);
                    }
                    ((Turnout)TurnoutEditAction.this.bean).setTurnoutOperation(null);
                    ((Turnout)TurnoutEditAction.this.bean).setTurnoutOperation(TurnoutEditAction.this.currentOperation);
                }
                TurnoutEditAction.this.config.endConfigure();
                switch (TurnoutEditAction.this.automationBox.getSelectedIndex()) {
                    case 0: {
                        ((Turnout)TurnoutEditAction.this.bean).setInhibitOperation(true);
                        ((Turnout)TurnoutEditAction.this.bean).setTurnoutOperation(null);
                        break;
                    }
                    case 1: {
                        ((Turnout)TurnoutEditAction.this.bean).setInhibitOperation(false);
                        ((Turnout)TurnoutEditAction.this.bean).setTurnoutOperation(null);
                        break;
                    }
                    default: {
                        ((Turnout)TurnoutEditAction.this.bean).setInhibitOperation(false);
                        String autoMode = (String)TurnoutEditAction.this.automationBox.getSelectedItem();
                        if (autoMode == null) break;
                        ((Turnout)TurnoutEditAction.this.bean).setTurnoutOperation(InstanceManager.getDefault(TurnoutOperationManager.class).getOperation(autoMode));
                    }
                }
                TurnoutEditAction.this.oldAutomationSelection = ((Turnout)TurnoutEditAction.this.bean).getTurnoutOperation();
                TurnoutEditAction.this.oldModeSelection = ((Turnout)TurnoutEditAction.this.bean).getFeedbackModeName();
                try {
                    ((Turnout)TurnoutEditAction.this.bean).provideFirstFeedbackSensor(TurnoutEditAction.this.sensorFeedBack1ComboBox.getSelectedItemDisplayName());
                }
                catch (JmriException ex) {
                    JOptionPane.showMessageDialog(null, ex.toString());
                }
                try {
                    ((Turnout)TurnoutEditAction.this.bean).provideSecondFeedbackSensor(TurnoutEditAction.this.sensorFeedBack2ComboBox.getSelectedItemDisplayName());
                }
                catch (JmriException ex) {
                    JOptionPane.showMessageDialog(null, ex.toString());
                }
            }
        });
        this.feedback.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TurnoutEditAction.this.sensorFeedBack1ComboBox.setSelectedItem(((Turnout)TurnoutEditAction.this.bean).getFirstSensor());
                TurnoutEditAction.this.sensorFeedBack2ComboBox.setSelectedItem(((Turnout)TurnoutEditAction.this.bean).getSecondSensor());
                TurnoutEditAction.this.automationBox.removeActionListener(TurnoutEditAction.this.automationSelectionListener);
                TurnoutTableAction.updateAutomationBox((Turnout)TurnoutEditAction.this.bean, TurnoutEditAction.this.automationBox);
                TurnoutEditAction.this.automationBox.addActionListener(TurnoutEditAction.this.automationSelectionListener);
                ((Turnout)TurnoutEditAction.this.bean).setFeedbackMode(TurnoutEditAction.this.oldModeSelection);
                TurnoutEditAction.this.updateFeedbackOptions();
            }
        });
        this.bei.add(this.feedback);
        return this.feedback;
    }

    private void updateFeedbackOptions() {
        this.sensorFeedBack1ComboBox.setEnabled(false);
        this.sensorFeedBack2ComboBox.setEnabled(false);
        String mode = (String)this.modeBox.getSelectedItem();
        if (mode != null) {
            if (mode.equals("ONESENSOR")) {
                this.sensorFeedBack1ComboBox.setEnabled(true);
            } else if (mode.equals("TWOSENSOR")) {
                this.sensorFeedBack1ComboBox.setEnabled(true);
                this.sensorFeedBack2ComboBox.setEnabled(true);
            }
            ((Turnout)this.bean).setFeedbackMode(mode);
        }
        ((Turnout)this.bean).setFeedbackMode((String)this.modeBox.getSelectedItem());
        TurnoutTableAction.updateAutomationBox((Turnout)this.bean, this.automationBox);
    }

    private void updateAutomationOptions() {
        String autoMode;
        this.currentOperation = null;
        this.automationBox.removeActionListener(this.automationSelectionListener);
        if (this.automationBox.getSelectedIndex() > 1 && (autoMode = (String)this.automationBox.getSelectedItem()) != null) {
            this.currentOperation = InstanceManager.getDefault(TurnoutOperationManager.class).getOperation(autoMode);
        }
        if (this.currentOperation != null) {
            this.turnoutOperation.remove(this.config);
            if (!this.currentOperation.isNonce()) {
                this.currentOperation = this.currentOperation.makeNonce((Turnout)this.bean);
            }
            this.config = TurnoutOperationConfig.getConfigPanel(this.currentOperation);
            this.operationsName.setEnabled(true);
            this.config.setEnabled(true);
            this.turnoutOperation.add(this.config);
            this.feedback.revalidate();
            this.feedback.repaint();
        } else {
            this.operationsName.setEnabled(false);
            this.config.setEnabled(false);
            Component[] componentArray = this.config.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component j = componentArray[n2];
                j.setEnabled(false);
                ++n2;
            }
        }
        this.automationBox.addActionListener(this.automationSelectionListener);
    }

    @Override
    protected void cancelButtonAction(ActionEvent e) {
        ((Turnout)this.bean).setFeedbackMode(this.oldModeSelection);
        ((Turnout)this.bean).setTurnoutOperation(this.oldAutomationSelection);
        super.cancelButtonAction(e);
    }

    protected BeanItemPanel lock() {
        BeanItemPanel lock = new BeanItemPanel();
        lock.setName(Bundle.getMessage("Lock"));
        if (((Turnout)this.bean).getPossibleLockModes() != 0) {
            lock.addItem(new BeanEditItem(null, null, Bundle.getMessage("LockToolTip")));
            Vector<String> lockOperations = new Vector<String>();
            int modes = ((Turnout)this.bean).getPossibleLockModes();
            if ((modes & 1) != 0 && (modes & 2) != 0) {
                lockOperations.add(bothText);
            }
            if ((modes & 1) != 0) {
                lockOperations.add(cabOnlyText);
            }
            if ((modes & 2) != 0) {
                lockOperations.add(pushbutText);
            }
            lockOperations.add(noneText);
            final JComboBox lockOperationBox = new JComboBox(lockOperations);
            lockOperationBox.setMaximumRowCount(lockOperationBox.getItemCount());
            lock.addItem(new BeanEditItem(lockOperationBox, Bundle.getMessage("LockMode"), Bundle.getMessage("LockModeToolTip")));
            lockOperationBox.addActionListener(e -> {
                String lockOp = (String)lockOperationBox.getSelectedItem();
                if (lockOp != null) {
                    if (lockOp.equals(noneText)) {
                        this.lockBox.setEnabled(false);
                    } else {
                        this.lockBox.setEnabled(true);
                    }
                }
            });
            this.lockBox = (((Turnout)this.bean).getPossibleLockModes() & 2) != 0 ? new JComboBox<String>(((Turnout)this.bean).getValidDecoderNames()) : new JComboBox<String>(new String[]{((Turnout)this.bean).getDecoderName()});
            lock.addItem(new BeanEditItem(this.lockBox, Bundle.getMessage("LockModeDecoder"), Bundle.getMessage("LockModeDecoderToolTip")));
            lock.setSaveItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String decoderName;
                    String lockOpName = (String)lockOperationBox.getSelectedItem();
                    if (lockOpName != null) {
                        if (lockOpName.equals(TurnoutEditAction.bothText)) {
                            ((Turnout)TurnoutEditAction.this.bean).enableLockOperation(3, true);
                        }
                        if (lockOpName.equals(TurnoutEditAction.cabOnlyText)) {
                            ((Turnout)TurnoutEditAction.this.bean).enableLockOperation(1, true);
                            ((Turnout)TurnoutEditAction.this.bean).enableLockOperation(2, false);
                        }
                        if (lockOpName.equals(TurnoutEditAction.pushbutText)) {
                            ((Turnout)TurnoutEditAction.this.bean).enableLockOperation(1, false);
                            ((Turnout)TurnoutEditAction.this.bean).enableLockOperation(2, true);
                        }
                    }
                    if ((decoderName = (String)TurnoutEditAction.this.lockBox.getSelectedItem()) != null) {
                        ((Turnout)TurnoutEditAction.this.bean).setDecoderName(decoderName);
                    }
                }
            });
            lock.setResetItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TurnoutEditAction.this.lockBox.setSelectedItem(((Turnout)TurnoutEditAction.this.bean).getDecoderName());
                    TurnoutEditAction.this.lockBox.setEnabled(true);
                    if (((Turnout)TurnoutEditAction.this.bean).canLock(1) && ((Turnout)TurnoutEditAction.this.bean).canLock(2)) {
                        lockOperationBox.setSelectedItem(TurnoutEditAction.bothText);
                    } else if (((Turnout)TurnoutEditAction.this.bean).canLock(2)) {
                        lockOperationBox.setSelectedItem(TurnoutEditAction.pushbutText);
                    } else if (((Turnout)TurnoutEditAction.this.bean).canLock(1)) {
                        lockOperationBox.setSelectedItem(TurnoutEditAction.cabOnlyText);
                    } else {
                        lockOperationBox.setSelectedItem(TurnoutEditAction.noneText);
                        TurnoutEditAction.this.lockBox.setEnabled(false);
                    }
                }
            });
        } else {
            lock.addItem(new BeanEditItem(null, null, Bundle.getMessage("LockModeUnavailable")));
        }
        this.bei.add(lock);
        return lock;
    }

    protected BeanItemPanel speed() {
        BeanItemPanel speed = new BeanItemPanel();
        speed.setName(Bundle.getMessage("Speed"));
        speed.addItem(new BeanEditItem(null, null, Bundle.getMessage("SpeedTabToolTip")));
        this.defaultThrownSpeedText = String.valueOf(Bundle.getMessage("UseGlobal", "Global")) + " " + InstanceManager.turnoutManagerInstance().getDefaultThrownSpeed();
        this.defaultClosedSpeedText = String.valueOf(Bundle.getMessage("UseGlobal", "Global")) + " " + InstanceManager.turnoutManagerInstance().getDefaultClosedSpeed();
        this.useBlockSpeed = Bundle.getMessage("UseGlobal", "Block Speed");
        this.speedListClosed.add(this.defaultClosedSpeedText);
        this.speedListThrown.add(this.defaultThrownSpeedText);
        this.speedListClosed.add(this.useBlockSpeed);
        this.speedListThrown.add(this.useBlockSpeed);
        Vector<String> _speedMap = InstanceManager.getDefault(SignalSpeedMap.class).getValidSpeedNames();
        for (String speedMap : _speedMap) {
            if (!this.speedListClosed.contains(speedMap)) {
                this.speedListClosed.add(speedMap);
            }
            if (this.speedListThrown.contains(speedMap)) continue;
            this.speedListThrown.add(speedMap);
        }
        this.closedSpeedBox = new JComboBox<String>(this.speedListClosed);
        this.closedSpeedBox.setMaximumRowCount(this.closedSpeedBox.getItemCount());
        this.closedSpeedBox.setEditable(true);
        speed.addItem(new BeanEditItem(this.closedSpeedBox, Bundle.getMessage("ClosedSpeed"), Bundle.getMessage("ClosedSpeedToolTip")));
        this.thrownSpeedBox = new JComboBox<String>(this.speedListThrown);
        this.thrownSpeedBox.setMaximumRowCount(this.thrownSpeedBox.getItemCount());
        this.thrownSpeedBox.setEditable(true);
        speed.addItem(new BeanEditItem(this.thrownSpeedBox, Bundle.getMessage("ThrownSpeed"), Bundle.getMessage("ThrownSpeedToolTip")));
        speed.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String speed = (String)TurnoutEditAction.this.closedSpeedBox.getSelectedItem();
                if (speed != null) {
                    try {
                        ((Turnout)TurnoutEditAction.this.bean).setStraightSpeed(speed);
                        if (!TurnoutEditAction.this.speedListClosed.contains(speed) && !speed.contains("Global")) {
                            TurnoutEditAction.this.speedListClosed.add(speed);
                        }
                    }
                    catch (JmriException ex) {
                        JOptionPane.showMessageDialog(null, String.valueOf(ex.getMessage()) + "\n" + speed);
                    }
                }
                if ((speed = (String)TurnoutEditAction.this.thrownSpeedBox.getSelectedItem()) != null) {
                    try {
                        ((Turnout)TurnoutEditAction.this.bean).setDivergingSpeed(speed);
                        if (!TurnoutEditAction.this.speedListThrown.contains(speed) && !speed.contains("Global")) {
                            TurnoutEditAction.this.speedListThrown.add(speed);
                        }
                    }
                    catch (JmriException ex) {
                        JOptionPane.showMessageDialog(null, String.valueOf(ex.getMessage()) + "\n" + speed);
                    }
                }
            }
        });
        speed.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String speed = ((Turnout)TurnoutEditAction.this.bean).getDivergingSpeed();
                TurnoutEditAction.this.speedListThrown.remove(TurnoutEditAction.this.defaultThrownSpeedText);
                TurnoutEditAction.this.defaultThrownSpeedText = String.valueOf(Bundle.getMessage("UseGlobal", "Global")) + " " + InstanceManager.turnoutManagerInstance().getDefaultThrownSpeed();
                TurnoutEditAction.this.speedListThrown.add(0, TurnoutEditAction.this.defaultThrownSpeedText);
                if (!TurnoutEditAction.this.speedListThrown.contains(speed)) {
                    TurnoutEditAction.this.speedListThrown.add(speed);
                    TurnoutEditAction.this.thrownSpeedBox.addItem(speed);
                }
                TurnoutEditAction.this.thrownSpeedBox.setSelectedItem(speed);
                speed = ((Turnout)TurnoutEditAction.this.bean).getStraightSpeed();
                TurnoutEditAction.this.speedListClosed.remove(TurnoutEditAction.this.defaultClosedSpeedText);
                TurnoutEditAction.this.defaultClosedSpeedText = String.valueOf(Bundle.getMessage("UseGlobal", "Global")) + " " + InstanceManager.turnoutManagerInstance().getDefaultClosedSpeed();
                TurnoutEditAction.this.speedListClosed.add(0, TurnoutEditAction.this.defaultClosedSpeedText);
                if (!TurnoutEditAction.this.speedListClosed.contains(speed)) {
                    TurnoutEditAction.this.speedListClosed.add(speed);
                    TurnoutEditAction.this.closedSpeedBox.addItem(speed);
                }
                TurnoutEditAction.this.closedSpeedBox.setSelectedItem(speed);
            }
        });
        this.bei.add(speed);
        return speed;
    }
}

