/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.beanedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandleManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.beanedit.BeanEditItem;
import jmri.jmrit.beantable.beanedit.BeanItemPanel;
import jmri.jmrit.beantable.beanedit.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanEditAction<B extends NamedBean>
extends AbstractAction {
    B bean;
    JTextField userNameField = new JTextField(20);
    JTextArea commentField = new JTextArea(3, 30);
    JScrollPane commentFieldScroller = new JScrollPane(this.commentField);
    private JLabel statusBar = new JLabel(Bundle.getMessage("ItemEditStatusInfo", Bundle.getMessage("ButtonApply")));
    private BeanPropertiesTableModel<B> propertiesModel;
    protected ArrayList<BeanItemPanel> bei = new ArrayList(5);
    JmriJFrame f;
    protected Component selectedTab = null;
    private final JTabbedPane detailsTab = new JTabbedPane();
    protected JButton applyBut;
    NamedBeanHandleManager nbMan = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private static final Logger log = LoggerFactory.getLogger(BeanEditAction.class);

    public BeanEditAction(String s) {
        super(s);
    }

    public BeanEditAction() {
        super("Bean Edit");
    }

    public void setBean(B bean) {
        this.bean = bean;
    }

    protected void initPanels() {
        this.basicDetails();
    }

    protected void initPanelsFirst() {
    }

    protected void initPanelsLast() {
        this.usageDetails();
        this.propertiesDetails();
    }

    BeanItemPanel basicDetails() {
        BeanItemPanel basic = new BeanItemPanel();
        basic.setName(Bundle.getMessage("Basic"));
        basic.setLayout(new BoxLayout(basic, 1));
        basic.addItem(new BeanEditItem(new JLabel(this.bean.getSystemName()), Bundle.getMessage("ColumnSystemName"), null));
        basic.addItem(new BeanEditItem(this.userNameField, Bundle.getMessage("ColumnUserName"), null));
        basic.addItem(new BeanEditItem(this.commentFieldScroller, Bundle.getMessage("ColumnComment"), null));
        basic.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanEditAction.this.saveBasicItems(e);
            }
        });
        basic.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanEditAction.this.resetBasicItems(e);
            }
        });
        this.bei.add(basic);
        return basic;
    }

    BeanItemPanel usageDetails() {
        BeanItemPanel usage = new BeanItemPanel();
        usage.setName(Bundle.getMessage("Usage"));
        usage.setLayout(new BoxLayout(usage, 1));
        usage.addItem(new BeanEditItem(null, null, Bundle.getMessage("UsageText", this.bean.getDisplayName())));
        ArrayList<String> listeners = new ArrayList<String>();
        for (String ref : this.bean.getListenerRefs()) {
            if (listeners.contains(ref)) continue;
            listeners.add(ref);
        }
        Object[] strArray = new Object[listeners.size()];
        listeners.toArray(strArray);
        JList<Object> list = new JList<Object>(strArray);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(-1);
        list.setSelectionMode(1);
        JScrollPane listScroller = new JScrollPane(list);
        listScroller.setPreferredSize(new Dimension(250, 80));
        listScroller.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black)));
        usage.addItem(new BeanEditItem(listScroller, Bundle.getMessage("ColumnLocation"), null));
        this.bei.add(usage);
        return usage;
    }

    BeanItemPanel propertiesDetails() {
        BeanItemPanel properties = new BeanItemPanel();
        properties.setName(Bundle.getMessage("Properties"));
        properties.addItem(new BeanEditItem(null, null, Bundle.getMessage("NamedBeanPropertiesTableDescription")));
        properties.setLayout(new BoxLayout(properties, 1));
        this.propertiesModel = new BeanPropertiesTableModel();
        JTable jtAttributes = new JTable();
        jtAttributes.setModel(this.propertiesModel);
        JScrollPane jsp = new JScrollPane(jtAttributes);
        Dimension tableDim = new Dimension(400, 200);
        jsp.setMinimumSize(tableDim);
        jsp.setMaximumSize(tableDim);
        jsp.setPreferredSize(tableDim);
        properties.addItem(new BeanEditItem(jsp, "", null));
        properties.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanEditAction.this.propertiesModel.updateModel(BeanEditAction.this.bean);
            }
        });
        properties.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanEditAction.this.propertiesModel.setModel(BeanEditAction.this.bean);
            }
        });
        this.bei.add(properties);
        return properties;
    }

    @OverridingMethodsMustInvokeSuper
    protected void saveBasicItems(ActionEvent e) {
        String uname = this.bean.getUserName();
        if (uname == null && !this.userNameField.getText().isEmpty()) {
            this.renameBean(this.userNameField.getText());
        } else if (uname != null && !uname.equals(this.userNameField.getText())) {
            if (this.userNameField.getText().isEmpty()) {
                this.removeName();
            } else {
                this.renameBean(this.userNameField.getText());
            }
        }
        this.bean.setComment(this.commentField.getText());
    }

    @OverridingMethodsMustInvokeSuper
    protected void resetBasicItems(ActionEvent e) {
        this.userNameField.setText(this.bean.getUserName());
        this.commentField.setText(this.bean.getComment());
    }

    protected abstract String helpTarget();

    public void setSelectedComponent(Component c) {
        this.selectedTab = c;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.bean == null) {
            log.error("No bean set so unable to edit a null bean");
            return;
        }
        if (this.f == null) {
            this.f = new JmriJFrame(Bundle.getMessage("EditBean", this.bean.getBeanType(), this.bean.getDisplayName()), false, false);
            this.f.addHelpMenu(this.helpTarget(), true);
            this.applyBut = new JButton(Bundle.getMessage("ButtonApply"));
            Container containerPanel = this.f.getContentPane();
            this.initPanelsFirst();
            this.initPanels();
            this.initPanelsLast();
            int i = 0;
            for (BeanItemPanel bi : this.bei) {
                this.addToPanel(bi, bi.getListOfItems());
                this.detailsTab.add(bi, bi.getName(), i);
                this.detailsTab.setEnabledAt(i, bi.isEnabled());
                this.detailsTab.setToolTipTextAt(i, bi.getToolTipText());
                ++i;
            }
            containerPanel.add((Component)this.detailsTab, "Center");
            JPanel bottom = new JPanel();
            bottom.setLayout(new BoxLayout(bottom, 3));
            JPanel panelStatus = new JPanel();
            this.statusBar.setFont(this.statusBar.getFont().deriveFont(0.9f * (float)this.userNameField.getFont().getSize()));
            this.statusBar.setForeground(Color.gray);
            panelStatus.add(this.statusBar);
            bottom.add(panelStatus);
            JPanel buttons = new JPanel();
            this.applyBut.addActionListener(this::applyButtonAction);
            JButton okBut = new JButton(Bundle.getMessage("ButtonOK"));
            okBut.addActionListener(e1 -> {
                this.applyButtonAction(e1);
                this.f.dispose();
            });
            JButton cancelBut = new JButton(Bundle.getMessage("ButtonCancel"));
            cancelBut.addActionListener(this::cancelButtonAction);
            buttons.add(this.applyBut);
            buttons.add(okBut);
            buttons.add(cancelBut);
            bottom.add(buttons);
            containerPanel.add((Component)bottom, "South");
        }
        for (BeanItemPanel bi : this.bei) {
            bi.resetField();
        }
        this.persistSelectedTab();
        if (this.selectedTab != null) {
            this.detailsTab.setSelectedComponent(this.selectedTab);
        }
        this.f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BeanEditAction.this.cancelButtonAction(null);
            }
        });
        this.f.pack();
        this.f.setVisible(true);
    }

    private void persistSelectedTab() {
        String TAB_SELECT_STRING = "selectedTabIndex";
        Object obj = InstanceManager.getDefault(UserPreferencesManager.class).getProperty(this.getClass().getName(), TAB_SELECT_STRING);
        int previoustab = obj != null ? (Integer)obj : 0;
        this.detailsTab.setSelectedIndex(Math.max(Math.min(this.detailsTab.getTabCount() - 1, previoustab), 0));
        this.detailsTab.getModel().addChangeListener(evt -> InstanceManager.getDefault(UserPreferencesManager.class).setProperty(this.getClass().getName(), TAB_SELECT_STRING, this.detailsTab.getSelectedIndex()));
    }

    protected void applyButtonAction(ActionEvent e) {
        this.save();
    }

    protected void cancelButtonAction(ActionEvent e) {
        this.f.dispose();
    }

    protected void addToPanel(JPanel panel, List<BeanEditItem> items) {
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints cL = new GridBagConstraints();
        GridBagConstraints cD = new GridBagConstraints();
        GridBagConstraints cR = new GridBagConstraints();
        cL.fill = 2;
        cL.insets = new Insets(4, 0, 0, 15);
        cR.insets = new Insets(4, 10, 13, 15);
        cD.insets = new Insets(4, 0, 0, 0);
        cD.anchor = 18;
        cL.anchor = 18;
        int y = 0;
        JPanel p = new JPanel();
        for (BeanEditItem it : items) {
            if (it.getDescription() != null && it.getComponent() != null) {
                JLabel descript = new JLabel(String.valueOf(it.getDescription()) + ":", 2);
                if (it.getDescription().isEmpty()) {
                    descript.setText("");
                }
                cL.gridx = 0;
                cL.gridy = y;
                cL.ipadx = 3;
                gbLayout.setConstraints(descript, cL);
                p.setLayout(gbLayout);
                p.add((Component)descript, cL);
                cD.gridx = 1;
                cD.gridy = y;
                JComponent thing = it.getComponent();
                cD.insets = thing instanceof JComboBox || thing instanceof JTextField || thing instanceof JCheckBox || thing instanceof JRadioButton ? new Insets(0, 0, 0, 0) : (thing instanceof JColorChooser ? new Insets(-6, 0, 0, 0) : new Insets(4, 0, 0, 0));
                gbLayout.setConstraints(thing, cD);
                p.add((Component)thing, cD);
                cR.gridx = 2;
                cR.gridwidth = 1;
                cR.anchor = 17;
            } else {
                cR.anchor = 10;
                cR.gridx = 0;
                cR.gridwidth = 3;
            }
            cR.gridy = y;
            if (it.getHelp() != null) {
                JTextPane help = new JTextPane();
                help.setText(it.getHelp());
                gbLayout.setConstraints(help, cR);
                this.formatTextAreaAsLabel(help);
                p.add((Component)help, cR);
            }
            ++y;
        }
        panel.add(p);
    }

    void formatTextAreaAsLabel(JTextPane pane) {
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setBorder(null);
    }

    public void save() {
        String feedback = String.valueOf(Bundle.getMessage("ItemUpdateFeedback", this.bean.getBeanType())) + " " + this.bean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        this.statusBar.setText(feedback);
        this.statusBar.setForeground(Color.gray);
        for (BeanItemPanel bi : this.bei) {
            bi.saveItem();
        }
    }

    static boolean validateNumericalInput(String text) {
        if (text.length() != 0) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    protected abstract B getByUserName(String var1);

    public void renameBean(String _newName) {
        if (!this.allowBlockNameChange("Rename", _newName)) {
            return;
        }
        String value = _newName;
        B nBean = this.bean;
        String oldName = nBean.getUserName();
        if (value.equals(oldName)) {
            return;
        }
        B nB = this.getByUserName(value);
        if (nB != null) {
            log.error("User name is not unique {}", (Object)value);
            String msg = MessageFormat.format(Bundle.getMessage("WarningUserName"), value);
            JOptionPane.showMessageDialog(this.f, msg, Bundle.getMessage("WarningTitle"), 0);
            return;
        }
        nBean.setUserName(value);
        if (!value.isEmpty()) {
            if (oldName == null || oldName.isEmpty()) {
                if (!this.nbMan.inUse(nBean.getSystemName(), nBean)) {
                    return;
                }
                String msg = Bundle.getMessage("UpdateToUserName", nBean.getBeanType(), value, nBean.getSystemName());
                int optionPane = JOptionPane.showConfirmDialog(this.f, msg, Bundle.getMessage("UpdateToUserNameTitle"), 0);
                if (optionPane == 0) {
                    try {
                        this.nbMan.updateBeanFromSystemToUser((NamedBean)nBean);
                    }
                    catch (JmriException jmriException) {}
                }
            } else {
                this.nbMan.renameBean(oldName, value, nBean);
            }
        } else {
            this.nbMan.updateBeanFromUserToSystem((NamedBean)nBean);
        }
    }

    public void removeName() {
        if (!this.allowBlockNameChange("Remove", "")) {
            return;
        }
        String msg = MessageFormat.format(Bundle.getMessage("UpdateToSystemName"), this.bean.getBeanType());
        int optionPane = JOptionPane.showConfirmDialog(this.f, msg, Bundle.getMessage("UpdateToSystemNameTitle"), 0);
        if (optionPane == 0) {
            this.nbMan.updateBeanFromUserToSystem((NamedBean)this.bean);
        }
        this.bean.setUserName(null);
    }

    boolean allowBlockNameChange(String changeType, String newName) {
        if (!this.bean.getBeanType().equals("Block")) {
            return true;
        }
        String oldName = this.bean.getUserName();
        if (oldName == null) {
            return true;
        }
        LayoutBlock layoutBlock = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(oldName);
        if (layoutBlock == null) {
            return true;
        }
        if (changeType.equals("Remove")) {
            log.warn("Cannot remove user name for block {}", (Object)oldName);
            JOptionPane.showMessageDialog(this.f, Bundle.getMessage("BlockRemoveUserNameWarning", oldName), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        int optionPane = JOptionPane.showConfirmDialog(this.f, Bundle.getMessage("BlockChangeUserName", oldName, newName), Bundle.getMessage("QuestionTitle"), 0);
        return optionPane == 0;
    }

    private static class BeanPropertiesTableModel<B extends NamedBean>
    extends AbstractTableModel {
        Vector<KeyValueModel> attributes;
        String[] titles = new String[2];
        boolean wasModified;

        public BeanPropertiesTableModel() {
            this.titles[0] = Bundle.getMessage("NamedBeanPropertyName");
            this.titles[1] = Bundle.getMessage("NamedBeanPropertyValue");
        }

        public void setModel(B nb) {
            this.attributes = new Vector(nb.getPropertyKeys().size());
            for (String key : nb.getPropertyKeys()) {
                KeyValueModel kv = new KeyValueModel(key, nb.getProperty(key));
                this.attributes.add(kv);
            }
            this.wasModified = false;
        }

        public void updateModel(B nb) {
            if (!this.wasModified()) {
                return;
            }
            int i = 0;
            while (i < this.attributes.size()) {
                KeyValueModel kv = this.attributes.get(i);
                if (!(kv.key == null || nb.getProperty(kv.key) != null && kv.value.equals(nb.getProperty(kv.key)))) {
                    nb.setProperty(kv.key, kv.value);
                }
                ++i;
            }
            Iterator<String> ite = nb.getPropertyKeys().iterator();
            while (ite.hasNext()) {
                if (this.keyExist(ite.next())) continue;
                ite.remove();
            }
            this.wasModified = false;
        }

        private boolean keyExist(Object k) {
            if (k == null) {
                return false;
            }
            int i = 0;
            while (i < this.attributes.size()) {
                if (k.equals(this.attributes.get((int)i).key)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.attributes.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.titles[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.attributes.size()) {
                if (col == 0) {
                    return this.attributes.get((int)row).key;
                }
                if (col == 1) {
                    return this.attributes.get((int)row).value;
                }
            }
            return "...";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            KeyValueModel kv = row < this.attributes.size() ? this.attributes.get(row) : new KeyValueModel("", "");
            if (col == 0) {
                if (!this.keyExist(((String)value).replaceAll("\\s", ""))) {
                    kv.key = ((String)value).replaceAll("\\s", "");
                } else {
                    this.setValueAt(value + "-1", row, col);
                    return;
                }
            }
            if (col == 1) {
                kv.value = value;
            }
            if (row < this.attributes.size()) {
                this.attributes.set(row, kv);
            } else {
                this.attributes.add(row, kv);
            }
            if (col == 0 && kv.key.isEmpty()) {
                this.attributes.remove(row);
            }
            this.wasModified = true;
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public boolean wasModified() {
            return this.wasModified;
        }

        private static class KeyValueModel {
            public String key;
            public Object value;

            public KeyValueModel(String k, Object v) {
                this.key = k;
                this.value = v;
            }
        }
    }
}

