/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.Block;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Transit;
import jmri.TransitManager;
import jmri.TransitSection;
import jmri.TransitSectionAction;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.swing.NamedBeanComboBox;
import jmri.util.AlphanumComparator;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitTableAction
extends AbstractTableAction<Transit> {
    static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.beantable.SectionTransitTableBundle");
    private boolean editMode = false;
    private boolean duplicateMode = false;
    private TransitManager transitManager = null;
    private final SectionManager sectionManager = InstanceManager.getNullableDefault(SectionManager.class);
    private Transit curTransit = null;
    private SectionTableModel sectionTableModel = null;
    private final List<Section> sectionList = new ArrayList<Section>();
    private final List<Integer> direction = new ArrayList<Integer>();
    private final List<Integer> sequence = new ArrayList<Integer>();
    private final List<List<TransitSectionAction>> action = new ArrayList<List<TransitSectionAction>>();
    private final List<Boolean> alternate = new ArrayList<Boolean>();
    private final List<Boolean> safe = new ArrayList<Boolean>();
    private String[] sensorList;
    private final List<String> sensorStopAllocation = new ArrayList<String>();
    private final List<Section> primarySectionBoxList = new ArrayList<Section>();
    private final List<Integer> priSectionDirection = new ArrayList<Integer>();
    private final List<Section> alternateSectionBoxList = new ArrayList<Section>();
    private final List<Integer> altSectionDirection = new ArrayList<Integer>();
    private final List<Section> insertAtBeginningBoxList = new ArrayList<Section>();
    private final List<Integer> insertAtBeginningDirection = new ArrayList<Integer>();
    private Section curSection = null;
    private int curSectionDirection = 0;
    private Section prevSection = null;
    private int prevSectionDirection = 0;
    private int curSequenceNum = 0;
    JmriJFrame addFrame = null;
    JTextField sysName = new JTextField(15);
    JLabel sysNameFixed = new JLabel("");
    JTextField userName = new JTextField(17);
    JLabel sysNameLabel = new JLabel(Bundle.getMessage("LabelSystemName"));
    JLabel userNameLabel = new JLabel(Bundle.getMessage("LabelUserName"));
    JButton create = null;
    JButton update = null;
    JButton deleteSections = null;
    JComboBox<String> primarySectionBox = new JComboBox();
    JButton addNextSection = null;
    JCheckBox addAsSafe = null;
    JComboBox<String> stopAllocatingSensorBox = new JComboBox();
    JButton removeLastSection = null;
    JButton removeFirstSection = null;
    JButton insertAtBeginning = null;
    JComboBox<String> insertAtBeginningBox = new JComboBox();
    JLabel seqNumLabel = new JLabel(rbx.getString("LabelSeqNum"));
    JSpinner seqNum = new JSpinner(new SpinnerNumberModel(1, 1, 1, 1));
    JButton replacePrimaryForSequence = null;
    JButton deleteAlternateForSequence = null;
    JButton addAlternateForSequence = null;
    JComboBox<String> alternateSectionBox = new JComboBox();
    JButton addAlternateSection = null;
    JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    UserPreferencesManager pref;
    String systemNameAuto = String.valueOf(this.getClass().getName()) + ".AutoSystemName";
    private int activeRow = 0;
    private SpecialActionTableModel actionTableModel = null;
    private JmriJFrame actionTableFrame = null;
    private final JLabel fixedSectionLabel = new JLabel("X");
    private boolean editActionMode = false;
    private JmriJFrame addEditActionFrame = null;
    private TransitSectionAction curTSA = null;
    private final JComboBox<String> whenBox = new JComboBox();
    private final NamedBeanComboBox<Sensor> whenSensorComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SensorManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final JSpinner whenDataSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 65500, 1));
    private final JComboBox<String> whatBox = new JComboBox();
    private final JSpinner whatPercentSpinner = new JSpinner();
    private final JSpinner whatMinuteSpinner1 = new JSpinner(new SpinnerNumberModel(1, 1, 65500, 1));
    private final JSpinner whatMinuteSpinner2 = new JSpinner(new SpinnerNumberModel(100, 100, 65500, 1));
    private final JSpinner locoFunctionSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 28, 1));
    private final JTextField whatStringField = new JTextField(12);
    private JButton updateActionButton = null;
    private JButton createActionButton = null;
    private JButton cancelAddEditActionButton = null;
    private final JComboBox<String> blockBox = new JComboBox();
    private List<Block> blockList = new ArrayList<Block>();
    private final JRadioButton onButton = new JRadioButton(Bundle.getMessage("StateOn"));
    private final JRadioButton offButton = new JRadioButton(Bundle.getMessage("StateOff"));
    private final JLabel doneSensorLabel = new JLabel(rbx.getString("DoneSensorLabel"));
    private JPanel signalPanel;
    private final NamedBeanComboBox<Sensor> doneSensorComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SensorManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final NamedBeanComboBox<SignalMast> signalMastComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalMastManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final NamedBeanComboBox<SignalHead> signalHeadComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalHeadManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private int tWhen = 0;
    private int tWhenData = 0;
    private String tWhenString = "";
    private int tWhat = 0;
    private int tWhatData1 = 0;
    private int tWhatData2 = 0;
    private String tWhatString = "";
    private static final Logger log = LoggerFactory.getLogger(TransitTableAction.class);

    public TransitTableAction(String actionName) {
        super(actionName);
        this.transitManager = InstanceManager.getNullableDefault(TransitManager.class);
        if (this.sectionManager == null || this.transitManager == null) {
            super.setEnabled(false);
        }
        this.updateSensorList();
    }

    public TransitTableAction() {
        this(Bundle.getMessage("TitleTransitTable"));
    }

    @Override
    protected void createModel() {
        this.m = new BeanTableDataModel<Transit>(){
            public static final int EDITCOL = 5;
            public static final int DUPLICATECOL = 6;

            @Override
            public String getValue(String name) {
                if (name == null) {
                    log.warn("requested getValue(null)");
                    return "(no name)";
                }
                Transit z = (Transit)InstanceManager.getDefault(TransitManager.class).getBySystemName(name);
                if (z == null) {
                    log.debug("requested getValue(\"{}\"), Transit doesn't exist", (Object)name);
                    return "(no Transit)";
                }
                return "Transit";
            }

            public TransitManager getManager() {
                return InstanceManager.getDefault(TransitManager.class);
            }

            @Override
            public Transit getBySystemName(@Nonnull String name) {
                return (Transit)InstanceManager.getDefault(TransitManager.class).getBySystemName(name);
            }

            @Override
            public Transit getByUserName(@Nonnull String name) {
                return (Transit)InstanceManager.getDefault(TransitManager.class).getByUserName(name);
            }

            @Override
            protected String getMasterClassName() {
                return TransitTableAction.this.getClassName();
            }

            @Override
            public void clickOn(Transit t) {
            }

            @Override
            public int getColumnCount() {
                return 7;
            }

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 2: {
                        if (row >= this.sysNameList.size()) {
                            log.debug("row is greater than name list");
                            return "";
                        }
                        Transit z = this.getBySystemName((String)this.sysNameList.get(row));
                        if (z == null) {
                            return "";
                        }
                        int state = z.getState();
                        if (state == 2) {
                            return rbx.getString("TransitIdle");
                        }
                        if (state != 4) break;
                        return rbx.getString("TransitAssigned");
                    }
                    case 5: {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    case 6: {
                        return rbx.getString("ButtonDuplicate");
                    }
                    default: {
                        return super.getValueAt(row, col);
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                switch (col) {
                    case 5: {
                        SwingUtilities.invokeLater(() -> TransitTableAction.this.editPressed(((Transit)this.getValueAt(row, 0)).getSystemName()));
                        break;
                    }
                    case 6: {
                        SwingUtilities.invokeLater(() -> TransitTableAction.this.duplicatePressed(((Transit)this.getValueAt(row, 0)).getSystemName()));
                        break;
                    }
                    default: {
                        super.setValueAt(value, row, col);
                    }
                }
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 5: 
                    case 6: {
                        return "";
                    }
                }
                return super.getColumnName(col);
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 2: {
                        return String.class;
                    }
                    case 5: 
                    case 6: {
                        return JButton.class;
                    }
                }
                return super.getColumnClass(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 2: {
                        return false;
                    }
                    case 5: 
                    case 6: {
                        return true;
                    }
                }
                return super.isCellEditable(row, col);
            }

            @Override
            public int getPreferredWidth(int col) {
                switch (col) {
                    case 0: {
                        return new JTextField((int)9).getPreferredSize().width;
                    }
                    case 1: {
                        return new JTextField((int)17).getPreferredSize().width;
                    }
                    case 2: 
                    case 5: {
                        return new JTextField((int)6).getPreferredSize().width;
                    }
                    case 6: {
                        return new JTextField((int)10).getPreferredSize().width;
                    }
                }
                return super.getPreferredWidth(col);
            }

            @Override
            public void configValueColumn(JTable table) {
            }

            @Override
            protected boolean matchPropertyName(PropertyChangeEvent e) {
                return true;
            }

            @Override
            public JButton configureButton() {
                log.error("configureButton should not have been called");
                return null;
            }

            @Override
            public void configureTable(JTable table) {
                InstanceManager.getDefault(SensorManager.class).addPropertyChangeListener(this);
                super.configureTable(table);
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getSource() instanceof SensorManager && (e.getPropertyName().equals("DisplayListName") || e.getPropertyName().equals("length"))) {
                    TransitTableAction.this.updateSensorList();
                }
                super.propertyChange(e);
            }

            @Override
            public void dispose() {
                InstanceManager.getDefault(SensorManager.class).removePropertyChangeListener(this);
                super.dispose();
            }
        };
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleTransitTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.TransitTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.editMode = false;
        this.duplicateMode = false;
        if (this.sectionManager.getNamedBeanSet().size() > 0) {
            this.addEditPressed();
        } else {
            JOptionPane.showMessageDialog(null, rbx.getString("Message21"), Bundle.getMessage("ErrorTitle"), 0);
        }
    }

    void editPressed(String sName) {
        this.curTransit = (Transit)this.transitManager.getBySystemName(sName);
        if (this.curTransit == null) {
            return;
        }
        this.sysNameFixed.setText(sName);
        this.editMode = true;
        this.duplicateMode = false;
        this.addEditPressed();
    }

    void duplicatePressed(String sName) {
        this.curTransit = (Transit)this.transitManager.getBySystemName(sName);
        if (this.curTransit == null) {
            return;
        }
        this.duplicateMode = true;
        this.editMode = false;
        this.addEditPressed();
    }

    void addEditPressed() {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddTransit"));
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.TransitAddEdit", true);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.sysNameLabel);
            this.sysNameLabel.setLabelFor(this.sysName);
            p.add(this.sysNameFixed);
            p.add(this.sysName);
            p.add(this._autoSystemName);
            this._autoSystemName.addActionListener(e -> this.autoSystemName());
            if (this.pref.getSimplePreferenceState(this.systemNameAuto)) {
                this._autoSystemName.setSelected(true);
            }
            this.sysName.setToolTipText(rbx.getString("TransitSystemNameHint"));
            this.addFrame.getContentPane().add(p);
            p = new JPanel();
            p.add(this.userNameLabel);
            this.userNameLabel.setLabelFor(this.userName);
            p.add(this.userName);
            this.userName.setToolTipText(rbx.getString("TransitUserNameHint"));
            this.addFrame.getContentPane().add(p);
            this.addFrame.getContentPane().add(new JSeparator());
            JPanel p1 = new JPanel();
            p1.setLayout(new BoxLayout(p1, 1));
            JPanel p11 = new JPanel();
            p11.setLayout(new FlowLayout());
            p11.add(new JLabel(rbx.getString("SectionTableMessage")));
            p1.add(p11);
            JPanel p12 = new JPanel();
            p12.setLayout(new BorderLayout());
            this.sectionTableModel = new SectionTableModel();
            JTable sectionTable = new JTable(this.sectionTableModel);
            sectionTable.setDefaultRenderer(JComboBox.class, new ValueRenderer());
            sectionTable.setDefaultEditor(JComboBox.class, new ValueEditor());
            sectionTable.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
            sectionTable.setRowSelectionAllowed(false);
            TableColumnModel sectionColumnModel = sectionTable.getColumnModel();
            TableColumn sequenceColumn = sectionColumnModel.getColumn(0);
            sequenceColumn.setResizable(true);
            sequenceColumn.setMinWidth(50);
            sequenceColumn.setMaxWidth(70);
            TableColumn sectionColumn = sectionColumnModel.getColumn(1);
            sectionColumn.setResizable(true);
            sectionColumn.setMinWidth(150);
            TableColumn actionColumn = sectionColumnModel.getColumn(2);
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            sectionTable.setDefaultRenderer(JButton.class, buttonRenderer);
            ButtonEditor buttonEditor = new ButtonEditor(new JButton());
            sectionTable.setDefaultEditor(JButton.class, buttonEditor);
            JButton testButton = new JButton(rbx.getString("AddEditActions"));
            sectionTable.setRowHeight(testButton.getPreferredSize().height);
            actionColumn.setResizable(false);
            actionColumn.setMinWidth(testButton.getPreferredSize().width);
            TableColumn directionColumn = sectionColumnModel.getColumn(3);
            directionColumn.setResizable(true);
            String s = rbx.getString("DirectionColName");
            directionColumn.setMinWidth((int)new JLabel(s.substring(1, Math.min(s.length(), 7))).getPreferredSize().getWidth());
            directionColumn.setMaxWidth((int)new JLabel(rbx.getString("DirectionColName").concat("WW")).getPreferredSize().getWidth());
            TableColumn alternateColumn = sectionColumnModel.getColumn(4);
            alternateColumn.setResizable(true);
            s = rbx.getString("AlternateColName");
            alternateColumn.setMinWidth((int)new JLabel(s.substring(1, Math.min(s.length(), 7))).getPreferredSize().getWidth());
            alternateColumn.setMaxWidth((int)new JLabel(rbx.getString("AlternateColName").concat("WW")).getPreferredSize().getWidth());
            JScrollPane sectionTableScrollPane = new JScrollPane(sectionTable);
            p12.add((Component)sectionTableScrollPane, "Center");
            p1.add(p12);
            JPanel p13 = new JPanel();
            p13.add(this.primarySectionBox);
            this.primarySectionBox.setToolTipText(rbx.getString("PrimarySectionBoxHint"));
            this.addNextSection = new JButton(rbx.getString("AddPrimaryButton"));
            p13.add(this.addNextSection);
            this.addAsSafe = new JCheckBox(Bundle.getMessage("TransitSectionIsSafe"));
            p13.add(this.addAsSafe);
            this.addAsSafe.setToolTipText(Bundle.getMessage("TransitSectionIsSafeHint"));
            JPanel p13A = new JPanel();
            p13A.add(new JLabel(Bundle.getMessage("PauseAllocationOnSensorActive")));
            this.stopAllocatingSensorBox = new JComboBox<String>(this.sensorList);
            p13A.add(this.stopAllocatingSensorBox);
            JComboBoxUtil.setupComboBoxMaxRows(this.stopAllocatingSensorBox);
            p13.add(p13A);
            this.stopAllocatingSensorBox.setToolTipText(Bundle.getMessage("PauseAllocationOnSensorActiveHint"));
            this.addNextSection.addActionListener(this::addNextSectionPressed);
            this.addNextSection.setToolTipText(rbx.getString("AddPrimaryButtonHint"));
            p13.setLayout(new FlowLayout());
            p1.add(p13);
            JPanel p14 = new JPanel();
            p14.setLayout(new FlowLayout());
            p14.add(this.alternateSectionBox);
            this.alternateSectionBox.setToolTipText(rbx.getString("AlternateSectionBoxHint"));
            this.addAlternateSection = new JButton(rbx.getString("AddAlternateButton"));
            p14.add(this.addAlternateSection);
            this.addAlternateSection.addActionListener(this::addAlternateSectionPressed);
            this.addAlternateSection.setToolTipText(rbx.getString("AddAlternateButtonHint"));
            p14.add(new JLabel("        "));
            p14.add(this.insertAtBeginningBox);
            this.insertAtBeginningBox.setToolTipText(rbx.getString("InsertAtBeginningBoxHint"));
            this.insertAtBeginning = new JButton(rbx.getString("InsertAtBeginningButton"));
            p14.add(this.insertAtBeginning);
            this.insertAtBeginning.addActionListener(this::insertAtBeginningPressed);
            this.insertAtBeginning.setToolTipText(rbx.getString("InsertAtBeginningButtonHint"));
            p1.add(p14);
            p1.add(new JSeparator());
            JPanel p15 = new JPanel();
            p15.setLayout(new FlowLayout());
            this.deleteSections = new JButton(rbx.getString("DeleteSectionsButton"));
            p15.add(this.deleteSections);
            this.deleteSections.addActionListener(this::deleteAllSections);
            this.deleteSections.setToolTipText(rbx.getString("DeleteSectionsButtonHint"));
            p15.add(new JLabel("  "));
            this.removeLastSection = new JButton(rbx.getString("RemoveLastButton"));
            p15.add(this.removeLastSection);
            this.removeLastSection.addActionListener(this::removeLastSectionPressed);
            this.removeLastSection.setToolTipText(rbx.getString("RemoveLastButtonHint"));
            p15.add(new JLabel("  "));
            this.removeFirstSection = new JButton(rbx.getString("RemoveFirstButton"));
            p15.add(this.removeFirstSection);
            this.removeFirstSection.addActionListener(this::removeFirstSectionPressed);
            this.removeFirstSection.setToolTipText(rbx.getString("RemoveFirstButtonHint"));
            p1.add(p15);
            JPanel p16 = new JPanel();
            p16.setLayout(new FlowLayout());
            p16.add(this.seqNumLabel);
            p16.add(this.seqNum);
            this.seqNum.setToolTipText(rbx.getString("SeqNumHint"));
            p1.add(p16);
            JPanel p17 = new JPanel();
            p17.setLayout(new FlowLayout());
            this.replacePrimaryForSequence = new JButton(rbx.getString("ReplacePrimaryForSeqButton"));
            p17.add(this.replacePrimaryForSequence);
            this.replacePrimaryForSequence.addActionListener(this::replacePrimaryForSeqPressed);
            this.replacePrimaryForSequence.setToolTipText(rbx.getString("ReplacePrimaryForSeqButtonHint"));
            p17.add(new JLabel("  "));
            this.deleteAlternateForSequence = new JButton(rbx.getString("DeleteAlternateForSeqButton"));
            p17.add(this.deleteAlternateForSequence);
            this.deleteAlternateForSequence.addActionListener(this::deleteAlternateForSeqPressed);
            this.deleteAlternateForSequence.setToolTipText(rbx.getString("DeleteAlternateForSeqButtonHint"));
            p17.add(new JLabel("  "));
            this.addAlternateForSequence = new JButton(rbx.getString("AddAlternateForSeqButton"));
            p17.add(this.addAlternateForSequence);
            this.addAlternateForSequence.addActionListener(this::addAlternateForSeqPressed);
            this.addAlternateForSequence.setToolTipText(rbx.getString("AddAlternateForSeqButtonHint"));
            p1.add(p17);
            this.addFrame.getContentPane().add(p1);
            this.addFrame.getContentPane().add(new JSeparator());
            JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
            JPanel pb = new JPanel();
            pb.setLayout(new FlowLayout());
            pb.add(cancel);
            cancel.addActionListener(this::cancelPressed);
            cancel.setToolTipText(rbx.getString("CancelButtonHint"));
            this.create = new JButton(Bundle.getMessage("ButtonCreate"));
            pb.add(this.create);
            this.create.addActionListener(this::createPressed);
            this.create.setToolTipText(rbx.getString("SectionCreateButtonHint"));
            this.update = new JButton(Bundle.getMessage("ButtonUpdate"));
            pb.add(this.update);
            this.update.addActionListener(this::updatePressed);
            this.update.setToolTipText(rbx.getString("SectionUpdateButtonHint"));
            this.addFrame.getContentPane().add(pb);
        }
        if (this.editMode) {
            this.addFrame.setTitle(Bundle.getMessage("TitleEditTransit"));
            this._autoSystemName.setVisible(false);
            this.sysNameLabel.setEnabled(true);
            this.create.setVisible(false);
            this.update.setVisible(true);
            this.sysName.setVisible(false);
            this.sysNameFixed.setVisible(true);
            this.addFrame.getRootPane().setDefaultButton(this.update);
            this.initializeEditInformation();
        } else {
            this.addFrame.setTitle(Bundle.getMessage("TitleAddTransit"));
            this._autoSystemName.setVisible(true);
            this._autoSystemName.setEnabled(true);
            this.autoSystemName();
            this.create.setVisible(true);
            this.create.setEnabled(true);
            this.update.setVisible(false);
            this.sysName.setVisible(true);
            this.sysNameFixed.setVisible(false);
            this.addFrame.getRootPane().setDefaultButton(this.create);
            if (this.duplicateMode) {
                this.initializeEditInformation();
                this.sysName.setText(this.curTransit.getSystemName());
                this.curTransit = null;
            } else {
                this.deleteAllSections(null);
            }
        }
        this.initializeSectionCombos();
        this.updateSeqNum();
        this.addFrame.setEscapeKeyClosesWindow(true);
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    private void initializeEditInformation() {
        this.sectionList.clear();
        this.sequence.clear();
        this.action.clear();
        this.direction.clear();
        this.alternate.clear();
        this.safe.clear();
        this.sensorStopAllocation.clear();
        this.curSection = null;
        this.curSectionDirection = 0;
        this.curSequenceNum = 0;
        this.prevSection = null;
        this.prevSectionDirection = 0;
        if (this.curTransit != null) {
            this.userName.setText(this.curTransit.getUserName());
            ArrayList<TransitSection> tsList = this.curTransit.getTransitSectionList();
            int i = 0;
            while (i < tsList.size()) {
                TransitSection ts = (TransitSection)tsList.get(i);
                if (ts != null) {
                    this.sectionList.add(ts.getSection());
                    this.sequence.add(ts.getSequenceNumber());
                    this.direction.add(ts.getDirection());
                    this.action.add(ts.getTransitSectionActionList());
                    this.alternate.add(ts.isAlternate());
                    this.safe.add(ts.isSafe());
                    this.sensorStopAllocation.add(ts.getStopAllocatingSensor());
                }
                ++i;
            }
            int index = this.sectionList.size() - 1;
            if (index >= this.alternate.size()) {
                index = this.alternate.size() - 1;
            }
            while (this.alternate.get(index).booleanValue() && index > 0) {
                --index;
            }
            if (index >= 0) {
                this.curSection = this.sectionList.get(index);
                this.curSequenceNum = this.sequence.get(index);
                if (index > 0) {
                    this.curSectionDirection = this.direction.get(index);
                }
                --index;
                while (index >= 0 && this.alternate.get(index).booleanValue()) {
                    --index;
                }
                if (index >= 0) {
                    this.prevSection = this.sectionList.get(index);
                    this.prevSectionDirection = this.direction.get(index);
                }
            }
        }
        this.sectionTableModel.fireTableDataChanged();
    }

    private void deleteAllSections(ActionEvent e) {
        this.sectionList.clear();
        this.direction.clear();
        this.sequence.clear();
        this.action.clear();
        this.alternate.clear();
        this.safe.clear();
        this.sensorStopAllocation.clear();
        this.curSection = null;
        this.curSectionDirection = 0;
        this.prevSection = null;
        this.prevSectionDirection = 0;
        this.curSequenceNum = 0;
        this.initializeSectionCombos();
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void addNextSectionPressed(ActionEvent e) {
        if (this.primarySectionBoxList.isEmpty()) {
            JOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message25"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int index = this.primarySectionBox.getSelectedIndex();
        Section s = this.primarySectionBoxList.get(index);
        if (s != null) {
            int j = this.sectionList.size();
            this.sectionList.add(s);
            this.direction.add(this.priSectionDirection.get(index));
            ++this.curSequenceNum;
            this.sequence.add(this.curSequenceNum);
            this.safe.add(this.addAsSafe.isSelected());
            if (this.stopAllocatingSensorBox.getSelectedIndex() >= 0) {
                this.sensorStopAllocation.add((String)this.stopAllocatingSensorBox.getSelectedItem());
            } else {
                this.sensorStopAllocation.add("");
            }
            this.action.add(new ArrayList());
            this.alternate.add(false);
            if (this.sectionList.size() == 2 && this.curSection != null) {
                if (this.forwardConnected(this.curSection, s, 0)) {
                    this.direction.set(0, 8);
                }
                this.curSectionDirection = this.direction.get(0);
            }
            this.prevSection = this.curSection;
            this.prevSectionDirection = this.curSectionDirection;
            this.curSection = s;
            if (this.prevSection != null) {
                this.curSectionDirection = this.direction.get(j);
            }
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void removeLastSectionPressed(ActionEvent e) {
        if (this.sectionList.size() <= 1) {
            this.deleteAllSections(e);
        } else {
            int j = this.sectionList.size() - 1;
            if (!this.alternate.get(j).booleanValue()) {
                --this.curSequenceNum;
                this.curSection = this.sectionList.get(j - 1);
                this.curSectionDirection = this.direction.get(j - 1);
                int k = j - 2;
                while (k >= 0 && this.alternate.get(k).booleanValue()) {
                    --k;
                }
                if (k < 0) {
                    this.prevSection = null;
                } else {
                    this.prevSection = this.sectionList.get(k);
                    this.prevSectionDirection = this.direction.get(k);
                }
            }
            this.sectionList.remove(j);
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void insertAtBeginningPressed(ActionEvent e) {
        if (this.insertAtBeginningBoxList.isEmpty()) {
            JOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message35"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int index = this.insertAtBeginningBox.getSelectedIndex();
        Section s = this.insertAtBeginningBoxList.get(index);
        if (s != null) {
            this.sectionList.add(0, s);
            this.direction.add(0, this.insertAtBeginningDirection.get(index));
            ++this.curSequenceNum;
            this.sequence.add(0, 1);
            this.alternate.add(0, false);
            this.safe.add(0, this.addAsSafe.isSelected());
            this.sensorStopAllocation.add(0, "");
            this.action.add(0, new ArrayList());
            if (this.curSequenceNum == 2) {
                this.prevSectionDirection = this.direction.get(0);
                this.prevSection = s;
            }
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void removeFirstSectionPressed(ActionEvent e) {
        if (this.curSequenceNum <= 1) {
            this.deleteAllSections(e);
        } else {
            int keep = 1;
            while (this.alternate.get(keep).booleanValue()) {
                ++keep;
            }
            int c = 0;
            while (c < keep) {
                this.sequence.remove(0);
                this.direction.remove(0);
                this.action.remove(0);
                this.alternate.remove(0);
                this.safe.remove(0);
                this.sensorStopAllocation.remove(0);
                this.sectionList.remove(0);
                --this.curSequenceNum;
                ++c;
            }
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void replacePrimaryForSeqPressed(ActionEvent e) {
        int seq = this.getSeqNum();
        if (seq == 0) {
            return;
        }
        Section sOld = null;
        ArrayList<Section> altOldList = new ArrayList<Section>();
        Section beforeSection = null;
        int beforeSectionDirection = 0;
        Section afterSection = null;
        int afterSectionDirection = 0;
        int index = -1;
        int i = 0;
        while (i < this.sectionList.size()) {
            if (this.sequence.get(i) == seq && !this.alternate.get(i).booleanValue()) {
                sOld = this.sectionList.get(i);
                index = i;
            }
            if (this.sequence.get(i) == seq && this.alternate.get(i).booleanValue()) {
                altOldList.add(this.sectionList.get(i));
            }
            if (this.sequence.get(i) == seq - 1 && !this.alternate.get(i).booleanValue()) {
                beforeSection = this.sectionList.get(i);
                beforeSectionDirection = this.direction.get(i);
            }
            if (this.sequence.get(i) == seq + 1 && !this.alternate.get(i).booleanValue()) {
                afterSection = this.sectionList.get(i);
                afterSectionDirection = 4;
                if (afterSectionDirection == this.direction.get(i)) {
                    afterSectionDirection = 8;
                }
            }
            ++i;
        }
        if (sOld == null) {
            log.error("Missing primary Section for seq = {}", (Object)seq);
            return;
        }
        ArrayList<Section> possibles = new ArrayList<Section>();
        ArrayList<Integer> possiblesDirection = new ArrayList<Integer>();
        ArrayList<String> possibleNames = new ArrayList<String>();
        for (Section s : this.sectionManager.getNamedBeanSet()) {
            Section mayBeSection = null;
            String mayBeName = s.getDisplayName();
            int mayBeDirection = 0;
            if (s == sOld || s == beforeSection || s == afterSection || this.inSectionList(s, altOldList)) continue;
            if (beforeSection != null) {
                if (this.forwardConnected(s, beforeSection, beforeSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 4;
                } else if (this.reverseConnected(s, beforeSection, beforeSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 8;
                }
                if (mayBeSection != null && afterSection != null) {
                    if (mayBeDirection == 8) {
                        if (!this.forwardConnected(s, afterSection, afterSectionDirection)) {
                            mayBeSection = null;
                        }
                    } else if (!this.reverseConnected(s, afterSection, afterSectionDirection)) {
                        mayBeSection = null;
                    }
                }
            } else if (afterSection != null) {
                if (this.forwardConnected(s, afterSection, afterSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 8;
                } else if (this.reverseConnected(s, afterSection, afterSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 4;
                }
            } else {
                mayBeSection = s;
                mayBeDirection = 4;
            }
            if (mayBeSection == null) continue;
            possibles.add(mayBeSection);
            possiblesDirection.add(mayBeDirection);
            possibleNames.add(mayBeName);
        }
        if (possibles.isEmpty()) {
            JOptionPane.showMessageDialog(this.addFrame, MessageFormat.format(rbx.getString("Message36"), "" + seq), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int k = 0;
        if (possibles.size() > 1) {
            Object[] choices = new Object[possibles.size()];
            int j = 0;
            while (j < possibles.size()) {
                choices[j] = possibleNames.get(j);
                ++j;
            }
            Object selName = JOptionPane.showInputDialog(this.addFrame, rbx.getString("ReplacePrimaryChoice"), rbx.getString("ReplacePrimaryTitle"), 3, null, choices, choices[0]);
            if (selName == null) {
                return;
            }
            int j2 = 0;
            while (j2 < possibles.size()) {
                if (selName.equals(choices[j2])) {
                    k = j2;
                }
                ++j2;
            }
        }
        this.sectionList.remove(index);
        this.sectionList.add(index, (Section)possibles.get(k));
        this.direction.set(index, (Integer)possiblesDirection.get(k));
        if (index == this.sectionList.size() - 1) {
            this.curSection = this.sectionList.get(index);
            this.curSectionDirection = this.direction.get(index);
        } else if (index == this.sectionList.size() - 2) {
            this.prevSection = this.sectionList.get(index);
            this.prevSectionDirection = this.direction.get(index);
        }
        this.initializeSectionCombos();
        this.sectionTableModel.fireTableDataChanged();
    }

    boolean inSectionList(Section s, List<Section> sList) {
        int i = 0;
        while (i < sList.size()) {
            if (sList.get(i) == s) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int getSeqNum() {
        int n = (Integer)this.seqNum.getValue();
        if (n > this.curSequenceNum) {
            JOptionPane.showMessageDialog(null, rbx.getString("Message34"), Bundle.getMessage("ErrorTitle"), 0);
            return 0;
        }
        return n;
    }

    void updateSeqNum() {
        int seqMax = 0;
        int seqNumber = 0;
        int ix = 0;
        while (ix < this.alternate.size()) {
            if (!this.alternate.get(ix).booleanValue()) {
                ++seqNumber;
            }
            this.sequence.set(ix, seqNumber);
            ++ix;
        }
        seqMax = seqNumber;
        this.seqNum.setModel(new SpinnerNumberModel(seqMax, Math.min(seqMax, 1), seqMax, 1));
        this.seqNum.setValue(Math.min(seqMax, 1));
    }

    void deleteAlternateForSeqPressed(ActionEvent e) {
        if (this.sectionList.size() <= 1) {
            this.deleteAllSections(e);
        } else {
            int seq = this.getSeqNum();
            if (seq == 0) {
                return;
            }
            int i = this.sectionList.size();
            while (i >= seq) {
                if (this.sequence.get(i) == seq && this.alternate.get(i).booleanValue()) {
                    this.sequence.remove(i);
                    this.direction.remove(i);
                    this.action.remove(i);
                    this.alternate.remove(i);
                    this.safe.remove(i);
                    this.sensorStopAllocation.remove(i);
                    this.sectionList.remove(i);
                }
                --i;
            }
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void addAlternateForSeqPressed(ActionEvent e) {
        int seq = this.getSeqNum();
        if (seq == 0) {
            return;
        }
        Section primarySection = null;
        ArrayList<Section> altOldList = new ArrayList<Section>();
        Section beforeSection = null;
        int beforeSectionDirection = 0;
        Section afterSection = null;
        int afterSectionDirection = 0;
        int index = -1;
        int i = 0;
        while (i < this.sectionList.size()) {
            if (this.sequence.get(i) == seq && !this.alternate.get(i).booleanValue()) {
                primarySection = this.sectionList.get(i);
                index = i;
            }
            if (this.sequence.get(i) == seq && this.alternate.get(i).booleanValue()) {
                altOldList.add(this.sectionList.get(i));
            }
            if (this.sequence.get(i) == seq - 1 && !this.alternate.get(i).booleanValue()) {
                beforeSection = this.sectionList.get(i);
                beforeSectionDirection = this.direction.get(i);
            }
            if (this.sequence.get(i) == seq + 1 && !this.alternate.get(i).booleanValue()) {
                afterSection = this.sectionList.get(i);
                afterSectionDirection = 4;
                if (afterSectionDirection == this.direction.get(i)) {
                    afterSectionDirection = 8;
                }
            }
            ++i;
        }
        if (primarySection == null) {
            log.error("Missing primary Section for seq = {}", (Object)seq);
            return;
        }
        ArrayList<Section> possibles = new ArrayList<Section>();
        ArrayList<Integer> possiblesDirection = new ArrayList<Integer>();
        ArrayList<String> possibleNames = new ArrayList<String>();
        for (Section s : this.sectionManager.getNamedBeanSet()) {
            Section mayBeSection = null;
            String mayBeName = s.getDisplayName();
            int mayBeDirection = 0;
            if (s == primarySection || s == beforeSection || s == afterSection || this.inSectionList(s, altOldList)) continue;
            if (beforeSection != null) {
                if (this.forwardConnected(s, beforeSection, beforeSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 4;
                } else if (this.reverseConnected(s, beforeSection, beforeSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 8;
                }
                if (mayBeSection != null && afterSection != null) {
                    if (mayBeDirection == 8) {
                        if (!this.forwardConnected(s, afterSection, afterSectionDirection)) {
                            mayBeSection = null;
                        }
                    } else if (!this.reverseConnected(s, afterSection, afterSectionDirection)) {
                        mayBeSection = null;
                    }
                }
            } else if (afterSection != null) {
                if (this.forwardConnected(s, afterSection, afterSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 8;
                } else if (this.reverseConnected(s, afterSection, afterSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 4;
                }
            } else {
                mayBeSection = s;
                mayBeDirection = 4;
            }
            if (mayBeSection == null) continue;
            possibles.add(mayBeSection);
            possiblesDirection.add(mayBeDirection);
            possibleNames.add(mayBeName);
        }
        if (possibles.isEmpty()) {
            JOptionPane.showMessageDialog(this.addFrame, MessageFormat.format(rbx.getString("Message37"), "" + seq), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int k = 0;
        if (possibles.size() > 1) {
            Object[] choices = new Object[possibles.size()];
            int j = 0;
            while (j < possibles.size()) {
                choices[j] = possibleNames.get(j);
                ++j;
            }
            Object selName = JOptionPane.showInputDialog(this.addFrame, rbx.getString("AddAlternateChoice"), rbx.getString("AddAlternateTitle"), 3, null, choices, choices[0]);
            if (selName == null) {
                return;
            }
            int j2 = 0;
            while (j2 < possibles.size()) {
                if (selName.equals(choices[j2])) {
                    k = j2;
                }
                ++j2;
            }
        }
        index = index + 1 + altOldList.size();
        this.sectionList.add(index, (Section)possibles.get(k));
        this.direction.add(index, (Integer)possiblesDirection.get(k));
        this.sequence.add(index, this.sequence.get(index - 1));
        this.alternate.add(index, true);
        this.safe.add(index, this.addAsSafe.isSelected());
        if (this.stopAllocatingSensorBox.getSelectedIndex() < 0) {
            this.sensorStopAllocation.add(index, "");
        } else {
            this.sensorStopAllocation.add(index, (String)this.stopAllocatingSensorBox.getSelectedItem());
        }
        this.action.add(index, new ArrayList());
        this.initializeSectionCombos();
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void addAlternateSectionPressed(ActionEvent e) {
        if (this.alternateSectionBoxList.isEmpty()) {
            JOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message24"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int index = this.alternateSectionBox.getSelectedIndex();
        Section s = this.alternateSectionBoxList.get(index);
        if (s != null) {
            this.sectionList.add(s);
            this.direction.add(this.altSectionDirection.get(index));
            this.sequence.add(this.curSequenceNum);
            this.action.add(new ArrayList());
            this.alternate.add(true);
            this.safe.add(this.addAsSafe.isSelected());
            this.sensorStopAllocation.add((String)this.stopAllocatingSensorBox.getSelectedItem());
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void createPressed(ActionEvent e) {
        if (!this.checkTransitInformation()) {
            return;
        }
        String uName = this.userName.getText();
        if (uName.isEmpty()) {
            uName = null;
        }
        try {
            if (this._autoSystemName.isSelected()) {
                this.curTransit = this.transitManager.createNewTransit(uName);
            } else {
                String sName = this.sysName.getText();
                this.curTransit = this.transitManager.createNewTransit(sName, uName);
            }
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(this.addFrame, ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.sysName.setText(this.curTransit.getSystemName());
        this.setTransitInformation();
        this.addFrame.setVisible(false);
        this.pref.setSimplePreferenceState(this.systemNameAuto, this._autoSystemName.isSelected());
    }

    void cancelPressed(ActionEvent e) {
        this.addFrame.setVisible(false);
        this.sectionTableModel.dispose();
        this.addFrame.dispose();
        this.addFrame = null;
    }

    void updatePressed(ActionEvent e) {
        Transit tTransit;
        if (!this.checkTransitInformation()) {
            return;
        }
        String uName = this.userName.getText();
        if (uName.isEmpty()) {
            uName = null;
        }
        if (uName != null && !uName.equals(this.curTransit.getUserName()) && (tTransit = (Transit)this.transitManager.getByUserName(uName)) != null) {
            JOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message22"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.curTransit.setUserName(uName);
        if (this.setTransitInformation()) {
            this.addFrame.setVisible(false);
            this.sectionTableModel.dispose();
            this.addFrame.dispose();
            this.addFrame = null;
        }
    }

    private boolean checkTransitInformation() {
        return true;
    }

    private boolean setTransitInformation() {
        if (this.curTransit == null) {
            return false;
        }
        this.curTransit.removeAllSections();
        int i = 0;
        while (i < this.sectionList.size()) {
            TransitSection ts = new TransitSection(this.sectionList.get(i), (int)this.sequence.get(i), (int)this.direction.get(i), (boolean)this.alternate.get(i), (boolean)this.safe.get(i), this.sensorStopAllocation.get(i));
            List<TransitSectionAction> list = this.action.get(i);
            if (list != null) {
                int j = 0;
                while (j < list.size()) {
                    ts.addAction(list.get(j));
                    ++j;
                }
            }
            this.curTransit.addTransitSection(ts);
            ++i;
        }
        return true;
    }

    private void initializeSectionCombos() {
        this.primarySectionBox.removeAllItems();
        this.alternateSectionBox.removeAllItems();
        this.insertAtBeginningBox.removeAllItems();
        this.primarySectionBoxList.clear();
        this.alternateSectionBoxList.clear();
        this.insertAtBeginningBoxList.clear();
        this.priSectionDirection.clear();
        this.altSectionDirection.clear();
        this.insertAtBeginningDirection.clear();
        if (this.sectionList.isEmpty()) {
            for (Section s : this.sectionManager.getNamedBeanSet()) {
                String sName = s.getDisplayName();
                this.primarySectionBox.addItem(sName);
                this.primarySectionBoxList.add(s);
                this.priSectionDirection.add(4);
            }
        } else {
            String sName;
            for (Section s : this.sectionManager.getNamedBeanSet()) {
                sName = s.getDisplayName();
                if (s != this.prevSection && this.forwardConnected(s, this.curSection, this.curSectionDirection)) {
                    this.primarySectionBox.addItem(sName);
                    this.primarySectionBoxList.add(s);
                    this.priSectionDirection.add(4);
                    continue;
                }
                if (s == this.prevSection || !this.reverseConnected(s, this.curSection, this.curSectionDirection)) continue;
                this.primarySectionBox.addItem(sName);
                this.primarySectionBoxList.add(s);
                this.priSectionDirection.add(8);
            }
            if (this.prevSection != null) {
                for (Section s : this.sectionManager.getNamedBeanSet()) {
                    sName = s.getDisplayName();
                    if (this.notIncludedWithSeq(s, this.curSequenceNum) && this.forwardConnected(s, this.prevSection, this.prevSectionDirection)) {
                        this.alternateSectionBox.addItem(sName);
                        this.alternateSectionBoxList.add(s);
                        this.altSectionDirection.add(4);
                        continue;
                    }
                    if (!this.notIncludedWithSeq(s, this.curSequenceNum) || !this.reverseConnected(s, this.prevSection, this.prevSectionDirection)) continue;
                    this.alternateSectionBox.addItem(sName);
                    this.alternateSectionBoxList.add(s);
                    this.altSectionDirection.add(8);
                }
            }
            Section firstSection = this.sectionList.get(0);
            int testDirection = 4;
            if (this.direction.get(0) == 4) {
                testDirection = 8;
            }
            for (Section s : this.sectionManager.getNamedBeanSet()) {
                String sName2 = s.getDisplayName();
                if (s != firstSection && this.forwardConnected(s, firstSection, testDirection)) {
                    this.insertAtBeginningBox.addItem(sName2);
                    this.insertAtBeginningBoxList.add(s);
                    this.insertAtBeginningDirection.add(8);
                    continue;
                }
                if (s == firstSection || !this.reverseConnected(s, firstSection, testDirection)) continue;
                this.insertAtBeginningBox.addItem(sName2);
                this.insertAtBeginningBoxList.add(s);
                this.insertAtBeginningDirection.add(4);
            }
        }
        JComboBoxUtil.setupComboBoxMaxRows(this.primarySectionBox);
        JComboBoxUtil.setupComboBoxMaxRows(this.alternateSectionBox);
        JComboBoxUtil.setupComboBoxMaxRows(this.insertAtBeginningBox);
    }

    private boolean forwardConnected(Section s1, Section s2, int restrictedDirection) {
        if (s1 != null && s2 != null) {
            List<EntryPoint> s2Entries;
            List<EntryPoint> s1ForwardEntries = s1.getForwardEntryPointList();
            switch (restrictedDirection) {
                case 4: {
                    s2Entries = s2.getReverseEntryPointList();
                    break;
                }
                case 8: {
                    s2Entries = s2.getForwardEntryPointList();
                    break;
                }
                default: {
                    s2Entries = s2.getEntryPointList();
                }
            }
            int i = 0;
            while (i < s1ForwardEntries.size()) {
                Block b1 = s1ForwardEntries.get(i).getFromBlock();
                int j = 0;
                while (j < s2Entries.size()) {
                    Block b2 = s2Entries.get(j).getFromBlock();
                    if (b1 == s2Entries.get(j).getBlock() && b2 == s1ForwardEntries.get(i).getBlock()) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean reverseConnected(Section s1, Section s2, int restrictedDirection) {
        if (s1 != null && s2 != null) {
            List<EntryPoint> s2Entries;
            List<EntryPoint> s1ReverseEntries = s1.getReverseEntryPointList();
            switch (restrictedDirection) {
                case 4: {
                    s2Entries = s2.getReverseEntryPointList();
                    break;
                }
                case 8: {
                    s2Entries = s2.getForwardEntryPointList();
                    break;
                }
                default: {
                    s2Entries = s2.getEntryPointList();
                }
            }
            int i = 0;
            while (i < s1ReverseEntries.size()) {
                Block b1 = s1ReverseEntries.get(i).getFromBlock();
                int j = 0;
                while (j < s2Entries.size()) {
                    Block b2 = s2Entries.get(j).getFromBlock();
                    if (b1 == s2Entries.get(j).getBlock() && b2 == s1ReverseEntries.get(i).getBlock()) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean notIncludedWithSeq(Section s, int seq) {
        int i = 0;
        while (i < this.sectionList.size()) {
            if (this.sectionList.get(i) == s && seq == this.sequence.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this.sysName.setEnabled(false);
            this.sysNameLabel.setEnabled(false);
        } else {
            this.sysName.setEnabled(true);
            this.sysNameLabel.setEnabled(true);
        }
    }

    private void addEditActionsPressed(int r) {
        this.activeRow = r;
        if (this.actionTableModel != null) {
            this.actionTableModel.fireTableStructureChanged();
        }
        if (this.actionTableFrame == null) {
            this.actionTableFrame = new JmriJFrame(rbx.getString("TitleViewActions"));
            this.actionTableFrame.addHelpMenu("package.jmri.jmrit.beantable.ViewSpecialActions", true);
            this.actionTableFrame.setLocation(50, 60);
            Container contentPane = this.actionTableFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            JLabel sectionNameLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameSection")));
            panel1.add(sectionNameLabel);
            panel1.add(this.fixedSectionLabel);
            contentPane.add(panel1);
            JPanel pctSpace = new JPanel();
            pctSpace.setLayout(new FlowLayout());
            pctSpace.add(new JLabel("   "));
            contentPane.add(pctSpace);
            JPanel pct = new JPanel();
            this.actionTableModel = new SpecialActionTableModel();
            JTable actionTable = new JTable(this.actionTableModel);
            actionTable.setRowSelectionAllowed(false);
            actionTable.setPreferredScrollableViewportSize(new Dimension(750, 200));
            TableColumnModel actionColumnModel = actionTable.getColumnModel();
            TableColumn whenColumn = actionColumnModel.getColumn(0);
            whenColumn.setResizable(true);
            whenColumn.setMinWidth(270);
            whenColumn.setMaxWidth(300);
            TableColumn whatColumn = actionColumnModel.getColumn(1);
            whatColumn.setResizable(true);
            whatColumn.setMinWidth(290);
            whatColumn.setMaxWidth(350);
            TableColumn editColumn = actionColumnModel.getColumn(2);
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            actionTable.setDefaultRenderer(JButton.class, buttonRenderer);
            ButtonEditor buttonEditor = new ButtonEditor(new JButton());
            actionTable.setDefaultEditor(JButton.class, buttonEditor);
            JButton testButton = new JButton(Bundle.getMessage("ButtonDelete"));
            actionTable.setRowHeight(testButton.getPreferredSize().height);
            editColumn.setResizable(false);
            editColumn.setMinWidth(testButton.getPreferredSize().width);
            TableColumn removeColumn = actionColumnModel.getColumn(3);
            removeColumn.setMinWidth(testButton.getPreferredSize().width);
            removeColumn.setResizable(false);
            JScrollPane actionTableScrollPane = new JScrollPane(actionTable);
            pct.add((Component)actionTableScrollPane, "Center");
            contentPane.add(pct);
            pct.setVisible(true);
            JPanel but = new JPanel();
            but.setLayout(new BoxLayout(but, 1));
            JPanel panel4 = new JPanel();
            panel4.setLayout(new FlowLayout());
            JButton newActionButton = new JButton(rbx.getString("ButtonAddNewAction"));
            panel4.add(newActionButton);
            newActionButton.addActionListener(this::newActionPressed);
            newActionButton.setToolTipText(rbx.getString("NewActionButtonHint"));
            JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
            panel4.add(doneButton);
            doneButton.addActionListener(this::doneWithActionsPressed);
            doneButton.setToolTipText(rbx.getString("DoneButtonHint"));
            but.add(panel4);
            contentPane.add(but);
        }
        this.fixedSectionLabel.setText(String.valueOf(this.getSectionNameByRow(r)) + "    " + rbx.getString("SequenceAbbrev") + ": " + this.sequence.get(r));
        this.actionTableFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TransitTableAction.this.actionTableFrame != null) {
                    TransitTableAction.this.actionTableFrame.setVisible(false);
                    TransitTableAction.this.actionTableFrame.dispose();
                    TransitTableAction.this.actionTableFrame = null;
                }
                if (TransitTableAction.this.addEditActionFrame != null) {
                    TransitTableAction.this.addEditActionFrame.setVisible(false);
                    TransitTableAction.this.addEditActionFrame.dispose();
                    TransitTableAction.this.addEditActionFrame = null;
                }
            }
        });
        this.actionTableFrame.pack();
        this.actionTableFrame.setVisible(true);
    }

    private void doneWithActionsPressed(ActionEvent e) {
        this.actionTableFrame.setVisible(false);
        this.actionTableFrame.dispose();
        this.actionTableFrame = null;
        if (this.addEditActionFrame != null) {
            this.addEditActionFrame.setVisible(false);
            this.addEditActionFrame.dispose();
            this.addEditActionFrame = null;
        }
    }

    private void newActionPressed(ActionEvent e) {
        this.editActionMode = false;
        this.curTSA = null;
        this.addEditActionWindow();
    }

    private void addEditActionWindow() {
        if (this.addEditActionFrame == null) {
            this.addEditActionFrame = new JmriJFrame(rbx.getString("TitleAddAction"));
            this.addEditActionFrame.addHelpMenu("package.jmri.jmrit.beantable.TransitSectionAddEditAction", true);
            this.addEditActionFrame.setLocation(120, 80);
            Container contentPane = this.addEditActionFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panelx = new JPanel();
            panelx.setLayout(new BoxLayout(panelx, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            panel1.add(new JLabel(rbx.getString("WhenText")));
            this.initializeWhenBox();
            JComboBoxUtil.setupComboBoxMaxRows(this.whenBox);
            panel1.add(this.whenBox);
            this.whenBox.addActionListener(e -> {
                log.debug("whenBox was set");
                this.setWhen(this.whenBox.getSelectedIndex() + 1);
            });
            this.whenBox.setToolTipText(rbx.getString("WhenBoxTip"));
            JComboBoxUtil.setupComboBoxMaxRows(this.whenSensorComboBox);
            panel1.add(this.whenSensorComboBox);
            this.whenSensorComboBox.setAllowNull(true);
            this.initializeBlockBox();
            JComboBoxUtil.setupComboBoxMaxRows(this.blockBox);
            panel1.add(this.blockBox);
            panelx.add(panel1);
            JPanel panel11 = new JPanel();
            panel11.setLayout(new FlowLayout());
            panel11.add(new JLabel("    " + rbx.getString("OptionalDelay") + ": "));
            panel11.add(this.whenDataSpinner);
            this.whenDataSpinner.setToolTipText(rbx.getString("HintDelayData"));
            panel11.add(new JLabel(Bundle.getMessage("LabelMilliseconds")));
            panelx.add(panel11);
            JPanel spacer = new JPanel();
            spacer.setLayout(new FlowLayout());
            spacer.add(new JLabel("     "));
            panelx.add(spacer);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            panel2.add(new JLabel(rbx.getString("WhatText")));
            this.initializeWhatBox();
            JComboBoxUtil.setupComboBoxMaxRows(this.whatBox);
            panel2.add(this.whatBox);
            this.whatBox.setToolTipText(rbx.getString("WhatBoxTip"));
            this.whatBox.addActionListener(e -> this.setWhat(this.whatBox.getSelectedIndex() + 1));
            panel2.add(this.whatStringField);
            this.whatStringField.setToolTipText(rbx.getString("HintSoundHornPatternString"));
            panelx.add(panel2);
            JPanel panel21 = new JPanel();
            panel21.setLayout(new FlowLayout());
            this.whatPercentSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.5f), Float.valueOf(0.01f)));
            this.whatPercentSpinner.setEditor(new JSpinner.NumberEditor(this.whatPercentSpinner, "# %"));
            panel21.add(this.whatPercentSpinner);
            panel21.add(this.whatMinuteSpinner1);
            panel21.add(this.whatMinuteSpinner2);
            panel21.add(this.locoFunctionSpinner);
            TitledBorder border = BorderFactory.createTitledBorder(rbx.getString("SelectASignal"));
            this.signalPanel = new JPanel();
            this.signalPanel.setBorder(border);
            this.signalPanel.add(new JLabel(rbx.getString("MastLabel")));
            JComboBoxUtil.setupComboBoxMaxRows(this.signalMastComboBox);
            this.signalPanel.add(this.signalMastComboBox);
            this.signalMastComboBox.setAllowNull(true);
            this.signalMastComboBox.addActionListener(e -> {
                if (this.signalMastComboBox.getSelectedIndex() > 0) {
                    this.signalHeadComboBox.setSelectedIndex(0);
                }
            });
            this.signalPanel.add(new JLabel(rbx.getString("HeadLabel")));
            JComboBoxUtil.setupComboBoxMaxRows(this.signalHeadComboBox);
            this.signalPanel.add(this.signalHeadComboBox);
            this.signalHeadComboBox.setAllowNull(true);
            this.signalHeadComboBox.addActionListener(e -> {
                if (this.signalHeadComboBox.getSelectedIndex() > 0) {
                    this.signalMastComboBox.setSelectedIndex(0);
                }
            });
            this.signalMastComboBox.setToolTipText(rbx.getString("HintSignalEntry"));
            this.signalHeadComboBox.setToolTipText(rbx.getString("HintSignalEntry"));
            panel21.add(this.signalPanel);
            ButtonGroup onOffGroup = new ButtonGroup();
            onOffGroup.add(this.onButton);
            onOffGroup.add(this.offButton);
            panel21.add(this.onButton);
            panel21.add(this.offButton);
            panel21.add(this.doneSensorLabel);
            panel21.add(this.doneSensorComboBox);
            JComboBoxUtil.setupComboBoxMaxRows(this.doneSensorComboBox);
            this.doneSensorComboBox.setAllowNull(true);
            panelx.add(panel21);
            contentPane.add(panelx);
            contentPane.add(new JSeparator());
            JPanel but = new JPanel();
            but.setLayout(new FlowLayout());
            this.cancelAddEditActionButton = new JButton(Bundle.getMessage("ButtonCancel"));
            but.add(this.cancelAddEditActionButton);
            this.cancelAddEditActionButton.addActionListener(this::cancelAddEditActionPressed);
            this.cancelAddEditActionButton.setToolTipText(rbx.getString("CancelButtonHint"));
            this.createActionButton = new JButton(rbx.getString("CreateActionButton"));
            but.add(this.createActionButton);
            this.createActionButton.addActionListener(this::createActionPressed);
            this.createActionButton.setToolTipText(rbx.getString("CreateActionButtonHint"));
            this.updateActionButton = new JButton(rbx.getString("UpdateActionButton"));
            but.add(this.updateActionButton);
            this.updateActionButton.addActionListener(this::updateActionPressed);
            this.updateActionButton.setToolTipText(rbx.getString("UpdateActionButtonHint"));
            contentPane.add(but);
        }
        if (this.editActionMode) {
            this.addEditActionFrame.setTitle(rbx.getString("TitleEditAction"));
            this.updateActionButton.setVisible(true);
            this.createActionButton.setVisible(false);
            this.whenDataSpinner.setValue(this.curTSA.getDataWhen());
            this.whenSensorComboBox.setSelectedItemByName(this.curTSA.getStringWhen());
            this.whatStringField.setText(this.curTSA.getStringWhat());
            this.onButton.setSelected(true);
            if (this.curTSA.getStringWhat().equals("Off")) {
                this.offButton.setSelected(true);
            }
            log.debug("setWhen called for edit of action, editmode = {}", (Object)this.editActionMode);
            this.whenBox.setSelectedIndex(this.curTSA.getWhenCode() - 1);
            this.whatBox.setSelectedIndex(this.curTSA.getWhatCode() - 1);
            this.setBlockBox();
        } else {
            this.addEditActionFrame.setTitle(rbx.getString("TitleAddAction"));
            this.whenBox.setSelectedIndex(0);
            this.whatBox.setSelectedIndex(0);
            this.whenDataSpinner.setValue(0);
            this.whenSensorComboBox.setSelectedItem(0);
            this.whatPercentSpinner.setValue(Float.valueOf(1.0f));
            this.whatMinuteSpinner1.setValue(100);
            this.whatMinuteSpinner2.setValue(100);
            this.locoFunctionSpinner.setValue(0);
            this.signalMastComboBox.setSelectedItem(0);
            this.signalHeadComboBox.setSelectedItem(0);
            this.doneSensorComboBox.setSelectedItem(0);
            this.whatStringField.setText("");
            this.onButton.setSelected(true);
            this.updateActionButton.setVisible(false);
            this.createActionButton.setVisible(true);
            this.setBlockBox();
        }
        this.addEditActionFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TransitTableAction.this.addEditActionFrame != null) {
                    TransitTableAction.this.addEditActionFrame.setVisible(false);
                    TransitTableAction.this.addEditActionFrame.dispose();
                    TransitTableAction.this.addEditActionFrame = null;
                }
            }
        });
        this.addEditActionFrame.pack();
        this.addEditActionFrame.setVisible(true);
    }

    private void setWhen(int code) {
        this.whenSensorComboBox.setVisible(false);
        this.blockBox.setVisible(false);
        log.debug("setWhen code = {}", (Object)code);
        switch (code) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                this.blockBox.setVisible(true);
                this.blockBox.setToolTipText(rbx.getString("HintBlockEntry"));
                break;
            }
            case 7: 
            case 8: {
                this.whenSensorComboBox.setVisible(true);
                this.whenSensorComboBox.setToolTipText(rbx.getString("HintSensorEntry"));
                break;
            }
            default: {
                log.debug("Unhandled transit action code: {}", (Object)code);
            }
        }
        this.addEditActionFrame.pack();
        this.addEditActionFrame.setVisible(true);
    }

    private void setWhat(int code) {
        this.whatStringField.setVisible(false);
        this.whatPercentSpinner.setVisible(false);
        this.whatMinuteSpinner1.setVisible(false);
        this.whatMinuteSpinner2.setVisible(false);
        this.locoFunctionSpinner.setVisible(false);
        this.signalPanel.setVisible(false);
        this.onButton.setVisible(false);
        this.offButton.setVisible(false);
        this.doneSensorLabel.setVisible(false);
        this.doneSensorComboBox.setVisible(false);
        log.debug("setWhat code = {}", (Object)code);
        switch (code) {
            case 1: {
                this.whatMinuteSpinner1.setModel(new SpinnerNumberModel(1, 1, 65500, 1));
                if (this.editActionMode) {
                    this.whatMinuteSpinner1.setValue(Math.max(this.curTSA.getDataWhat1(), 1));
                }
                this.whatMinuteSpinner1.setVisible(true);
                this.whatMinuteSpinner1.setToolTipText(rbx.getString("HintPauseData"));
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.editActionMode) {
                    float maxPerc = Math.max(0.01f * (float)this.curTSA.getDataWhat1(), 0.0f);
                    this.whatPercentSpinner.setValue(Float.valueOf(maxPerc));
                }
                this.whatPercentSpinner.setVisible(true);
                this.whatPercentSpinner.setToolTipText(rbx.getString("HintSetSpeedData1"));
                break;
            }
            case 5: {
                if (this.editActionMode) {
                    this.doneSensorComboBox.setSelectedItemByName(this.curTSA.getStringWhat());
                }
                this.doneSensorLabel.setVisible(true);
                this.doneSensorComboBox.setVisible(true);
                this.doneSensorComboBox.setToolTipText(rbx.getString("HintDoneSensor"));
                break;
            }
            case 6: {
                this.onButton.setVisible(true);
                this.offButton.setVisible(true);
                this.onButton.setToolTipText(rbx.getString("HintSetLight"));
                this.offButton.setToolTipText(rbx.getString("HintSetLight"));
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.whatMinuteSpinner1.setValue(100);
                this.whatMinuteSpinner1.setModel(new SpinnerNumberModel(100, 100, 65500, 1));
                if (this.editActionMode) {
                    this.whatMinuteSpinner1.setValue(this.curTSA.getDataWhat1());
                }
                if ((Integer)this.whatMinuteSpinner1.getValue() < 100) {
                    this.whatMinuteSpinner1.setValue(100);
                }
                this.whatMinuteSpinner1.setVisible(true);
                this.whatMinuteSpinner1.setToolTipText(rbx.getString("HintSoundHornData1"));
                break;
            }
            case 10: {
                this.whatMinuteSpinner1.setValue(100);
                this.whatMinuteSpinner1.setModel(new SpinnerNumberModel(100, 100, 65500, 1));
                if (this.editActionMode) {
                    this.whatMinuteSpinner1.setValue(this.curTSA.getDataWhat1());
                    this.whatMinuteSpinner2.setValue(Math.max(this.curTSA.getDataWhat2(), 100));
                }
                if ((Integer)this.whatMinuteSpinner1.getValue() < 100) {
                    this.whatMinuteSpinner1.setValue(100);
                }
                this.whatMinuteSpinner1.setVisible(true);
                this.whatMinuteSpinner1.setToolTipText(rbx.getString("HintSoundHornPatternData1"));
                this.whatMinuteSpinner2.setVisible(true);
                this.whatMinuteSpinner2.setToolTipText(rbx.getString("HintSoundHornPatternData2"));
                this.whatStringField.setVisible(true);
                break;
            }
            case 11: {
                if (this.editActionMode) {
                    this.locoFunctionSpinner.setValue(this.curTSA.getDataWhat1());
                }
                this.locoFunctionSpinner.setVisible(true);
                this.locoFunctionSpinner.setToolTipText(rbx.getString("HintLocoFunctionData1"));
                this.onButton.setVisible(true);
                this.offButton.setVisible(true);
                this.onButton.setToolTipText(rbx.getString("HintLocoFunctionOnOff"));
                this.offButton.setToolTipText(rbx.getString("HintLocoFunctionOnOff"));
                break;
            }
            case 12: 
            case 13: {
                if (this.editActionMode) {
                    this.doneSensorComboBox.setSelectedItemByName(this.curTSA.getStringWhat());
                }
                this.doneSensorComboBox.setVisible(true);
                this.doneSensorComboBox.setToolTipText(rbx.getString("HintSensorEntry"));
                break;
            }
            case 14: 
            case 15: {
                if (this.editActionMode) {
                    SignalMast sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(this.curTSA.getStringWhat());
                    if (sm != null) {
                        this.signalMastComboBox.setSelectedItemByName(this.curTSA.getStringWhat());
                    } else {
                        SignalHead sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(this.curTSA.getStringWhat());
                        if (sh != null) {
                            this.signalHeadComboBox.setSelectedItemByName(this.curTSA.getStringWhat());
                        }
                    }
                }
                this.signalPanel.setVisible(true);
                break;
            }
            default: {
                log.debug("Unhandled transit section action: {}", (Object)code);
            }
        }
        this.addEditActionFrame.pack();
        this.addEditActionFrame.setVisible(true);
    }

    private void createActionPressed(ActionEvent e) {
        if (!this.validateWhenData() || !this.validateWhatData()) {
            return;
        }
        this.curTSA = new TransitSectionAction(this.tWhen, this.tWhat, this.tWhenData, this.tWhatData1, this.tWhatData2, this.tWhenString, this.tWhatString);
        List<TransitSectionAction> list = this.action.get(this.activeRow);
        list.add(this.curTSA);
        this.actionTableModel.fireTableDataChanged();
        this.addEditActionFrame.setVisible(false);
        this.addEditActionFrame.dispose();
        this.addEditActionFrame = null;
    }

    private void updateActionPressed(ActionEvent e) {
        if (!this.validateWhenData() || !this.validateWhatData()) {
            return;
        }
        this.curTSA.setWhenCode(this.tWhen);
        this.curTSA.setWhatCode(this.tWhat);
        this.curTSA.setDataWhen(this.tWhenData);
        this.curTSA.setDataWhat1(this.tWhatData1);
        this.curTSA.setDataWhat2(this.tWhatData2);
        this.curTSA.setStringWhen(this.tWhenString);
        this.curTSA.setStringWhat(this.tWhatString);
        this.actionTableModel.fireTableDataChanged();
        this.addEditActionFrame.setVisible(false);
        this.addEditActionFrame.dispose();
        this.addEditActionFrame = null;
    }

    private void cancelAddEditActionPressed(ActionEvent e) {
        this.addEditActionFrame.setVisible(false);
        this.addEditActionFrame.dispose();
        this.addEditActionFrame = null;
    }

    private boolean validateWhenData() {
        this.tWhen = this.whenBox.getSelectedIndex() + 1;
        this.tWhenData = (Integer)this.whenDataSpinner.getValue();
        this.tWhenString = "";
        if (this.tWhen == 7 || this.tWhen == 8) {
            if (this.whenSensorComboBox.getSelectedIndex() != 0) {
                this.tWhenString = this.whenSensorComboBox.getSelectedItemSystemName();
            }
            if (!this.validateSensor(this.tWhenString, true)) {
                return false;
            }
        }
        if (this.tWhen == 3 || this.tWhen == 4) {
            this.tWhenString = this.blockList.get(this.blockBox.getSelectedIndex()).getSystemName();
        }
        return true;
    }

    private boolean validateSensor(String sName, boolean when) {
        if (sName.length() < 1) {
            JOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("NoSensorError"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        Sensor s = InstanceManager.sensorManagerInstance().getSensor(sName);
        if (s == null) {
            JOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("SensorEntryError"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        if (!sName.equals(s.getUserName())) {
            if (when) {
                this.tWhenString = sName;
            } else {
                this.tWhatString = sName;
            }
        }
        return true;
    }

    private boolean validateSignal(String sName, boolean when) {
        if (sName.length() < 1) {
            JOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("NoSignalError"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        SignalMast sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(sName);
        SignalHead sh = null;
        if (sm == null) {
            sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(sName);
        }
        if (sm == null && sh == null) {
            JOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("SignalEntryError"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    private boolean validateWhatData() {
        this.tWhat = this.whatBox.getSelectedIndex() + 1;
        this.tWhatData1 = 0;
        this.tWhatData2 = 0;
        this.tWhatString = "";
        switch (this.tWhat) {
            case 2: 
            case 3: 
            case 4: {
                this.tWhatData1 = Math.round(100.0f * ((Float)this.whatPercentSpinner.getValue()).floatValue());
                break;
            }
            case 5: {
                this.tWhatString = "";
                if (this.doneSensorComboBox.getSelectedIndex() >= 0) {
                    this.tWhatString = this.doneSensorComboBox.getSelectedItemSystemName();
                }
                if (this.tWhatString.length() < 1 || this.validateSensor(this.tWhatString, false)) break;
                this.tWhatString = "";
                break;
            }
            case 6: {
                this.tWhatString = "On";
                if (!this.offButton.isSelected()) break;
                this.tWhatString = "Off";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 1: 
            case 9: {
                this.tWhatData1 = (Integer)this.whatMinuteSpinner1.getValue();
                break;
            }
            case 10: {
                this.tWhatData1 = (Integer)this.whatMinuteSpinner1.getValue();
                this.tWhatData2 = (Integer)this.whatMinuteSpinner2.getValue();
                this.tWhatString = this.whatStringField.getText();
                if (this.tWhatString == null || this.tWhatString.isEmpty() || this.tWhatString.length() < 1) {
                    JOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("MissingPattern"), Bundle.getMessage("ErrorTitle"), 0);
                    return false;
                }
                this.tWhatString = this.tWhatString.trim().toLowerCase();
                int i = 0;
                while (i < this.tWhatString.length()) {
                    char c = this.tWhatString.charAt(i);
                    if (c != 's' && c != 'l') {
                        JOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("ErrorPattern"), Bundle.getMessage("ErrorTitle"), 0);
                        return false;
                    }
                    ++i;
                }
                this.whatStringField.setText(this.tWhatString);
                break;
            }
            case 11: {
                this.tWhatData1 = (Integer)this.locoFunctionSpinner.getValue();
                this.tWhatString = "On";
                if (!this.offButton.isSelected()) break;
                this.tWhatString = "Off";
                break;
            }
            case 12: 
            case 13: {
                if (this.doneSensorComboBox.getSelectedIndex() != 0) {
                    this.tWhatString = this.doneSensorComboBox.getSelectedItemSystemName();
                }
                if (this.validateSensor(this.tWhatString, false)) break;
                return false;
            }
            case 14: 
            case 15: {
                if (this.signalMastComboBox.getSelectedIndex() != 0) {
                    this.tWhatString = this.signalMastComboBox.getSelectedItemSystemName();
                } else if (this.signalHeadComboBox.getSelectedIndex() != 0) {
                    this.tWhatString = this.signalHeadComboBox.getSelectedItemSystemName();
                }
                if (this.validateSignal(this.tWhatString, false)) break;
                return false;
            }
            default: {
                log.warn("Unhandled transit section action code: {}", (Object)this.tWhat);
            }
        }
        return true;
    }

    private void initializeWhenBox() {
        this.whenBox.removeAllItems();
        int i = 1;
        while (i <= 8) {
            this.whenBox.addItem(this.getWhenMenuText(i));
            ++i;
        }
    }

    private String getWhenMenuText(int i) {
        switch (i) {
            case 1: {
                return rbx.getString("OnEntry");
            }
            case 2: {
                return rbx.getString("OnExit");
            }
            case 3: {
                return rbx.getString("OnBlockEntry");
            }
            case 4: {
                return rbx.getString("OnBlockExit");
            }
            case 5: {
                return rbx.getString("TrainStop");
            }
            case 6: {
                return rbx.getString("TrainStart");
            }
            case 7: {
                return rbx.getString("OnSensorActive");
            }
            case 8: {
                return rbx.getString("OnSensorInactive");
            }
        }
        log.warn("Unhandled transit section action code: {}", (Object)i);
        return "WHEN";
    }

    private void initializeWhatBox() {
        this.whatBox.removeAllItems();
        int i = 1;
        while (i <= 15) {
            this.whatBox.addItem(this.getWhatMenuText(i));
            ++i;
        }
    }

    private String getWhatMenuText(int i) {
        switch (i) {
            case 1: {
                return rbx.getString("Pause");
            }
            case 2: {
                return rbx.getString("SetMaxSpeed");
            }
            case 3: {
                return rbx.getString("SetTrainSpeed");
            }
            case 4: {
                return rbx.getString("RampTrainSpeed");
            }
            case 5: {
                return rbx.getString("ToManualMode");
            }
            case 6: {
                return rbx.getString("SetLight");
            }
            case 7: {
                return rbx.getString("StartBell");
            }
            case 8: {
                return rbx.getString("StopBell");
            }
            case 9: {
                return rbx.getString("SoundHorn");
            }
            case 10: {
                return rbx.getString("SoundHornPattern");
            }
            case 11: {
                return rbx.getString("LocoFunction");
            }
            case 12: {
                return rbx.getString("SetSensorActive");
            }
            case 13: {
                return rbx.getString("SetSensorInactive");
            }
            case 14: {
                return rbx.getString("HoldSignal");
            }
            case 15: {
                return rbx.getString("ReleaseSignal");
            }
        }
        log.warn("Unhandled transit section action code: {}", (Object)i);
        return "WHAT";
    }

    private void initializeBlockBox() {
        this.blockList = this.sectionList.get(this.activeRow).getBlockList();
        this.blockBox.removeAllItems();
        int i = 0;
        while (i < this.blockList.size()) {
            String s = this.blockList.get(i).getDisplayName();
            this.blockBox.addItem(s);
            ++i;
        }
    }

    private void setBlockBox() {
        if (this.editActionMode && (this.curTSA.getWhenCode() == 3 || this.curTSA.getWhenCode() == 4)) {
            int i = 0;
            while (i < this.blockList.size()) {
                if (this.curTSA.getStringWhen().equals(this.blockList.get(i).getSystemName())) {
                    this.blockBox.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
        this.blockBox.setSelectedIndex(0);
    }

    private void editAction(int r) {
        this.curTSA = this.action.get(this.activeRow).get(r);
        this.editActionMode = true;
        this.addEditActionWindow();
    }

    private void deleteAction(int r) {
        TransitSectionAction tsa = this.action.get(this.activeRow).get(r);
        this.action.get(this.activeRow).remove(r);
        tsa.dispose();
        this.actionTableModel.fireTableDataChanged();
    }

    private String getWhenText(int r) {
        TransitSectionAction tsa = this.action.get(this.activeRow).get(r);
        switch (tsa.getWhenCode()) {
            case 1: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnEntryDelayedFull"), "" + tsa.getDataWhen());
                }
                return rbx.getString("OnEntryFull");
            }
            case 2: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnExitDelayedFull"), "" + tsa.getDataWhen());
                }
                return rbx.getString("OnExitFull");
            }
            case 3: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnBlockEntryDelayedFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
                }
                return MessageFormat.format(rbx.getString("OnBlockEntryFull"), tsa.getStringWhen());
            }
            case 4: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnBlockExitDelayedFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
                }
                return MessageFormat.format(rbx.getString("OnBlockExitFull"), tsa.getStringWhen());
            }
            case 5: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("TrainStopDelayedFull"), "" + tsa.getDataWhen());
                }
                return rbx.getString("TrainStopFull");
            }
            case 6: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("TrainStartDelayedFull"), "" + tsa.getDataWhen());
                }
                return rbx.getString("TrainStartFull");
            }
            case 7: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnSensorActiveDelayedFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
                }
                return MessageFormat.format(rbx.getString("OnSensorActiveFull"), tsa.getStringWhen());
            }
            case 8: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnSensorInactiveDelayedFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
                }
                return MessageFormat.format(rbx.getString("OnSensorInactiveFull"), tsa.getStringWhen());
            }
        }
        log.warn("Unhandled transit section action When code: {}", (Object)tsa.getWhenCode());
        return "WHEN";
    }

    private String getWhatText(int r) {
        TransitSectionAction tsa = this.action.get(this.activeRow).get(r);
        switch (tsa.getWhatCode()) {
            case 1: {
                return MessageFormat.format(rbx.getString("PauseFull"), tsa.getDataWhat1());
            }
            case 2: {
                return MessageFormat.format(rbx.getString("SetMaxSpeedFull"), tsa.getDataWhat1());
            }
            case 3: {
                return MessageFormat.format(rbx.getString("SetTrainSpeedFull"), tsa.getDataWhat1());
            }
            case 4: {
                return MessageFormat.format(rbx.getString("RampTrainSpeedFull"), "" + tsa.getDataWhat1());
            }
            case 5: {
                if (tsa.getStringWhat().length() > 0) {
                    return MessageFormat.format(rbx.getString("ToManualModeAltFull"), tsa.getStringWhat());
                }
                return rbx.getString("ToManualModeFull");
            }
            case 6: {
                if (tsa.getStringWhat().equals("Off")) {
                    return MessageFormat.format(rbx.getString("SetLightFull"), Bundle.getMessage("StateOff"));
                }
                return MessageFormat.format(rbx.getString("SetLightFull"), Bundle.getMessage("StateOn"));
            }
            case 7: {
                return rbx.getString("StartBellFull");
            }
            case 8: {
                return rbx.getString("StopBellFull");
            }
            case 9: {
                return MessageFormat.format(rbx.getString("SoundHornFull"), tsa.getDataWhat1());
            }
            case 10: {
                return MessageFormat.format(rbx.getString("SoundHornPatternFull"), tsa.getStringWhat(), "" + tsa.getDataWhat1(), "" + tsa.getDataWhat2());
            }
            case 11: {
                if (tsa.getStringWhat().equals("Off")) {
                    return MessageFormat.format(rbx.getString("LocoFunctionFull"), "" + tsa.getDataWhat1(), Bundle.getMessage("StateOff"));
                }
                return MessageFormat.format(rbx.getString("LocoFunctionFull"), "" + tsa.getDataWhat1(), Bundle.getMessage("StateOn"));
            }
            case 12: {
                return MessageFormat.format(rbx.getString("SetSensorActiveFull"), tsa.getStringWhat());
            }
            case 13: {
                return MessageFormat.format(rbx.getString("SetSensorInactiveFull"), tsa.getStringWhat());
            }
            case 14: {
                return MessageFormat.format(rbx.getString("HoldSignalFull"), tsa.getStringWhat());
            }
            case 15: {
                return MessageFormat.format(rbx.getString("ReleaseSignalFull"), tsa.getStringWhat());
            }
        }
        log.warn("Unhandled transit section action What code: {}", (Object)tsa.getWhatCode());
        return "WHAT";
    }

    private String getSectionNameByRow(int r) {
        return this.sectionList.get(r).getDisplayName();
    }

    private void updateSensorList() {
        SortedSet nameSet = InstanceManager.getDefault(SensorManager.class).getNamedBeanSet();
        String[] displayList = new String[nameSet.size()];
        int i = 0;
        for (Sensor nBean : nameSet) {
            if (nBean == null) continue;
            displayList[i++] = nBean.getDisplayName();
        }
        Arrays.sort(displayList, new AlphanumComparator());
        this.sensorList = new String[displayList.length + 1];
        this.sensorList[0] = "";
        i = 1;
        String[] stringArray = displayList;
        int n = displayList.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            this.sensorList[i] = name = stringArray[n2];
            ++i;
            ++n2;
        }
    }

    @Override
    protected String getClassName() {
        return TransitTableAction.class.getName();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleTransitTable");
    }

    public class SectionTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SEQUENCE_COLUMN = 0;
        public static final int SECTIONNAME_COLUMN = 1;
        public static final int ACTION_COLUMN = 2;
        public static final int SEC_DIRECTION_COLUMN = 3;
        public static final int ALTERNATE_COLUMN = 4;
        public static final int SAFE_COLUMN = 5;
        public static final int STOPALLOCATING_SENSOR = 6;
        public static final int NUMBER_OF_COLUMNS = 7;

        public SectionTableModel() {
            this.addPcl();
        }

        final void addPcl() {
            TransitTableAction.this.sectionManager.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
            if (e.getSource() instanceof SensorManager && e.getPropertyName().equals("DisplayListName")) {
                TransitTableAction.this.updateSensorList();
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 2: {
                    return JButton.class;
                }
                case 5: {
                    return Boolean.class;
                }
                case 6: {
                    return JComboBox.class;
                }
            }
            return super.getColumnClass(c);
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return TransitTableAction.this.sectionList.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                case 2: 
                case 5: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return rbx.getString("SequenceColName");
                }
                case 1: {
                    return Bundle.getMessage("BeanNameSection");
                }
                case 2: {
                    return rbx.getString("ActionColName");
                }
                case 3: {
                    return rbx.getString("DirectionColName");
                }
                case 4: {
                    return rbx.getString("AlternateColName");
                }
                case 5: {
                    return rbx.getString("SafeColName");
                }
                case 6: {
                    return rbx.getString("StopAllocationColName");
                }
            }
            return "";
        }

        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)8).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 2: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                case 3: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                case 4: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                case 5: {
                    return new JTextField((int)4).getPreferredSize().width;
                }
                case 6: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
            }
            return new JTextField((int)5).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int r, int c) {
            int rx = r;
            if (rx > TransitTableAction.this.sectionList.size()) {
                return null;
            }
            switch (c) {
                case 0: {
                    return "" + TransitTableAction.this.sequence.get(rx);
                }
                case 1: {
                    return TransitTableAction.this.getSectionNameByRow(rx);
                }
                case 2: {
                    return rbx.getString("AddEditActions");
                }
                case 3: {
                    if ((Integer)TransitTableAction.this.direction.get(rx) == 4) {
                        return rbx.getString("SectionForward");
                    }
                    if ((Integer)TransitTableAction.this.direction.get(rx) == 8) {
                        return rbx.getString("SectionReverse");
                    }
                    return Bundle.getMessage("BeanStateUnknown");
                }
                case 4: {
                    if (((Boolean)TransitTableAction.this.alternate.get(rx)).booleanValue()) {
                        return rbx.getString("Alternate");
                    }
                    return rbx.getString("Primary");
                }
                case 5: {
                    return TransitTableAction.this.safe.get(rx);
                }
                case 6: {
                    String sensor = (String)TransitTableAction.this.sensorStopAllocation.get(rx);
                    JComboBox<String> cb = new JComboBox<String>(TransitTableAction.this.sensorList);
                    JComboBoxUtil.setupComboBoxMaxRows(cb);
                    String name = sensor != null ? sensor : "";
                    cb.setSelectedItem(name);
                    return cb;
                }
            }
            return Bundle.getMessage("BeanStateUnknown");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 2: {
                    TransitTableAction.this.addEditActionsPressed(row);
                    break;
                }
                case 5: {
                    boolean val = (Boolean)value;
                    TransitTableAction.this.safe.set(row, val);
                    break;
                }
                case 6: {
                    JComboBox cb = (JComboBox)value;
                    if (cb.getSelectedIndex() < 0) {
                        TransitTableAction.this.sensorStopAllocation.set(row, "");
                        break;
                    }
                    TransitTableAction.this.sensorStopAllocation.set(row, (String)cb.getSelectedItem());
                    break;
                }
            }
        }

        public void dispose() {
            TransitTableAction.this.sectionManager.removePropertyChangeListener(this);
        }
    }

    public class SpecialActionTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int WHEN_COLUMN = 0;
        public static final int WHAT_COLUMN = 1;
        public static final int EDIT_COLUMN = 2;
        public static final int REMOVE_COLUMN = 3;

        public SpecialActionTableModel() {
            this.addPcl();
        }

        final void addPcl() {
            TransitTableAction.this.sectionManager.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 2: 
                case 3: {
                    return JButton.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return ((List)TransitTableAction.this.action.get(TransitTableAction.this.activeRow)).size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return rbx.getString("WhenColName");
                }
                case 1: {
                    return rbx.getString("WhatColName");
                }
            }
            return "";
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return new JTextField((int)50).getPreferredSize().width;
                }
            }
            return new JTextField((int)8).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int r, int c) {
            int rx = r;
            if (rx > ((List)TransitTableAction.this.action.get(TransitTableAction.this.activeRow)).size()) {
                return null;
            }
            switch (c) {
                case 0: {
                    return TransitTableAction.this.getWhenText(rx);
                }
                case 1: {
                    return TransitTableAction.this.getWhatText(rx);
                }
                case 2: {
                    return Bundle.getMessage("ButtonEdit");
                }
                case 3: {
                    return Bundle.getMessage("ButtonDelete");
                }
            }
            return Bundle.getMessage("BeanStateUnknown");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2) {
                TransitTableAction.this.editAction(row);
            } else if (col == 3) {
                TransitTableAction.this.deleteAction(row);
            }
        }

        public void dispose() {
            TransitTableAction.this.sectionManager.removePropertyChangeListener(this);
        }
    }
}

