/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SectionManager;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.signalling.SignallingAction;
import jmri.managers.DefaultSignalMastLogicManager;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastLogicTableAction
extends AbstractTableAction<SignalMastLogic> {
    private List<Hashtable<SignalMastLogic, SignalMast>> signalMastLogicList = null;
    boolean suppressUpdate = false;
    JmriJFrame signalMastLogicFrame = null;
    JLabel sourceLabel = new JLabel();
    protected transient PropertyChangeListener propertyGenerateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("autoGenerateComplete")) {
                if (SignalMastLogicTableAction.this.signalMastLogicFrame != null) {
                    SignalMastLogicTableAction.this.signalMastLogicFrame.setVisible(false);
                }
                InstanceManager.getDefault(SignalMastLogicManager.class).removePropertyChangeListener(this);
                JOptionPane.showMessageDialog(null, Bundle.getMessage("SignalMastPairGenerationComplete"));
            } else if (evt.getPropertyName().equals("autoGenerateUpdate")) {
                SignalMastLogicTableAction.this.sourceLabel.setText((String)evt.getNewValue());
                SignalMastLogicTableAction.this.signalMastLogicFrame.pack();
                SignalMastLogicTableAction.this.signalMastLogicFrame.repaint();
            }
        }
    };
    private final SignallingAction sigLog = new SignallingAction();
    private static final Logger log = LoggerFactory.getLogger(SignalMastLogicTableAction.class);

    public SignalMastLogicTableAction(String s) {
        super(s);
    }

    public SignalMastLogicTableAction() {
        this(Bundle.getMessage("TitleSignalMastLogicTable"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createModel();
        TableRowSorter<BeanTableDataModel> sorter = new TableRowSorter<BeanTableDataModel>(this.m);
        JTable dataTable = this.m.makeJTable(this.m.getMasterClassName(), this.m, sorter);
        this.f = new BeanTableFrame<SignalMastLogic>(this.m, this.helpTarget(), dataTable){};
        this.setMenuBar(this.f);
        this.setTitle();
        this.addToFrame(this.f);
        this.f.pack();
        this.f.setVisible(true);
    }

    @Override
    public void setMenuBar(BeanTableFrame<SignalMastLogic> f) {
        BeanTableFrame<SignalMastLogic> finalF = f;
        JMenuBar menuBar = f.getJMenuBar();
        int pos = menuBar.getMenuCount() - 1;
        int offset = 1;
        log.debug("setMenuBar number of menu items = {}", (Object)pos);
        int i = 0;
        while (i <= pos) {
            if (menuBar.getComponent(i) instanceof JMenu && ((AbstractButton)menuBar.getComponent(i)).getText().equals(Bundle.getMessage("MenuHelp"))) {
                offset = -1;
            }
            ++i;
        }
        JMenu pathMenu = new JMenu(Bundle.getMessage("MenuTools"));
        menuBar.add((Component)pathMenu, pos + offset);
        JMenuItem item = new JMenuItem(Bundle.getMessage("MenuItemAutoGen"));
        pathMenu.add(item);
        item.addActionListener(e -> this.autoCreatePairs(finalF));
        item = new JMenuItem(Bundle.getMessage("MenuItemAutoGenSections"));
        pathMenu.add(item);
        item.addActionListener(e -> {
            ((DefaultSignalMastLogicManager)InstanceManager.getDefault(SignalMastLogicManager.class)).generateSection();
            InstanceManager.getDefault(SectionManager.class).generateBlockSections();
            JOptionPane.showMessageDialog(finalF, Bundle.getMessage("SectionGenerationComplete"));
        });
        JMenuItem setSMLDirSensors = new JMenuItem(Bundle.getMessage("MenuItemAddDirectionSensors"));
        pathMenu.add(setSMLDirSensors);
        setSMLDirSensors.addActionListener(e -> {
            int n = InstanceManager.getDefault(SignalMastLogicManager.class).setupSignalMastsDirectionSensors();
            if (n > 0) {
                JOptionPane.showMessageDialog(finalF, MessageFormat.format(Bundle.getMessage("MenuItemAddDirectionSensorsErrorCount"), n), Bundle.getMessage("ErrorTitle"), 0);
            }
        });
    }

    @Override
    protected void createModel() {
        this.m = new BeanTableDataModel<SignalMastLogic>(){
            public static final int SOURCECOL = 0;
            public static final int SOURCEAPPCOL = 1;
            public static final int DESTCOL = 2;
            public static final int DESTAPPCOL = 3;
            public static final int COMCOL = 4;
            public static final int DELCOL = 5;
            public static final int ENABLECOL = 6;
            public static final int EDITLOGICCOL = 7;
            public static final int MAXSPEEDCOL = 8;
            public static final int COLUMNCOUNT = 9;

            protected SignalMastLogicManager getManager() {
                return InstanceManager.getDefault(SignalMastLogicManager.class);
            }

            @Override
            public String getValue(String s) {
                return "Set";
            }

            @Override
            protected String getMasterClassName() {
                return SignalMastLogicTableAction.this.getClassName();
            }

            @Override
            public void clickOn(SignalMastLogic t) {
            }

            @Override
            protected synchronized void updateNameList() {
                if (SignalMastLogicTableAction.this.signalMastLogicList != null) {
                    int i = 0;
                    while (i < SignalMastLogicTableAction.this.signalMastLogicList.size()) {
                        Hashtable b = (Hashtable)SignalMastLogicTableAction.this.signalMastLogicList.get(i);
                        Enumeration en = b.keys();
                        while (en.hasMoreElements()) {
                            SignalMastLogic sm = (SignalMastLogic)en.nextElement();
                            SignalMast dest = (SignalMast)b.get(sm);
                            sm.removePropertyChangeListener(this);
                            sm.getSourceMast().removePropertyChangeListener(this);
                            dest.removePropertyChangeListener(this);
                        }
                        ++i;
                    }
                }
                List<SignalMastLogic> source = this.getManager().getSignalMastLogicList();
                SignalMastLogicTableAction.this.signalMastLogicList = new ArrayList();
                int i = 0;
                while (i < source.size()) {
                    List<SignalMast> destList = source.get(i).getDestinationList();
                    source.get(i).addPropertyChangeListener(this);
                    source.get(i).getSourceMast().addPropertyChangeListener(this);
                    int j = 0;
                    while (j < destList.size()) {
                        Hashtable<SignalMastLogic, SignalMast> hash = new Hashtable<SignalMastLogic, SignalMast>(1);
                        hash.put(source.get(i), destList.get(j));
                        destList.get(j).addPropertyChangeListener(this);
                        SignalMastLogicTableAction.this.signalMastLogicList.add(hash);
                        ++j;
                    }
                    ++i;
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                block7: {
                    block8: {
                        block6: {
                            if (SignalMastLogicTableAction.this.suppressUpdate) {
                                return;
                            }
                            if (!e.getPropertyName().equals("length") && !e.getPropertyName().equals("updatedDestination") && !e.getPropertyName().equals("updatedSource")) break block6;
                            this.updateNameList();
                            log.debug("Table changed length to {}", (Object)SignalMastLogicTableAction.this.signalMastLogicList.size());
                            this.fireTableDataChanged();
                            break block7;
                        }
                        if (!(e.getSource() instanceof SignalMastLogic)) break block8;
                        SignalMastLogic logic = (SignalMastLogic)e.getSource();
                        if (!this.matchPropertyName(e)) break block7;
                        int i = 0;
                        while (i < SignalMastLogicTableAction.this.signalMastLogicList.size()) {
                            Hashtable b = (Hashtable)SignalMastLogicTableAction.this.signalMastLogicList.get(i);
                            Enumeration en = b.keys();
                            while (en.hasMoreElements()) {
                                SignalMastLogic sm = (SignalMastLogic)en.nextElement();
                                if (sm != logic) continue;
                                this.fireTableRowsUpdated(i, i);
                            }
                            ++i;
                        }
                        break block7;
                    }
                    if (e.getSource() instanceof SignalMast) {
                        SignalMast sigMast = (SignalMast)e.getSource();
                        int i = 0;
                        while (i < SignalMastLogicTableAction.this.signalMastLogicList.size()) {
                            Hashtable b = (Hashtable)SignalMastLogicTableAction.this.signalMastLogicList.get(i);
                            Enumeration en = b.keys();
                            while (en.hasMoreElements()) {
                                SignalMastLogic sm = (SignalMastLogic)en.nextElement();
                                if (sm.getSourceMast() != sigMast) continue;
                                this.fireTableRowsUpdated(i, i);
                            }
                            ++i;
                        }
                    }
                }
            }

            @Override
            protected boolean matchPropertyName(PropertyChangeEvent e) {
                return e.getPropertyName().contains("Comment") || e.getPropertyName().contains("Enable");
            }

            @Override
            public int getColumnCount() {
                return 9;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                SignalMastLogic rowLogic = this.getLogicFromRow(row);
                if (rowLogic == null) {
                    return;
                }
                switch (col) {
                    case 4: {
                        rowLogic.setComment((String)value, this.getDestMastFromRow(row));
                        break;
                    }
                    case 7: {
                        SwingUtilities.invokeLater(() -> this.editLogic(row));
                        break;
                    }
                    case 5: {
                        this.deleteLogic(row);
                        break;
                    }
                    case 6: {
                        SignalMast destMast = this.getDestMastFromRow(row);
                        if (destMast == null) break;
                        if (((Boolean)value).booleanValue()) {
                            rowLogic.setEnabled(destMast);
                            break;
                        }
                        rowLogic.setDisabled(destMast);
                        break;
                    }
                }
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return Bundle.getMessage("Source");
                    }
                    case 2: {
                        return Bundle.getMessage("Destination");
                    }
                    case 1: {
                        return Bundle.getMessage("LabelAspectType");
                    }
                    case 3: {
                        return Bundle.getMessage("LabelAspectType");
                    }
                    case 4: {
                        return Bundle.getMessage("Comment");
                    }
                    case 5: {
                        return "";
                    }
                    case 7: {
                        return "";
                    }
                    case 6: {
                        return Bundle.getMessage("ColumnHeadEnabled");
                    }
                    case 8: {
                        return Bundle.getMessage("LabelMaxSpeed");
                    }
                }
                return "unknown";
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return String.class;
                    }
                    case 6: {
                        return Boolean.class;
                    }
                    case 5: 
                    case 7: {
                        return JButton.class;
                    }
                    case 8: {
                        return Float.class;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }

            void editLogic(int row) {
                SignalMastLogic sml = this.getLogicFromRow(row);
                if (sml != null) {
                    SignalMastLogicTableAction.this.sigLog.setMast(sml.getSourceMast(), this.getDestMastFromRow(row));
                    SignalMastLogicTableAction.this.sigLog.actionPerformed(null);
                }
            }

            void deleteLogic(int row) {
                SignalMastLogic sml = this.getLogicFromRow(row);
                SignalMast destMast = this.getDestMastFromRow(row);
                if (sml != null && destMast != null) {
                    InstanceManager.getDefault(SignalMastLogicManager.class).removeSignalMastLogic(sml, destMast);
                }
            }

            @CheckForNull
            public SignalMast getDestMastFromRow(int row) {
                Hashtable b = (Hashtable)SignalMastLogicTableAction.this.signalMastLogicList.get(row);
                Enumeration en = b.keys();
                if (en.hasMoreElements()) {
                    return (SignalMast)b.get(en.nextElement());
                }
                return null;
            }

            @CheckForNull
            public SignalMastLogic getLogicFromRow(int row) {
                Hashtable b = (Hashtable)SignalMastLogicTableAction.this.signalMastLogicList.get(row);
                Enumeration en = b.keys();
                if (en.hasMoreElements()) {
                    return (SignalMastLogic)en.nextElement();
                }
                return null;
            }

            @Override
            public int getPreferredWidth(int col) {
                switch (col) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 8: {
                        return new JTextField((int)10).getPreferredSize().width;
                    }
                    case 4: {
                        return 75;
                    }
                    case 7: {
                        return new JTextField((int)6).getPreferredSize().width;
                    }
                    case 5: 
                    case 6: {
                        return new JTextField((int)5).getPreferredSize().width;
                    }
                }
                return new JTextField((int)8).getPreferredSize().width;
            }

            @Override
            public void configureTable(JTable table) {
                this.setColumnToHoldButton(table, 7, new JButton(Bundle.getMessage("ButtonEdit")));
                table.getTableHeader().setReorderingAllowed(true);
                table.setAutoResizeMode(0);
                int i = 0;
                while (i < table.getColumnCount()) {
                    int width = this.getPreferredWidth(i);
                    table.getColumnModel().getColumn(i).setPreferredWidth(width);
                    ++i;
                }
                table.sizeColumnsToFit(-1);
                this.configDeleteColumn(table);
            }

            @Override
            public SignalMastLogic getBySystemName(@Nonnull String name) {
                return null;
            }

            @Override
            public SignalMastLogic getByUserName(@Nonnull String name) {
                return null;
            }

            @Override
            public synchronized void dispose() {
                this.getManager().removePropertyChangeListener(this);
                if (SignalMastLogicTableAction.this.signalMastLogicList != null) {
                    int i = 0;
                    while (i < SignalMastLogicTableAction.this.signalMastLogicList.size()) {
                        SignalMastLogic b = this.getLogicFromRow(i);
                        if (b != null) {
                            b.removePropertyChangeListener(this);
                        }
                        ++i;
                    }
                }
            }

            @Override
            public int getRowCount() {
                return SignalMastLogicTableAction.this.signalMastLogicList.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (row >= SignalMastLogicTableAction.this.signalMastLogicList.size()) {
                    log.debug("row index is greater than signalMastLogicList size");
                    return null;
                }
                SignalMastLogic b = this.getLogicFromRow(row);
                if (b == null) {
                    return null;
                }
                switch (col) {
                    case 0: {
                        return b.getSourceMast().getDisplayName();
                    }
                    case 2: {
                        SignalMast destMast = this.getDestMastFromRow(row);
                        return destMast != null ? destMast.getDisplayName() : null;
                    }
                    case 1: {
                        return b.getSourceMast().getAspect();
                    }
                    case 3: {
                        SignalMast destMast = this.getDestMastFromRow(row);
                        return destMast != null ? destMast.getAspect() : null;
                    }
                    case 4: {
                        return b.getComment(this.getDestMastFromRow(row));
                    }
                    case 5: {
                        return Bundle.getMessage("ButtonDelete");
                    }
                    case 7: {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    case 6: {
                        return b.isEnabled(this.getDestMastFromRow(row));
                    }
                    case 8: {
                        return Float.valueOf(b.getMaximumSpeed(this.getDestMastFromRow(row)));
                    }
                }
                return null;
            }

            @Override
            protected void configDeleteColumn(JTable table) {
                this.setColumnToHoldButton(table, 5, new JButton(Bundle.getMessage("ButtonDelete")));
            }

            @Override
            protected String getBeanType() {
                return "Signal Mast Logic";
            }

            @Override
            protected void showPopup(MouseEvent e) {
            }

            @Override
            protected void setColumnIdentities(JTable table) {
                super.setColumnIdentities(table);
                Enumeration<TableColumn> columns = table.getColumnModel() instanceof XTableColumnModel ? ((XTableColumnModel)table.getColumnModel()).getColumns(false) : table.getColumnModel().getColumns();
                while (columns.hasMoreElements()) {
                    TableColumn column = columns.nextElement();
                    switch (column.getModelIndex()) {
                        case 1: {
                            column.setIdentifier("SrcAspect");
                            break;
                        }
                        case 3: {
                            column.setIdentifier("DstAspect");
                            break;
                        }
                        case 5: {
                            column.setIdentifier("Delete");
                            break;
                        }
                        case 7: {
                            column.setIdentifier("Edit");
                        }
                    }
                }
            }
        };
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleSignalMastLogicTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.SignalMastLogicTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.sigLog.setMast(null, null);
        this.sigLog.actionPerformed(e);
    }

    void autoCreatePairs(JmriJFrame f) {
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            int response = JOptionPane.showConfirmDialog(f, Bundle.getMessage("EnableLayoutBlockRouting"), Bundle.getMessage("TitleBlockRouting"), 0);
            if (response == 0) {
                InstanceManager.getDefault(LayoutBlockManager.class).enableAdvancedRouting(true);
                JOptionPane.showMessageDialog(f, Bundle.getMessage("LayoutBlockRoutingEnabled"));
            } else {
                return;
            }
        }
        this.signalMastLogicFrame = new JmriJFrame(Bundle.getMessage("DiscoverSignalMastPairs"), false, false);
        this.signalMastLogicFrame.setPreferredSize(null);
        JPanel panel1 = new JPanel();
        this.sourceLabel = new JLabel(Bundle.getMessage("DiscoveringSignalMastPairs"));
        panel1.add(this.sourceLabel);
        this.signalMastLogicFrame.add(panel1);
        this.signalMastLogicFrame.pack();
        this.signalMastLogicFrame.setVisible(true);
        JCheckBox genSect = new JCheckBox(Bundle.getMessage("AutoGenSectionAfterLogic"));
        genSect.setToolTipText(Bundle.getMessage("AutoGenSectionAfterLogicToolTip"));
        Object[] params = new Object[]{Bundle.getMessage("AutoGenSignalMastLogicMessage"), " ", genSect};
        int retval = JOptionPane.showConfirmDialog(f, params, Bundle.getMessage("AutoGenSignalMastLogicTitle"), 0);
        if (retval == 0) {
            InstanceManager.getDefault(SignalMastLogicManager.class).addPropertyChangeListener(this.propertyGenerateListener);
            Runnable r = () -> {
                this.suppressUpdate = true;
                try {
                    InstanceManager.getDefault(SignalMastLogicManager.class).automaticallyDiscoverSignallingPairs();
                }
                catch (JmriException e) {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            InstanceManager.getDefault(SignalMastLogicManager.class).removePropertyChangeListener(this.propertyGenerateListener);
                            JOptionPane.showMessageDialog(null, e.toString());
                            this.signalMastLogicFrame.setVisible(false);
                        });
                    }
                    catch (InvocationTargetException ex) {
                        log.error("failed to notify of problem with automaticallyDiscoverSignallingPairs", (Throwable)ex);
                    }
                    catch (InterruptedException ex) {
                        log.error("interrupted while notifying of problem with automaticallyDiscoverSignallingPairs", (Throwable)ex);
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        this.m.updateNameList();
                        this.suppressUpdate = false;
                        this.m.fireTableDataChanged();
                        if (genSect.isSelected()) {
                            ((DefaultSignalMastLogicManager)InstanceManager.getDefault(SignalMastLogicManager.class)).generateSection();
                            InstanceManager.getDefault(SectionManager.class).generateBlockSections();
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    log.error("failed to update at end of automaticallyDiscoverSignallingPairs", (Throwable)ex);
                }
                catch (InterruptedException ex) {
                    log.error("interrupted during update at end of automaticallyDiscoverSignallingPairs", (Throwable)ex);
                }
            };
            Thread thr = ThreadingUtil.newThread(r, "Discover Signal Mast Logic");
            thr.start();
        } else {
            this.signalMastLogicFrame.setVisible(false);
        }
    }

    @Override
    protected String getClassName() {
        return SignalMastLogicTableAction.class.getName();
    }
}

