/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.implementation.DccSignalHead;
import jmri.implementation.DoubleTurnoutSignalHead;
import jmri.implementation.LsDecSignalHead;
import jmri.implementation.MergSD2SignalHead;
import jmri.implementation.QuadOutputSignalHead;
import jmri.implementation.SE8cSignalHead;
import jmri.implementation.SingleTurnoutSignalHead;
import jmri.implementation.TripleOutputSignalHead;
import jmri.implementation.TripleTurnoutSignalHead;
import jmri.implementation.VirtualSignalHead;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.RowComboBoxPanel;
import jmri.jmrix.acela.AcelaAddress;
import jmri.jmrix.acela.AcelaNode;
import jmri.jmrix.acela.AcelaSignalHead;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialSignalHead;
import jmri.util.ConnectionNameFromSystemName;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.BeanSelectCreatePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadTableAction
extends AbstractTableAction<SignalHead> {
    private final int[] signalStatesValues;
    private final String[] signalStates;
    private final String stateThrown;
    private final String stateClosed;
    private final String[] turnoutStates;
    private final int[] turnoutStateValues;
    private final String signalheadDouble;
    private final String signalheadTriple;
    private final String signalheadRGB;
    private final String signalheadBiPolar;
    private final String signalheadWigwag;
    private final String[] signalheadTypes;
    private final int[] signalheadTypeValues;
    private final String[] ukSignalAspects;
    private final String[] ukSignalType;
    private JmriJFrame addFrame;
    private JComboBox<String> typeBox;
    private final Border blackline;
    private final JTextField systemNameTextField;
    private final JTextField userNameTextField;
    private final JTextField ato1TextField;
    private BeanSelectCreatePanel<Turnout> to1;
    private BeanSelectCreatePanel<Turnout> to2;
    private BeanSelectCreatePanel<Turnout> to3;
    private BeanSelectCreatePanel<Turnout> to4;
    private BeanSelectCreatePanel<Turnout> to5;
    private BeanSelectCreatePanel<Turnout> to6;
    private BeanSelectCreatePanel<Turnout> to7;
    private final FlowLayout defaultFlow;
    private final JLabel systemNameLabel;
    private final JLabel userNameLabel;
    private JPanel v1Panel;
    private JPanel v2Panel;
    private JPanel v3Panel;
    private JPanel v4Panel;
    private JPanel v5Panel;
    private JPanel v6Panel;
    private JPanel v7Panel;
    private final JLabel vtLabel;
    private final TitledBorder v1Border;
    private final TitledBorder v2Border;
    private final TitledBorder v3Border;
    private final TitledBorder v4Border;
    private final TitledBorder v5Border;
    private final TitledBorder v6Border;
    private final TitledBorder v7Border;
    private final JComboBox<String> s1Box;
    private final JComboBox<String> s2Box;
    private final JComboBox<String> s2aBox;
    private final JComboBox<String> s3Box;
    private final JComboBox<String> s3aBox;
    private final JComboBox<String> s4Box;
    private final JComboBox<String> s5Box;
    private final JComboBox<String> s6Box;
    private final JComboBox<String> s7Box;
    private final JComboBox<String> stBox;
    private final JComboBox<String> mstBox;
    private final JComboBox<String> msaBox;
    private final String acelaAspect;
    private final String se8c4Aspect;
    private final String quadOutput;
    private final String tripleOutput;
    private final String tripleTurnout;
    private final String doubleTurnout;
    private final String virtualHead;
    private final String grapevine;
    private final String acela;
    private final String lsDec;
    private final String dccSignalDecoder;
    private final String mergSignalDriver;
    private final String singleTurnout;
    private final JComboBox<String> prefixBox;
    private final JLabel prefixBoxLabel;
    private final JLabel stateLabel1;
    private final JLabel stateLabel2;
    private final JLabel stateLabel3;
    private final JLabel stateLabel4;
    private final JLabel stateLabel5;
    private final JLabel stateLabel6;
    private final JLabel stateLabel7;
    private boolean editingHead;
    private String editSysName;
    private JmriJFrame editFrame;
    private final JLabel signalType;
    private SignalHead curS;
    private String className;
    private final JTextField eSystemName;
    private final JTextField eUserName;
    private final JTextField etot;
    private BeanSelectCreatePanel<Turnout> eto1;
    private BeanSelectCreatePanel<Turnout> eto2;
    private BeanSelectCreatePanel<Turnout> eto3;
    private BeanSelectCreatePanel<Turnout> eto4;
    private BeanSelectCreatePanel<Turnout> eto5;
    private BeanSelectCreatePanel<Turnout> eto6;
    private BeanSelectCreatePanel<Turnout> eto7;
    private JPanel ev1Panel;
    private JPanel ev2Panel;
    private JPanel ev3Panel;
    private JPanel ev4Panel;
    private JPanel ev5Panel;
    private JPanel ev6Panel;
    private JPanel ev7Panel;
    private final TitledBorder ev1Border;
    private final TitledBorder ev2Border;
    private final TitledBorder ev3Border;
    private final TitledBorder ev4Border;
    private final TitledBorder ev5Border;
    private final TitledBorder ev6Border;
    private final TitledBorder ev7Border;
    private Turnout et1;
    private final JLabel eSystemNameLabel;
    private final JLabel eUserNameLabel;
    private final JLabel eSysNameLabel;
    private final JLabel evtLabel;
    private final JComboBox<String> es1Box;
    private final JComboBox<String> es2Box;
    private final JComboBox<String> es2aBox;
    private final JComboBox<String> es3Box;
    private final JComboBox<String> es3aBox;
    private final JComboBox<String> es4Box;
    private final JComboBox<String> es5Box;
    private final JComboBox<String> es6Box;
    private final JComboBox<String> es7Box;
    private final JComboBox<String> estBox;
    private final JComboBox<String> emstBox;
    private final JComboBox<String> emsaBox;
    private final NamedBeanHandleManager nbhm;
    private SignalHead _curSignal;
    private JSpinner[] dccAspect;
    private final JCheckBox dccOffSetAddress;
    private final JLabel dccPacketSendCount;
    private final JSpinner dccPacketSendCountSpinner;
    private JPanel dccSignalPanel;
    private JSpinner[] dccAspectEdt;
    private final JCheckBox dccOffSetAddressEdt;
    private JPanel dccSignalPanelEdt;
    private static final Logger log = LoggerFactory.getLogger(SignalHeadTableAction.class);

    public SignalHeadTableAction(String s) {
        super(s);
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 64;
        nArray[3] = 4;
        nArray[4] = 16;
        this.signalStatesValues = nArray;
        this.signalStates = new String[]{Bundle.getMessage("SignalHeadStateDark"), Bundle.getMessage("SignalHeadStateRed"), Bundle.getMessage("SignalHeadStateLunar"), Bundle.getMessage("SignalHeadStateYellow"), Bundle.getMessage("SignalHeadStateGreen")};
        this.stateThrown = InstanceManager.turnoutManagerInstance().getThrownText();
        this.stateClosed = InstanceManager.turnoutManagerInstance().getClosedText();
        this.turnoutStates = new String[]{this.stateClosed, this.stateThrown};
        this.turnoutStateValues = new int[]{2, 4};
        this.signalheadDouble = Bundle.getMessage("StringSignalheadDouble");
        this.signalheadTriple = Bundle.getMessage("StringSignalheadTriple");
        this.signalheadRGB = Bundle.getMessage("StringSignalheadRGB");
        this.signalheadBiPolar = Bundle.getMessage("StringSignalheadBiPolar");
        this.signalheadWigwag = Bundle.getMessage("StringSignalheadWigwag");
        this.signalheadTypes = new String[]{this.signalheadDouble, this.signalheadTriple, this.signalheadRGB, this.signalheadBiPolar, this.signalheadWigwag};
        this.signalheadTypeValues = new int[]{1, 2, 3, 4};
        this.ukSignalAspects = new String[]{"2", "3", "4"};
        this.ukSignalType = new String[]{Bundle.getMessage("HomeSignal"), Bundle.getMessage("DistantSignal")};
        this.addFrame = null;
        this.blackline = BorderFactory.createLineBorder(Color.black);
        this.systemNameTextField = new JTextField(5);
        this.userNameTextField = new JTextField(10);
        this.ato1TextField = new JTextField(5);
        this.defaultFlow = new FlowLayout(1, 5, 0);
        this.systemNameLabel = new JLabel("");
        this.userNameLabel = new JLabel("");
        this.v1Panel = new JPanel();
        this.v2Panel = new JPanel();
        this.v3Panel = new JPanel();
        this.v4Panel = new JPanel();
        this.v5Panel = new JPanel();
        this.v6Panel = new JPanel();
        this.v7Panel = new JPanel();
        this.vtLabel = new JLabel("");
        this.v1Border = BorderFactory.createTitledBorder(this.blackline);
        this.v2Border = BorderFactory.createTitledBorder(this.blackline);
        this.v3Border = BorderFactory.createTitledBorder(this.blackline);
        this.v4Border = BorderFactory.createTitledBorder(this.blackline);
        this.v5Border = BorderFactory.createTitledBorder(this.blackline);
        this.v6Border = BorderFactory.createTitledBorder(this.blackline);
        this.v7Border = BorderFactory.createTitledBorder(this.blackline);
        this.s1Box = new JComboBox<String>(this.turnoutStates);
        this.s2Box = new JComboBox<String>(this.turnoutStates);
        this.s2aBox = new JComboBox<String>(this.signalStates);
        this.s3Box = new JComboBox<String>(this.turnoutStates);
        this.s3aBox = new JComboBox<String>(this.signalStates);
        this.s4Box = new JComboBox<String>(this.turnoutStates);
        this.s5Box = new JComboBox<String>(this.turnoutStates);
        this.s6Box = new JComboBox<String>(this.turnoutStates);
        this.s7Box = new JComboBox<String>(this.turnoutStates);
        this.stBox = new JComboBox<String>(this.signalheadTypes);
        this.mstBox = new JComboBox<String>(this.ukSignalType);
        this.msaBox = new JComboBox<String>(this.ukSignalAspects);
        this.acelaAspect = Bundle.getMessage("StringAcelaaspect");
        this.se8c4Aspect = Bundle.getMessage("StringSE8c4aspect");
        this.quadOutput = Bundle.getMessage("StringQuadOutput");
        this.tripleOutput = Bundle.getMessage("StringTripleOutput");
        this.tripleTurnout = Bundle.getMessage("StringTripleTurnout");
        this.doubleTurnout = Bundle.getMessage("StringDoubleTurnout");
        this.virtualHead = Bundle.getMessage("StringVirtual");
        this.grapevine = Bundle.getMessage("StringGrapevine");
        this.acela = Bundle.getMessage("StringAcelaaspect");
        this.lsDec = Bundle.getMessage("StringLsDec");
        this.dccSignalDecoder = Bundle.getMessage("StringDccSigDec");
        this.mergSignalDriver = Bundle.getMessage("StringMerg");
        this.singleTurnout = Bundle.getMessage("StringSingle");
        this.prefixBox = new JComboBox();
        this.prefixBoxLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("DCCSystem")));
        this.stateLabel1 = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("TurnoutState")));
        this.stateLabel2 = new JLabel(this.stateLabel1.getText());
        this.stateLabel3 = new JLabel(this.stateLabel1.getText());
        this.stateLabel4 = new JLabel(this.stateLabel1.getText());
        this.stateLabel5 = new JLabel(this.stateLabel1.getText());
        this.stateLabel6 = new JLabel(this.stateLabel1.getText());
        this.stateLabel7 = new JLabel(this.stateLabel1.getText());
        this.editingHead = false;
        this.editSysName = "";
        this.editFrame = null;
        this.signalType = new JLabel("XXXX");
        this.curS = null;
        this.className = "";
        this.eSystemName = new JTextField(5);
        this.eUserName = new JTextField(10);
        this.etot = new JTextField(5);
        this.ev1Panel = new JPanel();
        this.ev2Panel = new JPanel();
        this.ev3Panel = new JPanel();
        this.ev4Panel = new JPanel();
        this.ev5Panel = new JPanel();
        this.ev6Panel = new JPanel();
        this.ev7Panel = new JPanel();
        this.ev1Border = BorderFactory.createTitledBorder(this.blackline);
        this.ev2Border = BorderFactory.createTitledBorder(this.blackline);
        this.ev3Border = BorderFactory.createTitledBorder(this.blackline);
        this.ev4Border = BorderFactory.createTitledBorder(this.blackline);
        this.ev5Border = BorderFactory.createTitledBorder(this.blackline);
        this.ev6Border = BorderFactory.createTitledBorder(this.blackline);
        this.ev7Border = BorderFactory.createTitledBorder(this.blackline);
        this.et1 = null;
        this.eSystemNameLabel = new JLabel("");
        this.eUserNameLabel = new JLabel("");
        this.eSysNameLabel = new JLabel("");
        this.evtLabel = new JLabel("");
        this.es1Box = new JComboBox<String>(this.turnoutStates);
        this.es2Box = new JComboBox<String>(this.turnoutStates);
        this.es2aBox = new JComboBox<String>(this.signalStates);
        this.es3Box = new JComboBox<String>(this.turnoutStates);
        this.es3aBox = new JComboBox<String>(this.signalStates);
        this.es4Box = new JComboBox<String>(this.turnoutStates);
        this.es5Box = new JComboBox<String>(this.turnoutStates);
        this.es6Box = new JComboBox<String>(this.turnoutStates);
        this.es7Box = new JComboBox<String>(this.turnoutStates);
        this.estBox = new JComboBox<String>(this.signalheadTypes);
        this.emstBox = new JComboBox<String>(this.ukSignalType);
        this.emsaBox = new JComboBox<String>(this.ukSignalAspects);
        this.nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
        this._curSignal = null;
        this.dccOffSetAddress = new JCheckBox(Bundle.getMessage("DccAccessoryAddressOffSet"));
        this.dccPacketSendCount = new JLabel(Bundle.getMessage("DCCMastPacketSendCount"));
        this.dccPacketSendCountSpinner = new JSpinner();
        this.dccSignalPanel = new JPanel();
        this.dccOffSetAddressEdt = new JCheckBox(Bundle.getMessage("DccAccessoryAddressOffSet"));
        this.dccSignalPanelEdt = new JPanel();
        if (InstanceManager.getNullableDefault(SignalHeadManager.class) == null) {
            super.setEnabled(false);
        }
    }

    public SignalHeadTableAction() {
        this(Bundle.getMessage("TitleSignalTable"));
    }

    @Override
    protected void createModel() {
        this.m = new BeanTableDataModel<SignalHead>(){
            public static final int LITCOL = 5;
            public static final int HELDCOL = 6;
            public static final int EDITCOL = 7;
            final Hashtable<Object, JComboBox<String>> editorMap = new Hashtable();
            final Hashtable<Object, Vector<String>> boxMap = new Hashtable();

            @Override
            public int getColumnCount() {
                return 8;
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 2: {
                        return Bundle.getMessage("SignalMastAppearance");
                    }
                    case 5: {
                        return Bundle.getMessage("ColumnHeadLit");
                    }
                    case 6: {
                        return Bundle.getMessage("ColumnHeadHeld");
                    }
                    case 7: {
                        return "";
                    }
                }
                return super.getColumnName(col);
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 2: {
                        return RowComboBoxPanel.class;
                    }
                    case 5: 
                    case 6: {
                        return Boolean.class;
                    }
                    case 7: {
                        return JButton.class;
                    }
                }
                return super.getColumnClass(col);
            }

            @Override
            public int getPreferredWidth(int col) {
                switch (col) {
                    case 5: 
                    case 6: {
                        return new JTextField((int)4).getPreferredSize().width;
                    }
                    case 7: {
                        return new JTextField((int)7).getPreferredSize().width;
                    }
                }
                return super.getPreferredWidth(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 5: 
                    case 6: 
                    case 7: {
                        return true;
                    }
                }
                return super.isCellEditable(row, col);
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (row >= this.sysNameList.size()) {
                    log.debug("row is greater than name list");
                    return "error";
                }
                String name = (String)this.sysNameList.get(row);
                SignalHead s = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
                if (s == null) {
                    return Boolean.FALSE;
                }
                switch (col) {
                    case 5: {
                        return s.getLit();
                    }
                    case 6: {
                        return s.getHeld();
                    }
                    case 7: {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    case 2: {
                        try {
                            if (s.getAppearanceName() != null) {
                                return s.getAppearanceName();
                            }
                            log.debug("NULL Appearance returned for head in row {}", (Object)row);
                            return Bundle.getMessage("BeanStateUnknown");
                        }
                        catch (NullPointerException nullPointerException) {
                            log.debug("Appearance for head {} not set", (Object)row);
                            return Bundle.getMessage("BeanStateUnknown");
                        }
                    }
                }
                return super.getValueAt(row, col);
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                String name = (String)this.sysNameList.get(row);
                SignalHead s = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
                if (s == null) {
                    return;
                }
                switch (col) {
                    case 2: {
                        if (value == null) break;
                        log.debug("SignalHead setValueAt (rowConverted={}; value={})", (Object)row, value);
                        int newState = 99;
                        String[] stateNameList = s.getValidStateNames();
                        int[] validStateList = s.getValidStates();
                        int i = 0;
                        while (i < stateNameList.length) {
                            if (value.equals(stateNameList[i])) {
                                newState = validStateList[i];
                                break;
                            }
                            ++i;
                        }
                        if (newState == 99) {
                            if (stateNameList.length == 0) {
                                newState = 0;
                                log.warn("New signal state not found so setting to Dark {}", (Object)s.getDisplayName());
                            } else {
                                newState = validStateList[0];
                                log.warn("New signal state not found so setting to the first available {}", (Object)s.getDisplayName());
                            }
                        }
                        log.debug("Signal Head set from: {} to: {} [{}]", new Object[]{s.getAppearanceName(), value, newState});
                        s.setAppearance(newState);
                        this.fireTableRowsUpdated(row, row);
                        break;
                    }
                    case 5: {
                        s.setLit((Boolean)value);
                        break;
                    }
                    case 6: {
                        s.setHeld((Boolean)value);
                        break;
                    }
                    case 7: {
                        SignalHeadTableAction.this.editSignal(row);
                        break;
                    }
                    default: {
                        super.setValueAt(value, row, col);
                    }
                }
            }

            @Override
            public String getValue(String name) {
                SignalHead s = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
                if (s == null) {
                    return "<lost>";
                }
                String val = null;
                try {
                    val = s.getAppearanceName();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                }
                if (val != null) {
                    return val;
                }
                return "Unexpected null value";
            }

            public SignalHeadManager getManager() {
                return InstanceManager.getDefault(SignalHeadManager.class);
            }

            @Override
            public SignalHead getBySystemName(@Nonnull String name) {
                return InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
            }

            @Override
            public SignalHead getByUserName(@Nonnull String name) {
                return InstanceManager.getDefault(SignalHeadManager.class).getByUserName(name);
            }

            @Override
            protected String getMasterClassName() {
                return SignalHeadTableAction.this.getClassName();
            }

            @Override
            public void clickOn(SignalHead t) {
            }

            @Override
            public JButton configureButton() {
                JButton b = new JButton(Bundle.getMessage("SignalHeadStateYellow"));
                b.putClientProperty("JComponent.sizeVariant", "small");
                b.putClientProperty("JButton.buttonType", "square");
                return b;
            }

            @Override
            public boolean matchPropertyName(PropertyChangeEvent e) {
                if (e.getPropertyName().contains("Lit") || e.getPropertyName().contains("Held") || e.getPropertyName().contains("ValidStatesChanged")) {
                    return true;
                }
                return super.matchPropertyName(e);
            }

            @Override
            protected String getBeanType() {
                return Bundle.getMessage("BeanNameSignalHead");
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ((!e.getPropertyName().contains("Lit") || e.getPropertyName().contains("Held") || e.getPropertyName().contains("ValidStatesChanged")) && e.getSource() instanceof NamedBean) {
                    String name = ((NamedBean)e.getSource()).getSystemName();
                    if (log.isDebugEnabled()) {
                        log.debug("Update cell {}, {} for {}", new Object[]{this.sysNameList.indexOf(name), 2, name});
                    }
                    int row = this.sysNameList.indexOf(name);
                    this.fireTableRowsUpdated(row, row);
                    this.clearAppearanceVector(row);
                }
                super.propertyChange(e);
            }

            @Override
            protected void configValueColumn(JTable table) {
                this.setColumnToHoldButton(table, 2, this.configureButton());
                log.debug("Head configValueColumn (I am {})", (Object)super.toString());
                table.setDefaultEditor(RowComboBoxPanel.class, new AppearanceComboBoxPanel());
                table.setDefaultRenderer(RowComboBoxPanel.class, new AppearanceComboBoxPanel());
            }

            public void clearAppearanceVector(int row) {
                this.boxMap.remove(this.getValueAt(row, 0));
                this.editorMap.remove(this.getValueAt(row, 0));
            }

            public JComboBox<String> getAppearanceEditorBox(int row) {
                JComboBox<String> editCombo = this.editorMap.get(this.getValueAt(row, 0));
                if (editCombo == null) {
                    editCombo = new JComboBox<String>(this.getRowVector(row));
                    this.editorMap.put(this.getValueAt(row, 0), editCombo);
                }
                return editCombo;
            }

            public Vector<String> getValidAppearances(SignalHead head) {
                String[] app = head.getValidStateNames();
                Vector<String> v = new Vector<String>();
                Collections.addAll(v, app);
                return v;
            }

            Vector<String> getRowVector(int row) {
                Vector<String> comboappearances = this.boxMap.get(this.getValueAt(row, 0));
                if (comboappearances == null) {
                    comboappearances = this.getValidAppearances((SignalHead)this.getValueAt(row, 0));
                    this.boxMap.put(this.getValueAt(row, 0), comboappearances);
                }
                return comboappearances;
            }

            class AppearanceComboBoxPanel
            extends RowComboBoxPanel {
                AppearanceComboBoxPanel() {
                }

                @Override
                protected final void eventEditorMousePressed() {
                    this.editor.add(this.getEditorBox(this.table.convertRowIndexToModel(this.currentRow)));
                    this.editor.revalidate();
                    SwingUtilities.invokeLater(this.comboBoxFocusRequester);
                    log.debug("eventEditorMousePressed in row: {})", (Object)this.currentRow);
                }

                @Override
                protected JComboBox<String> getEditorBox(int row) {
                    return this.getAppearanceEditorBox(row);
                }
            }
        };
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleSignalTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.SignalHeadTable";
    }

    private int turnoutStateFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, this.turnoutStateValues, this.turnoutStates);
        if (result < 0) {
            log.warn("unexpected mode string in turnoutMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    private void setTurnoutStateInBox(JComboBox<String> box, int state, int[] iTurnoutStates) {
        if (state == iTurnoutStates[0]) {
            box.setSelectedIndex(0);
        } else if (state == iTurnoutStates[1]) {
            box.setSelectedIndex(1);
        } else {
            log.error("unexpected turnout state value: {}", (Object)state);
        }
    }

    private int signalStateFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, this.signalStatesValues, this.signalStates);
        if (result < 0) {
            log.warn("unexpected mode string in signalMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    private void setSignalStateInBox(JComboBox<String> box, int state) {
        switch (state) {
            case 0: {
                box.setSelectedIndex(0);
                break;
            }
            case 1: {
                box.setSelectedIndex(1);
                break;
            }
            case 64: {
                box.setSelectedIndex(2);
                break;
            }
            case 4: {
                box.setSelectedIndex(3);
                break;
            }
            case 16: {
                box.setSelectedIndex(4);
                break;
            }
            case 2: {
                box.setSelectedIndex(5);
                break;
            }
            case 128: {
                box.setSelectedIndex(6);
                break;
            }
            case 8: {
                box.setSelectedIndex(7);
                break;
            }
            case 32: {
                box.setSelectedIndex(8);
                break;
            }
            default: {
                log.error("unexpected Signal state value: {}", (Object)state);
            }
        }
    }

    private int signalheadTypeFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, this.signalheadTypeValues, this.signalheadTypes);
        if (result < 0) {
            log.warn("unexpected mode string in signalhead appearance type: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    private void setSignalheadTypeInBox(JComboBox<String> box, int state, int[] iSignalheadTypes) {
        if (state == iSignalheadTypes[0]) {
            box.setSelectedIndex(0);
        } else if (state == iSignalheadTypes[1]) {
            box.setSelectedIndex(1);
        } else if (state == iSignalheadTypes[2]) {
            box.setSelectedIndex(2);
        } else if (state == iSignalheadTypes[3]) {
            box.setSelectedIndex(3);
        } else {
            log.error("unexpected signalhead type value: {}", (Object)state);
        }
    }

    private int ukSignalAspectsFromBox(JComboBox<String> box) {
        switch (box.getSelectedIndex()) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
        }
        log.warn("unexpected appearance{}", box.getSelectedItem());
        throw new IllegalArgumentException();
    }

    private void setUkSignalAspectsFromBox(JComboBox<String> box, int val) {
        switch (val) {
            case 2: {
                box.setSelectedIndex(0);
                break;
            }
            case 3: {
                box.setSelectedIndex(1);
                break;
            }
            case 4: {
                box.setSelectedIndex(2);
                break;
            }
            default: {
                log.error("Unexpected Signal Appearance{}", (Object)val);
            }
        }
    }

    private String ukSignalTypeFromBox(JComboBox<String> box) {
        switch (box.getSelectedIndex()) {
            case 0: {
                return "Home";
            }
            case 1: {
                return "Distant";
            }
        }
        log.warn("unexpected appearance{}", box.getSelectedItem());
        throw new IllegalArgumentException();
    }

    private void setUkSignalType(JComboBox<String> box, String val) {
        if (val.equals(this.ukSignalType[0])) {
            box.setSelectedIndex(0);
        } else if (val.equals(this.ukSignalType[1])) {
            box.setSelectedIndex(1);
        } else {
            log.error("Unexpected Signal Type {}", (Object)val);
        }
    }

    @Override
    protected void addPressed(ActionEvent e) {
        if (this.addFrame == null) {
            List<GrapevineSystemConnectionMemo> memos;
            Iterator<CommandStation> iterator = InstanceManager.getList(CommandStation.class).iterator();
            while (iterator.hasNext()) {
                CommandStation obj;
                CommandStation station = obj = iterator.next();
                this.prefixBox.addItem(station.getUserName());
            }
            this.dccSignalPanel();
            this.to1 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.to2 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.to3 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.to4 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.to5 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.to6 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.to7 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddSignalHead"), false, true);
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.SignalAddEdit", true);
            this.addFrame.getContentPane().setLayout(new BorderLayout());
            JPanel panelHeader = new JPanel();
            panelHeader.setLayout(new BoxLayout(panelHeader, 1));
            this.typeBox = new JComboBox<String>(new String[]{this.acelaAspect, this.dccSignalDecoder, this.doubleTurnout, this.lsDec, this.mergSignalDriver, this.quadOutput, this.singleTurnout, this.se8c4Aspect, this.tripleTurnout, this.tripleOutput, this.virtualHead});
            panelHeader.add(this.typeBox);
            if (this.prefixBox.getItemCount() == 0) {
                this.typeBox.removeItem(this.dccSignalDecoder);
            }
            if (!(memos = InstanceManager.getList(GrapevineSystemConnectionMemo.class)).isEmpty()) {
                this.typeBox.addItem(this.grapevine);
            }
            this.typeBox.addActionListener(e1 -> this.typeChanged());
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.prefixBoxLabel);
            p.add(this.prefixBox);
            panelHeader.add(p);
            p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.systemNameLabel);
            this.systemNameLabel.setLabelFor(this.systemNameTextField);
            p.add(this.systemNameTextField);
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            p.add(this.dccOffSetAddress);
            this.dccOffSetAddress.setToolTipText(Bundle.getMessage("DccOffsetTooltip"));
            p.add(this.dccPacketSendCount);
            this.dccPacketSendCountSpinner.setModel(new SpinnerNumberModel(3, 1, 4, 1));
            p.add(this.dccPacketSendCountSpinner);
            this.dccPacketSendCountSpinner.setToolTipText(Bundle.getMessage("DCCMastPacketSendCountToolTip"));
            panelHeader.add(p);
            p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.userNameLabel);
            this.userNameLabel.setLabelFor(this.userNameTextField);
            p.add(this.userNameTextField);
            this.userNameTextField.setToolTipText(Bundle.getMessage("SignalHeadUserNameTooltip"));
            panelHeader.add(p);
            this.addFrame.getContentPane().add((Component)panelHeader, "First");
            JPanel panelCentre = new JPanel();
            panelCentre.setLayout(new BoxLayout(panelCentre, 1));
            this.v1Panel = new JPanel();
            this.v1Panel.setLayout(new FlowLayout());
            this.v1Panel.add(this.ato1TextField);
            this.v1Panel.add(this.to1);
            this.v1Panel.add(this.stateLabel1);
            this.v1Panel.add(this.s1Box);
            this.s1Box.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
            this.v1Panel.add(this.msaBox);
            this.v1Panel.setBorder(this.v1Border);
            panelCentre.add(this.v1Panel);
            this.v2Panel = new JPanel();
            this.v2Panel.setLayout(this.defaultFlow);
            this.v2Panel.add(this.to2);
            this.v2Panel.add(this.stateLabel2);
            this.v2Panel.add(this.s2Box);
            this.s2Box.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
            this.v2Panel.add(this.s2aBox);
            this.v2Panel.add(this.mstBox);
            this.v2Panel.add(this.dccSignalPanel);
            this.v2Panel.setBorder(this.v2Border);
            panelCentre.add(this.v2Panel);
            this.v3Panel = new JPanel();
            this.v3Panel.setLayout(this.defaultFlow);
            this.v3Panel.add(this.to3);
            this.v3Panel.add(this.stateLabel3);
            this.v3Panel.add(this.s3Box);
            this.s3Box.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
            this.v3Panel.add(this.s3aBox);
            this.v3Panel.setBorder(this.v3Border);
            panelCentre.add(this.v3Panel);
            this.v4Panel = new JPanel();
            this.v4Panel.setLayout(this.defaultFlow);
            this.v4Panel.add(this.to4);
            this.v4Panel.add(this.stateLabel4);
            this.v4Panel.add(this.s4Box);
            this.s4Box.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
            this.v4Panel.setBorder(this.v4Border);
            panelCentre.add(this.v4Panel);
            this.v5Panel = new JPanel();
            this.v5Panel.setLayout(this.defaultFlow);
            this.v5Panel.add(this.to5);
            this.v5Panel.add(this.stateLabel5);
            this.v5Panel.add(this.s5Box);
            this.s5Box.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
            this.v5Panel.setBorder(this.v5Border);
            panelCentre.add(this.v5Panel);
            this.v6Panel = new JPanel();
            this.v6Panel.setLayout(this.defaultFlow);
            this.v6Panel.add(this.to6);
            this.v6Panel.add(this.stateLabel6);
            this.v6Panel.add(this.s6Box);
            this.s6Box.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
            this.v6Panel.setBorder(this.v6Border);
            panelCentre.add(this.v6Panel);
            this.v7Panel = new JPanel();
            this.v7Panel.setLayout(this.defaultFlow);
            this.v7Panel.add(this.to7);
            this.v7Panel.add(this.stateLabel7);
            this.v7Panel.add(this.s7Box);
            this.s7Box.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
            this.v7Panel.setBorder(this.v7Border);
            panelCentre.add(this.v7Panel);
            p = new JPanel();
            p.setLayout(this.defaultFlow);
            p.add(this.vtLabel);
            p.add(this.stBox);
            panelCentre.add(p);
            JScrollPane scrollPane = new JScrollPane(panelCentre);
            this.addFrame.getContentPane().add((Component)scrollPane, "Center");
            JPanel panelBottom = new JPanel();
            panelBottom.setLayout(new FlowLayout(4));
            JButton cancelNew = new JButton(Bundle.getMessage("ButtonCancel"));
            panelBottom.add(cancelNew);
            cancelNew.addActionListener(this::cancelNewPressed);
            JButton ok = new JButton(Bundle.getMessage("ButtonCreate"));
            panelBottom.add(ok);
            ok.addActionListener(this::okPressed);
            this.addFrame.getRootPane().setDefaultButton(ok);
            this.addFrame.getContentPane().add((Component)panelBottom, "Last");
        } else {
            this.systemNameTextField.setText("");
            this.userNameTextField.setText("");
        }
        this.typeBox.setSelectedIndex(2);
        this.addFrame.setEscapeKeyClosesWindow(true);
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    private void hideAllOptions() {
        this.ato1TextField.setVisible(false);
        this.prefixBoxLabel.setVisible(false);
        this.prefixBox.setVisible(false);
        this.systemNameLabel.setVisible(false);
        this.systemNameTextField.setVisible(false);
        this.to1.setVisible(false);
        this.ato1TextField.setVisible(false);
        this.stateLabel1.setVisible(false);
        this.s1Box.setVisible(false);
        this.dccOffSetAddress.setVisible(false);
        this.dccPacketSendCount.setVisible(false);
        this.dccPacketSendCountSpinner.setVisible(false);
        this.v1Panel.setVisible(false);
        this.v2Panel.setVisible(false);
        this.to2.setVisible(false);
        this.stateLabel2.setVisible(false);
        this.s2Box.setVisible(false);
        this.s2aBox.setVisible(false);
        this.dccSignalPanel.setVisible(false);
        this.v3Panel.setVisible(false);
        this.to3.setVisible(false);
        this.stateLabel3.setVisible(false);
        this.s3Box.setVisible(false);
        this.s3aBox.setVisible(false);
        this.v4Panel.setVisible(false);
        this.to4.setVisible(false);
        this.stateLabel4.setVisible(false);
        this.s4Box.setVisible(false);
        this.v5Panel.setVisible(false);
        this.to5.setVisible(false);
        this.stateLabel5.setVisible(false);
        this.s5Box.setVisible(false);
        this.v6Panel.setVisible(false);
        this.to6.setVisible(false);
        this.stateLabel6.setVisible(false);
        this.s6Box.setVisible(false);
        this.v7Panel.setVisible(false);
        this.to7.setVisible(false);
        this.stateLabel7.setVisible(false);
        this.s7Box.setVisible(false);
        this.vtLabel.setVisible(false);
        this.stBox.setVisible(false);
        this.mstBox.setVisible(false);
        this.msaBox.setVisible(false);
    }

    private void typeChanged() {
        this.hideAllOptions();
        if (this.se8c4Aspect.equals(this.typeBox.getSelectedItem())) {
            this.handleSE8cTypeChanged();
        } else if (this.grapevine.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.userNameLabel.setVisible(true);
            this.userNameTextField.setVisible(true);
        } else if (this.acelaAspect.equals(this.typeBox.getSelectedItem())) {
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.userNameLabel.setVisible(true);
            this.userNameTextField.setVisible(true);
            this.v1Border.setTitle(Bundle.getMessage("LabelSignalheadNumber"));
            this.v1Panel.setVisible(true);
            this.v1Panel.setToolTipText(Bundle.getMessage("SignalHeadAcelaTooltip"));
            this.ato1TextField.setVisible(true);
            this.vtLabel.setText(Bundle.getMessage("MakeLabel", Bundle.getMessage("HeadType")));
            this.vtLabel.setVisible(true);
            this.stBox.setVisible(true);
        } else if (this.quadOutput.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.v1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.to1.setVisible(true);
            this.v1Panel.setVisible(true);
            this.v2Border.setTitle(Bundle.getMessage("LabelYellowTurnoutNumber"));
            this.v2Panel.setVisible(true);
            this.to2.setVisible(true);
            this.v3Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.v3Panel.setVisible(true);
            this.to3.setVisible(true);
            this.v4Border.setTitle(Bundle.getMessage("LabelLunarTurnoutNumber"));
            this.v4Panel.setVisible(true);
            this.to4.setVisible(true);
        } else if (this.tripleTurnout.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.v1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.v1Panel.setVisible(true);
            this.to1.setVisible(true);
            this.v2Border.setTitle(Bundle.getMessage("LabelYellowTurnoutNumber"));
            this.v2Panel.setVisible(true);
            this.to2.setVisible(true);
            this.v3Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.v3Panel.setVisible(true);
            this.to3.setVisible(true);
        } else if (this.tripleOutput.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.v1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.v1Panel.setVisible(true);
            this.to1.setVisible(true);
            this.v2Border.setTitle(Bundle.getMessage("LabelBlueTurnoutNumber"));
            this.v2Panel.setVisible(true);
            this.to2.setVisible(true);
            this.v3Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.v3Panel.setVisible(true);
            this.to3.setVisible(true);
        } else if (this.doubleTurnout.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.v1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.v1Panel.setVisible(true);
            this.to1.setVisible(true);
            this.v2Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.v2Panel.setVisible(true);
            this.to2.setVisible(true);
        } else if (this.singleTurnout.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.v1Border.setTitle(Bundle.getMessage("LabelTurnoutNumber"));
            this.v1Panel.setVisible(true);
            this.to1.setVisible(true);
            this.v2Border.setTitle(Bundle.getMessage("LabelTurnoutClosedAppearance"));
            this.v2Panel.setVisible(true);
            this.s2aBox.setVisible(true);
            this.v3Border.setTitle(Bundle.getMessage("LabelTurnoutThrownAppearance"));
            this.s3aBox.setVisible(true);
            this.v3Panel.setVisible(true);
        } else if (this.virtualHead.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
        } else if (this.lsDec.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.v1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.v1Panel.setVisible(true);
            this.to1.setVisible(true);
            this.stateLabel1.setVisible(true);
            this.s1Box.setVisible(true);
            this.v2Border.setTitle(Bundle.getMessage("LabelYellowTurnoutNumber"));
            this.v2Panel.setVisible(true);
            this.to2.setVisible(true);
            this.stateLabel2.setVisible(true);
            this.s2Box.setVisible(true);
            this.v3Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.v3Panel.setVisible(true);
            this.to3.setVisible(true);
            this.stateLabel3.setVisible(true);
            this.s3Box.setVisible(true);
            this.s3aBox.setVisible(false);
            this.v4Border.setTitle(Bundle.getMessage("LabelFlashGreenTurnoutNumber"));
            this.v4Panel.setVisible(true);
            this.to4.setVisible(true);
            this.stateLabel4.setVisible(true);
            this.s4Box.setVisible(true);
            this.v5Border.setTitle(Bundle.getMessage("LabelFlashYellowTurnoutNumber"));
            this.v5Panel.setVisible(true);
            this.to5.setVisible(true);
            this.stateLabel5.setVisible(true);
            this.s5Box.setVisible(true);
            this.v6Border.setTitle(Bundle.getMessage("LabelFlashRedTurnoutNumber"));
            this.v6Panel.setVisible(true);
            this.to6.setVisible(true);
            this.stateLabel6.setVisible(true);
            this.s6Box.setVisible(true);
            this.v7Border.setTitle(Bundle.getMessage("LabelDarkTurnoutNumber"));
            this.v7Panel.setVisible(true);
            this.to7.setVisible(true);
            this.stateLabel7.setVisible(true);
            this.s7Box.setVisible(true);
        } else if (this.dccSignalDecoder.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelHardwareAddress"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setToolTipText(Bundle.getMessage("HardwareAddressToolTip"));
            this.systemNameTextField.setVisible(true);
            this.prefixBox.setVisible(true);
            this.prefixBoxLabel.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.v2Border.setTitle(Bundle.getMessage("LabelAspectNumbering"));
            this.v2Panel.setVisible(true);
            this.dccSignalPanel.setVisible(true);
            this.dccOffSetAddress.setVisible(true);
            this.dccOffSetAddress.setToolTipText(Bundle.getMessage("DccOffsetTooltip"));
            this.dccPacketSendCount.setVisible(true);
            this.dccPacketSendCountSpinner.setVisible(true);
        } else if (this.mergSignalDriver.equals(this.typeBox.getSelectedItem())) {
            this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
            this.systemNameTextField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            this.systemNameLabel.setVisible(true);
            this.systemNameTextField.setVisible(true);
            this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
            this.v1Border.setTitle(Bundle.getMessage("NumberOfAppearances"));
            this.v1Panel.setVisible(true);
            this.v2Border.setTitle(Bundle.getMessage("UseAs"));
            this.v2Panel.setVisible(true);
            this.mstBox.setVisible(true);
            this.msaBox.setVisible(true);
            this.setUkSignalAspectsFromBox(this.msaBox, 2);
            this.v3Border.setTitle(Bundle.getMessage("InputNum", " 1 "));
            this.v3Panel.setVisible(true);
            this.to3.setVisible(true);
            this.v4Border.setTitle(Bundle.getMessage("InputNum", " 2 "));
            this.v5Border.setTitle(Bundle.getMessage("InputNum", " 3 "));
            this.msaBox.addActionListener(e -> this.ukAspectChange(false));
        } else {
            log.error("Unexpected type in typeChanged: {}", this.typeBox.getSelectedItem());
        }
        this.addFrame.pack();
    }

    private boolean checkBeforeCreating(String sysName) {
        if (this.dccSignalDecoder.equals(this.typeBox.getSelectedItem())) {
            try {
                Integer.parseInt(sysName.substring(sysName.indexOf("$") + 1));
            }
            catch (NumberFormatException numberFormatException) {
                String msg = Bundle.getMessage("ShouldBeNumber", "Hardware Address");
                JOptionPane.showMessageDialog(this.addFrame, msg, Bundle.getMessage("WarningTitle"), 0);
                return false;
            }
        }
        boolean ok = true;
        try {
            int i = Manager.getSystemPrefixLength(sysName);
            if (sysName.length() < i + 2) {
                ok = false;
            } else if (sysName.charAt(i) != 'H') {
                ok = false;
            }
        }
        catch (NamedBean.BadSystemNameException badSystemNameException) {
            ok = false;
        }
        if (!ok) {
            String msg = Bundle.getMessage("InvalidSignalSystemName", sysName);
            JOptionPane.showMessageDialog(this.addFrame, msg, Bundle.getMessage("WarningTitle"), 0);
            return false;
        }
        SignalHead s = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sysName);
        if (s == null) {
            SignalHead nB = InstanceManager.getDefault(SignalHeadManager.class).getByUserName(sysName);
            if (nB != null) {
                log.error("System name is not unique {} It already exists as a User name", (Object)sysName);
                String msg = Bundle.getMessage("WarningSystemNameAsUser", sysName);
                JOptionPane.showMessageDialog(this.editFrame, msg, Bundle.getMessage("WarningTitle"), 0);
                return false;
            }
            return true;
        }
        log.warn("Attempt to create signal with duplicate system name {}", (Object)sysName);
        String msg = Bundle.getMessage("DuplicateSignalSystemName", sysName);
        JOptionPane.showMessageDialog(this.addFrame, msg, Bundle.getMessage("WarningTitle"), 0);
        return false;
    }

    public boolean checkIntegerOnly(String s) {
        String allowed = "0123456789";
        boolean result = true;
        int i = 0;
        while (i < s.length()) {
            if (allowed.indexOf(s.charAt(i)) == -1) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    private void addTurnoutMessage(String s1, String s2) {
        log.warn("Could not provide turnout {}", (Object)s2);
        String msg = Bundle.getMessage("AddNoTurnout", s1, s2);
        JOptionPane.showMessageDialog(this.addFrame, msg, Bundle.getMessage("WarningTitle"), 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void okPressed(ActionEvent e) {
        if (!this.checkUserName(this.userNameTextField.getText())) {
            return;
        }
        try {
            if (this.se8c4Aspect.equals(this.typeBox.getSelectedItem())) {
                this.handleSE8cOkPressed();
                return;
            }
            if (this.acelaAspect.equals(this.typeBox.getSelectedItem())) {
                int headnumber;
                String inputusername = this.userNameTextField.getText();
                String inputsysname = this.ato1TextField.getText();
                if (inputsysname.length() == 0) {
                    JOptionPane.showMessageDialog(this.addFrame, Bundle.getMessage("signalHeadEntryWarning"));
                    log.warn("must supply a signalhead number (i.e. AH23) using your prefix");
                    return;
                }
                String acelaPrefix = InstanceManager.getDefault(AcelaSystemConnectionMemo.class).getSystemPrefix();
                if (inputsysname.length() > 2) {
                    int offset = Manager.getSystemPrefixLength(inputsysname);
                    if (inputsysname.startsWith(acelaPrefix)) {
                        headnumber = Integer.parseInt(inputsysname.substring(offset));
                    } else {
                        if (!this.checkIntegerOnly(inputsysname)) {
                            log.warn("skipping creation of signal head, '{}' does not start with AxH", (Object)inputsysname);
                            String msg = Bundle.getMessage("acelaSkippingCreation", this.ato1TextField.getText());
                            JOptionPane.showMessageDialog(this.addFrame, msg, Bundle.getMessage("WarningTitle"), 0);
                            return;
                        }
                        headnumber = Integer.parseInt(inputsysname);
                    }
                } else {
                    headnumber = Integer.parseInt(inputsysname);
                }
                if (this.checkBeforeCreating(String.valueOf(acelaPrefix) + "H" + headnumber)) {
                    try {
                        AcelaSignalHead s = inputusername.length() == 0 ? new AcelaSignalHead(String.valueOf(acelaPrefix) + "H" + headnumber, InstanceManager.getDefault(AcelaSystemConnectionMemo.class)) : new AcelaSignalHead(String.valueOf(acelaPrefix) + "H" + headnumber, inputusername, InstanceManager.getDefault(AcelaSystemConnectionMemo.class));
                        InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    }
                    catch (NullPointerException nullPointerException) {
                        JOptionPane.showMessageDialog(this.addFrame, Bundle.getMessage("SystemNotActiveWarning", "Acela"));
                        log.warn("No active Acela connection to create Signal Head");
                        return;
                    }
                }
                int st = this.signalheadTypeFromBox(this.stBox);
                AcelaNode sh = AcelaAddress.getNodeFromSystemName(String.valueOf(acelaPrefix) + "H" + headnumber, InstanceManager.getDefault(AcelaSystemConnectionMemo.class));
                assert (sh != null);
                switch (st) {
                    case 1: {
                        sh.setOutputSignalHeadType(headnumber, 1);
                        return;
                    }
                    case 2: {
                        sh.setOutputSignalHeadType(headnumber, 2);
                        return;
                    }
                    case 3: {
                        sh.setOutputSignalHeadType(headnumber, 3);
                        return;
                    }
                    case 4: {
                        sh.setOutputSignalHeadType(headnumber, 4);
                        return;
                    }
                }
                log.warn("Unexpected Acela Aspect type: {}", (Object)st);
                sh.setOutputSignalHeadType(headnumber, 0);
                return;
            }
            if (this.grapevine.equals(this.typeBox.getSelectedItem())) {
                if (this.systemNameTextField.getText().length() == 0) {
                    JOptionPane.showMessageDialog(this.addFrame, Bundle.getMessage("signalHeadEntryWarning"));
                    log.warn("must supply a signalhead number (i.e. GH23) using your prefix");
                    return;
                }
                String inputsysname = this.systemNameTextField.getText();
                int offset = Manager.getSystemPrefixLength(inputsysname);
                String grapevinePrefix = InstanceManager.getDefault(GrapevineSystemConnectionMemo.class).getSystemPrefix();
                if (inputsysname.startsWith(grapevinePrefix) && inputsysname.charAt(offset) == 'H') {
                    if (!this.checkBeforeCreating(inputsysname)) return;
                    SerialSignalHead s = new SerialSignalHead(inputsysname, this.userNameTextField.getText(), InstanceManager.getDefault(GrapevineSystemConnectionMemo.class));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal head, '{}' does not start with GxH", (Object)inputsysname);
                String msg = Bundle.getMessage("GrapevineSkippingCreation", inputsysname);
                JOptionPane.showMessageDialog(this.addFrame, msg, Bundle.getMessage("WarningTitle"), 0);
                return;
            }
            if (this.quadOutput.equals(this.typeBox.getSelectedItem())) {
                if (!this.checkBeforeCreating(this.systemNameTextField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.to1, "SignalHead:" + this.systemNameTextField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.to2, "SignalHead:" + this.systemNameTextField.getText() + ":Yellow");
                Turnout t3 = this.getTurnoutFromPanel(this.to3, "SignalHead:" + this.systemNameTextField.getText() + ":Red");
                Turnout t4 = this.getTurnoutFromPanel(this.to4, "SignalHead:" + this.systemNameTextField.getText() + ":Lunar");
                if (t1 == null) {
                    this.addTurnoutMessage(this.v1Border.getTitle(), this.to1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.v2Border.getTitle(), this.to2.getDisplayName());
                }
                if (t3 == null) {
                    this.addTurnoutMessage(this.v3Border.getTitle(), this.to3.getDisplayName());
                }
                if (t4 == null) {
                    this.addTurnoutMessage(this.v4Border.getTitle(), this.to4.getDisplayName());
                }
                if (t4 != null && t3 != null && t2 != null && t1 != null) {
                    QuadOutputSignalHead s = new QuadOutputSignalHead(this.systemNameTextField.getText(), this.userNameTextField.getText(), this.nbhm.getNamedBeanHandle(this.to1.getDisplayName(), t1), this.nbhm.getNamedBeanHandle(this.to2.getDisplayName(), t2), this.nbhm.getNamedBeanHandle(this.to3.getDisplayName(), t3), this.nbhm.getNamedBeanHandle(this.to4.getDisplayName(), t4));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameTextField.getText());
                return;
            }
            if (this.tripleTurnout.equals(this.typeBox.getSelectedItem())) {
                if (!this.checkBeforeCreating(this.systemNameTextField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.to1, "SignalHead:" + this.systemNameTextField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.to2, "SignalHead:" + this.systemNameTextField.getText() + ":Yellow");
                Turnout t3 = this.getTurnoutFromPanel(this.to3, "SignalHead:" + this.systemNameTextField.getText() + ":Red");
                if (t1 == null) {
                    this.addTurnoutMessage(this.v1Border.getTitle(), this.to1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.v2Border.getTitle(), this.to2.getDisplayName());
                }
                if (t3 == null) {
                    this.addTurnoutMessage(this.v3Border.getTitle(), this.to3.getDisplayName());
                }
                if (t3 != null && t2 != null && t1 != null) {
                    TripleTurnoutSignalHead s = new TripleTurnoutSignalHead(this.systemNameTextField.getText(), this.userNameTextField.getText(), this.nbhm.getNamedBeanHandle(this.to1.getDisplayName(), t1), this.nbhm.getNamedBeanHandle(this.to2.getDisplayName(), t2), this.nbhm.getNamedBeanHandle(this.to3.getDisplayName(), t3));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameTextField.getText());
                return;
            }
            if (this.tripleOutput.equals(this.typeBox.getSelectedItem())) {
                if (!this.checkBeforeCreating(this.systemNameTextField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.to1, "SignalHead:" + this.systemNameTextField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.to2, "SignalHead:" + this.systemNameTextField.getText() + ":Blue");
                Turnout t3 = this.getTurnoutFromPanel(this.to3, "SignalHead:" + this.systemNameTextField.getText() + ":Red");
                if (t1 == null) {
                    this.addTurnoutMessage(this.v1Border.getTitle(), this.to1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.v2Border.getTitle(), this.to2.getDisplayName());
                }
                if (t3 == null) {
                    this.addTurnoutMessage(this.v3Border.getTitle(), this.to3.getDisplayName());
                }
                if (t3 != null && t2 != null && t1 != null) {
                    TripleOutputSignalHead s = new TripleOutputSignalHead(this.systemNameTextField.getText(), this.userNameTextField.getText(), this.nbhm.getNamedBeanHandle(this.to1.getDisplayName(), t1), this.nbhm.getNamedBeanHandle(this.to2.getDisplayName(), t2), this.nbhm.getNamedBeanHandle(this.to3.getDisplayName(), t3));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameTextField.getText());
                return;
            }
            if (this.doubleTurnout.equals(this.typeBox.getSelectedItem())) {
                if (!this.checkBeforeCreating(this.systemNameTextField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.to1, "SignalHead:" + this.systemNameTextField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.to2, "SignalHead:" + this.systemNameTextField.getText() + ":Red");
                if (t1 == null) {
                    this.addTurnoutMessage(this.v1Border.getTitle(), this.to1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.v2Border.getTitle(), this.to2.getDisplayName());
                }
                if (t2 != null && t1 != null) {
                    DoubleTurnoutSignalHead s = new DoubleTurnoutSignalHead(this.systemNameTextField.getText(), this.userNameTextField.getText(), this.nbhm.getNamedBeanHandle(this.to1.getDisplayName(), t1), this.nbhm.getNamedBeanHandle(this.to2.getDisplayName(), t2));
                    s.setUserName(this.userNameTextField.getText());
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameTextField.getText());
                return;
            }
            if (this.singleTurnout.equals(this.typeBox.getSelectedItem())) {
                if (!this.checkBeforeCreating(this.systemNameTextField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.to1, "SignalHead:" + this.systemNameTextField.getText() + ":" + this.s2aBox.getSelectedItem() + ":" + this.s3aBox.getSelectedItem());
                int on = this.signalStateFromBox(this.s2aBox);
                int off = this.signalStateFromBox(this.s3aBox);
                if (t1 == null) {
                    this.addTurnoutMessage(this.v1Border.getTitle(), this.to1.getDisplayName());
                }
                if (t1 == null) {
                    log.warn("skipping creation of signal {} due to error", (Object)this.systemNameTextField.getText());
                    return;
                }
                SingleTurnoutSignalHead s = new SingleTurnoutSignalHead(this.systemNameTextField.getText(), this.userNameTextField.getText(), this.nbhm.getNamedBeanHandle(t1.getDisplayName(), t1), on, off);
                InstanceManager.getDefault(SignalHeadManager.class).register(s);
                return;
            }
            if (this.virtualHead.equals(this.typeBox.getSelectedItem())) {
                if (!this.checkBeforeCreating(this.systemNameTextField.getText())) return;
                VirtualSignalHead s = new VirtualSignalHead(this.systemNameTextField.getText(), this.userNameTextField.getText());
                InstanceManager.getDefault(SignalHeadManager.class).register(s);
                return;
            }
            if (this.lsDec.equals(this.typeBox.getSelectedItem())) {
                if (!this.checkBeforeCreating(this.systemNameTextField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.to1, "SignalHead:" + this.systemNameTextField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.to2, "SignalHead:" + this.systemNameTextField.getText() + ":Yellow");
                Turnout t3 = this.getTurnoutFromPanel(this.to3, "SignalHead:" + this.systemNameTextField.getText() + ":Red");
                Turnout t4 = this.getTurnoutFromPanel(this.to4, "SignalHead:" + this.systemNameTextField.getText() + ":FlashGreen");
                Turnout t5 = this.getTurnoutFromPanel(this.to5, "SignalHead:" + this.systemNameTextField.getText() + ":FlashYellow");
                Turnout t6 = this.getTurnoutFromPanel(this.to6, "SignalHead:" + this.systemNameTextField.getText() + ":FlashRed");
                Turnout t7 = this.getTurnoutFromPanel(this.to7, "SignalHead:" + this.systemNameTextField.getText() + ":Dark");
                int s1 = this.turnoutStateFromBox(this.s1Box);
                int s2 = this.turnoutStateFromBox(this.s2Box);
                int s3 = this.turnoutStateFromBox(this.s3Box);
                int s4 = this.turnoutStateFromBox(this.s4Box);
                int s5 = this.turnoutStateFromBox(this.s5Box);
                int s6 = this.turnoutStateFromBox(this.s6Box);
                int s7 = this.turnoutStateFromBox(this.s7Box);
                if (t1 == null) {
                    this.addTurnoutMessage(this.v1Border.getTitle(), this.to1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.v2Border.getTitle(), this.to2.getDisplayName());
                }
                if (t3 == null) {
                    this.addTurnoutMessage(this.v3Border.getTitle(), this.to3.getDisplayName());
                }
                if (t4 == null) {
                    this.addTurnoutMessage(this.v4Border.getTitle(), this.to4.getDisplayName());
                }
                if (t5 == null) {
                    this.addTurnoutMessage(this.v5Border.getTitle(), this.to5.getDisplayName());
                }
                if (t6 == null) {
                    this.addTurnoutMessage(this.v6Border.getTitle(), this.to6.getDisplayName());
                }
                if (t7 == null) {
                    this.addTurnoutMessage(this.v7Border.getTitle(), this.to7.getDisplayName());
                }
                if (t7 != null && t6 != null && t5 != null && t4 != null && t3 != null && t2 != null && t1 != null) {
                    LsDecSignalHead s = new LsDecSignalHead(this.systemNameTextField.getText(), this.nbhm.getNamedBeanHandle(t1.getDisplayName(), t1), s1, this.nbhm.getNamedBeanHandle(t2.getDisplayName(), t2), s2, this.nbhm.getNamedBeanHandle(t3.getDisplayName(), t3), s3, this.nbhm.getNamedBeanHandle(t4.getDisplayName(), t4), s4, this.nbhm.getNamedBeanHandle(t5.getDisplayName(), t5), s5, this.nbhm.getNamedBeanHandle(t6.getDisplayName(), t6), s6, this.nbhm.getNamedBeanHandle(t7.getDisplayName(), t7), s7);
                    s.setUserName(this.userNameTextField.getText());
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameTextField.getText());
                return;
            }
            if (this.dccSignalDecoder.equals(this.typeBox.getSelectedItem())) {
                this.handleDCCOkPressed();
                return;
            }
            if (this.mergSignalDriver.equals(this.typeBox.getSelectedItem())) {
                this.handleMergSignalDriverOkPressed();
                return;
            }
            log.error("Unexpected type: {}", this.typeBox.getSelectedItem());
            return;
        }
        catch (NumberFormatException ex) {
            this.handleCreateException(ex, this.systemNameTextField.getText());
        }
    }

    private void handleCreateException(Exception ex, String sysName) {
        if (ex.getLocalizedMessage() != null) {
            JOptionPane.showMessageDialog(this.addFrame, ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
        } else if (ex.getMessage() != null) {
            JOptionPane.showMessageDialog(this.addFrame, ex.getMessage(), Bundle.getMessage("ErrorTitle"), 0);
        } else {
            JOptionPane.showMessageDialog(this.addFrame, String.valueOf(Bundle.getMessage("ErrorSignalHeadAddFailed", sysName)) + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), Bundle.getMessage("ErrorTitle"), 0);
        }
    }

    private void handleDCCOkPressed() {
        String systemNameText = null;
        String prefix = (String)this.prefixBox.getSelectedItem();
        if (prefix != null) {
            systemNameText = ConnectionNameFromSystemName.getPrefixFromName(prefix);
        }
        if (systemNameText == null) {
            systemNameText = "I";
        }
        if (this.checkBeforeCreating(systemNameText = String.valueOf(systemNameText) + "H$" + this.systemNameTextField.getText())) {
            DccSignalHead s = new DccSignalHead(systemNameText);
            s.setUserName(this.userNameTextField.getText());
            log.debug("dccAspect Length = {}", (Object)this.dccAspect.length);
            int i = 0;
            while (i < DccSignalHead.getDefaultValidStates().length) {
                log.debug("i = {}", (Object)i);
                int number = (Integer)this.dccAspect[i].getValue();
                try {
                    s.setOutputForAppearance(s.getValidStates()[i], number);
                }
                catch (RuntimeException runtimeException) {
                    log.warn("error setting \"{}\" output for appearance \"{}\"", (Object)systemNameText, (Object)number);
                }
                ++i;
            }
            InstanceManager.getDefault(SignalHeadManager.class).register(s);
            s.useAddressOffSet(this.dccOffSetAddress.isSelected());
            s.setDccSignalHeadPacketSendCount((Integer)this.dccPacketSendCountSpinner.getValue());
        }
    }

    private void handleSE8cOkPressed() {
        Turnout t1 = this.getTurnoutFromPanel(this.to1, "SignalHead:" + this.systemNameTextField.getText() + ":low");
        Turnout t2 = this.getTurnoutFromPanel(this.to2, "SignalHead:" + this.systemNameTextField.getText() + ":high");
        if (t1 != null && t2 != null) {
            SE8cSignalHead s;
            try {
                s = new SE8cSignalHead(this.nbhm.getNamedBeanHandle(t1.getSystemName(), t1), this.nbhm.getNamedBeanHandle(t2.getSystemName(), t2), this.userNameTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.handleCreate2TurnoutException(t1.getSystemName(), t2.getSystemName(), this.userNameTextField.getText());
                return;
            }
            InstanceManager.getDefault(SignalHeadManager.class).register(s);
        } else {
            String msg = t1 == null ? Bundle.getMessage("se8c4SkippingDueToErrorInFirst") : Bundle.getMessage("se8c4SkippingDueToErrorInSecond");
            JOptionPane.showMessageDialog(this.addFrame, msg, Bundle.getMessage("WarningTitle"), 0);
        }
    }

    private void handleCreate2TurnoutException(String t1, String t2, String uName) {
        JOptionPane.showMessageDialog(this.addFrame, String.valueOf(Bundle.getMessage("ErrorSe8cAddFailed", uName, t1, t2)) + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), Bundle.getMessage("ErrorTitle"), 0);
    }

    private void handleSE8cTypeChanged() {
        this.hideAllOptions();
        this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
        this.v1Border.setTitle(Bundle.getMessage("LabelTurnoutNumber"));
        this.v1Panel.setVisible(true);
        this.to1.setVisible(true);
        this.v2Panel.setVisible(true);
        this.v2Border.setTitle(Bundle.getMessage("LabelSecondNumber"));
        this.to2.setVisible(true);
    }

    private void handleSE8cEditSignal() {
        this.signalType.setText(this.se8c4Aspect);
        this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
        this.eSysNameLabel.setText(this.curS.getSystemName());
        this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
        this.eUserNameLabel.setVisible(true);
        this.eUserName.setVisible(true);
        this.eUserName.setText(this.curS.getUserName());
        this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
        this.eSysNameLabel.setText(this.curS.getSystemName());
    }

    private void handleSE8cUpdatePressed() {
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private void handleMergSignalDriverOkPressed() {
        NamedBeanHandle<Turnout> nbt1 = null;
        NamedBeanHandle<Turnout> nbt2 = null;
        NamedBeanHandle<Turnout> nbt3 = null;
        if (this.checkBeforeCreating(this.systemNameTextField.getText())) {
            switch (this.ukSignalAspectsFromBox(this.msaBox)) {
                case 4: {
                    Turnout t3 = this.getTurnoutFromPanel(this.to5, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.systemNameTextField.getText(), Bundle.getMessage("InputNum", "3")));
                    if (t3 == null) {
                        this.addTurnoutMessage(this.v5Border.getTitle(), this.to5.getDisplayName());
                        log.warn("skipping creation of signal {} due to error", (Object)this.systemNameTextField.getText());
                        return;
                    }
                    nbt3 = this.nbhm.getNamedBeanHandle(this.to5.getDisplayName(), t3);
                }
                case 3: {
                    Turnout t2 = this.getTurnoutFromPanel(this.to4, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.systemNameTextField.getText(), Bundle.getMessage("InputNum", "2")));
                    if (t2 == null) {
                        this.addTurnoutMessage(this.v4Border.getTitle(), this.to4.getDisplayName());
                        log.warn("skipping creation of signal {} due to error", (Object)this.systemNameTextField.getText());
                        return;
                    }
                    nbt2 = this.nbhm.getNamedBeanHandle(this.to4.getDisplayName(), t2);
                }
                case 2: {
                    Turnout t1 = this.getTurnoutFromPanel(this.to3, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.systemNameTextField.getText(), Bundle.getMessage("InputNum", "1")));
                    if (t1 == null) {
                        this.addTurnoutMessage(this.v3Border.getTitle(), this.to3.getDisplayName());
                        log.warn("skipping creation of signal {} due to error", (Object)this.systemNameTextField.getText());
                        return;
                    }
                    nbt1 = this.nbhm.getNamedBeanHandle(this.to3.getDisplayName(), t1);
                    break;
                }
            }
            boolean home = !this.ukSignalTypeFromBox(this.mstBox).equals("Distant");
            MergSD2SignalHead s = new MergSD2SignalHead(this.systemNameTextField.getText(), this.ukSignalAspectsFromBox(this.msaBox), nbt1, nbt2, nbt3, false, home);
            s.setUserName(this.userNameTextField.getText());
            InstanceManager.getDefault(SignalHeadManager.class).register(s);
        }
    }

    private void editSignal(int row) {
        this._curSignal = (SignalHead)this.m.getValueAt(row, 0);
        String eSName = this._curSignal.getSystemName();
        Runnable t = this::makeEditSignalWindow;
        if (log.isDebugEnabled()) {
            log.debug("editPressed started for {}", (Object)eSName);
        }
        SwingUtilities.invokeLater(t);
    }

    private void makeEditSignalWindow() {
        String eSName = this._curSignal.getSystemName();
        if (this.editingHead) {
            if (eSName.equals(this.editSysName)) {
                this.editFrame.setVisible(true);
            } else {
                log.error("Attempt to edit two signal heads at the same time-{}-and-{}-", (Object)this.editSysName, (Object)eSName);
                String msg = Bundle.getMessage("WarningEdit", this.editSysName, eSName);
                JOptionPane.showMessageDialog(this.editFrame, msg, Bundle.getMessage("WarningTitle"), 0);
                this.editFrame.setVisible(true);
                return;
            }
        }
        this.editSysName = eSName;
        this.editingHead = true;
        this.curS = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(this.editSysName);
        if (this.editFrame == null) {
            this.dccSignalPanelEdt();
            this.eto1 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.eto2 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.eto3 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.eto4 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.eto5 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.eto6 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.eto7 = new BeanSelectCreatePanel<Object>(InstanceManager.turnoutManagerInstance(), null);
            this.editFrame = new JmriJFrame(Bundle.getMessage("TitleEditSignalHead"), false, true);
            this.editFrame.addHelpMenu("package.jmri.jmrit.beantable.SignalAddEdit", true);
            this.editFrame.getContentPane().setLayout(new BorderLayout());
            JPanel panelHeader = new JPanel();
            panelHeader.setLayout(new BoxLayout(panelHeader, 1));
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.signalType);
            panelHeader.add(p);
            panelHeader.add(new JSeparator());
            p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.eSystemNameLabel);
            p.add(this.eSystemName);
            p.add(this.eSysNameLabel);
            p.add(this.dccOffSetAddressEdt);
            this.dccOffSetAddressEdt.setToolTipText(Bundle.getMessage("DccOffsetTooltip"));
            p.add(this.dccPacketSendCount);
            p.add(this.dccPacketSendCountSpinner);
            panelHeader.add(p);
            p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.eUserNameLabel);
            p.add(this.eUserName);
            panelHeader.add(p);
            this.editFrame.getContentPane().add((Component)panelHeader, "First");
            JPanel panelCentre = new JPanel();
            panelCentre.setLayout(new BoxLayout(panelCentre, 1));
            this.ev1Panel = new JPanel();
            this.ev1Panel.setLayout(this.defaultFlow);
            this.ev1Panel.add(this.eto1);
            this.ev1Panel.add(this.es1Box);
            this.ev1Panel.add(this.emsaBox);
            this.emsaBox.setToolTipText(Bundle.getMessage("SignalHeadMergTooltip"));
            this.ev1Panel.setBorder(this.ev1Border);
            panelCentre.add(this.ev1Panel);
            this.ev2Panel = new JPanel();
            this.ev2Panel.setLayout(this.defaultFlow);
            this.ev2Panel.add(this.eto2);
            this.ev2Panel.add(this.es2Box);
            this.ev2Panel.add(this.es2aBox);
            this.ev2Panel.add(this.emstBox);
            this.emstBox.setToolTipText(Bundle.getMessage("SignalHeadUseTooltip"));
            this.ev2Panel.add(this.dccSignalPanelEdt);
            this.ev2Panel.setBorder(this.ev2Border);
            panelCentre.add(this.ev2Panel);
            this.ev3Panel = new JPanel();
            this.ev3Panel.setLayout(this.defaultFlow);
            this.ev3Panel.add(this.eto3);
            this.ev3Panel.add(this.es3Box);
            this.ev3Panel.add(this.es3aBox);
            this.ev3Panel.setBorder(this.ev3Border);
            panelCentre.add(this.ev3Panel);
            this.ev4Panel = new JPanel();
            this.ev4Panel.setLayout(this.defaultFlow);
            this.ev4Panel.add(this.eto4);
            this.ev4Panel.add(this.es4Box);
            this.ev4Panel.setBorder(this.ev4Border);
            panelCentre.add(this.ev4Panel);
            this.ev5Panel = new JPanel();
            this.ev5Panel.setLayout(this.defaultFlow);
            this.ev5Panel.add(this.eto5);
            this.ev5Panel.add(this.es5Box);
            this.ev5Panel.setBorder(this.ev5Border);
            panelCentre.add(this.ev5Panel);
            this.ev6Panel = new JPanel();
            this.ev6Panel.setLayout(this.defaultFlow);
            this.ev6Panel.add(this.eto6);
            this.ev6Panel.add(this.es6Box);
            this.ev6Panel.setBorder(this.ev6Border);
            panelCentre.add(this.ev6Panel);
            this.ev7Panel = new JPanel();
            this.ev7Panel.setLayout(this.defaultFlow);
            this.ev7Panel.add(this.eto7);
            this.ev7Panel.add(this.es7Box);
            this.ev7Panel.setBorder(this.ev7Border);
            panelCentre.add(this.ev7Panel);
            p = new JPanel();
            p.setLayout(this.defaultFlow);
            p.add(this.evtLabel);
            p.add(this.etot);
            p.add(this.estBox);
            panelCentre.add(p);
            JScrollPane scrollPane = new JScrollPane(panelCentre);
            this.editFrame.getContentPane().add((Component)scrollPane, "Center");
            JPanel panelBottom = new JPanel();
            panelBottom.setLayout(new BoxLayout(panelBottom, 1));
            p = new JPanel();
            p.setLayout(new FlowLayout(4));
            JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
            p.add(cancel);
            cancel.addActionListener(this::cancelPressed);
            JButton update = new JButton(Bundle.getMessage("ButtonUpdate"));
            p.add(update);
            update.addActionListener(this::updatePressed);
            panelBottom.add(p);
            this.editFrame.getContentPane().add((Component)panelBottom, "Last");
            this.editFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SignalHeadTableAction.this.cancelPressed(null);
                }
            });
        }
        this.eSystemName.setVisible(false);
        this.eSysNameLabel.setVisible(true);
        this.eUserNameLabel.setVisible(true);
        this.eUserName.setVisible(true);
        this.ev1Panel.setVisible(false);
        this.dccOffSetAddressEdt.setVisible(false);
        this.dccPacketSendCount.setVisible(false);
        this.dccPacketSendCountSpinner.setVisible(false);
        this.eto1.setVisible(false);
        this.es1Box.setVisible(false);
        this.ev2Panel.setVisible(false);
        this.eto2.setVisible(false);
        this.es2Box.setVisible(false);
        this.es2aBox.setVisible(false);
        this.dccSignalPanelEdt.setVisible(false);
        this.ev3Panel.setVisible(false);
        this.eto3.setVisible(false);
        this.es3Box.setVisible(false);
        this.es3aBox.setVisible(false);
        this.ev4Panel.setVisible(false);
        this.eto4.setVisible(false);
        this.es4Box.setVisible(false);
        this.ev5Panel.setVisible(false);
        this.eto5.setVisible(false);
        this.es5Box.setVisible(false);
        this.ev6Panel.setVisible(false);
        this.eto6.setVisible(false);
        this.es6Box.setVisible(false);
        this.ev7Panel.setVisible(false);
        this.eto7.setVisible(false);
        this.es7Box.setVisible(false);
        this.evtLabel.setVisible(false);
        this.etot.setVisible(false);
        this.estBox.setVisible(false);
        this.emstBox.setVisible(false);
        this.emsaBox.setVisible(false);
        switch (this.className = this.curS.getClass().getName()) {
            case "jmri.implementation.QuadOutputSignalHead": {
                this.signalType.setText(this.quadOutput);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                this.ev1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
                this.ev1Panel.setVisible(true);
                this.eto1.setVisible(true);
                this.et1 = ((TripleTurnoutSignalHead)this.curS).getGreen().getBean();
                this.eto1.setDefaultNamedBean(this.et1);
                this.ev2Border.setTitle(Bundle.getMessage("LabelYellowTurnoutNumber"));
                this.ev2Panel.setVisible(true);
                this.eto2.setVisible(true);
                this.eto2.setDefaultNamedBean(((TripleTurnoutSignalHead)this.curS).getYellow().getBean());
                this.ev3Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
                this.ev3Panel.setVisible(true);
                this.eto3.setVisible(true);
                this.eto3.setDefaultNamedBean(((TripleTurnoutSignalHead)this.curS).getRed().getBean());
                this.ev4Border.setTitle(Bundle.getMessage("LabelLunarTurnoutNumber"));
                this.ev4Panel.setVisible(true);
                this.eto4.setVisible(true);
                this.eto4.setDefaultNamedBean(((QuadOutputSignalHead)this.curS).getLunar().getBean());
                break;
            }
            case "jmri.implementation.TripleTurnoutSignalHead": {
                this.signalType.setText(this.tripleTurnout);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                this.ev1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
                this.ev1Panel.setVisible(true);
                this.eto1.setVisible(true);
                this.eto1.setDefaultNamedBean(((TripleTurnoutSignalHead)this.curS).getGreen().getBean());
                this.ev2Border.setTitle(Bundle.getMessage("LabelYellowTurnoutNumber"));
                this.ev2Panel.setVisible(true);
                this.eto2.setVisible(true);
                this.eto2.setDefaultNamedBean(((TripleTurnoutSignalHead)this.curS).getYellow().getBean());
                this.ev3Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
                this.ev3Panel.setVisible(true);
                this.eto3.setVisible(true);
                this.eto3.setDefaultNamedBean(((TripleTurnoutSignalHead)this.curS).getRed().getBean());
                break;
            }
            case "jmri.implementation.TripleOutputSignalHead": {
                this.signalType.setText(this.tripleOutput);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                this.ev1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
                this.ev1Panel.setVisible(true);
                this.eto1.setVisible(true);
                this.eto1.setDefaultNamedBean(((TripleOutputSignalHead)this.curS).getGreen().getBean());
                this.ev2Border.setTitle(Bundle.getMessage("LabelBlueTurnoutNumber"));
                this.ev2Panel.setVisible(true);
                this.eto2.setVisible(true);
                this.eto2.setDefaultNamedBean(((TripleOutputSignalHead)this.curS).getBlue().getBean());
                this.ev3Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
                this.ev3Panel.setVisible(true);
                this.eto3.setVisible(true);
                this.eto3.setDefaultNamedBean(((TripleOutputSignalHead)this.curS).getRed().getBean());
                break;
            }
            case "jmri.implementation.DoubleTurnoutSignalHead": {
                this.signalType.setText(this.doubleTurnout);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                this.ev1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
                this.ev1Panel.setVisible(true);
                this.eto1.setVisible(true);
                this.eto1.setDefaultNamedBean(((DoubleTurnoutSignalHead)this.curS).getGreen().getBean());
                this.ev2Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
                this.ev2Panel.setVisible(true);
                this.eto2.setVisible(true);
                this.eto2.setDefaultNamedBean(((DoubleTurnoutSignalHead)this.curS).getRed().getBean());
                break;
            }
            case "jmri.implementation.SingleTurnoutSignalHead": {
                this.signalType.setText(this.singleTurnout);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                this.ev1Border.setTitle(Bundle.getMessage("LabelTurnoutNumber"));
                this.ev1Panel.setVisible(true);
                this.eto1.setVisible(true);
                this.eto1.setDefaultNamedBean(((SingleTurnoutSignalHead)this.curS).getOutput().getBean());
                this.ev2Border.setTitle(Bundle.getMessage("LabelTurnoutClosedAppearance"));
                this.ev2Panel.setVisible(true);
                this.es2aBox.setVisible(true);
                this.setSignalStateInBox(this.es2aBox, ((SingleTurnoutSignalHead)this.curS).getOnAppearance());
                this.ev3Border.setTitle(Bundle.getMessage("LabelTurnoutThrownAppearance"));
                this.ev3Panel.setVisible(true);
                this.es3aBox.setVisible(true);
                this.setSignalStateInBox(this.es3aBox, ((SingleTurnoutSignalHead)this.curS).getOffAppearance());
                break;
            }
            case "jmri.implementation.VirtualSignalHead": {
                this.signalType.setText(this.virtualHead);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                break;
            }
            case "jmri.implementation.LsDecSignalHead": {
                this.signalType.setText(this.lsDec);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                this.ev1Border.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
                this.ev1Panel.setVisible(true);
                this.eto1.setVisible(true);
                this.eto1.setDefaultNamedBean(((LsDecSignalHead)this.curS).getGreen().getBean());
                this.es1Box.setVisible(true);
                this.setTurnoutStateInBox(this.es1Box, ((LsDecSignalHead)this.curS).getGreenState(), this.turnoutStateValues);
                this.ev2Border.setTitle(Bundle.getMessage("LabelYellowTurnoutNumber"));
                this.ev2Panel.setVisible(true);
                this.eto2.setVisible(true);
                this.eto2.setDefaultNamedBean(((LsDecSignalHead)this.curS).getYellow().getBean());
                this.es2Box.setVisible(true);
                this.setTurnoutStateInBox(this.es2Box, ((LsDecSignalHead)this.curS).getYellowState(), this.turnoutStateValues);
                this.ev3Border.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
                this.ev3Panel.setVisible(true);
                this.eto3.setVisible(true);
                this.eto3.setDefaultNamedBean(((LsDecSignalHead)this.curS).getRed().getBean());
                this.es3Box.setVisible(true);
                this.setTurnoutStateInBox(this.es3Box, ((LsDecSignalHead)this.curS).getRedState(), this.turnoutStateValues);
                this.ev4Border.setTitle(Bundle.getMessage("LabelFlashGreenTurnoutNumber"));
                this.ev4Panel.setVisible(true);
                this.eto4.setVisible(true);
                this.eto4.setDefaultNamedBean(((LsDecSignalHead)this.curS).getFlashGreen().getBean());
                this.es4Box.setVisible(true);
                this.setTurnoutStateInBox(this.es4Box, ((LsDecSignalHead)this.curS).getFlashGreenState(), this.turnoutStateValues);
                this.ev5Border.setTitle(Bundle.getMessage("LabelFlashYellowTurnoutNumber"));
                this.ev5Panel.setVisible(true);
                this.eto5.setVisible(true);
                this.eto5.setDefaultNamedBean(((LsDecSignalHead)this.curS).getFlashYellow().getBean());
                this.es5Box.setVisible(true);
                this.setTurnoutStateInBox(this.es5Box, ((LsDecSignalHead)this.curS).getFlashYellowState(), this.turnoutStateValues);
                this.ev6Border.setTitle(Bundle.getMessage("LabelFlashRedTurnoutNumber"));
                this.ev6Panel.setVisible(true);
                this.eto6.setVisible(true);
                this.eto6.setDefaultNamedBean(((LsDecSignalHead)this.curS).getFlashRed().getBean());
                this.es6Box.setVisible(true);
                this.setTurnoutStateInBox(this.es6Box, ((LsDecSignalHead)this.curS).getFlashRedState(), this.turnoutStateValues);
                this.ev7Border.setTitle(Bundle.getMessage("LabelDarkTurnoutNumber"));
                this.ev7Panel.setVisible(true);
                this.eto7.setVisible(true);
                this.eto7.setDefaultNamedBean(((LsDecSignalHead)this.curS).getDark().getBean());
                this.es7Box.setVisible(true);
                this.setTurnoutStateInBox(this.es7Box, ((LsDecSignalHead)this.curS).getDarkState(), this.turnoutStateValues);
                break;
            }
            case "jmri.implementation.SE8cSignalHead": {
                this.handleSE8cEditSignal();
                break;
            }
            case "jmri.jmrix.grapevine.SerialSignalHead": {
                this.signalType.setText(this.grapevine);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                break;
            }
            case "jmri.jmrix.acela.AcelaSignalHead": {
                this.signalType.setText(this.acela);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                this.evtLabel.setText(String.valueOf(Bundle.getMessage("LabelAspectType")) + ":");
                this.etot.setVisible(false);
                AcelaNode tNode = AcelaAddress.getNodeFromSystemName(this.curS.getSystemName(), InstanceManager.getDefault(AcelaSystemConnectionMemo.class));
                if (tNode == null) {
                    log.error("Can't find new Acela Signal with name '{}", (Object)this.curS.getSystemName());
                    return;
                }
                int headnumber = Integer.parseInt(this.curS.getSystemName().substring(2));
                this.estBox.setVisible(true);
                this.setSignalheadTypeInBox(this.estBox, tNode.getOutputSignalHeadType(headnumber), this.signalheadTypeValues);
                break;
            }
            case "jmri.implementation.DccSignalHead": {
                this.signalType.setText(this.dccSignalDecoder);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                int i = 0;
                while (i < DccSignalHead.getDefaultValidStates().length) {
                    JSpinner tmp = this.dccAspectEdt[i];
                    tmp.setValue(((DccSignalHead)this.curS).getOutputForAppearance(this.curS.getValidStates()[i]));
                    ++i;
                }
                this.dccOffSetAddressEdt.setVisible(true);
                this.dccOffSetAddressEdt.setSelected(((DccSignalHead)this.curS).useAddressOffSet());
                this.dccPacketSendCount.setVisible(true);
                this.dccPacketSendCountSpinner.setVisible(true);
                this.dccPacketSendCountSpinner.setValue(((DccSignalHead)this.curS).getDccSignalHeadPacketSendCount());
                this.ev2Border.setTitle(Bundle.getMessage("LabelAspectNumbering"));
                this.ev2Panel.setVisible(true);
                this.dccSignalPanelEdt.setVisible(true);
                break;
            }
            case "jmri.implementation.MergSD2SignalHead": {
                this.signalType.setText(this.mergSignalDriver);
                this.eSystemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
                this.eSysNameLabel.setText(this.curS.getSystemName());
                this.eUserNameLabel.setText(Bundle.getMessage("LabelUserName"));
                this.eUserName.setText(this.curS.getUserName());
                this.ev1Border.setTitle(Bundle.getMessage("NumberOfAppearances"));
                this.ev1Panel.setVisible(true);
                this.setUkSignalAspectsFromBox(this.emsaBox, ((MergSD2SignalHead)this.curS).getAspects());
                this.eto1.setVisible(false);
                this.emsaBox.setVisible(true);
                this.ev2Border.setTitle(Bundle.getMessage("UseAs"));
                this.ev2Panel.setVisible(true);
                this.eto2.setVisible(false);
                this.emstBox.setVisible(true);
                if (((MergSD2SignalHead)this.curS).getHome()) {
                    this.setUkSignalType(this.emstBox, Bundle.getMessage("HomeSignal"));
                } else {
                    this.setUkSignalType(this.emstBox, Bundle.getMessage("DistantSignal"));
                }
                this.ev3Border.setTitle(Bundle.getMessage("InputNum", " 1 "));
                this.ev3Panel.setVisible(true);
                this.eto3.setVisible(true);
                this.eto3.setDefaultNamedBean(((MergSD2SignalHead)this.curS).getInput1().getBean());
                this.ev4Border.setTitle(Bundle.getMessage("InputNum", " 2 "));
                this.ev4Panel.setVisible(true);
                this.eto4.setVisible(true);
                if (((MergSD2SignalHead)this.curS).getInput2() != null) {
                    this.eto4.setDefaultNamedBean(((MergSD2SignalHead)this.curS).getInput2().getBean());
                }
                this.ev5Border.setTitle(Bundle.getMessage("InputNum", " 3 "));
                this.ev5Panel.setVisible(true);
                this.eto5.setVisible(true);
                if (((MergSD2SignalHead)this.curS).getInput3() != null) {
                    this.eto5.setDefaultNamedBean(((MergSD2SignalHead)this.curS).getInput3().getBean());
                }
                this.emsaBox.addActionListener(e -> this.ukAspectChange(true));
                this.ukAspectChange(true);
                break;
            }
            default: {
                log.error("Cannot edit SignalHead of unrecognized type: {}", (Object)this.className);
            }
        }
        this.editFrame.pack();
        this.editFrame.setVisible(true);
    }

    private void cancelPressed(ActionEvent e) {
        this.editFrame.setVisible(false);
        this.editingHead = false;
    }

    private void cancelNewPressed(ActionEvent e) {
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private void updatePressed(ActionEvent e) {
        String nam = this.eUserName.getText();
        String uname = this.curS.getUserName();
        if (uname == null || !uname.equals(nam)) {
            if (this.checkUserName(nam)) {
                this.curS.setUserName(nam);
            } else {
                return;
            }
        }
        block14 : switch (this.className) {
            case "jmri.implementation.QuadOutputSignalHead": {
                Turnout t1 = this.updateTurnoutFromPanel(this.eto1, "SignalHead:" + this.eSysNameLabel.getText() + ":Green", ((QuadOutputSignalHead)this.curS).getGreen().getBean(), this.ev1Border.getTitle());
                if (t1 == null) {
                    return;
                }
                ((QuadOutputSignalHead)this.curS).setGreen(this.nbhm.getNamedBeanHandle(this.eto1.getDisplayName(), t1));
                Turnout t2 = this.updateTurnoutFromPanel(this.eto2, "SignalHead:" + this.eSysNameLabel.getText() + ":Yellow", ((QuadOutputSignalHead)this.curS).getYellow().getBean(), this.ev2Border.getTitle());
                if (t2 == null) {
                    return;
                }
                ((QuadOutputSignalHead)this.curS).setYellow(this.nbhm.getNamedBeanHandle(this.eto2.getDisplayName(), t2));
                Turnout t3 = this.updateTurnoutFromPanel(this.eto3, "SignalHead:" + this.eSysNameLabel.getText() + ":Red", ((QuadOutputSignalHead)this.curS).getRed().getBean(), this.ev3Border.getTitle());
                if (t3 == null) {
                    return;
                }
                ((QuadOutputSignalHead)this.curS).setRed(this.nbhm.getNamedBeanHandle(this.eto3.getDisplayName(), t3));
                Turnout t4 = this.updateTurnoutFromPanel(this.eto4, "SignalHead:" + this.eSysNameLabel.getText() + ":Lunar", ((QuadOutputSignalHead)this.curS).getLunar().getBean(), this.ev4Border.getTitle());
                if (t4 == null) {
                    return;
                }
                ((QuadOutputSignalHead)this.curS).setLunar(this.nbhm.getNamedBeanHandle(this.eto4.getDisplayName(), t4));
                break;
            }
            case "jmri.implementation.TripleTurnoutSignalHead": {
                Turnout t1 = this.updateTurnoutFromPanel(this.eto1, "SignalHead:" + this.eSysNameLabel.getText() + ":Green", ((TripleTurnoutSignalHead)this.curS).getGreen().getBean(), this.ev1Border.getTitle());
                if (t1 == null) {
                    return;
                }
                ((TripleTurnoutSignalHead)this.curS).setGreen(this.nbhm.getNamedBeanHandle(this.eto1.getDisplayName(), t1));
                Turnout t2 = this.updateTurnoutFromPanel(this.eto2, "SignalHead:" + this.eSysNameLabel.getText() + ":Yellow", ((TripleTurnoutSignalHead)this.curS).getYellow().getBean(), this.ev2Border.getTitle());
                if (t2 == null) {
                    return;
                }
                ((TripleTurnoutSignalHead)this.curS).setYellow(this.nbhm.getNamedBeanHandle(this.eto2.getDisplayName(), t2));
                Turnout t3 = this.updateTurnoutFromPanel(this.eto3, "SignalHead:" + this.eSysNameLabel.getText() + ":Red", ((TripleTurnoutSignalHead)this.curS).getRed().getBean(), this.ev3Border.getTitle());
                if (t3 == null) {
                    return;
                }
                ((TripleTurnoutSignalHead)this.curS).setRed(this.nbhm.getNamedBeanHandle(this.eto3.getDisplayName(), t3));
                break;
            }
            case "jmri.implementation.TripleOutputSignalHead": {
                Turnout t1 = this.updateTurnoutFromPanel(this.eto1, "SignalHead:" + this.eSysNameLabel.getText() + ":Green", ((TripleOutputSignalHead)this.curS).getGreen().getBean(), this.ev1Border.getTitle());
                if (t1 == null) {
                    return;
                }
                ((TripleOutputSignalHead)this.curS).setGreen(this.nbhm.getNamedBeanHandle(this.eto1.getDisplayName(), t1));
                Turnout t2 = this.updateTurnoutFromPanel(this.eto2, "SignalHead:" + this.eSysNameLabel.getText() + ":Blue", ((TripleOutputSignalHead)this.curS).getBlue().getBean(), this.ev2Border.getTitle());
                if (t2 == null) {
                    return;
                }
                ((TripleOutputSignalHead)this.curS).setBlue(this.nbhm.getNamedBeanHandle(this.eto2.getDisplayName(), t2));
                Turnout t3 = this.updateTurnoutFromPanel(this.eto3, "SignalHead:" + this.eSysNameLabel.getText() + ":Red", ((TripleOutputSignalHead)this.curS).getRed().getBean(), this.ev3Border.getTitle());
                if (t3 == null) {
                    return;
                }
                ((TripleOutputSignalHead)this.curS).setRed(this.nbhm.getNamedBeanHandle(this.eto3.getDisplayName(), t3));
                break;
            }
            case "jmri.implementation.DoubleTurnoutSignalHead": {
                Turnout t1 = this.updateTurnoutFromPanel(this.eto1, "SignalHead:" + this.eSysNameLabel.getText() + ":Green", ((DoubleTurnoutSignalHead)this.curS).getGreen().getBean(), this.ev1Border.getTitle());
                Turnout t2 = this.updateTurnoutFromPanel(this.eto2, "SignalHead:" + this.eSysNameLabel.getText() + ":Red", ((DoubleTurnoutSignalHead)this.curS).getRed().getBean(), this.ev2Border.getTitle());
                if (t1 == null) {
                    return;
                }
                ((DoubleTurnoutSignalHead)this.curS).setGreen(this.nbhm.getNamedBeanHandle(this.eto1.getDisplayName(), t1));
                if (t2 == null) {
                    return;
                }
                ((DoubleTurnoutSignalHead)this.curS).setRed(this.nbhm.getNamedBeanHandle(this.eto2.getDisplayName(), t2));
                break;
            }
            case "jmri.implementation.SingleTurnoutSignalHead": {
                Turnout t1 = this.updateTurnoutFromPanel(this.eto1, "SignalHead:" + this.eSysNameLabel.getText() + ":" + this.es2aBox.getSelectedItem() + ":" + this.es3aBox.getSelectedItem(), ((SingleTurnoutSignalHead)this.curS).getOutput().getBean(), this.ev1Border.getTitle());
                if (t1 == null) {
                    this.noTurnoutMessage(this.ev1Border.getTitle(), this.eto1.getDisplayName());
                    return;
                }
                ((SingleTurnoutSignalHead)this.curS).setOutput(this.nbhm.getNamedBeanHandle(this.eto1.getDisplayName(), t1));
                ((SingleTurnoutSignalHead)this.curS).setOnAppearance(this.signalStateFromBox(this.es2aBox));
                ((SingleTurnoutSignalHead)this.curS).setOffAppearance(this.signalStateFromBox(this.es3aBox));
                break;
            }
            case "jmri.implementation.LsDecSignalHead": {
                Turnout t1 = this.updateTurnoutFromPanel(this.eto1, "SignalHead:" + this.eSysNameLabel.getText() + ":Green", ((LsDecSignalHead)this.curS).getGreen().getBean(), this.ev1Border.getTitle());
                if (t1 == null) {
                    return;
                }
                ((LsDecSignalHead)this.curS).setGreen(this.nbhm.getNamedBeanHandle(this.eto1.getDisplayName(), t1));
                ((LsDecSignalHead)this.curS).setGreenState(this.turnoutStateFromBox(this.es1Box));
                Turnout t2 = this.updateTurnoutFromPanel(this.eto2, "SignalHead:" + this.eSysNameLabel.getText() + ":Yellow", ((LsDecSignalHead)this.curS).getYellow().getBean(), this.ev2Border.getTitle());
                if (t2 == null) {
                    return;
                }
                ((LsDecSignalHead)this.curS).setYellow(this.nbhm.getNamedBeanHandle(this.eto2.getDisplayName(), t2));
                ((LsDecSignalHead)this.curS).setYellowState(this.turnoutStateFromBox(this.es2Box));
                Turnout t3 = this.updateTurnoutFromPanel(this.eto3, "SignalHead:" + this.eSysNameLabel.getText() + ":Red", ((LsDecSignalHead)this.curS).getRed().getBean(), this.ev3Border.getTitle());
                if (t3 == null) {
                    return;
                }
                ((LsDecSignalHead)this.curS).setRed(this.nbhm.getNamedBeanHandle(this.eto3.getDisplayName(), t3));
                ((LsDecSignalHead)this.curS).setRedState(this.turnoutStateFromBox(this.es3Box));
                Turnout t4 = this.updateTurnoutFromPanel(this.eto4, "SignalHead:" + this.eSysNameLabel.getText() + ":FlashGreen", ((LsDecSignalHead)this.curS).getFlashGreen().getBean(), this.ev4Border.getTitle());
                if (t4 == null) {
                    return;
                }
                ((LsDecSignalHead)this.curS).setFlashGreen(this.nbhm.getNamedBeanHandle(this.eto4.getDisplayName(), t4));
                ((LsDecSignalHead)this.curS).setFlashGreenState(this.turnoutStateFromBox(this.es4Box));
                Turnout t5 = this.updateTurnoutFromPanel(this.eto5, "SignalHead:" + this.eSysNameLabel.getText() + ":FlashYellow", ((LsDecSignalHead)this.curS).getFlashYellow().getBean(), this.ev5Border.getTitle());
                if (t5 == null) {
                    return;
                }
                ((LsDecSignalHead)this.curS).setFlashYellow(this.nbhm.getNamedBeanHandle(this.eto5.getDisplayName(), t5));
                ((LsDecSignalHead)this.curS).setFlashYellowState(this.turnoutStateFromBox(this.es5Box));
                Turnout t6 = this.updateTurnoutFromPanel(this.eto6, "SignalHead:" + this.eSysNameLabel.getText() + ":FlashRed", ((LsDecSignalHead)this.curS).getFlashRed().getBean(), this.ev6Border.getTitle());
                if (t6 == null) {
                    return;
                }
                ((LsDecSignalHead)this.curS).setFlashRed(this.nbhm.getNamedBeanHandle(this.eto6.getDisplayName(), t6));
                ((LsDecSignalHead)this.curS).setFlashRedState(this.turnoutStateFromBox(this.es6Box));
                Turnout t7 = this.updateTurnoutFromPanel(this.eto7, "SignalHead:" + this.eSysNameLabel.getText() + ":Dark", ((LsDecSignalHead)this.curS).getDark().getBean(), this.ev7Border.getTitle());
                if (t7 == null) {
                    return;
                }
                ((LsDecSignalHead)this.curS).setDark(this.nbhm.getNamedBeanHandle(this.eto7.getDisplayName(), t7));
                ((LsDecSignalHead)this.curS).setDarkState(this.turnoutStateFromBox(this.es7Box));
                break;
            }
            case "jmri.implementation.SE8cSignalHead": {
                this.handleSE8cUpdatePressed();
                break;
            }
            case "jmri.jmrix.acela.AcelaSignalHead": {
                AcelaNode tNode = AcelaAddress.getNodeFromSystemName(this.curS.getSystemName(), InstanceManager.getDefault(AcelaSystemConnectionMemo.class));
                if (tNode == null) {
                    log.error("Can't find new Acela Signal with name '{}'", (Object)this.curS.getSystemName());
                    return;
                }
                int headnumber = Integer.parseInt(this.curS.getSystemName().substring(2));
                tNode.setOutputSignalHeadTypeString(headnumber, Objects.requireNonNull(this.estBox.getSelectedItem()).toString());
                break;
            }
            case "jmri.implementation.MergSD2SignalHead": {
                switch (this.ukSignalAspectsFromBox(this.emsaBox)) {
                    case 4: {
                        Turnout t3 = this.updateTurnoutFromPanel(this.eto5, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.eSysNameLabel.getText(), Bundle.getMessage("InputNum", "3")), ((MergSD2SignalHead)this.curS).getInput3().getBean(), this.ev5Border.getTitle());
                        if (t3 == null) {
                            return;
                        }
                        ((MergSD2SignalHead)this.curS).setInput3(this.nbhm.getNamedBeanHandle(this.eto5.getDisplayName(), t3));
                    }
                    case 3: {
                        Turnout t2 = this.updateTurnoutFromPanel(this.eto4, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.eSysNameLabel.getText(), Bundle.getMessage("InputNum", "2")), ((MergSD2SignalHead)this.curS).getInput2().getBean(), this.ev4Border.getTitle());
                        if (t2 == null) {
                            return;
                        }
                        ((MergSD2SignalHead)this.curS).setInput2(this.nbhm.getNamedBeanHandle(this.eto4.getDisplayName(), t2));
                    }
                    case 2: {
                        Turnout t1 = this.updateTurnoutFromPanel(this.eto3, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.eSysNameLabel.getText(), Bundle.getMessage("InputNum", "1")), ((MergSD2SignalHead)this.curS).getInput1().getBean(), this.ev3Border.getTitle());
                        if (t1 == null) {
                            return;
                        }
                        ((MergSD2SignalHead)this.curS).setInput1(this.nbhm.getNamedBeanHandle(this.eto3.getDisplayName(), t1));
                        ((MergSD2SignalHead)this.curS).setAspects(this.ukSignalAspectsFromBox(this.emsaBox));
                        ((MergSD2SignalHead)this.curS).setHome(!this.ukSignalTypeFromBox(this.emstBox).equals("Distant"));
                        break block14;
                    }
                }
                break;
            }
            case "jmri.implementation.DccSignalHead": {
                int i = 0;
                while (i < this.dccAspectEdt.length) {
                    int number = (Integer)this.dccAspectEdt[i].getValue();
                    try {
                        ((DccSignalHead)this.curS).setOutputForAppearance(this.curS.getValidStates()[i], number);
                    }
                    catch (Exception ex) {
                        log.error(ex.toString());
                    }
                    ++i;
                }
                ((DccSignalHead)this.curS).useAddressOffSet(this.dccOffSetAddressEdt.isSelected());
                ((DccSignalHead)this.curS).setDccSignalHeadPacketSendCount((Integer)this.dccPacketSendCountSpinner.getValue());
                break;
            }
            default: {
                log.error("Internal error - cannot update signal of type {}", (Object)this.className);
            }
            case "jmri.jmrix.grapevine.SerialSignalHead": 
        }
        this.editFrame.setVisible(false);
        this.editingHead = false;
    }

    private boolean checkUserName(String nam) {
        if (nam != null && !nam.isEmpty()) {
            SignalHead nB = InstanceManager.getDefault(SignalHeadManager.class).getByUserName(nam);
            if (nB != null) {
                log.error("User name is not unique {}", (Object)nam);
                String msg = Bundle.getMessage("WarningUserName", nam);
                JOptionPane.showMessageDialog(this.editFrame, msg, Bundle.getMessage("WarningTitle"), 0);
                return false;
            }
            nB = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(nam);
            if (nB != null) {
                log.error("User name is not unique {} It already exists as a System name", (Object)nam);
                String msg = Bundle.getMessage("WarningUserNameAsSystem", nam);
                JOptionPane.showMessageDialog(this.editFrame, msg, Bundle.getMessage("WarningTitle"), 0);
                return false;
            }
        }
        return true;
    }

    private void noTurnoutMessage(String s1, String s2) {
        log.warn("Could not provide turnout {}", (Object)s2);
        String msg = Bundle.getMessage("WarningNoTurnout", s1, s2);
        JOptionPane.showMessageDialog(this.editFrame, msg, Bundle.getMessage("WarningTitle"), 0);
    }

    private void ukAspectChange(boolean edit) {
        if (edit) {
            switch (this.ukSignalAspectsFromBox(this.emsaBox)) {
                case 2: {
                    this.ev4Panel.setVisible(false);
                    this.eto4.setVisible(false);
                    this.ev5Panel.setVisible(false);
                    this.eto5.setVisible(false);
                    this.ev2Panel.setVisible(true);
                    this.emstBox.setVisible(true);
                    break;
                }
                case 3: {
                    this.ev4Panel.setVisible(true);
                    this.eto4.setVisible(true);
                    this.ev5Panel.setVisible(false);
                    this.eto5.setVisible(false);
                    this.ev2Panel.setVisible(false);
                    this.emstBox.setVisible(false);
                    this.setUkSignalType(this.emstBox, "Home");
                    break;
                }
                case 4: {
                    this.ev4Panel.setVisible(true);
                    this.eto4.setVisible(true);
                    this.ev5Panel.setVisible(true);
                    this.eto5.setVisible(true);
                    this.ev2Panel.setVisible(false);
                    this.emstBox.setVisible(false);
                    break;
                }
            }
            this.editFrame.pack();
        } else {
            switch (this.ukSignalAspectsFromBox(this.msaBox)) {
                case 2: {
                    this.v4Panel.setVisible(false);
                    this.to4.setVisible(false);
                    this.v5Panel.setVisible(false);
                    this.to5.setVisible(false);
                    this.v2Panel.setVisible(true);
                    this.mstBox.setVisible(true);
                    break;
                }
                case 3: {
                    this.v4Panel.setVisible(true);
                    this.to4.setVisible(true);
                    this.v5Panel.setVisible(false);
                    this.to5.setVisible(false);
                    this.v2Panel.setVisible(false);
                    this.mstBox.setVisible(false);
                    this.setUkSignalType(this.mstBox, "Home");
                    break;
                }
                case 4: {
                    this.v4Panel.setVisible(true);
                    this.to4.setVisible(true);
                    this.v5Panel.setVisible(true);
                    this.to5.setVisible(true);
                    this.v2Panel.setVisible(false);
                    this.mstBox.setVisible(false);
                    this.setUkSignalType(this.mstBox, "Home");
                    break;
                }
            }
            this.addFrame.pack();
        }
    }

    @Override
    public void dispose() {
        if (this.to1 != null) {
            this.to1.dispose();
        }
        if (this.to2 != null) {
            this.to2.dispose();
        }
        if (this.to3 != null) {
            this.to3.dispose();
        }
        if (this.to4 != null) {
            this.to4.dispose();
        }
        if (this.to5 != null) {
            this.to5.dispose();
        }
        if (this.to6 != null) {
            this.to6.dispose();
        }
        if (this.to7 != null) {
            this.to7.dispose();
        }
        if (this.eto1 != null) {
            this.eto1.dispose();
        }
        if (this.eto1 != null) {
            this.eto2.dispose();
        }
        if (this.eto1 != null) {
            this.eto3.dispose();
        }
        if (this.eto1 != null) {
            this.eto4.dispose();
        }
        if (this.eto1 != null) {
            this.eto5.dispose();
        }
        if (this.eto1 != null) {
            this.eto6.dispose();
        }
        if (this.eto1 != null) {
            this.eto7.dispose();
        }
        super.dispose();
    }

    protected Turnout updateTurnoutFromPanel(BeanSelectCreatePanel<Turnout> bp, String reference, Turnout oldTurnout, String title) {
        String comment;
        Turnout newTurnout = this.getTurnoutFromPanel(bp, reference);
        if (newTurnout == null) {
            this.noTurnoutMessage(title, bp.getDisplayName());
        }
        if (newTurnout != null && ((comment = newTurnout.getComment()) == null || comment.isEmpty())) {
            newTurnout.setComment(reference);
        }
        if (oldTurnout == null || newTurnout == oldTurnout) {
            return newTurnout;
        }
        comment = oldTurnout.getComment();
        if (comment != null && comment.equals(reference)) {
            oldTurnout.setComment(null);
        }
        return newTurnout;
    }

    protected Turnout getTurnoutFromPanel(BeanSelectCreatePanel<Turnout> bp, String reference) {
        if (bp == null) {
            return null;
        }
        bp.setReference(reference);
        try {
            return bp.getNamedBean();
        }
        catch (JmriException jmriException) {
            log.warn("skipping creation of turnout not found for {}", (Object)reference);
            return null;
        }
    }

    @Override
    protected String getClassName() {
        return SignalHeadTableAction.class.getName();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleSignalTable");
    }

    public void dccSignalPanel() {
        this.dccSignalPanel = new JPanel();
        this.dccSignalPanel.setLayout(new GridLayout(0, 2));
        this.dccAspect = new JSpinner[DccSignalHead.getDefaultValidStates().length];
        int i = 0;
        while (i < DccSignalHead.getDefaultValidStates().length) {
            String aspect = DccSignalHead.getDefaultValidStateNames()[i];
            this.dccSignalPanel.add(new JLabel(aspect));
            SpinnerNumberModel DccSpinnerModel = new SpinnerNumberModel(1, 0, 31, 1);
            JSpinner tmp = new JSpinner(DccSpinnerModel);
            tmp.setValue(DccSignalHead.getDefaultNumberForAppearance(DccSignalHead.getDefaultValidStates()[i]));
            this.dccAspect[i] = tmp;
            this.dccSignalPanel.add(tmp);
            tmp.setToolTipText(Bundle.getMessage("DccAccessoryAspect", i));
            ++i;
        }
    }

    public void dccSignalPanelEdt() {
        this.dccSignalPanelEdt = new JPanel();
        this.dccSignalPanelEdt.setLayout(new GridLayout(0, 2));
        this.dccAspectEdt = new JSpinner[DccSignalHead.getDefaultValidStates().length];
        int i = 0;
        while (i < DccSignalHead.getDefaultValidStates().length) {
            JSpinner tmp;
            String aspect = DccSignalHead.getDefaultValidStateNames()[i];
            this.dccSignalPanelEdt.add(new JLabel(aspect));
            SpinnerNumberModel DccSpinnerModel = new SpinnerNumberModel(1, 0, 31, 1);
            this.dccAspectEdt[i] = tmp = new JSpinner(DccSpinnerModel);
            this.dccSignalPanelEdt.add(tmp);
            tmp.setToolTipText(Bundle.getMessage("DccAccessoryAspect", i));
            ++i;
        }
    }
}

