/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalGroup;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.implementation.SingleTurnoutSignalHead;
import jmri.jmrit.beantable.Bundle;
import jmri.swing.RowSorterUtil;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalGroupSubTableAction {
    private static String[] oper = new String[]{"AND", "OR"};
    private static int[] operValues;
    JLabel _systemName;
    JComboBox<String> _OnAppearance;
    JComboBox<String> _OffAppearance;
    JLabel spacer = new JLabel("       ");
    JComboBox<String> _SensorTurnoutOper = new JComboBox<String>(oper);
    JmriJFrame addSubFrame = null;
    SignalGroupTurnoutModel _SignalGroupTurnoutModel;
    JScrollPane _SignalGroupTurnoutScrollPane;
    SignalGroupSensorModel _SignalGroupSensorModel;
    JScrollPane _SignalGroupSensorScrollPane;
    ButtonGroup selGroup = null;
    JRadioButton allButton = null;
    JRadioButton includedButton = null;
    JLabel nameLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameSignalHead")));
    JLabel signalOnStateLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("OnAppearance")));
    JLabel signalOffStateLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("OffAppearance")));
    JLabel userLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("SelectConditionsOn")));
    JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    JButton updateSubButton = new JButton(Bundle.getMessage("ButtonApply"));
    static String updateInst;
    JLabel status1 = new JLabel(updateInst);
    JPanel p2xt = null;
    JPanel p2xs = null;
    SignalGroup curSignalGroup = null;
    String curHeadName;
    SignalHead curSignalHead;
    private boolean showAll = true;
    private static int ROW_HEIGHT;
    private static String[] COLUMN_NAMES;
    private static String SET_TO_ACTIVE;
    private static String SET_TO_INACTIVE;
    private static final String SET_TO_CLOSED;
    private static final String SET_TO_THROWN;
    private static String[] sensorInputModes;
    private static int[] sensorInputModeValues;
    private static String[] signalStates;
    private static int[] signalStatesValues;
    private static String[] turnoutInputModes;
    private static int[] turnoutInputModeValues;
    private ArrayList<SignalGroupTurnout> _turnoutList;
    private ArrayList<SignalGroupTurnout> _includedTurnoutList;
    private ArrayList<SignalGroupSensor> _sensorList;
    private ArrayList<SignalGroupSensor> _includedSensorList;
    private static final Logger log;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        operValues = nArray;
        updateInst = Bundle.getMessage("ClickToApply", Bundle.getMessage("ButtonApply"));
        COLUMN_NAMES = new String[]{Bundle.getMessage("ColumnSystemName"), Bundle.getMessage("ColumnUserName"), Bundle.getMessage("Include"), Bundle.getMessage("ColumnLabelSetState")};
        SET_TO_ACTIVE = Bundle.getMessage("SensorStateActive");
        SET_TO_INACTIVE = Bundle.getMessage("SensorStateInactive");
        SET_TO_CLOSED = InstanceManager.getDefault(TurnoutManager.class).getClosedText();
        SET_TO_THROWN = InstanceManager.getDefault(TurnoutManager.class).getThrownText();
        sensorInputModes = new String[]{Bundle.getMessage("SensorStateActive"), Bundle.getMessage("SensorStateInactive")};
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        sensorInputModeValues = nArray2;
        signalStates = new String[]{Bundle.getMessage("SignalHeadStateDark"), Bundle.getMessage("SignalHeadStateRed"), Bundle.getMessage("SignalHeadStateYellow"), Bundle.getMessage("SignalHeadStateGreen"), Bundle.getMessage("SignalHeadStateLunar")};
        int[] nArray3 = new int[5];
        nArray3[1] = 1;
        nArray3[2] = 4;
        nArray3[3] = 16;
        nArray3[4] = 64;
        signalStatesValues = nArray3;
        turnoutInputModes = new String[]{SET_TO_CLOSED, SET_TO_THROWN};
        turnoutInputModeValues = new int[]{2, 4};
        log = LoggerFactory.getLogger(SignalGroupSubTableAction.class);
    }

    public SignalGroupSubTableAction(String s) {
    }

    public SignalGroupSubTableAction() {
        this("Signal Group Head Edit Table");
    }

    String helpTarget() {
        return "package.jmri.jmrit.beantable.SignalGroupTable";
    }

    void setoperBox(boolean mode, JComboBox<String> box) {
        int _mode = 0;
        if (mode) {
            _mode = 1;
        }
        String result = StringUtil.getNameFromState(_mode, operValues, oper);
        box.setSelectedItem(result);
    }

    boolean operFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, operValues, oper);
        if (result < 0) {
            log.warn("unexpected mode string in Signal Head Appearance Mode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result != 0;
    }

    int headStateFromBox(JComboBox<String> box) throws IllegalArgumentException {
        SignalHead sig = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(this.curHeadName);
        String mode = (String)box.getSelectedItem();
        int result = sig != null ? StringUtil.getStateFromName(mode, sig.getValidStates(), sig.getValidStateNames()) : StringUtil.getStateFromName(mode, signalStatesValues, signalStates);
        if (result < 0) {
            log.warn("unexpected mode string in signalHeadMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    void setSignalHeadStateBox(int mode, JComboBox<String> box) {
        SignalHead sig = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(this.curHeadName);
        if (sig != null) {
            String result = StringUtil.getNameFromState(mode, sig.getValidStates(), sig.getValidStateNames());
            box.setSelectedItem(result);
        } else {
            log.error("Failed to get signal head {}", (Object)this.curHeadName);
        }
    }

    int sensorModeFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, sensorInputModeValues, sensorInputModes);
        if (result < 0) {
            log.warn("unexpected mode string in Signal Head Appearance: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    void setSensorModeBox(int mode, JComboBox<String> box) {
        String result = StringUtil.getNameFromState(mode, sensorInputModeValues, sensorInputModes);
        box.setSelectedItem(result);
    }

    int turnoutModeFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, turnoutInputModeValues, turnoutInputModes);
        if (result < 0) {
            log.warn("unexpected mode string in turnoutMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    void setTurnoutModeBox(int mode, JComboBox<String> box) {
        String result = StringUtil.getNameFromState(mode, turnoutInputModeValues, turnoutInputModes);
        box.setSelectedItem(result);
    }

    void editHead(SignalGroup g, String headName) {
        this.curSignalGroup = g;
        this.curHeadName = headName;
        this.curSignalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(this.curHeadName);
        if (this.curSignalHead != null) {
            this._OnAppearance = new JComboBox<String>(this.curSignalHead.getValidStateNames());
            this._OffAppearance = new JComboBox<String>(this.curSignalHead.getValidStateNames());
        }
        this._systemName = new JLabel(headName);
        this._systemName.setVisible(true);
        TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
        this._turnoutList = new ArrayList(tm.getNamedBeanSet().size());
        tm.getNamedBeanSet().stream().filter(turn -> turn != null).forEachOrdered(turn -> this._turnoutList.add(new SignalGroupTurnout(turn.getSystemName(), turn.getUserName())));
        SensorManager sm = InstanceManager.getDefault(SensorManager.class);
        this._sensorList = new ArrayList(sm.getNamedBeanSet().size());
        sm.getNamedBeanSet().stream().filter(sen -> sen != null).forEachOrdered(sen -> this._sensorList.add(new SignalGroupSensor(sen.getSystemName(), sen.getUserName())));
        this.initializeIncludedList();
        if (this.addSubFrame == null) {
            this.addSubFrame = new JmriJFrame(String.valueOf(Bundle.getMessage("EditSignalGroup")) + " - " + Bundle.getMessage("BeanNameSignalHead"), false, true);
            this.addSubFrame.addHelpMenu("package.jmri.jmrit.beantable.SignalGroupAddEdit", true);
            this.addSubFrame.setLocation(100, 30);
            this.addSubFrame.getContentPane().setLayout(new BoxLayout(this.addSubFrame.getContentPane(), 1));
            Container contentPane = this.addSubFrame.getContentPane();
            JPanel ps = new JPanel();
            ps.setLayout(new FlowLayout());
            ps.add(this.nameLabel);
            ps.add(this._systemName);
            contentPane.add(ps);
            JPanel pc = new JPanel();
            pc.setLayout(new FlowLayout());
            pc.add(this.signalOnStateLabel);
            pc.add(this._OnAppearance);
            this._OnAppearance.setToolTipText(Bundle.getMessage("StateWhenMetTooltip"));
            pc.add(this.spacer);
            pc.add(this.signalOffStateLabel);
            pc.add(this._OffAppearance);
            this._OffAppearance.setToolTipText(Bundle.getMessage("StateWhenNotMetTooltip"));
            contentPane.add(pc);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.userLabel);
            contentPane.add(p);
            if (this.curSignalHead.getClass().getName().contains("SingleTurnoutSignalHead")) {
                SingleTurnoutSignalHead stsh = (SingleTurnoutSignalHead)InstanceManager.getDefault(SignalHeadManager.class).getByUserName(this.curHeadName);
                if (stsh == null) {
                    stsh = (SingleTurnoutSignalHead)InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(this.curHeadName);
                }
                if (stsh != null) {
                    log.debug("SGsubTA #279 editHead: setting props for signal head {}", (Object)this.curHeadName);
                    if (g.getHeadOnState(this.curSignalHead) == 0 && g.getHeadOffState(this.curSignalHead) == 0) {
                        g.setHeadOnState(this.curSignalHead, stsh.getOnAppearance());
                        g.setHeadOffState(this.curSignalHead, stsh.getOffAppearance());
                    }
                } else {
                    log.error("Failed to get signal head object named {}", (Object)this.curHeadName);
                }
            }
            this.setSignalHeadStateBox(g.getHeadOnState(this.curSignalHead), this._OnAppearance);
            this.setSignalHeadStateBox(g.getHeadOffState(this.curSignalHead), this._OffAppearance);
            JPanel py = new JPanel();
            py.add(new JLabel(Bundle.getMessage("Show")));
            this.selGroup = new ButtonGroup();
            this.allButton = new JRadioButton(Bundle.getMessage("All"), true);
            this.selGroup.add(this.allButton);
            py.add(this.allButton);
            this.allButton.addActionListener(e -> {
                if (!this.showAll) {
                    this.showAll = true;
                    this._SignalGroupTurnoutModel.fireTableDataChanged();
                    this._SignalGroupSensorModel.fireTableDataChanged();
                }
            });
            this.includedButton = new JRadioButton(Bundle.getMessage("Included"), false);
            this.selGroup.add(this.includedButton);
            py.add(this.includedButton);
            this.includedButton.addActionListener(e -> {
                if (this.showAll) {
                    this.showAll = false;
                    this.initializeIncludedList();
                    this._SignalGroupTurnoutModel.fireTableDataChanged();
                    this._SignalGroupSensorModel.fireTableDataChanged();
                }
            });
            py.add(new JLabel("  " + Bundle.getMessage("_and_", Bundle.getMessage("Turnouts"), Bundle.getMessage("Sensors"))));
            contentPane.add(py);
            this.p2xt = new JPanel();
            JPanel p2xtSpace = new JPanel();
            p2xtSpace.setLayout(new BoxLayout(p2xtSpace, 1));
            p2xtSpace.add(new JLabel("XXX"));
            this.p2xt.add(p2xtSpace);
            JPanel p21t = new JPanel();
            p21t.setLayout(new BoxLayout(p21t, 1));
            p21t.add(new JLabel(Bundle.getMessage("SelectInGroup", Bundle.getMessage("Turnouts"))));
            this.p2xt.add(p21t);
            this._SignalGroupTurnoutModel = new SignalGroupTurnoutModel();
            JTable SignalGroupTurnoutTable = new JTable(this._SignalGroupTurnoutModel);
            TableRowSorter<SignalGroupTurnoutModel> sgtSorter = new TableRowSorter<SignalGroupTurnoutModel>(this._SignalGroupTurnoutModel);
            RowSorterUtil.setSortOrder(sgtSorter, 0, SortOrder.ASCENDING);
            SignalGroupTurnoutTable.setRowSorter(sgtSorter);
            SignalGroupTurnoutTable.setRowSelectionAllowed(false);
            SignalGroupTurnoutTable.setPreferredScrollableViewportSize(new Dimension(480, 80));
            SignalGroupSubTableAction.setRowHeight(SignalGroupTurnoutTable.getRowHeight());
            JComboBox<String> stateTCombo = new JComboBox<String>();
            stateTCombo.addItem(SET_TO_CLOSED);
            stateTCombo.addItem(SET_TO_THROWN);
            TableColumnModel SignalGroupTurnoutColumnModel = SignalGroupTurnoutTable.getColumnModel();
            TableColumn includeColumnT = SignalGroupTurnoutColumnModel.getColumn(2);
            includeColumnT.setResizable(false);
            includeColumnT.setMinWidth(50);
            includeColumnT.setMaxWidth(60);
            TableColumn sNameColumnT = SignalGroupTurnoutColumnModel.getColumn(0);
            sNameColumnT.setResizable(true);
            sNameColumnT.setMinWidth(75);
            sNameColumnT.setMaxWidth(95);
            TableColumn uNameColumnT = SignalGroupTurnoutColumnModel.getColumn(1);
            uNameColumnT.setResizable(true);
            uNameColumnT.setMinWidth(210);
            uNameColumnT.setMaxWidth(260);
            TableColumn stateColumnT = SignalGroupTurnoutColumnModel.getColumn(3);
            stateColumnT.setCellEditor(new DefaultCellEditor(stateTCombo));
            stateColumnT.setResizable(false);
            stateColumnT.setMinWidth(90);
            stateColumnT.setMaxWidth(100);
            this._SignalGroupTurnoutScrollPane = new JScrollPane(SignalGroupTurnoutTable);
            this.p2xt.add((Component)this._SignalGroupTurnoutScrollPane, "Center");
            contentPane.add(this.p2xt);
            this.p2xt.setVisible(true);
            JPanel po = new JPanel();
            po.setLayout(new FlowLayout());
            JLabel operLabel = new JLabel(Bundle.getMessage("ChooseOrAnd"));
            po.add(operLabel);
            po.add(this._SensorTurnoutOper);
            contentPane.add(po);
            this.p2xs = new JPanel();
            JPanel p2xsSpace = new JPanel();
            p2xsSpace.setLayout(new BoxLayout(p2xsSpace, 1));
            p2xsSpace.add(new JLabel("XXX"));
            this.p2xs.add(p2xsSpace);
            JPanel p21s = new JPanel();
            p21s.setLayout(new BoxLayout(p21s, 1));
            p21s.add(new JLabel(Bundle.getMessage("SelectInGroup", Bundle.getMessage("Sensors"))));
            this.p2xs.add(p21s);
            this._SignalGroupSensorModel = new SignalGroupSensorModel();
            JTable SignalGroupSensorTable = new JTable(this._SignalGroupSensorModel);
            TableRowSorter<SignalGroupSensorModel> sgsSorter = new TableRowSorter<SignalGroupSensorModel>(this._SignalGroupSensorModel);
            RowSorterUtil.setSortOrder(sgsSorter, 0, SortOrder.ASCENDING);
            SignalGroupSensorTable.setRowSorter(sgsSorter);
            SignalGroupSensorTable.setRowSelectionAllowed(false);
            SignalGroupSensorTable.setPreferredScrollableViewportSize(new Dimension(480, 80));
            JComboBox<String> stateSCombo = new JComboBox<String>();
            stateSCombo.addItem(SET_TO_ACTIVE);
            stateSCombo.addItem(SET_TO_INACTIVE);
            TableColumnModel SignalGroupSensorColumnModel = SignalGroupSensorTable.getColumnModel();
            TableColumn includeColumnS = SignalGroupSensorColumnModel.getColumn(2);
            includeColumnS.setResizable(false);
            includeColumnS.setMinWidth(50);
            includeColumnS.setMaxWidth(60);
            TableColumn sNameColumnS = SignalGroupSensorColumnModel.getColumn(0);
            sNameColumnS.setResizable(true);
            sNameColumnS.setMinWidth(75);
            sNameColumnS.setMaxWidth(95);
            TableColumn uNameColumnS = SignalGroupSensorColumnModel.getColumn(1);
            uNameColumnS.setResizable(true);
            uNameColumnS.setMinWidth(210);
            uNameColumnS.setMaxWidth(260);
            TableColumn stateColumnS = SignalGroupSensorColumnModel.getColumn(3);
            stateColumnS.setCellEditor(new DefaultCellEditor(stateSCombo));
            stateColumnS.setResizable(false);
            stateColumnS.setMinWidth(90);
            stateColumnS.setMaxWidth(100);
            this._SignalGroupSensorScrollPane = new JScrollPane(SignalGroupSensorTable);
            this.p2xs.add((Component)this._SignalGroupSensorScrollPane, "Center");
            contentPane.add(this.p2xs);
            this.p2xs.setVisible(true);
            JPanel pa = new JPanel();
            pa.setLayout(new BoxLayout(pa, 1));
            JPanel p1 = new JPanel();
            p1.setLayout(new FlowLayout());
            this.status1.setFont(this.status1.getFont().deriveFont(0.9f * (float)this.nameLabel.getFont().getSize()));
            this.status1.setForeground(Color.gray);
            p1.add(this.status1);
            pa.add(p1);
            Border pBorder = BorderFactory.createEtchedBorder();
            pa.setBorder(pBorder);
            contentPane.add(pa);
            JPanel pb = new JPanel();
            pb.setLayout(new FlowLayout(4));
            pb.add(this.cancelButton);
            this.cancelButton.addActionListener(this::cancelSubPressed);
            pb.add(this.updateSubButton);
            this.updateSubButton.addActionListener(e -> this.updateSubPressed(e, false));
            this.updateSubButton.setToolTipText(Bundle.getMessage("TooltipUpdateGroup"));
            p2xtSpace.setVisible(false);
            p2xsSpace.setVisible(false);
            this.updateSubButton.setVisible(true);
            contentPane.add(pb);
            this.addSubFrame.pack();
        }
        this.addSubFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SignalGroupSubTableAction.this.addSubFrame.setVisible(false);
                SignalGroupSubTableAction.this.cancelSubEdit();
                SignalGroupSubTableAction.this._SignalGroupSensorModel.dispose();
                SignalGroupSubTableAction.this._SignalGroupTurnoutModel.dispose();
            }
        });
        this.addSubFrame.setVisible(true);
        this.setoperBox(this.curSignalGroup.getSensorTurnoutOper(this.curSignalHead), this._SensorTurnoutOper);
        this.setSignalHeadStateBox(this.curSignalGroup.getHeadOnState(this.curSignalHead), this._OnAppearance);
        this.setSignalHeadStateBox(this.curSignalGroup.getHeadOffState(this.curSignalHead), this._OffAppearance);
        int setRow = 0;
        int i = this._turnoutList.size() - 1;
        while (i >= 0) {
            SignalGroupTurnout turnout = this._turnoutList.get(i);
            Turnout tTurnout = turnout.getTurnout();
            if (this.curSignalGroup.isTurnoutIncluded(this.curSignalHead, tTurnout)) {
                turnout.setIncluded(true);
                turnout.setState(this.curSignalGroup.getTurnoutState(this.curSignalHead, tTurnout));
                setRow = i;
            } else {
                turnout.setIncluded(false);
                turnout.setState(2);
            }
            --i;
        }
        if (--setRow < 0) {
            setRow = 0;
        }
        this._SignalGroupTurnoutScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._SignalGroupTurnoutModel.fireTableDataChanged();
        i = this._sensorList.size() - 1;
        while (i >= 0) {
            SignalGroupSensor sensor = this._sensorList.get(i);
            Sensor tSensor = sensor.getSensor();
            if (this.curSignalGroup.isSensorIncluded(this.curSignalHead, tSensor)) {
                sensor.setIncluded(true);
                sensor.setState(this.curSignalGroup.getSensorState(this.curSignalHead, tSensor));
            } else {
                sensor.setIncluded(false);
                sensor.setState(4);
            }
            --i;
        }
        this.status1.setText(updateInst);
        this.updateSubButton.setVisible(true);
    }

    void initializeIncludedList() {
        this._includedTurnoutList = new ArrayList();
        int i = 0;
        while (i < this._turnoutList.size()) {
            if (this._turnoutList.get(i).isIncluded()) {
                this._includedTurnoutList.add(this._turnoutList.get(i));
            }
            ++i;
        }
        this._includedSensorList = new ArrayList();
        i = 0;
        while (i < this._sensorList.size()) {
            if (this._sensorList.get(i).isIncluded()) {
                this._includedSensorList.add(this._sensorList.get(i));
            }
            ++i;
        }
    }

    int setTurnoutInformation(SignalGroup g) {
        int i = 0;
        while (i < this._includedTurnoutList.size()) {
            SignalGroupTurnout t = this._includedTurnoutList.get(i);
            g.setHeadAlignTurnout(this.curSignalHead, t.getTurnout(), t.getState());
            ++i;
        }
        return this._includedTurnoutList.size();
    }

    int setSensorInformation(SignalGroup g) {
        int i = 0;
        while (i < this._includedSensorList.size()) {
            SignalGroupSensor s = this._includedSensorList.get(i);
            g.setHeadAlignSensor(this.curSignalHead, s.getSensor(), s.getState());
            ++i;
        }
        return this._includedSensorList.size();
    }

    void cancelSubPressed(ActionEvent e) {
        log.debug("Edit Signal Group Head canceled in SGSTA line 569");
        this.cancelSubEdit();
        this._SignalGroupSensorModel.dispose();
        this._SignalGroupTurnoutModel.dispose();
    }

    void updateSubPressed(ActionEvent e, boolean newSignalGroup) {
        this.curSignalGroup.clearHeadTurnout(this.curSignalHead);
        this.curSignalGroup.clearHeadSensor(this.curSignalHead);
        this.initializeIncludedList();
        this.setTurnoutInformation(this.curSignalGroup);
        this.setSensorInformation(this.curSignalGroup);
        this.curSignalGroup.setHeadOnState(this.curSignalHead, this.headStateFromBox(this._OnAppearance));
        this.curSignalGroup.setHeadOffState(this.curSignalHead, this.headStateFromBox(this._OffAppearance));
        this.curSignalGroup.setSensorTurnoutOper(this.curSignalHead, this.operFromBox(this._SensorTurnoutOper));
        this.finishUpdate();
    }

    void finishUpdate() {
        this.cancelIncludedOnly();
        this.updateSubButton.setVisible(false);
        this.addSubFrame.setVisible(false);
    }

    void cancelSubEdit() {
        this.curSignalGroup = null;
        this.finishUpdate();
    }

    void cancelIncludedOnly() {
        if (!this.showAll) {
            this.allButton.doClick();
        }
    }

    private static synchronized void setRowHeight(int newVal) {
        ROW_HEIGHT = newVal;
    }

    private abstract class SignalGroupElement {
        String _sysName;
        String _userName;
        boolean _included;
        int _setToState;

        SignalGroupElement(String sysName, String userName) {
            this._sysName = sysName;
            this._userName = userName;
            this._included = false;
            this._setToState = 4;
        }

        String getSysName() {
            return this._sysName;
        }

        String getUserName() {
            return this._userName;
        }

        boolean isIncluded() {
            return this._included;
        }

        void setIncluded(boolean include) {
            this._included = include;
        }

        abstract String getSetToState();

        abstract void setSetToState(String var1);

        int getState() {
            return this._setToState;
        }

        void setState(int state) {
            this._setToState = state;
        }
    }

    public abstract class SignalGroupOutputModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SNAME_COLUMN = 0;
        public static final int UNAME_COLUMN = 1;
        public static final int INCLUDE_COLUMN = 2;
        public static final int STATE_COLUMN = 3;

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public String getColumnName(int c) {
            return COLUMN_NAMES[c];
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 2 || c == 3;
        }

        public String getDisplayName(int r) {
            if ((String)this.getValueAt(r, 1) != null || !((String)this.getValueAt(r, 1)).isEmpty()) {
                return (String)this.getValueAt(r, 1);
            }
            return (String)this.getValueAt(r, 0);
        }
    }

    private class SignalGroupSensor
    extends SignalGroupElement {
        SignalGroupSensor(String sysName, String userName) {
            super(sysName, userName);
        }

        @Override
        String getSetToState() {
            switch (this._setToState) {
                case 4: {
                    return SET_TO_INACTIVE;
                }
                case 2: {
                    return SET_TO_ACTIVE;
                }
            }
            return "";
        }

        @Override
        void setSetToState(String state) {
            if (SET_TO_INACTIVE.equals(state)) {
                this._setToState = 4;
            } else if (SET_TO_ACTIVE.equals(state)) {
                this._setToState = 2;
            }
        }

        Sensor getSensor() {
            return InstanceManager.getDefault(SensorManager.class).getSensor(this._sysName);
        }
    }

    class SignalGroupSensorModel
    extends SignalGroupOutputModel {
        SignalGroupSensorModel() {
            this.init();
        }

        final void init() {
            InstanceManager.getDefault(SensorManager.class).addPropertyChangeListener(this);
        }

        public void dispose() {
            InstanceManager.getDefault(SensorManager.class).removePropertyChangeListener(this);
        }

        @Override
        public int getRowCount() {
            return SignalGroupSubTableAction.this.showAll ? SignalGroupSubTableAction.this._sensorList.size() : SignalGroupSubTableAction.this._includedSensorList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            ArrayList sensorList;
            ArrayList arrayList = sensorList = SignalGroupSubTableAction.this.showAll ? SignalGroupSubTableAction.this._sensorList : SignalGroupSubTableAction.this._includedSensorList;
            if (r >= sensorList.size()) {
                log.debug("SGSTA getValueAt #766: row is greater than sensor list size");
                return null;
            }
            switch (c) {
                case 2: {
                    return ((SignalGroupSensor)sensorList.get(r)).isIncluded();
                }
                case 0: {
                    return ((SignalGroupSensor)sensorList.get(r)).getSysName();
                }
                case 1: {
                    return ((SignalGroupSensor)sensorList.get(r)).getUserName();
                }
                case 3: {
                    return ((SignalGroupSensor)sensorList.get(r)).getSetToState();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            ArrayList sensorList = SignalGroupSubTableAction.this.showAll ? SignalGroupSubTableAction.this._sensorList : SignalGroupSubTableAction.this._includedSensorList;
            switch (c) {
                case 2: {
                    ((SignalGroupSensor)sensorList.get(r)).setIncluded((Boolean)type);
                    break;
                }
                case 3: {
                    ((SignalGroupSensor)sensorList.get(r)).setSetToState((String)type);
                    break;
                }
            }
        }
    }

    private class SignalGroupTurnout
    extends SignalGroupElement {
        SignalGroupTurnout(String sysName, String userName) {
            super(sysName, userName);
        }

        @Override
        String getSetToState() {
            switch (this._setToState) {
                case 2: {
                    return SET_TO_CLOSED;
                }
                case 4: {
                    return SET_TO_THROWN;
                }
            }
            return "";
        }

        @Override
        void setSetToState(String state) {
            if (SET_TO_CLOSED.equals(state)) {
                this._setToState = 2;
            } else if (SET_TO_THROWN.equals(state)) {
                this._setToState = 4;
            }
        }

        Turnout getTurnout() {
            return InstanceManager.getDefault(TurnoutManager.class).getTurnout(this._sysName);
        }
    }

    class SignalGroupTurnoutModel
    extends SignalGroupOutputModel {
        SignalGroupTurnoutModel() {
            this.init();
        }

        final void init() {
            InstanceManager.getDefault(TurnoutManager.class).addPropertyChangeListener(this);
        }

        public void dispose() {
            InstanceManager.getDefault(TurnoutManager.class).removePropertyChangeListener(this);
        }

        @Override
        public int getRowCount() {
            return SignalGroupSubTableAction.this.showAll ? SignalGroupSubTableAction.this._turnoutList.size() : SignalGroupSubTableAction.this._includedTurnoutList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            ArrayList turnoutList;
            ArrayList arrayList = turnoutList = SignalGroupSubTableAction.this.showAll ? SignalGroupSubTableAction.this._turnoutList : SignalGroupSubTableAction.this._includedTurnoutList;
            if (r >= turnoutList.size()) {
                log.debug("SGSTA getValueAt #703: row index is greater than turnout list size");
                return null;
            }
            switch (c) {
                case 2: {
                    return ((SignalGroupTurnout)turnoutList.get(r)).isIncluded();
                }
                case 0: {
                    return ((SignalGroupTurnout)turnoutList.get(r)).getSysName();
                }
                case 1: {
                    return ((SignalGroupTurnout)turnoutList.get(r)).getUserName();
                }
                case 3: {
                    return ((SignalGroupTurnout)turnoutList.get(r)).getSetToState();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            ArrayList turnoutList = SignalGroupSubTableAction.this.showAll ? SignalGroupSubTableAction.this._turnoutList : SignalGroupSubTableAction.this._includedTurnoutList;
            switch (c) {
                case 2: {
                    ((SignalGroupTurnout)turnoutList.get(r)).setIncluded((Boolean)type);
                    break;
                }
                case 3: {
                    ((SignalGroupTurnout)turnoutList.get(r)).setSetToState((String)type);
                    break;
                }
            }
        }
    }
}

