/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.Nonnull;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.AbstractTableTabAction;
import jmri.jmrit.beantable.AddNewHardwareDevicePanel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.sensor.SensorTableDataModel;
import jmri.jmrix.internal.InternalSensorManager;
import jmri.swing.ManagerComboBox;
import jmri.swing.SystemNameValidator;
import jmri.util.JmriJFrame;
import jmri.util.swing.TriStateJCheckBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorTableAction
extends AbstractTableAction<Sensor> {
    protected SensorManager sensorManager = InstanceManager.getDefault(SensorManager.class);
    JmriJFrame addFrame = null;
    JTextField hardwareAddressTextField = new JTextField(20);
    JTextField userNameField = new JTextField(40);
    ManagerComboBox<Sensor> prefixBox = new ManagerComboBox();
    SpinnerNumberModel rangeSpinner = new SpinnerNumberModel(1, 1, 100, 1);
    JSpinner numberToAddSpinner = new JSpinner(this.rangeSpinner);
    JCheckBox rangeBox = new JCheckBox(Bundle.getMessage("AddRangeBox"));
    JLabel hwAddressLabel = new JLabel(Bundle.getMessage("LabelHardwareAddress"));
    JLabel userNameLabel = new JLabel(Bundle.getMessage("LabelUserName"));
    String systemSelectionCombo = String.valueOf(this.getClass().getName()) + ".SystemSelected";
    JButton addButton;
    JLabel statusBarLabel = new JLabel(Bundle.getMessage("HardwareAddStatusEnter"), 10);
    UserPreferencesManager p;
    Manager<Sensor> connectionChoice = null;
    SystemNameValidator hardwareAddressValidator;
    private String addEntryToolTip;
    private final TriStateJCheckBox showDebounceBox = new TriStateJCheckBox(Bundle.getMessage("SensorDebounceCheckBox"));
    private final TriStateJCheckBox showPullUpBox = new TriStateJCheckBox(Bundle.getMessage("SensorPullUpCheckBox"));
    private final TriStateJCheckBox showStateForgetAndQueryBox = new TriStateJCheckBox(Bundle.getMessage("ShowStateForgetAndQuery"));
    private static final Logger log = LoggerFactory.getLogger(SensorTableAction.class);

    public SensorTableAction(String actionName) {
        super(actionName);
        if (this.sensorManager == null) {
            super.setEnabled(false);
        }
    }

    public SensorTableAction() {
        this(Bundle.getMessage("TitleSensorTable"));
    }

    @Override
    public void setManager(@Nonnull Manager<Sensor> s) {
        if (s instanceof SensorManager) {
            log.debug("setting manager of ST Action{} to {}", (Object)this, s.getClass());
            this.sensorManager = (SensorManager)s;
            if (this.m != null) {
                this.m.setManager(this.sensorManager);
            }
        }
    }

    @Override
    protected void createModel() {
        this.m = new SensorTableDataModel(this.sensorManager);
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleSensorTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.SensorTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.p = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddSensor"));
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.SensorAddEdit", true);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            ActionListener createListener = this::createPressed;
            ActionListener cancelListener = this::cancelPressed;
            ActionListener rangeListener = this::canAddRange;
            this.configureManagerComboBox(this.prefixBox, this.sensorManager, SensorManager.class);
            this.userNameField.setName("userName");
            this.prefixBox.setName("prefixBox");
            this.addButton = new JButton(Bundle.getMessage("ButtonCreate"));
            this.addButton.addActionListener(createListener);
            log.debug("add frame hwAddValidator is {} prefix box is {}", (Object)this.hardwareAddressValidator, this.prefixBox.getSelectedItem());
            if (this.hardwareAddressValidator == null) {
                this.hardwareAddressValidator = new SystemNameValidator(this.hardwareAddressTextField, (Manager<?>)this.prefixBox.getSelectedItem(), true);
            } else {
                this.hardwareAddressValidator.setManager((Manager<?>)this.prefixBox.getSelectedItem());
            }
            this.addFrame.add(new AddNewHardwareDevicePanel(this.hardwareAddressTextField, this.hardwareAddressValidator, this.userNameField, this.prefixBox, this.numberToAddSpinner, this.rangeBox, this.addButton, cancelListener, rangeListener, this.statusBarLabel));
            this.canAddRange(null);
            this.addFrame.setEscapeKeyClosesWindow(true);
            this.addFrame.getRootPane().setDefaultButton(this.addButton);
        }
        this.hardwareAddressTextField.setName("hwAddressTextField");
        this.addButton.setName("createButton");
        this.statusBarLabel.setText(Bundle.getMessage("HardwareAddStatusEnter"));
        this.statusBarLabel.setForeground(Color.gray);
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    void cancelPressed(ActionEvent e) {
        this.removePrefixBoxListener(this.prefixBox);
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    void createPressed(ActionEvent e) {
        int numberOfSensors = 1;
        if (this.rangeBox.isSelected()) {
            numberOfSensors = (Integer)this.numberToAddSpinner.getValue();
        }
        if (numberOfSensors >= 65 && JOptionPane.showConfirmDialog(this.addFrame, Bundle.getMessage("WarnExcessBeans", Bundle.getMessage("Sensors"), numberOfSensors), Bundle.getMessage("WarningTitle"), 0) == 1) {
            return;
        }
        String sensorPrefix = this.prefixBox.getSelectedItem().getSystemPrefix();
        String uName = this.userNameField.getText();
        String curAddress = this.hardwareAddressTextField.getText();
        if (curAddress.length() < 1) {
            this.statusBarLabel.setText(Bundle.getMessage("WarningEmptyHardwareAddress"));
            this.statusBarLabel.setForeground(Color.red);
            this.hardwareAddressTextField.setBackground(Color.red);
            return;
        }
        this.hardwareAddressTextField.setBackground(Color.white);
        String statusMessage = Bundle.getMessage("ItemCreateFeedback", Bundle.getMessage("BeanNameSensor"));
        int x = 0;
        while (x < numberOfSensors) {
            Sensor s;
            log.debug("b4 next valid addr for prefix {} conn choice mgr {}", (Object)sensorPrefix, this.connectionChoice);
            try {
                curAddress = InstanceManager.getDefault(SensorManager.class).getNextValidAddress(curAddress, sensorPrefix, false);
            }
            catch (JmriException ex) {
                this.displayHwError(curAddress, ex);
                this.statusBarLabel.setText(Bundle.getMessage("ErrorConvertHW", curAddress));
                this.statusBarLabel.setForeground(Color.red);
                return;
            }
            String sName = String.valueOf(sensorPrefix) + InstanceManager.getDefault(SensorManager.class).typeLetter() + curAddress;
            try {
                s = InstanceManager.getDefault(SensorManager.class).provideSensor(sName);
            }
            catch (IllegalArgumentException ex) {
                this.handleCreateException(ex, sName);
                return;
            }
            if (!uName.isEmpty()) {
                if (InstanceManager.getDefault(SensorManager.class).getByUserName(uName) == null) {
                    s.setUserName(uName);
                } else {
                    InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorDuplicateUserName", uName), this.getClassName(), "duplicateUserName", false, true);
                }
            }
            if (x == 0 || x == numberOfSensors - 1) {
                statusMessage = String.valueOf(statusMessage) + " " + sName + " (" + uName + ")";
            }
            if (x == numberOfSensors - 2) {
                statusMessage = String.valueOf(statusMessage) + " " + Bundle.getMessage("ItemCreateUpTo") + " ";
            }
            if (!uName.isEmpty()) {
                uName = this.nextName(uName);
            }
            ++x;
        }
        this.statusBarLabel.setText(statusMessage);
        this.statusBarLabel.setForeground(Color.gray);
        this.p.setComboBoxLastSelection(this.systemSelectionCombo, this.prefixBox.getSelectedItem().getMemo().getUserName());
        this.removePrefixBoxListener(this.prefixBox);
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    private void canAddRange(ActionEvent e) {
        this.rangeBox.setEnabled(false);
        this.rangeBox.setSelected(false);
        if (this.prefixBox.getSelectedIndex() == -1) {
            this.prefixBox.setSelectedIndex(0);
        }
        this.connectionChoice = this.prefixBox.getSelectedItem();
        String systemPrefix = this.connectionChoice.getSystemPrefix();
        this.rangeBox.setEnabled(((SensorManager)this.connectionChoice).allowMultipleAdditions(systemPrefix));
        this.addEntryToolTip = this.connectionChoice.getEntryToolTip();
        this.hardwareAddressTextField.setToolTipText(Bundle.getMessage("AddEntryToolTipLine1", this.connectionChoice.getMemo().getUserName(), Bundle.getMessage("Sensors"), this.addEntryToolTip));
        this.hardwareAddressValidator.setToolTipText(this.hardwareAddressTextField.getToolTipText());
        this.hardwareAddressValidator.verify(this.hardwareAddressTextField);
    }

    void handleCreateException(Exception ex, String hwAddress) {
        this.statusBarLabel.setText(ex.getLocalizedMessage());
        String err = Bundle.getMessage("ErrorBeanCreateFailed", InstanceManager.getDefault(SensorManager.class).getBeanTypeHandled(), hwAddress);
        JOptionPane.showMessageDialog(this.addFrame, String.valueOf(err) + "\n" + ex.getLocalizedMessage(), err, 0);
    }

    protected void setDefaultDebounce(JFrame _who) {
        SpinnerNumberModel activeSpinnerModel = new SpinnerNumberModel((Number)this.sensorManager.getDefaultSensorDebounceGoingActive(), Long.valueOf(0L), Sensor.MAX_DEBOUNCE, (Number)1L);
        JSpinner activeSpinner = new JSpinner(activeSpinnerModel);
        activeSpinner.setPreferredSize(new JTextField(Long.toString(Sensor.MAX_DEBOUNCE).length() + 1).getPreferredSize());
        SpinnerNumberModel inActiveSpinnerModel = new SpinnerNumberModel((Number)this.sensorManager.getDefaultSensorDebounceGoingInActive(), Long.valueOf(0L), Sensor.MAX_DEBOUNCE, (Number)1L);
        JSpinner inActiveSpinner = new JSpinner(inActiveSpinnerModel);
        inActiveSpinner.setPreferredSize(new JTextField(Long.toString(Sensor.MAX_DEBOUNCE).length() + 1).getPreferredSize());
        JPanel input = new JPanel();
        input.setLayout(new BoxLayout(input, 1));
        JTextArea message = new JTextArea(Bundle.getMessage("SensorGlobalDebounceMessageBox"));
        message.setEditable(false);
        message.setOpaque(false);
        input.add(message);
        JPanel active = new JPanel();
        active.add(new JLabel(Bundle.getMessage("SensorActiveTimer")));
        active.add(activeSpinner);
        input.add(active);
        JPanel inActive = new JPanel();
        inActive.add(new JLabel(Bundle.getMessage("SensorInactiveTimer")));
        inActive.add(inActiveSpinner);
        input.add(inActive);
        int retval = JOptionPane.showOptionDialog(_who, input, Bundle.getMessage("SensorGlobalDebounceMessageTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonCancel")}, null);
        log.debug("dialog retval={}", (Object)retval);
        if (retval != 0) {
            return;
        }
        this.sensorManager.setDefaultSensorDebounceGoingActive((Long)activeSpinner.getValue());
        this.sensorManager.setDefaultSensorDebounceGoingInActive((Long)inActiveSpinner.getValue());
        this.m.fireTableDataChanged();
    }

    protected void setDefaultState(JFrame _who) {
        String[] sensorStates = new String[]{Bundle.getMessage("BeanStateUnknown"), Bundle.getMessage("SensorStateInactive"), Bundle.getMessage("SensorStateActive"), Bundle.getMessage("BeanStateInconsistent")};
        JComboBox<String> stateCombo = new JComboBox<String>(sensorStates);
        switch (InternalSensorManager.getDefaultStateForNewSensors()) {
            case 2: {
                stateCombo.setSelectedItem(Bundle.getMessage("SensorStateActive"));
                break;
            }
            case 4: {
                stateCombo.setSelectedItem(Bundle.getMessage("SensorStateInactive"));
                break;
            }
            case 8: {
                stateCombo.setSelectedItem(Bundle.getMessage("BeanStateInconsistent"));
                break;
            }
            default: {
                stateCombo.setSelectedItem(Bundle.getMessage("BeanStateUnknown"));
            }
        }
        JPanel input = new JPanel();
        input.add(new JLabel(Bundle.getMessage("SensorInitialStateMessageBox")));
        JPanel stateBoxPane = new JPanel();
        stateBoxPane.add(stateCombo);
        input.add(stateBoxPane);
        int retval = JOptionPane.showOptionDialog(_who, input, Bundle.getMessage("InitialSensorState"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonCancel")}, null);
        if (retval != 0) {
            return;
        }
        int defaultState = 1;
        String selectedState = (String)stateCombo.getSelectedItem();
        if (selectedState.equals(Bundle.getMessage("SensorStateActive"))) {
            defaultState = 2;
        } else if (selectedState.equals(Bundle.getMessage("SensorStateInactive"))) {
            defaultState = 4;
        } else if (selectedState.equals(Bundle.getMessage("BeanStateInconsistent"))) {
            defaultState = 8;
        }
        InternalSensorManager.setDefaultStateForNewSensors(defaultState);
    }

    @Override
    public void setMenuBar(BeanTableFrame<Sensor> f) {
        BeanTableFrame<Sensor> finalF = f;
        JMenuBar menuBar = f.getJMenuBar();
        boolean menuAbsent = true;
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            String name = menuBar.getMenu(i).getAccessibleContext().getAccessibleName();
            if (name.equals(Bundle.getMessage("MenuDefaults"))) {
                menuAbsent = false;
                break;
            }
            ++i;
        }
        if (menuAbsent) {
            JMenu optionsMenu = new JMenu(Bundle.getMessage("MenuDefaults"));
            JMenuItem item = new JMenuItem(Bundle.getMessage("GlobalDebounce"));
            optionsMenu.add(item);
            item.addActionListener(e -> this.setDefaultDebounce(finalF));
            item = new JMenuItem(Bundle.getMessage("InitialSensorState"));
            optionsMenu.add(item);
            item.addActionListener(e -> this.setDefaultState(finalF));
            int pos = menuBar.getMenuCount() - 1;
            int offset = 1;
            log.debug("setMenuBar number of menu items = {}", (Object)pos);
            int i2 = 0;
            while (i2 <= pos) {
                if (menuBar.getComponent(i2) instanceof JMenu && ((AbstractButton)menuBar.getComponent(i2)).getText().equals(Bundle.getMessage("MenuHelp"))) {
                    offset = -1;
                }
                ++i2;
            }
            menuBar.add((Component)optionsMenu, pos + offset);
        }
    }

    @Override
    protected void configureTable(JTable table) {
        super.configureTable(table);
        this.showDebounceBox.addActionListener(e -> ((SensorTableDataModel)this.m).showDebounce(this.showDebounceBox.isSelected(), table));
        this.showPullUpBox.addActionListener(e -> ((SensorTableDataModel)this.m).showPullUp(this.showPullUpBox.isSelected(), table));
        this.showStateForgetAndQueryBox.addActionListener(e -> ((SensorTableDataModel)this.m).showStateForgetAndQuery(this.showStateForgetAndQueryBox.isSelected(), table));
    }

    @Override
    public void addToFrame(BeanTableFrame<Sensor> f) {
        f.addToBottomBox(this.showDebounceBox, this.getClass().getName());
        this.showDebounceBox.setToolTipText(Bundle.getMessage("SensorDebounceToolTip"));
        f.addToBottomBox(this.showPullUpBox, this.getClass().getName());
        this.showPullUpBox.setToolTipText(Bundle.getMessage("SensorPullUpToolTip"));
        f.addToBottomBox(this.showStateForgetAndQueryBox, this.getClass().getName());
        this.showStateForgetAndQueryBox.setToolTipText(Bundle.getMessage("StateForgetAndQueryBoxToolTip"));
    }

    @Override
    protected void columnsVisibleUpdated(boolean[] colsVisible) {
        log.debug("columns updated {}", (Object)colsVisible);
        this.showDebounceBox.setState(new boolean[]{colsVisible[8], colsVisible[9], colsVisible[7]});
        this.showPullUpBox.setState(new boolean[]{colsVisible[10]});
        this.showStateForgetAndQueryBox.setState(new boolean[]{colsVisible[11], colsVisible[12]});
    }

    @Override
    public void addToPanel(AbstractTableTabAction<Sensor> f) {
        String connectionName = this.sensorManager.getMemo().getUserName();
        if (this.sensorManager.getClass().getName().contains("ProxySensorManager")) {
            connectionName = "All";
        }
        f.addToBottomBox(this.showDebounceBox, connectionName);
        this.showDebounceBox.setToolTipText(Bundle.getMessage("SensorDebounceToolTip"));
        f.addToBottomBox(this.showPullUpBox, connectionName);
        this.showPullUpBox.setToolTipText(Bundle.getMessage("SensorPullUpToolTip"));
        f.addToBottomBox(this.showStateForgetAndQueryBox, connectionName);
        this.showStateForgetAndQueryBox.setToolTipText(Bundle.getMessage("StateForgetAndQueryBoxToolTip"));
    }

    @Override
    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "duplicateUserName", Bundle.getMessage("DuplicateUserNameWarn"));
        super.setMessagePreferencesDetails();
    }

    @Override
    protected String getClassName() {
        return SensorTableAction.class.getName();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleSensorTable");
    }
}

