/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.annotation.Nonnull;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowComboBoxPanel
extends DefaultCellEditor
implements TableCellRenderer {
    protected JPanel editor = new JPanel(new BorderLayout());
    protected JPanel renderer;
    protected boolean tableListenerAdded = false;
    protected JTable table;
    protected Runnable comboBoxFocusRequester;
    protected int currentRow = -1;
    protected Object prevItem;
    protected boolean consumeComboBoxActionEvent = true;
    protected EventObject startEditingEvent = null;
    private static final Logger log = LoggerFactory.getLogger(RowComboBoxPanel.class);

    public RowComboBoxPanel(Object[] values, ListCellRenderer<?> customRenderer) {
        super(new JComboBox());
        if (values != null) {
            this.setItems(values);
        }
        this.renderer = new JPanel(new BorderLayout());
        super.setClickCountToStart(1);
        this.editor.addMouseListener(new MouseAdapter(){

            @Override
            public final void mousePressed(MouseEvent evt) {
                RowComboBoxPanel.this.eventEditorMousePressed();
            }
        });
    }

    public RowComboBoxPanel(Object[] values) {
        this(values, null);
    }

    public RowComboBoxPanel() {
        this(new Object[0]);
    }

    public RowComboBoxPanel(ListCellRenderer<?> customRenderer) {
        this(new Object[0], customRenderer);
    }

    @Override
    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        if (!this.tableListenerAdded) {
            this.tableListenerAdded = true;
            this.table = table;
            this.table.getSelectionModel().addListSelectionListener(evt -> this.eventTableSelectionChanged());
        }
        this.currentRow = row;
        this.updateData(row, true, table);
        return this.getEditorComponent(table, value, isSelected, row, col);
    }

    protected Component getEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        if (isSelected) {
            log.debug("getEditorComponent>isSelected (value={})", value);
        }
        this.editor.removeAll();
        JComboBox<String> editorbox = this.getEditorBox(table.convertRowIndexToModel(row));
        editorbox.putClientProperty("JComponent.sizeVariant", "small");
        editorbox.putClientProperty("JComboBox.buttonType", "square");
        log.debug("getEditorComponent>notSelected (row={}, value={}; me = {}))", new Object[]{row, value, this.toString()});
        if (value != null) {
            editorbox.setSelectedItem(value);
        }
        editorbox.addActionListener(evt -> {
            Object choice = editorbox.getSelectedItem();
            log.debug("actionPerformed (event={}, choice={}", (Object)evt.toString(), (Object)choice.toString());
            this.eventRowComboBoxActionPerformed(choice);
        });
        this.editor.add(editorbox);
        return this.editor;
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        if (!this.tableListenerAdded) {
            this.tableListenerAdded = true;
            this.table = table;
            this.table.getSelectionModel().addListSelectionListener(evt -> this.eventTableSelectionChanged());
        }
        this.currentRow = row;
        return this.getRendererComponent(table, value, isSelected, hasFocus, row, col);
    }

    protected Component getRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.renderer.removeAll();
        JComboBox<String> renderbox = new JComboBox<String>();
        log.debug("RCBP getRendererComponent (row={}, value={})", (Object)row, value);
        renderbox.putClientProperty("JComponent.sizeVariant", "small");
        renderbox.putClientProperty("JComboBox.buttonType", "square");
        if (value != null) {
            renderbox.addItem(value.toString());
        } else {
            renderbox.addItem("");
        }
        this.renderer.add(renderbox);
        return this.renderer;
    }

    protected void updateData(int row, boolean isSelected, JTable table) {
        log.debug("RCBP updateData (row:{}; me = {}))", (Object)row, (Object)this.toString());
        JComboBox<String> editorbox = this.getEditorBox(table.convertRowIndexToModel(row));
        this.editor.add(editorbox);
        if (isSelected) {
            this.editor.setBackground(table.getSelectionBackground());
        } else {
            this.editor.setBackground(table.getBackground());
        }
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        this.startEditingEvent = evt;
        if (evt instanceof MouseEvent && evt.getSource() instanceof JTable) {
            MouseEvent me = (MouseEvent)evt;
            JTable thisTable = (JTable)me.getSource();
            Point pt = new Point(me.getX(), me.getY());
            int row = thisTable.rowAtPoint(pt);
            int col = thisTable.columnAtPoint(pt);
            Rectangle rec = thisTable.getCellRect(row, col, false);
            if (me.getY() >= rec.y + rec.height || me.getX() >= rec.x + rec.width) {
                return false;
            }
        }
        return super.isCellEditable(evt);
    }

    @Override
    public Object getCellEditorValue() {
        log.debug("getCellEditorValue, prevItem: {}; me = {})", this.prevItem, (Object)this.toString());
        return this.prevItem;
    }

    public final void setItems(@Nonnull Object[] items) {
        JComboBox<String> editorbox = new JComboBox<String>();
        int n = items.length;
        int i = 0;
        while (i < n) {
            if (items[i] != null) {
                editorbox.addItem(items[i].toString());
            }
            ++i;
        }
        this.editor.add(editorbox);
    }

    protected void eventEditorMousePressed() {
        this.editor.add(this.getEditorBox(this.table.convertRowIndexToModel(this.currentRow)));
        this.editor.revalidate();
        SwingUtilities.invokeLater(this.comboBoxFocusRequester);
        log.debug("eventEditorMousePressed in row {}; me = {})", (Object)this.currentRow, (Object)this.toString());
    }

    protected void eventTableSelectionChanged() {
        log.debug("eventTableSelectionChanged");
        if (!this.table.isRowSelected(this.currentRow)) {
            this.stopCellEditing();
        }
    }

    protected void eventRowComboBoxActionPerformed(@Nonnull Object choice) {
        Object item = choice;
        log.debug("eventRowComboBoxActionPerformed; selected item: {}, me = {})", item, (Object)this.toString());
        this.prevItem = choice;
        if (this.consumeComboBoxActionEvent) {
            this.stopCellEditing();
        }
    }

    protected int getCurrentRow() {
        return this.currentRow;
    }

    protected JComboBox<String> getEditorBox(int row) {
        String[] list = new String[]{"Error", "Not Valid"};
        return new JComboBox<String>(list);
    }
}

