/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.beans.PropertyChangeEvent;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JTable;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Reportable;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.ReporterTableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterTableDataModel
extends BeanTableDataModel<Reporter> {
    public static final int LASTREPORTCOL = 5;
    private ReporterManager reporterManager;
    private static final Logger log = LoggerFactory.getLogger(ReporterTableDataModel.class);

    public ReporterTableDataModel(Manager<Reporter> mgr) {
        this.setManager(mgr);
    }

    @Override
    @CheckForNull
    public String getValue(String name) {
        Reporter r = this.getManager().getBySystemName(name);
        if (r == null) {
            return "";
        }
        Object value = r.getCurrentReport();
        if (value == null) {
            return null;
        }
        if (value instanceof Reportable) {
            return ((Reportable)value).toReportString();
        }
        return value.toString();
    }

    @Override
    public final void setManager(Manager<Reporter> rm) {
        if (!(rm instanceof ReporterManager)) {
            return;
        }
        this.getManager().removePropertyChangeListener(this);
        if (this.sysNameList != null) {
            int i = 0;
            while (i < this.sysNameList.size()) {
                Reporter b = this.getBySystemName((String)this.sysNameList.get(i));
                if (b != null) {
                    b.removePropertyChangeListener(this);
                }
                ++i;
            }
        }
        this.reporterManager = (ReporterManager)rm;
        this.getManager().addPropertyChangeListener(this);
        this.updateNameList();
    }

    public ReporterManager getManager() {
        return this.reporterManager == null ? InstanceManager.getDefault(ReporterManager.class) : this.reporterManager;
    }

    @Override
    public Reporter getBySystemName(@Nonnull String name) {
        return this.getManager().getBySystemName(name);
    }

    @Override
    public Reporter getByUserName(@Nonnull String name) {
        return this.getManager().getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return ReporterTableAction.class.getName();
    }

    @Override
    public void clickOn(Reporter t) {
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 2: {
                this.getBySystemName((String)this.sysNameList.get(row)).setReport(value);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 5: {
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 5 + this.getPropertyColumnCount() + 1;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 2: {
                return Bundle.getMessage("LabelReport");
            }
            case 5: {
                return Bundle.getMessage("LabelLastReport");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: 
            case 5: {
                return String.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 5) {
            return false;
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 5) {
            return this.getValue((String)this.sysNameList.get(row));
        }
        return super.getValueAt(row, col);
    }

    @Override
    public int getPreferredWidth(int col) {
        if (col == 5) {
            return super.getPreferredWidth(2);
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public void configValueColumn(JTable table) {
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        return true;
    }

    @Override
    public JButton configureButton() {
        log.error("configureButton should not have been called");
        return null;
    }
}

