/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.OBlockTableAction;
import jmri.jmrit.beantable.oblock.BlockPortalTableModel;
import jmri.jmrit.beantable.oblock.OBlockTableModel;
import jmri.jmrit.beantable.oblock.PortalTableModel;
import jmri.jmrit.beantable.oblock.SignalTableModel;
import jmri.jmrit.beantable.oblock.TableFrames;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.swing.RowSorterUtil;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import jmri.util.table.ToggleButtonEditor;
import jmri.util.table.ToggleButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBlockTablePanel
extends JPanel {
    private OBlockTableModel oblockDataModel;
    private PortalTableModel portalDataModel;
    private SignalTableModel signalDataModel;
    private BlockPortalTableModel blockportalDataModel;
    private JTable oblockTable;
    private JTable portalTable;
    private JTable signalTable;
    private JTable blockportalTable;
    private JScrollPane oblockDataScroll;
    private JScrollPane portalDataScroll;
    private JScrollPane signalDataScroll;
    private JScrollPane blockportalDataScroll;
    private final JTabbedPane oblockTabs;
    TableFrames _tf;
    Box bottomBox;
    int bottomBoxIndex;
    private static final int bottomStrutWidth = 20;
    private static final Logger log = LoggerFactory.getLogger(OBlockTablePanel.class);

    public OBlockTablePanel(OBlockTableModel oblocks, PortalTableModel portals, SignalTableModel signals, BlockPortalTableModel blockportals, TableFrames tf, String helpTarget) {
        int width;
        this._tf = tf;
        log.debug("Building tables");
        this.oblockDataModel = oblocks;
        TableRowSorter<OBlockTableModel> sorter = new TableRowSorter<OBlockTableModel>(this.oblockDataModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        this.oblockTable = this.makeJTable(OBlockTableAction.class.getName(), this.oblockDataModel, sorter);
        this.oblockTable.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        this.oblockTable.setDefaultRenderer(JButton.class, new ButtonRenderer());
        this.oblockTable.getColumnModel().getColumn(8).setCellRenderer(new ToggleButtonRenderer(Bundle.getMessage("cm"), Bundle.getMessage("in")));
        this.oblockTable.getColumnModel().getColumn(8).setCellEditor(new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("cm"), Bundle.getMessage("in")));
        oblocks.configCurveColumn(this.oblockTable);
        this.oblockTable.getColumnModel().getColumn(10).setCellRenderer(new ToggleButtonRenderer(Bundle.getMessage("Current"), Bundle.getMessage("Last")));
        this.oblockTable.getColumnModel().getColumn(10).setCellEditor(new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("Current"), Bundle.getMessage("Last")));
        oblocks.configSpeedColumn(this.oblockTable);
        this.oblockTable.getColumnModel().getColumn(11).setCellRenderer(new ToggleButtonRenderer(Bundle.getMessage("Permissive"), Bundle.getMessage("Absolute")));
        this.oblockTable.getColumnModel().getColumn(11).setCellEditor(new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("Permissive"), Bundle.getMessage("Absolute")));
        XTableColumnModel tcm = new XTableColumnModel();
        this.oblockTable.setColumnModel(tcm);
        this.oblockTable.getTableHeader().setReorderingAllowed(true);
        this.oblockTable.createDefaultColumnsFromModel();
        tcm.setColumnVisible(tcm.getColumnByModelIndex(9), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(10), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(11), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(13), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(14), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(15), false);
        int i = 0;
        while (i < tcm.getColumnCount()) {
            int width2 = this.oblockDataModel.getPreferredWidth(i);
            tcm.getColumn(i).setPreferredWidth(width2);
            ++i;
        }
        this.oblockDataModel.addHeaderListener(this.oblockTable);
        this.oblockTable.setPreferredScrollableViewportSize(new Dimension(550, 300));
        this.oblockDataScroll = new JScrollPane(this.oblockTable);
        this.portalDataModel = portals;
        TableRowSorter<PortalTableModel> portalsorter = new TableRowSorter<PortalTableModel>(this.portalDataModel);
        RowSorterUtil.setSortOrder(portalsorter, this.portalDataModel.NAME_COLUMN, SortOrder.ASCENDING);
        this.portalTable = this.makeJTable("Portal", this.portalDataModel, portalsorter);
        this.portalTable.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        this.portalTable.setDefaultRenderer(JButton.class, new ButtonRenderer());
        this.portalTable.doLayout();
        this.portalTable.createDefaultColumnsFromModel();
        int i2 = 0;
        while (i2 < this.portalDataModel.getColumnCount()) {
            int width3 = this.portalDataModel.getPreferredWidth(i2);
            this.portalTable.getColumnModel().getColumn(i2).setPreferredWidth(width3);
            ++i2;
        }
        this.portalDataScroll = new JScrollPane(this.portalTable);
        this.signalDataModel = signals;
        TableRowSorter<SignalTableModel> sigsorter = new TableRowSorter<SignalTableModel>(this.signalDataModel);
        RowSorterUtil.setSortOrder(sigsorter, 0, SortOrder.ASCENDING);
        this.signalTable = this.makeJTable("Signals", this.signalDataModel, sigsorter);
        this.signalTable.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        this.signalTable.setDefaultRenderer(JButton.class, new ButtonRenderer());
        this.signalTable.getColumnModel().getColumn(5).setCellRenderer(new ToggleButtonRenderer(Bundle.getMessage("cm"), Bundle.getMessage("in")));
        this.signalTable.getColumnModel().getColumn(5).setCellEditor(new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("cm"), Bundle.getMessage("in")));
        this.signalTable.doLayout();
        this.signalTable.createDefaultColumnsFromModel();
        int i3 = 0;
        while (i3 < this.signalDataModel.getColumnCount()) {
            width = SignalTableModel.getPreferredWidth(i3);
            this.signalTable.getColumnModel().getColumn(i3).setPreferredWidth(width);
            ++i3;
        }
        this.signalDataScroll = new JScrollPane(this.signalTable);
        this.blockportalDataModel = blockportals;
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        this.blockportalTable = this.makeJTable("Block-Portal X-ref", this.blockportalDataModel, sorter);
        this.blockportalTable.setDefaultRenderer(String.class, new ValueRenderer());
        this.blockportalTable.doLayout();
        this.blockportalTable.createDefaultColumnsFromModel();
        i3 = 0;
        while (i3 < this.blockportalDataModel.getColumnCount()) {
            width = this.blockportalDataModel.getPreferredWidth(i3);
            this.blockportalTable.getColumnModel().getColumn(i3).setPreferredWidth(width);
            ++i3;
        }
        this.blockportalDataScroll = new JScrollPane(this.blockportalTable);
        this.configureWarrantTable(this.oblockTable);
        i3 = 0;
        while (i3 < this.oblockTable.getColumnCount()) {
            width = this.oblockDataModel.getPreferredWidth(i3);
            this.oblockTable.getColumnModel().getColumn(i3).setPreferredWidth(width);
            ++i3;
        }
        this.oblockDataModel.persistTable(this.oblockTable);
        this.configureWarrantTable(this.signalTable);
        this.configureWarrantTable(this.portalTable);
        this.configureWarrantTable(this.blockportalTable);
        this.setLayout(new BorderLayout());
        this.oblockTabs = new JTabbedPane();
        this.oblockTabs.addTab(Bundle.getMessage("BeanNameOBlocks"), this.oblockDataScroll);
        this.oblockTabs.addTab(Bundle.getMessage("BeanNamePortals"), this.portalDataScroll);
        this.oblockTabs.addTab(Bundle.getMessage("Signals"), this.signalDataScroll);
        this.oblockTabs.addTab(Bundle.getMessage("TitleBlockPortalXRef"), this.blockportalDataScroll);
        this.add((Component)this.oblockTabs, "Center");
        log.debug("tabs complete");
        this.bottomBox = Box.createHorizontalBox();
        this.bottomBox.add(Box.createHorizontalGlue());
        this.bottomBoxIndex = 0;
        this.add((Component)this.bottomBox, "South");
        this.extras();
        log.debug("bottomBox complete");
        this.oblockDataScroll.setHorizontalScrollBarPolicy(32);
    }

    void extras() {
    }

    protected Box getBottomBox() {
        return this.bottomBox;
    }

    public JMenuItem getPrintItem() {
        log.debug("OBLOCK TABBED getPrintItem() called");
        return this._tf.getPrintMenuItems(this.oblockTable, this.portalTable, this.signalTable, this.blockportalTable);
    }

    public JMenu getOptionMenu() {
        log.debug("OBLOCK TABBED getOptionMenu() called");
        return this._tf.getOptionMenu();
    }

    public JMenu getTablesMenu() {
        log.debug("OBLOCK TABBED getTablesMenu() called");
        return this._tf.getTablesMenu();
    }

    protected void addToBottomBox(Component comp) {
        this.bottomBox.add(Box.createHorizontalStrut(20), this.bottomBoxIndex);
        ++this.bottomBoxIndex;
        this.bottomBox.add(comp, this.bottomBoxIndex);
        ++this.bottomBoxIndex;
    }

    public void dispose() {
        if (this.oblockDataModel != null) {
            this.oblockDataModel.stopPersistingTable(this.oblockTable);
            this.oblockDataModel.dispose();
        }
        this.oblockDataModel = null;
        this.oblockTable = null;
        this.oblockDataScroll = null;
        this.portalDataModel = null;
        this.portalTable = null;
        this.portalDataScroll = null;
        this.signalDataModel = null;
        this.signalTable = null;
        this.signalDataScroll = null;
        this.blockportalDataModel = null;
        this.blockportalTable = null;
        this.blockportalDataScroll = null;
    }

    public JTable makeJTable(@Nonnull String name, @Nonnull TableModel model, @CheckForNull RowSorter<? extends TableModel> sorter) {
        Objects.requireNonNull(name, "the table name must be nonnull " + name);
        Objects.requireNonNull(model, "the table model must be nonnull " + name);
        JTable table = this.configureJTable(name, new JTable(model), sorter);
        return table;
    }

    protected JTable configureJTable(@Nonnull String name, @Nonnull JTable table, @CheckForNull RowSorter<? extends TableModel> sorter) {
        Objects.requireNonNull(table, "the table must be nonnull");
        Objects.requireNonNull(name, "the table name must be nonnull");
        table.setRowSorter(sorter);
        table.setName(name);
        return table;
    }

    public void configureWarrantTable(JTable table) {
        table.setDefaultRenderer(JButton.class, new ButtonRenderer());
        table.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        table.setDefaultRenderer(JToggleButton.class, new ToggleButtonRenderer(Bundle.getMessage("cm"), Bundle.getMessage("in")));
        table.setDefaultEditor(JToggleButton.class, new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("cm"), Bundle.getMessage("in")));
        table.setDefaultRenderer(JRadioButton.class, new ToggleButtonRenderer(Bundle.getMessage("Current"), Bundle.getMessage("Last")));
        table.setDefaultEditor(JRadioButton.class, new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("Current"), Bundle.getMessage("Last")));
        table.setDefaultRenderer(JCheckBox.class, new ToggleButtonRenderer(Bundle.getMessage("Permissive"), Bundle.getMessage("Absolute")));
        table.setDefaultEditor(JCheckBox.class, new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("Permissive"), Bundle.getMessage("Absolute")));
        table.setDefaultEditor(OBlockTableModel.SpeedComboBoxPanel.class, new OBlockTableModel.SpeedComboBoxPanel());
        table.setDefaultRenderer(OBlockTableModel.SpeedComboBoxPanel.class, new OBlockTableModel.SpeedComboBoxPanel());
        table.setDefaultEditor(OBlockTableModel.CurveComboBoxPanel.class, new OBlockTableModel.CurveComboBoxPanel());
        table.setDefaultRenderer(OBlockTableModel.CurveComboBoxPanel.class, new OBlockTableModel.CurveComboBoxPanel());
        table.setAutoResizeMode(0);
        table.setRowHeight(TableFrames.ROW_HEIGHT);
    }
}

