/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.AddNewBeanPanel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.OBlockTableFrame;
import jmri.jmrit.beantable.OBlockTablePanel;
import jmri.jmrit.beantable.oblock.BlockPortalTableModel;
import jmri.jmrit.beantable.oblock.OBlockTableModel;
import jmri.jmrit.beantable.oblock.PortalEditFrame;
import jmri.jmrit.beantable.oblock.PortalTableModel;
import jmri.jmrit.beantable.oblock.SignalEditFrame;
import jmri.jmrit.beantable.oblock.SignalTableModel;
import jmri.jmrit.beantable.oblock.TableFrames;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.PortalManager;
import jmri.util.JmriJFrame;
import jmri.util.gui.GuiLafPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBlockTableAction
extends AbstractTableAction<OBlock>
implements PropertyChangeListener {
    protected boolean _tabbed = false;
    protected JPanel dataPanel;
    protected JTabbedPane dataTabs;
    protected boolean init = false;
    OBlockTableModel oblocks;
    PortalTableModel portals;
    SignalTableModel signals;
    BlockPortalTableModel blockportals;
    @Nonnull
    protected OBlockManager oblockManager = InstanceManager.getDefault(OBlockManager.class);
    @Nonnull
    protected PortalManager portalManager = InstanceManager.getDefault(PortalManager.class);
    TableFrames tf;
    OBlockTableFrame otf;
    OBlockTablePanel otp;
    PortalEditFrame portalFrame;
    SignalEditFrame signalFrame;
    JTextField startAddress = new JTextField(10);
    JTextField userName = new JTextField(40);
    SpinnerNumberModel rangeSpinner = new SpinnerNumberModel(1, 1, 100, 1);
    JSpinner numberToAddSpinner = new JSpinner(this.rangeSpinner);
    JCheckBox rangeBox = new JCheckBox(Bundle.getMessage("AddRangeBox"));
    JCheckBox autoSystemNameBox = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    JLabel statusBar = new JLabel(Bundle.getMessage("HardwareAddStatusEnter"), 10);
    UserPreferencesManager pref;
    JmriJFrame addOBlockFrame = null;
    String systemNameAuto = String.valueOf(this.getClass().getName()) + ".AutoSystemName";
    private static final Logger log = LoggerFactory.getLogger(OBlockTableAction.class);

    public OBlockTableAction(String actionName) {
        super(actionName);
        this.includeAddButton = false;
    }

    public OBlockTableAction() {
        this(Bundle.getMessage("TitleOBlockTable"));
    }

    @Override
    public void setManager(@Nonnull Manager<OBlock> om) {
        this.oblockManager.removePropertyChangeListener(this);
        if (om instanceof OBlockManager) {
            this.oblockManager = (OBlockManager)om;
            if (this.m != null) {
                this.m.setManager(this.oblockManager);
            }
        }
        this.oblockManager.addPropertyChangeListener(this);
    }

    @Override
    public void addToFrame(@Nonnull BeanTableFrame<OBlock> f) {
        JButton addOblockButton = new JButton(Bundle.getMessage("ButtonAddOBlock"));
        this.otp.addToBottomBox(addOblockButton);
        addOblockButton.addActionListener(this::addOBlockPressed);
        JButton addPortalButton = new JButton(Bundle.getMessage("ButtonAddPortal"));
        this.otp.addToBottomBox(addPortalButton);
        addPortalButton.addActionListener(this::addPortalPressed);
        JButton addSignalButton = new JButton(Bundle.getMessage("ButtonAddSignal"));
        this.otp.addToBottomBox(addSignalButton);
        addSignalButton.addActionListener(this::addSignalPressed);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._tabbed = InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed();
        this.initTableFrames();
    }

    private void initTableFrames() {
        this.tf = new TableFrames();
        if (this._tabbed) {
            log.debug("Tabbed starting");
            this.createModel();
            this.otf = new OBlockTableFrame(this.otp, this.helpTarget()){

                @Override
                void extras() {
                    OBlockTableAction.this.addToFrame(this);
                }
            };
            this.setTitle();
            this.otf.pack();
            this.otf.setVisible(true);
        } else {
            this.tf.initComponents();
        }
    }

    @Override
    protected void createModel() {
        if (this.tf == null) {
            this.initTableFrames();
        }
        this.oblocks = this.tf.getOblockTableModel();
        this.portals = this.tf.getPortalTableModel();
        this.signals = this.tf.getSignalTableModel();
        this.blockportals = this.tf.getPortalXRefTableModel();
        this.otp = new OBlockTablePanel(this.oblocks, this.portals, this.signals, this.blockportals, this.tf, this.helpTarget());
        this.init = true;
    }

    @Override
    public JPanel getPanel() {
        this.createModel();
        return this.otp;
    }

    @Override
    protected void setTitle() {
        if (this._tabbed && this.otf != null) {
            this.otf.setTitle(Bundle.getMessage("TitleOBlocksTabbedFrame"));
        }
    }

    @Override
    public void setMenuBar(BeanTableFrame<OBlock> f) {
        if (this._tabbed) {
            MenuElement[] subElements;
            JMenuBar menuBar = f.getJMenuBar();
            if (menuBar == null) {
                log.debug("NULL MenuBar");
                return;
            }
            JMenu fileMenu = null;
            int i = 0;
            while (i < menuBar.getMenuCount()) {
                if (menuBar.getComponent(i) instanceof JMenu && ((JMenu)menuBar.getComponent(i)).getText().equals(Bundle.getMessage("MenuFile"))) {
                    fileMenu = menuBar.getMenu(i);
                }
                ++i;
            }
            if (fileMenu == null) {
                log.debug("NULL FileMenu");
                return;
            }
            MenuElement[] menuElementArray = subElements = fileMenu.getSubElements();
            int n = subElements.length;
            int n2 = 0;
            while (n2 < n) {
                MenuElement[] popsubElements;
                MenuElement subElement = menuElementArray[n2];
                MenuElement[] menuElementArray2 = popsubElements = subElement.getSubElements();
                int n3 = popsubElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    MenuElement popsubElement = menuElementArray2[n4];
                    if (popsubElement instanceof JMenuItem && ((JMenuItem)popsubElement).getText().equals(Bundle.getMessage("PrintTable"))) {
                        JMenuItem printMenu = (JMenuItem)popsubElement;
                        fileMenu.remove(printMenu);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
            fileMenu.add(this.otp.getPrintItem());
            menuBar.add(this.otp.getOptionMenu());
            menuBar.add(this.otp.getTablesMenu());
            log.debug("setMenuBar for OBLOCKS");
            f.addHelpMenu("package.jmri.jmrit.beantable.OBlockTable", true);
        }
    }

    @Override
    protected void addPressed(ActionEvent e) {
        log.warn("This should not have happened");
    }

    protected void addOBlockPressed(ActionEvent e) {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.addOBlockFrame == null) {
            this.addOBlockFrame = new JmriJFrame(Bundle.getMessage("TitleAddOBlock"), false, true);
            this.addOBlockFrame.addHelpMenu("package.jmri.jmrit.beantable.OBlockTable", true);
            this.addOBlockFrame.getContentPane().setLayout(new BoxLayout(this.addOBlockFrame.getContentPane(), 1));
            ActionListener okListener = this::createObPressed;
            ActionListener cancelListener = this::cancelObPressed;
            AddNewBeanPanel anbp = new AddNewBeanPanel(this.startAddress, this.userName, this.numberToAddSpinner, this.rangeBox, this.autoSystemNameBox, "ButtonCreate", okListener, cancelListener, this.statusBar);
            this.addOBlockFrame.add(anbp);
            this.addOBlockFrame.getRootPane().setDefaultButton(anbp.ok);
            this.addOBlockFrame.setEscapeKeyClosesWindow(true);
            this.startAddress.setToolTipText(Bundle.getMessage("SysNameToolTip", "OB"));
        }
        this.startAddress.setBackground(Color.white);
        this.status(Bundle.getMessage("AddBeanStatusEnter"), false);
        if (this.pref.getSimplePreferenceState(this.systemNameAuto)) {
            this.autoSystemNameBox.setSelected(true);
        }
        this.addOBlockFrame.pack();
        this.addOBlockFrame.setVisible(true);
    }

    void cancelObPressed(ActionEvent e) {
        this.addOBlockFrame.setVisible(false);
        this.addOBlockFrame.dispose();
        this.addOBlockFrame = null;
    }

    void createObPressed(ActionEvent e) {
        int numberOfOblocks = 1;
        if (this.rangeBox.isSelected()) {
            numberOfOblocks = (Integer)this.numberToAddSpinner.getValue();
        }
        if (numberOfOblocks >= 65 && JOptionPane.showConfirmDialog(this.addOBlockFrame, Bundle.getMessage("WarnExcessBeans", Bundle.getMessage("OBlocks"), numberOfOblocks), Bundle.getMessage("WarningTitle"), 0) == 1) {
            return;
        }
        String uName = NamedBean.normalizeUserName(this.userName.getText());
        if (uName != null && uName.isEmpty()) {
            uName = null;
        }
        String sName = this.startAddress.getText().trim();
        if (this.autoSystemNameBox.isSelected()) {
            this.startAddress.setBackground(Color.white);
        } else {
            if (sName.equals("")) {
                this.status(Bundle.getMessage("WarningSysNameEmpty"), true);
                this.startAddress.setBackground(Color.red);
                return;
            }
            if (!sName.startsWith("OB")) {
                sName = "OB" + sName;
            }
        }
        StringBuilder statusMessage = new StringBuilder(Bundle.getMessage("ItemCreateFeedback", Bundle.getMessage("BeanNameOBlock")));
        String errorMessage = null;
        int x = 0;
        while (x < numberOfOblocks) {
            if (uName != null && !uName.isEmpty() && this.oblockManager.getByUserName(uName) != null && !this.pref.getPreferenceState(this.getClassName(), "duplicateUserName")) {
                InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorDuplicateUserName", uName), this.getClassName(), "duplicateUserName", false, true);
                errorMessage = Bundle.getMessage("ErrorDuplicateUserName", uName);
                this.status(errorMessage, true);
                uName = null;
            }
            if (!sName.isEmpty() && this.oblockManager.getBySystemName(sName) != null && !this.pref.getPreferenceState(this.getClassName(), "duplicateSystemName")) {
                InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorDuplicateSystemName", sName), this.getClassName(), "duplicateSystemName", false, true);
                errorMessage = Bundle.getMessage("ErrorDuplicateSystemName", sName);
                this.status(errorMessage, true);
                return;
            }
            String xName = "";
            try {
                OBlock oblk;
                if (this.autoSystemNameBox.isSelected()) {
                    assert (uName != null);
                    oblk = this.oblockManager.createNewOBlock(uName);
                    if (oblk == null) {
                        xName = uName;
                        throw new IllegalArgumentException();
                    }
                } else {
                    oblk = this.oblockManager.createNewOBlock(sName, uName);
                    if (oblk == null) {
                        xName = sName;
                        throw new IllegalArgumentException();
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleCreateException(xName);
                errorMessage = Bundle.getMessage("ErrorAddFailedCheck");
                this.status(errorMessage, true);
                return;
            }
            if (x == 0 || x == numberOfOblocks - 1) {
                statusMessage.append(" ").append(sName).append(" (").append(uName).append(")");
            }
            if (x == numberOfOblocks - 2) {
                statusMessage.append(" ").append(Bundle.getMessage("ItemCreateUpTo")).append(" ");
            }
            if (!this.autoSystemNameBox.isSelected()) {
                sName = this.nextName(sName);
            }
            if (uName != null) {
                uName = this.nextName(uName);
            }
            ++x;
        }
        if (errorMessage == null) {
            this.status(statusMessage.toString(), false);
        }
        this.pref.setSimplePreferenceState(this.systemNameAuto, this.autoSystemNameBox.isSelected());
        this.oblocks.fireTableDataChanged();
    }

    void addPortalPressed(ActionEvent e) {
        if (this.portalFrame == null) {
            this.portalFrame = new PortalEditFrame(Bundle.getMessage("TitleAddPortal"), null, this.portals);
        }
        this.portalFrame.resetFrame();
        this.portalFrame.pack();
        this.portalFrame.setVisible(true);
    }

    void addSignalPressed(ActionEvent e) {
        if (!this.signals.editMode()) {
            this.signals.setEditMode(true);
            if (this.signalFrame == null) {
                this.signalFrame = new SignalEditFrame(Bundle.getMessage("TitleAddSignal"), null, null, this.signals);
            }
            this.signalFrame.resetFrame();
            this.signalFrame.pack();
            this.signalFrame.setVisible(true);
        }
    }

    void handleCreateException(String sysName) {
        JOptionPane.showMessageDialog(this.addOBlockFrame, String.valueOf(Bundle.getMessage("ErrorOBlockAddFailed", sysName)) + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), Bundle.getMessage("ErrorTitle"), 0);
    }

    @Override
    protected String getClassName() {
        return OBlockTableAction.class.getName();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleOBlockTable");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        property = e.getPropertyName();
        if (OBlockTableAction.log.isDebugEnabled()) {
            OBlockTableAction.log.debug("PropertyChangeEvent property = {} source= {}", (Object)property, (Object)e.getSource().getClass().getName());
        }
        var3_3 = property;
        tmp = -1;
        switch (var3_3.hashCode()) {
            case -1435366540: {
                if (var3_3.equals("StateStored")) {
                    tmp = 1;
                }
                break;
            }
            case 1174135659: {
                if (!var3_3.equals("UseFastClock")) break;
                tmp = 1;
                break;
            }
        }
        ** switch (tmp)
lbl19:
        // 2 sources

    }

    void status(String message, boolean warn) {
        this.statusBar.setText(message);
        this.statusBar.setForeground(warn ? Color.red : Color.gray);
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.OBlockTable";
    }
}

