/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.beantable.Maintenance;
import jmri.jmrit.conditional.ConditionalEditBase;
import jmri.jmrit.conditional.ConditionalListCopy;
import jmri.jmrit.conditional.ConditionalListEdit;
import jmri.jmrit.conditional.ConditionalTreeEdit;
import jmri.jmrit.picker.PickFrame;
import jmri.jmrit.sensorgroup.SensorGroupFrame;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixTableAction
extends AbstractTableAction<Logix> {
    ConditionalManager _conditionalManager = null;
    LogixManager _logixManager = null;
    ConditionalEditBase _baseEdit;
    boolean _showReminder = false;
    PickFrame _pickTables;
    Logix _curLogix = null;
    int conditionalRowNumber = 0;
    JmriJFrame addLogixFrame = null;
    JTextField _systemName = new JTextField(20);
    JTextField _addUserName = new JTextField(20);
    JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    JLabel _sysNameLabel = new JLabel(String.valueOf(Bundle.getMessage("BeanNameLogix")) + " " + Bundle.getMessage("ColumnSystemName") + ":");
    JLabel _userNameLabel = new JLabel(String.valueOf(Bundle.getMessage("BeanNameLogix")) + " " + Bundle.getMessage("ColumnUserName") + ":");
    String systemNameAuto = String.valueOf(this.getClass().getName()) + ".AutoSystemName";
    JButton create;
    private boolean _inEditMode = false;
    private boolean _inCopyMode = false;
    private boolean _inAddMode = false;
    SelectionMode _selectionMode;
    EditMode _editMode;
    private TreeSet<String> _saveTargetNames = new TreeSet();
    private HashMap<String, ArrayList<String>> _saveTargetList = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(LogixTableAction.class);

    public LogixTableAction(String s) {
        super(s);
        this._logixManager = InstanceManager.getNullableDefault(LogixManager.class);
        this._conditionalManager = InstanceManager.getNullableDefault(ConditionalManager.class);
        if (this._logixManager == null || this._conditionalManager == null) {
            this.setEnabled(false);
        }
    }

    public LogixTableAction() {
        this(Bundle.getMessage("TitleLogixTable"));
    }

    @Override
    protected void createModel() {
        this.m = new BeanTableDataModel<Logix>(){
            public static final int ENABLECOL = 2;
            public static final int EDITCOL = 4;
            protected String enabledString = Bundle.getMessage("ColumnHeadEnabled");

            @Override
            public String getColumnName(int col) {
                if (col == 4) {
                    return "";
                }
                if (col == 2) {
                    return this.enabledString;
                }
                return super.getColumnName(col);
            }

            @Override
            public Class<?> getColumnClass(int col) {
                if (col == 4) {
                    return String.class;
                }
                if (col == 2) {
                    return Boolean.class;
                }
                return super.getColumnClass(col);
            }

            @Override
            public int getPreferredWidth(int col) {
                if (col == 0) {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                if (col == 1) {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                if (col == 4) {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                if (col == 2) {
                    return new JTextField((int)5).getPreferredSize().width;
                }
                return super.getPreferredWidth(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (col == 4) {
                    return true;
                }
                if (col == 2) {
                    return true;
                }
                return super.isCellEditable(row, col);
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 4) {
                    return Bundle.getMessage("ButtonSelect");
                }
                if (col == 2) {
                    Logix logix = (Logix)this.getValueAt(row, 0);
                    if (logix == null) {
                        return null;
                    }
                    return logix.getEnabled();
                }
                return super.getValueAt(row, col);
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (col == 4) {
                    String sName = ((Logix)this.getValueAt(row, 0)).getSystemName();
                    if (Bundle.getMessage("ButtonEdit").equals(value)) {
                        LogixTableAction.this.editPressed(sName);
                    } else if (Bundle.getMessage("BrowserButton").equals(value)) {
                        LogixTableAction.this.conditionalRowNumber = row;
                        LogixTableAction.this.browserPressed(sName);
                    } else if (Bundle.getMessage("ButtonCopy").equals(value)) {
                        LogixTableAction.this.copyPressed(sName);
                    } else if (Bundle.getMessage("ButtonDelete").equals(value)) {
                        LogixTableAction.this.deletePressed(sName);
                    }
                } else if (col == 2) {
                    Logix x;
                    boolean v = (x = (Logix)this.getValueAt(row, 0)).getEnabled();
                    x.setEnabled(!v);
                } else {
                    super.setValueAt(value, row, col);
                }
            }

            @Override
            protected void doDelete(Logix bean) {
                bean.deActivateLogix();
                LogixTableAction.this._logixManager.deleteLogix(bean);
            }

            @Override
            protected boolean matchPropertyName(PropertyChangeEvent e) {
                if (e.getPropertyName().equals(this.enabledString)) {
                    return true;
                }
                return super.matchPropertyName(e);
            }

            @Override
            public Manager<Logix> getManager() {
                return InstanceManager.getDefault(LogixManager.class);
            }

            @Override
            public Logix getBySystemName(@Nonnull String name) {
                return InstanceManager.getDefault(LogixManager.class).getBySystemName(name);
            }

            @Override
            public Logix getByUserName(@Nonnull String name) {
                return InstanceManager.getDefault(LogixManager.class).getByUserName(name);
            }

            @Override
            protected String getMasterClassName() {
                return LogixTableAction.this.getClassName();
            }

            @Override
            public void configureTable(JTable table) {
                table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
                table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
                table.setDefaultEditor(JComboBox.class, new ValueEditor());
                super.configureTable(table);
            }

            @Override
            protected void configDeleteColumn(JTable table) {
                JComboBox<String> editCombo = new JComboBox<String>();
                editCombo.addItem(Bundle.getMessage("ButtonSelect"));
                editCombo.addItem(Bundle.getMessage("ButtonEdit"));
                editCombo.addItem(Bundle.getMessage("BrowserButton"));
                editCombo.addItem(Bundle.getMessage("ButtonCopy"));
                editCombo.addItem(Bundle.getMessage("ButtonDelete"));
                TableColumn col = table.getColumnModel().getColumn(4);
                col.setCellEditor(new DefaultCellEditor(editCombo));
            }

            @Override
            public void clickOn(Logix t) {
            }

            @Override
            public String getValue(String s) {
                return "";
            }

            @Override
            protected String getBeanType() {
                return Bundle.getMessage("BeanNameLogix");
            }
        };
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleLogixTable"));
    }

    @Override
    public void setMenuBar(BeanTableFrame f) {
        this.loadSelectionMode();
        this.loadEditorMode();
        JMenu menu = new JMenu(Bundle.getMessage("MenuOptions"));
        menu.setMnemonic(79);
        JMenuBar menuBar = f.getJMenuBar();
        int pos = menuBar.getMenuCount() - 1;
        int offset = 1;
        log.debug("setMenuBar number of menu items = {}", (Object)pos);
        int i = 0;
        while (i <= pos) {
            if (menuBar.getComponent(i) instanceof JMenu && ((JMenu)menuBar.getComponent(i)).getText().equals(Bundle.getMessage("MenuHelp"))) {
                offset = -1;
            }
            ++i;
        }
        ButtonGroup enableButtonGroup = new ButtonGroup();
        JRadioButtonMenuItem r = new JRadioButtonMenuItem(Bundle.getMessage("EnableAll"));
        r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogixTableAction.this.enableAll(true);
            }
        });
        enableButtonGroup.add(r);
        r.setSelected(true);
        menu.add(r);
        r = new JRadioButtonMenuItem(Bundle.getMessage("DisableAll"));
        r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogixTableAction.this.enableAll(false);
            }
        });
        enableButtonGroup.add(r);
        menu.add(r);
        menu.addSeparator();
        ButtonGroup modeButtonGroup = new ButtonGroup();
        r = new JRadioButtonMenuItem(Bundle.getMessage("UseMultiPick"));
        r.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogixTableAction.this.setSelectionMode(SelectionMode.USEMULTI);
            }
        });
        modeButtonGroup.add(r);
        menu.add(r);
        r.setSelected(this._selectionMode == SelectionMode.USEMULTI);
        r = new JRadioButtonMenuItem(Bundle.getMessage("UseSinglePick"));
        r.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogixTableAction.this.setSelectionMode(SelectionMode.USESINGLE);
            }
        });
        modeButtonGroup.add(r);
        menu.add(r);
        r.setSelected(this._selectionMode == SelectionMode.USESINGLE);
        r = new JRadioButtonMenuItem(Bundle.getMessage("UseComboNameBoxes"));
        r.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogixTableAction.this.setSelectionMode(SelectionMode.USECOMBO);
            }
        });
        modeButtonGroup.add(r);
        menu.add(r);
        r.setSelected(this._selectionMode == SelectionMode.USECOMBO);
        menu.addSeparator();
        ButtonGroup viewButtonGroup = new ButtonGroup();
        r = new JRadioButtonMenuItem(Bundle.getMessage("ListEdit"));
        r.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogixTableAction.this.setEditorMode(EditMode.LISTEDIT);
            }
        });
        viewButtonGroup.add(r);
        menu.add(r);
        r.setSelected(this._editMode == EditMode.LISTEDIT);
        r = new JRadioButtonMenuItem(Bundle.getMessage("TreeEdit"));
        r.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogixTableAction.this.setEditorMode(EditMode.TREEEDIT);
            }
        });
        viewButtonGroup.add(r);
        menu.add(r);
        r.setSelected(this._editMode == EditMode.TREEEDIT);
        menuBar.add((Component)menu, pos + offset);
        menu = new JMenu(Bundle.getMessage("MenuTools"));
        menu.setMnemonic(84);
        JMenuItem item = new JMenuItem(Bundle.getMessage("OpenPickListTables"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogixTableAction.this.openPickListTable();
            }
        });
        menu.add(item);
        item = new JMenuItem(Bundle.getMessage("FindOrphans"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogixTableAction.this.findOrphansPressed(e);
            }
        });
        menu.add(item);
        item = new JMenuItem(Bundle.getMessage("EmptyConditionals"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogixTableAction.this.findEmptyPressed(e);
            }
        });
        menu.add(item);
        item = new JMenuItem(Bundle.getMessage("CrossReference"));
        item.addActionListener(new ActionListener(){
            BeanTableFrame parent;

            @Override
            public void actionPerformed(ActionEvent e) {
                new RefDialog(this.parent);
            }

            ActionListener init(BeanTableFrame f) {
                this.parent = f;
                return this;
            }
        }.init(f));
        menu.add(item);
        item = new JMenuItem(Bundle.getMessage("DisplayWhereUsed"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogixTableAction.this.makeWhereUsedWindow();
            }
        });
        menu.add(item);
        menuBar.add((Component)menu, pos + offset + 1);
    }

    void loadSelectionMode() {
        block14: {
            String currentMode;
            Object modeName;
            block13: {
                modeName = InstanceManager.getDefault(UserPreferencesManager.class).getProperty(this.getClassName(), "Selection Mode");
                if (modeName != null) break block13;
                this._selectionMode = SelectionMode.USEMULTI;
                break block14;
            }
            switch (currentMode = (String)modeName) {
                case "USEMULTI": {
                    this._selectionMode = SelectionMode.USEMULTI;
                    break;
                }
                case "USESINGLE": {
                    this._selectionMode = SelectionMode.USESINGLE;
                    break;
                }
                case "USECOMBO": {
                    this._selectionMode = SelectionMode.USECOMBO;
                    break;
                }
                default: {
                    log.warn("Invalid Logix conditional selection mode value, '{}', returned", (Object)currentMode);
                    this._selectionMode = SelectionMode.USEMULTI;
                }
            }
        }
    }

    void setSelectionMode(SelectionMode newMode) {
        this._selectionMode = newMode;
        InstanceManager.getDefault(UserPreferencesManager.class).setProperty(this.getClassName(), "Selection Mode", newMode.toString());
    }

    void loadEditorMode() {
        block11: {
            String currentMode;
            Object modeName;
            block10: {
                modeName = InstanceManager.getDefault(UserPreferencesManager.class).getProperty(this.getClassName(), "Edit Mode");
                if (modeName != null) break block10;
                this._editMode = EditMode.LISTEDIT;
                break block11;
            }
            switch (currentMode = (String)modeName) {
                case "LISTEDIT": {
                    this._editMode = EditMode.LISTEDIT;
                    break;
                }
                case "TREEEDIT": {
                    this._editMode = EditMode.TREEEDIT;
                    break;
                }
                default: {
                    log.warn("Invalid conditional edit mode value, '{}', returned", (Object)currentMode);
                    this._editMode = EditMode.LISTEDIT;
                }
            }
        }
    }

    void setEditorMode(EditMode newMode) {
        this._editMode = newMode;
        InstanceManager.getDefault(UserPreferencesManager.class).setProperty(this.getClassName(), "Edit Mode", newMode.toString());
    }

    void openPickListTable() {
        if (this._pickTables == null) {
            this._pickTables = new PickFrame(Bundle.getMessage("TitlePickList"));
        } else {
            this._pickTables.setVisible(true);
        }
        this._pickTables.toFront();
    }

    void findEmptyPressed(ActionEvent e) {
        Maintenance.findEmptyPressed(this.f);
    }

    void findOrphansPressed(ActionEvent e) {
        Maintenance.findOrphansPressed(this.f);
    }

    void enableAll(boolean enable) {
        for (Logix x : this._logixManager.getNamedBeanSet()) {
            x.setEnabled(enable);
        }
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.LogixTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        if (!this.checkFlags(null)) {
            return;
        }
        this._showReminder = true;
        if (this.addLogixFrame == null) {
            JPanel panel5 = this.makeAddLogixFrame("TitleAddLogix", "AddLogixMessage", "package.jmri.jmrit.beantable.LogixAddEdit");
            this.create = new JButton(Bundle.getMessage("ButtonCreate"));
            panel5.add(this.create);
            this.create.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogixTableAction.this.createPressed(e);
                }
            });
            this.create.setToolTipText(Bundle.getMessage("LogixCreateButtonHint"));
        }
        this._inAddMode = true;
        this.addLogixFrame.setEscapeKeyClosesWindow(true);
        this.addLogixFrame.getRootPane().setDefaultButton(this.create);
        this.addLogixFrame.pack();
        this.addLogixFrame.setVisible(true);
        this._autoSystemName.setSelected(false);
        this.addLogixFrame.setLocationRelativeTo(this.getFrame());
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> this._autoSystemName.setSelected(prefMgr.getSimplePreferenceState(this.systemNameAuto)));
    }

    JPanel makeAddLogixFrame(String titleId, String messageId, String helpFile) {
        this.addLogixFrame = new JmriJFrame(Bundle.getMessage(titleId));
        this.addLogixFrame.addHelpMenu(helpFile, true);
        this.addLogixFrame.setLocation(50, 30);
        Container contentPane = this.addLogixFrame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._sysNameLabel, c);
        c.gridy = 1;
        p.add((Component)this._userNameLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this._systemName, c);
        c.gridy = 1;
        p.add((Component)this._addUserName, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 0;
        p.add((Component)this._autoSystemName, c);
        this._addUserName.setToolTipText(Bundle.getMessage("LogixUserNameHint"));
        this._systemName.setToolTipText(Bundle.getMessage("LogixSystemNameHint"));
        contentPane.add(p);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        JLabel message1 = new JLabel(Bundle.getMessage(String.valueOf(messageId) + "1"));
        panel31.add(message1);
        JPanel panel32 = new JPanel();
        JLabel message2 = new JLabel(Bundle.getMessage(String.valueOf(messageId) + "2"));
        panel32.add(message2);
        panel3.add(panel31);
        panel3.add(panel32);
        contentPane.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogixTableAction.this.cancelAddPressed(e);
            }
        });
        cancel.setToolTipText(Bundle.getMessage("CancelLogixButtonHint"));
        this.addLogixFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LogixTableAction.this.cancelAddPressed(null);
            }
        });
        contentPane.add(panel5);
        this._autoSystemName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogixTableAction.this.autoSystemName();
            }
        });
        return panel5;
    }

    void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this._systemName.setEnabled(false);
            this._sysNameLabel.setEnabled(false);
        } else {
            this._systemName.setEnabled(true);
            this._sysNameLabel.setEnabled(true);
        }
    }

    void cancelAddPressed(ActionEvent e) {
        this.addLogixFrame.setVisible(false);
        this.addLogixFrame.dispose();
        this.addLogixFrame = null;
        this._inAddMode = false;
        this._inCopyMode = false;
        if (this.f != null) {
            this.f.setVisible(true);
        }
    }

    void copyPressed(String sName) {
        if (!this.checkFlags(sName)) {
            return;
        }
        this._showReminder = true;
        if (this.addLogixFrame == null) {
            JPanel panel5 = this.makeAddLogixFrame("TitleCopyLogix", "CopyLogixMessage", "package.jmri.jmrit.conditional.ConditionalCopy");
            JButton create = new JButton(Bundle.getMessage("ButtonCopy"));
            panel5.add(create);
            create.addActionListener(new CopyAction(sName));
            this.addLogixFrame.pack();
            this.addLogixFrame.setVisible(true);
            this._autoSystemName.setSelected(false);
            this.addLogixFrame.setLocationRelativeTo(this.getFrame());
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> this._autoSystemName.setSelected(prefMgr.getSimplePreferenceState(this.systemNameAuto)));
            this._inCopyMode = true;
        }
        this._curLogix = this._logixManager.getBySystemName(sName);
    }

    private void copyLogixPressed(String lgxName) {
        Logix targetLogix;
        String sName = this._systemName.getText();
        String uName = this._addUserName.getText();
        if (uName.length() == 0) {
            uName = null;
        }
        if (this._autoSystemName.isSelected()) {
            if (!this.checkLogixUserName(uName)) {
                return;
            }
            targetLogix = this._logixManager.createNewLogix(uName);
        } else {
            int result;
            targetLogix = this._logixManager.getBySystemName(sName);
            if (targetLogix == null && uName != null) {
                targetLogix = this._logixManager.getByUserName(uName);
            }
            if (targetLogix != null && 1 == (result = JOptionPane.showConfirmDialog(this.f, Bundle.getMessage("ConfirmLogixDuplicate", targetLogix.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), lgxName), Bundle.getMessage("QuestionTitle"), 0, 3))) {
                return;
            }
            if (targetLogix == null) {
                if (!this.checkLogixSysName()) {
                    return;
                }
                targetLogix = this._logixManager.createNewLogix(sName, uName);
                if (targetLogix == null) {
                    log.error("Failure to create Logix with System Name: {}", (Object)sName);
                    return;
                }
            } else {
                targetLogix.setUserName(uName);
            }
        }
        this.cancelAddPressed(null);
        this._baseEdit = new ConditionalListCopy(lgxName, targetLogix);
        this._baseEdit.locateAt(this.getFrame());
        this._inCopyMode = true;
        this._baseEdit.addLogixEventListener(new ConditionalBaseListener(lgxName));
    }

    boolean checkLogixUserName(String uName) {
        Logix x;
        if (uName != null && uName.trim().length() > 0 && (x = this._logixManager.getByUserName(uName)) != null) {
            JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixError3"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    boolean checkLogixSysName() {
        String sName = this._systemName.getText();
        try {
            sName = InstanceManager.getDefault(LogixManager.class).makeSystemName(sName);
        }
        catch (NamedBean.BadSystemNameException badSystemNameException) {
            JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixError8"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        this._systemName.setText(sName);
        return true;
    }

    boolean checkFlags(String sName) {
        Logix x;
        if (this._inEditMode) {
            JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixError32", this._curLogix.getSystemName()), Bundle.getMessage("ErrorTitle"), 0);
            this._baseEdit.bringToFront();
            return false;
        }
        if (this._inAddMode) {
            JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixError33"), Bundle.getMessage("ErrorTitle"), 0);
            this.addLogixFrame.toFront();
            return false;
        }
        if (this._inCopyMode) {
            JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixError31", this._curLogix.getSystemName()), Bundle.getMessage("ErrorTitle"), 0);
            this._baseEdit.bringToFront();
            return false;
        }
        if (sName != null && (x = this._logixManager.getBySystemName(sName)) == null) {
            log.error("No Logix with system name: {}", (Object)sName);
            JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixError5"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    void createPressed(ActionEvent e) {
        this._showReminder = true;
        String sName = "";
        String uName = this._addUserName.getText();
        if (uName.length() == 0) {
            uName = null;
        }
        if (this._autoSystemName.isSelected()) {
            if (!this.checkLogixUserName(uName)) {
                return;
            }
            this._curLogix = this._logixManager.createNewLogix(uName);
            sName = this._curLogix.getSystemName();
        } else {
            if (!this.checkLogixSysName()) {
                return;
            }
            sName = this._systemName.getText();
            Logix x = null;
            try {
                x = this._logixManager.getBySystemName(sName);
            }
            catch (Exception exception) {
                this.handleCreateException(sName);
                return;
            }
            if (x != null) {
                JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixError1"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            if (!this.checkLogixUserName(uName)) {
                return;
            }
            this._curLogix = this._logixManager.createNewLogix(sName, uName);
            if (this._curLogix == null) {
                log.error("Failure to create Logix with System Name: {}", (Object)sName);
                return;
            }
        }
        this.cancelAddPressed(null);
        this.editPressed(sName);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(this.systemNameAuto, this._autoSystemName.isSelected()));
    }

    void handleCreateException(String sysName) {
        JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("ErrorLogixAddFailed", sysName), Bundle.getMessage("ErrorTitle"), 0);
    }

    void editPressed(String sName) {
        if (!this.checkFlags(sName)) {
            return;
        }
        if (sName.equals(SensorGroupFrame.logixSysName)) {
            JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixWarn8", "System Logix", SensorGroupFrame.logixSysName), Bundle.getMessage("WarningTitle"), 2);
            return;
        }
        this._curLogix = this._logixManager.getBySystemName(sName);
        this._baseEdit = this._editMode == EditMode.TREEEDIT ? new ConditionalTreeEdit(sName) : new ConditionalListEdit(sName);
        this._baseEdit.locateAt(this.getFrame());
        this._inEditMode = true;
        this._baseEdit.addLogixEventListener(new ConditionalBaseListener(sName));
    }

    void showSaveReminder() {
        if (this._showReminder && InstanceManager.getNullableDefault(UserPreferencesManager.class) != null) {
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("MenuItemLogixTable")), this.getClassName(), "remindSaveLogix");
        }
    }

    @Override
    public void setMessagePreferencesDetails() {
        HashMap<Integer, String> options = new HashMap<Integer, String>(3);
        options.put(0, Bundle.getMessage("DeleteAsk"));
        options.put(1, Bundle.getMessage("DeleteNever"));
        options.put(2, Bundle.getMessage("DeleteAlways"));
        InstanceManager.getDefault(UserPreferencesManager.class).setMessageItemDetails(this.getClassName(), "delete", Bundle.getMessage("DeleteLogix"), options, 0);
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "remindSaveLogix", Bundle.getMessage("HideSaveReminder"));
        super.setMessagePreferencesDetails();
    }

    void deletePressed(String sName) {
        if (!this.checkConditionalReferences(sName)) {
            return;
        }
        final Logix x = this._logixManager.getBySystemName(sName);
        final UserPreferencesManager p = InstanceManager.getNullableDefault(UserPreferencesManager.class);
        if (p != null && p.getMultipleChoiceOption(this.getClassName(), "delete") == 2) {
            if (x != null) {
                this._logixManager.deleteLogix(x);
                this.deleteSourceWhereUsed();
            }
        } else {
            final JDialog dialog = new JDialog();
            dialog.setTitle(Bundle.getMessage("QuestionTitle"));
            dialog.setLocationRelativeTo(this.getFrame());
            dialog.setDefaultCloseOperation(2);
            JPanel container = new JPanel();
            container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            container.setLayout(new BoxLayout(container, 1));
            String msg = Bundle.getMessage("ConfirmLogixDelete", sName);
            JLabel question = new JLabel(msg);
            question.setAlignmentX(0.5f);
            container.add(question);
            final JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
            remember.setFont(remember.getFont().deriveFont(10.0f));
            remember.setAlignmentX(0.5f);
            JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
            JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
            JPanel button = new JPanel();
            button.setAlignmentX(0.5f);
            button.add(yesButton);
            button.add(noButton);
            container.add(button);
            noButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                }
            });
            yesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (p != null && remember.isSelected()) {
                        p.setMultipleChoiceOption(LogixTableAction.this.getClassName(), "delete", 2);
                    }
                    if (x != null) {
                        LogixTableAction.this._logixManager.deleteLogix(x);
                        LogixTableAction.this.deleteSourceWhereUsed();
                    }
                    dialog.dispose();
                }
            });
            container.add(remember);
            container.setAlignmentX(0.5f);
            container.setAlignmentY(0.5f);
            dialog.getContentPane().add(container);
            dialog.pack();
            dialog.setModal(true);
            dialog.setVisible(true);
        }
        this.f.setVisible(true);
    }

    void loadReferenceNames(List<ConditionalVariable> varList, TreeSet<String> treeSet) {
        treeSet.clear();
        for (ConditionalVariable var : varList) {
            if (var.getType() != Conditional.Type.CONDITIONAL_TRUE && var.getType() != Conditional.Type.CONDITIONAL_FALSE) continue;
            treeSet.add(var.getName());
        }
    }

    boolean checkConditionalUserName(String uName, Logix logix) {
        Conditional p;
        if (uName != null && !uName.equals("") && (p = this._conditionalManager.getByUserName(logix, uName)) != null) {
            log.error("Failure to update Conditional with Duplicate User Name: {}", (Object)uName);
            JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixError10"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    boolean checkConditionalSystemName(String sName) {
        if (sName != null && !sName.equals("")) {
            Conditional p = this._conditionalManager.getBySystemName(sName);
            return p == null;
        }
        return false;
    }

    boolean checkConditionalReferences(String logixName) {
        this._saveTargetList.clear();
        Logix x = this._logixManager.getLogix(logixName);
        int numConditionals = x.getNumConditionals();
        if (numConditionals > 0) {
            int i = 0;
            while (i < numConditionals) {
                ArrayList<String> refList;
                String csName = x.getConditionalByNumberOrder(i);
                ArrayList<String> targetList = InstanceManager.getDefault(ConditionalManager.class).getTargetList(csName);
                if (targetList.size() > 0) {
                    this._saveTargetList.put(csName, targetList);
                }
                if ((refList = InstanceManager.getDefault(ConditionalManager.class).getWhereUsed(csName)) != null) {
                    for (String refName : refList) {
                        Logix xRef = this._conditionalManager.getParentLogix(refName);
                        String xsName = xRef.getSystemName();
                        if (logixName.equals(xsName)) continue;
                        Conditional c = x.getConditional(csName);
                        Conditional cRef = xRef.getConditional(refName);
                        JOptionPane.showMessageDialog(this.getFrame(), Bundle.getMessage("LogixError11", c.getUserName(), c.getSystemName(), cRef.getUserName(), cRef.getSystemName(), xRef.getUserName(), xRef.getSystemName()), Bundle.getMessage("ErrorTitle"), 0);
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    void deleteSourceWhereUsed() {
        this._saveTargetList.forEach((refName, targetList) -> {
            for (String targetName : targetList) {
                InstanceManager.getDefault(ConditionalManager.class).removeWhereUsed(targetName, (String)refName);
            }
        });
    }

    void updateWhereUsed(TreeSet<String> newTargetNames, String refName) {
        TreeSet<String> deleteNames = new TreeSet<String>((SortedSet<String>)this._saveTargetNames);
        deleteNames.removeAll(newTargetNames);
        for (String deleteName : deleteNames) {
            InstanceManager.getDefault(ConditionalManager.class).removeWhereUsed(deleteName, refName);
        }
        TreeSet<String> addNames = new TreeSet<String>((SortedSet<String>)newTargetNames);
        addNames.removeAll(this._saveTargetNames);
        for (String addName : addNames) {
            InstanceManager.getDefault(ConditionalManager.class).addWhereUsed(addName, refName);
        }
    }

    JPanel makeEditPanel(JComponent comp, String label, String hint) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel p = new JPanel();
        p.add(new JLabel(Bundle.getMessage(label)));
        panel.add(p);
        if (hint != null) {
            panel.setToolTipText(Bundle.getMessage(hint));
        }
        comp.setMaximumSize(comp.getPreferredSize());
        panel.add(comp);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    public static String formatTime(int hour, int minute) {
        String s = "";
        String t = Integer.toString(hour);
        if (t.length() == 2) {
            s = String.valueOf(t) + ":";
        } else if (t.length() == 1) {
            s = "0" + t + ":";
        }
        t = Integer.toString(minute);
        if (t.length() == 2) {
            s = String.valueOf(s) + t;
        } else if (t.length() == 1) {
            s = String.valueOf(s) + "0" + t;
        }
        if (s.length() != 5) {
            s = "00:00";
        }
        return s;
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleLogixTable");
    }

    @Override
    protected String getClassName() {
        return LogixTableAction.class.getName();
    }

    void makeWhereUsedWindow() {
        JmriJFrame referenceListFrame = new JmriJFrame(Bundle.getMessage("LabelRefTitle"), false, true);
        Container contentPane = referenceListFrame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(0, 10, 5));
        panel1.add(new JLabel(Bundle.getMessage("LabelRefTarget")));
        panel1.add(new JLabel(Bundle.getMessage("LabelRefSource")));
        contentPane.add(panel1);
        JScrollPane scrollPane = null;
        JTextArea textContent = this.buildWhereUsedListing();
        scrollPane = new JScrollPane(textContent);
        contentPane.add(scrollPane);
        referenceListFrame.pack();
        referenceListFrame.setVisible(true);
    }

    public JTextArea buildWhereUsedListing() {
        JTextArea condText = new JTextArea();
        condText.setText(null);
        HashMap<String, ArrayList<String>> whereUsed = InstanceManager.getDefault(ConditionalManager.class).getWhereUsedMap();
        TreeSet<String> targets = new TreeSet<String>(whereUsed.keySet());
        targets.forEach(target -> {
            condText.append("\n" + target + "\t" + this.getWhereUsedName((String)target) + "  \n");
            ArrayList refNames = (ArrayList)whereUsed.get(target);
            refNames.forEach(refName -> condText.append("\t\t" + refName + "\t" + this.getWhereUsedName((String)refName) + "  \n"));
        });
        condText.setCaretPosition(0);
        condText.setTabSize(2);
        condText.setEditable(false);
        return condText;
    }

    String getWhereUsedName(String cName) {
        Conditional cond = this._conditionalManager.getBySystemName(cName);
        if (cond != null) {
            return cond.getUserName();
        }
        return "";
    }

    void browserPressed(String sName) {
        this.makeBrowserWindow(sName);
    }

    void makeBrowserWindow(String lgxName) {
        Logix logix = this._logixManager.getBySystemName(lgxName);
        if (logix == null) {
            return;
        }
        final JmriJFrame condBrowserFrame = new JmriJFrame(Bundle.getMessage("BrowserTitle"), false, true);
        condBrowserFrame.addHelpMenu("package.jmri.jmrit.beantable.LogixAddEdit", true);
        Container contentPane = condBrowserFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        String tStr = String.valueOf(Bundle.getMessage("BrowserLogix")) + " " + logix.getSystemName() + "    " + logix.getUserName() + "    " + (Boolean.valueOf(logix.getEnabled()) != false ? Bundle.getMessage("BrowserEnabled") : Bundle.getMessage("BrowserDisabled"));
        topPanel.add(new JLabel(tStr));
        contentPane.add((Component)topPanel, "North");
        JScrollPane scrollPane = null;
        JTextArea textContent = this.buildConditionalListing(logix);
        scrollPane = new JScrollPane(textContent);
        contentPane.add(scrollPane);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JButton helpBrowse = new JButton(Bundle.getMessage("MenuHelp"));
        bottomPanel.add((Component)helpBrowse, "West");
        helpBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(condBrowserFrame, Bundle.getMessage("BrowserHelpText"), Bundle.getMessage("BrowserHelpTitle"), 1);
            }
        });
        JButton saveBrowse = new JButton(Bundle.getMessage("BrowserSaveButton"));
        saveBrowse.setToolTipText(Bundle.getMessage("BrowserSaveButtonHint"));
        bottomPanel.add((Component)saveBrowse, "East");
        saveBrowse.addActionListener(new SaveAction(lgxName));
        contentPane.add((Component)bottomPanel, "South");
        condBrowserFrame.pack();
        condBrowserFrame.setVisible(true);
    }

    void saveBrowserPressed(String lgxName) {
        Logix logix = this._logixManager.getBySystemName(lgxName);
        if (logix == null) {
            log.warn("Can't save browsed data, logix {} no longer exits", (Object)lgxName);
            return;
        }
        JFileChooser userFileChooser = new JFileChooser(FileUtil.getUserFilesPath());
        userFileChooser.setApproveButtonText(Bundle.getMessage("BrowserSaveDialogApprove"));
        userFileChooser.setDialogTitle(Bundle.getMessage("BrowserSaveDialogTitle"));
        userFileChooser.rescanCurrentDirectory();
        userFileChooser.setSelectedFile(new File(String.valueOf(FileUtil.sanitizeFilename(logix.getSystemName())) + ".txt"));
        int retVal = userFileChooser.showSaveDialog(null);
        if (retVal != 0) {
            log.debug("Save browser content stopped, no file selected");
            return;
        }
        File file = userFileChooser.getSelectedFile();
        log.debug("Save browser content to '{}'", (Object)file);
        if (file.exists()) {
            Object[] options = new Object[]{Bundle.getMessage("BrowserSaveDuplicateReplace"), Bundle.getMessage("BrowserSaveDuplicateAppend"), Bundle.getMessage("ButtonCancel")};
            int selectedOption = JOptionPane.showOptionDialog(null, Bundle.getMessage("BrowserSaveDuplicatePrompt", file.getName()), Bundle.getMessage("BrowserSaveDuplicateTitle"), -1, 2, null, options, options[0]);
            if (selectedOption == 2 || selectedOption == -1) {
                log.debug("Save browser content stopped, file replace/append cancelled");
                return;
            }
            if (selectedOption == 0) {
                FileUtil.delete(file);
            }
        }
        String tStr = String.valueOf(Bundle.getMessage("BrowserLogix")) + " " + logix.getSystemName() + "    " + logix.getUserName() + "    " + (Boolean.valueOf(logix.getEnabled()) != false ? Bundle.getMessage("BrowserEnabled") : Bundle.getMessage("BrowserDisabled"));
        JTextArea textContent = this.buildConditionalListing(logix);
        try {
            FileUtil.appendTextToFile(file, tStr);
            FileUtil.appendTextToFile(file, textContent.getText());
        }
        catch (IOException e) {
            log.error("Unable to write browser content to '{}', exception: '{}'", (Object)file, (Object)e);
        }
    }

    JTextArea buildConditionalListing(Logix logix) {
        String _antecedent = null;
        JTextArea condText = new JTextArea();
        condText.setFont(new Font("Monospaced", 0, 12));
        condText.setText(null);
        int numConditionals = logix.getNumConditionals();
        int rx = 0;
        while (rx < numConditionals) {
            this.conditionalRowNumber = rx;
            Conditional curConditional = this._conditionalManager.getBySystemName(logix.getConditionalByNumberOrder(rx));
            if (curConditional != null) {
                List<ConditionalVariable> variableList = curConditional.getCopyOfStateVariables();
                List<ConditionalAction> actionList = curConditional.getCopyOfActions();
                String showCondName = curConditional.getUserName();
                if (showCondName == null) {
                    showCondName = "";
                }
                String showSystemName = curConditional.getSystemName();
                if (showCondName.equals("")) {
                    showCondName = "C" + (rx + 1);
                }
                condText.append("\n  " + showSystemName + "  " + showCondName + "   \n");
                if (curConditional.getLogicType() == Conditional.AntecedentOperator.MIXED) {
                    _antecedent = curConditional.getAntecedentExpression();
                    String antecedent = ConditionalEditBase.translateAntecedent(_antecedent, false);
                    condText.append("   " + Bundle.getMessage("LogixAntecedent") + " " + antecedent + "  \n");
                }
                int i = 0;
                while (i < variableList.size()) {
                    ConditionalVariable variable = variableList.get(i);
                    String varTrigger = variable.doTriggerActions() ? "[x]" : "[ ]";
                    String tStr = "    " + varTrigger + " ";
                    tStr = String.valueOf(tStr) + " R" + (i + 1) + (i > 8 ? " " : "  ");
                    condText.append(tStr);
                    String operand = variable.getOpernString();
                    if (i == 0) {
                        condText.append(String.valueOf(Bundle.getMessage("BrowserIF")) + " " + operand + " ");
                    } else {
                        condText.append("  " + operand + " ");
                    }
                    if (variable.isNegated()) {
                        condText.append(String.valueOf(Bundle.getMessage("LogicNOT")) + " ");
                    }
                    condText.append(String.valueOf(variable.toString()) + "   \n");
                    ++i;
                }
                if (actionList.size() > 0) {
                    condText.append("             " + Bundle.getMessage("BrowserTHEN") + "   \n");
                    boolean triggerType = curConditional.getTriggerOnChange();
                    int i2 = 0;
                    while (i2 < actionList.size()) {
                        ConditionalAction action = actionList.get(i2);
                        String condName = action.description(triggerType);
                        condText.append("               " + condName + "   \n");
                        ++i2;
                    }
                } else {
                    condText.append("             " + Bundle.getMessage("BrowserNoAction") + "   \n\n");
                }
            }
            ++rx;
        }
        condText.setCaretPosition(0);
        condText.setTabSize(4);
        condText.setEditable(false);
        return condText;
    }

    class ConditionalBaseListener
    implements ConditionalEditBase.LogixEventListener {
        String _lgxName;

        ConditionalBaseListener(String lgxName) {
            this._lgxName = lgxName;
        }

        @Override
        public void logixEventOccurred() {
            LogixTableAction.this._baseEdit.logixData.forEach((key, value) -> {
                if (key.equals("Finish")) {
                    LogixTableAction.this._baseEdit = null;
                    LogixTableAction.this._inEditMode = false;
                    LogixTableAction.this._inCopyMode = false;
                    Logix x = LogixTableAction.this._logixManager.getBySystemName((String)value);
                    if (x == null) {
                        log.error("Found no logix for name {} when done", value);
                        return;
                    }
                    x.activateLogix();
                    LogixTableAction.this.f.setVisible(true);
                } else if (key.equals("Delete")) {
                    LogixTableAction.this.deletePressed((String)value);
                } else if (key.equals("chgUname")) {
                    Logix x = LogixTableAction.this._logixManager.getBySystemName(this._lgxName);
                    if (x == null) {
                        log.error("Found no logix for name {} when changing user name (2)", (Object)this._lgxName);
                        return;
                    }
                    x.setUserName((String)value);
                    LogixTableAction.this.m.fireTableDataChanged();
                }
            });
        }
    }

    class CopyAction
    implements ActionListener {
        String _lgxName;

        CopyAction(String lgxName) {
            this._lgxName = lgxName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogixTableAction.this.copyLogixPressed(this._lgxName);
        }
    }

    public static enum EditMode {
        LISTEDIT,
        TREEEDIT;

    }

    class RefDialog
    extends JDialog {
        JTextField _devNameField;
        Frame _parent;

        RefDialog(Frame frame) {
            super(frame, Bundle.getMessage("CrossReference"), true);
            this._parent = frame;
            JPanel extraPanel = new JPanel();
            extraPanel.setLayout(new BoxLayout(extraPanel, 1));
            this._devNameField = new JTextField(30);
            JPanel panel = LogixTableAction.this.makeEditPanel(this._devNameField, "ElementName", "ElementNameHint");
            JButton referenceButton = new JButton(Bundle.getMessage("ReferenceButton"));
            panel.add(referenceButton);
            referenceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RefDialog.this.deviceReportPressed(e);
                }
            });
            panel.add(referenceButton);
            extraPanel.add(panel);
            this.setContentPane(extraPanel);
            this.pack();
            this.setVisible(true);
        }

        void deviceReportPressed(ActionEvent e) {
            Maintenance.deviceReportPressed(this._devNameField.getText(), this._parent);
            this.dispose();
        }
    }

    class SaveAction
    implements ActionListener {
        String _lgxName;

        SaveAction(String lgxName) {
            this._lgxName = lgxName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogixTableAction.this.saveBrowserPressed(this._lgxName);
        }
    }

    public static enum SelectionMode {
        USEMULTI,
        USESINGLE,
        USECOMBO;

    }
}

