/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.jmrit.beantable.AbstractLogixNGTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.tools.swing.AbstractLogixNGEditor;
import jmri.jmrit.logixng.tools.swing.TableEditor;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNGTableTableAction
extends AbstractLogixNGTableAction<NamedTable> {
    JRadioButton _typeExternalTable = new JRadioButton(Bundle.getMessage("LogixNG_typeExternalTable"));
    JRadioButton _typeInternalTable = new JRadioButton(Bundle.getMessage("LogixNG_typeInternalTable"));
    ButtonGroup _buttonGroup = new ButtonGroup();
    JTextField _csvFileName = new JTextField(50);
    private static final Logger log = LoggerFactory.getLogger(LogixNGTableTableAction.class);

    public LogixNGTableTableAction(String s) {
        super(s);
    }

    public LogixNGTableTableAction() {
        this(Bundle.getMessage("TitleLogixNGTableTable"));
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleLogixNGTableTable"));
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleLogixNGTableTable");
    }

    @Override
    protected AbstractLogixNGEditor<NamedTable> getEditor(BeanTableFrame<NamedTable> f, BeanTableDataModel<NamedTable> m, String sName) {
        return new TableEditor(m, sName);
    }

    @Override
    protected Manager<NamedTable> getManager() {
        return InstanceManager.getDefault(NamedTableManager.class);
    }

    @Override
    protected void enableAll(boolean enable) {
    }

    @Override
    protected void setEnabled(NamedTable bean, boolean enable) {
    }

    @Override
    protected boolean isEnabled(NamedTable bean) {
        return true;
    }

    @Override
    protected NamedTable createBean(String userName) {
        String systemName = InstanceManager.getDefault(NamedTableManager.class).getAutoSystemName();
        return this.createBean(systemName, userName);
    }

    @Override
    protected NamedTable createBean(String systemName, String userName) {
        if (this._typeExternalTable.isSelected()) {
            String fileName = this._csvFileName.getText();
            if (fileName == null || fileName.isEmpty()) {
                JOptionPane.showMessageDialog(this.addLogixNGFrame, Bundle.getMessage("LogixNGError2"), Bundle.getMessage("ErrorTitle"), 0);
                return null;
            }
            return InstanceManager.getDefault(NamedTableManager.class).newCSVTable(systemName, userName, fileName);
        }
        if (!this._typeInternalTable.isSelected()) {
            log.error("No table type selected");
            throw new RuntimeException("No table type selected");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void deleteBean(NamedTable bean) {
        try {
            InstanceManager.getDefault(NamedTableManager.class).deleteBean(bean, "DoDelete");
        }
        catch (PropertyVetoException e) {
            log.error(e.getMessage());
        }
    }

    @Override
    protected boolean browseMonoSpace() {
        return true;
    }

    @Override
    protected String getBeanText(NamedTable bean) {
        int maxColumnWidth = 0;
        int[] columnWidth = new int[bean.numColumns() + 1];
        String[][] cells = new String[bean.numRows() + 1][];
        int row = 0;
        while (row <= bean.numRows()) {
            cells[row] = new String[bean.numColumns() + 1];
            int col = 0;
            while (col <= bean.numColumns()) {
                Object value = bean.getCell(row, col);
                cells[row][col] = value != null ? value.toString() : "<null>";
                columnWidth[col] = Math.max(columnWidth[col], cells[row][col].length());
                maxColumnWidth = Math.max(maxColumnWidth, columnWidth[col]);
                ++col;
            }
            ++row;
        }
        StringBuilder columnLine = new StringBuilder();
        while (columnLine.length() + 2 < maxColumnWidth) {
            columnLine.append("----------------------");
        }
        String columnPadding = String.format("%" + Integer.toString(maxColumnWidth) + "s", "");
        StringBuilder sb = new StringBuilder();
        sb.append("+");
        int col = 0;
        while (col <= bean.numColumns()) {
            sb.append(columnLine.substring(0, columnWidth[col] + 2));
            sb.append("+");
            if (col == bean.numColumns()) {
                sb.append(String.format("%n", new Object[0]));
            }
            ++col;
        }
        int row2 = 0;
        while (row2 <= bean.numRows()) {
            sb.append("|");
            int col2 = 0;
            while (col2 <= bean.numColumns()) {
                sb.append(" ");
                sb.append((String.valueOf(cells[row2][col2]) + columnPadding).substring(0, columnWidth[col2]));
                sb.append(" |");
                if (col2 == bean.numColumns()) {
                    sb.append(String.format("%n", new Object[0]));
                }
                ++col2;
            }
            sb.append("+");
            col2 = 0;
            while (col2 <= bean.numColumns()) {
                sb.append(columnLine.substring(0, columnWidth[col2] + 2));
                sb.append("+");
                if (col2 == bean.numColumns()) {
                    sb.append(String.format("%n", new Object[0]));
                }
                ++col2;
            }
            ++row2;
        }
        return sb.toString();
    }

    @Override
    protected String getAddTitleKey() {
        return "TitleLogixNGTableTable";
    }

    @Override
    protected String getCreateButtonHintKey() {
        return "LogixNGTableCreateButtonHint";
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.LogixNGTableTable";
    }

    private JButton createFileChooser() {
        JButton selectFileButton = new JButton("...");
        selectFileButton.setMaximumSize(selectFileButton.getPreferredSize());
        selectFileButton.setToolTipText(Bundle.getMessage("LogixNG_FileButtonHint"));
        selectFileButton.addActionListener(e -> {
            JFileChooser csvFileChooser = new JFileChooser(FileUtil.getUserFilesPath());
            csvFileChooser.setFileFilter(new FileNameExtensionFilter("CSV files", "csv", "txt"));
            csvFileChooser.rescanCurrentDirectory();
            int retVal = csvFileChooser.showOpenDialog(null);
            if (retVal == 0) {
                try {
                    this._csvFileName.setText(FileUtil.getPortableFilename(csvFileChooser.getSelectedFile().getCanonicalPath()));
                }
                catch (IOException ex) {
                    log.error("exception setting file location: {}", (Throwable)ex);
                    this._csvFileName.setText("");
                }
            }
        });
        return selectFileButton;
    }

    @Override
    protected JPanel makeAddFrame(String titleId, String startMessageId) {
        this.addLogixNGFrame = new JmriJFrame(Bundle.getMessage(titleId));
        this.addLogixNGFrame.addHelpMenu("package.jmri.jmrit.beantable.LogixNGTableTable", true);
        this.addLogixNGFrame.setLocation(50, 30);
        Container contentPane = this.addLogixNGFrame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._sysNameLabel, c);
        this._sysNameLabel.setLabelFor(this._systemName);
        c.gridy = 1;
        p.add((Component)this._userNameLabel, c);
        this._userNameLabel.setLabelFor(this._addUserName);
        c.gridy = 2;
        p.add((Component)new JLabel(Bundle.getMessage("LogixNG_CsvFileName")), c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this._systemName, c);
        c.gridy = 1;
        p.add((Component)this._addUserName, c);
        c.gridy = 2;
        this.createFileChooser();
        p.add((Component)this.createFileChooser(), c);
        c.gridx = 2;
        c.gridwidth = 0;
        p.add((Component)this._csvFileName, c);
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 0;
        p.add((Component)this._autoSystemName, c);
        this._buttonGroup.add(this._typeExternalTable);
        this._buttonGroup.add(this._typeInternalTable);
        this._typeExternalTable.setSelected(true);
        this._typeInternalTable.setEnabled(false);
        this._addUserName.setToolTipText(Bundle.getMessage("LogixNGUserNameHint"));
        this._systemName.setToolTipText(Bundle.getMessage("LogixNGSystemNameHint"));
        contentPane.add(p);
        JPanel panel98 = new JPanel();
        panel98.setLayout(new FlowLayout());
        JPanel panel99 = new JPanel();
        panel99.setLayout(new BoxLayout(panel99, 1));
        panel99.add((Component)this._typeExternalTable, c);
        panel99.add((Component)this._typeInternalTable, c);
        panel98.add(panel99);
        contentPane.add(panel98);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        JLabel message1 = new JLabel(Bundle.getMessage(String.valueOf(startMessageId) + "LogixNGTableMessage1"));
        panel31.add(message1);
        JPanel panel32 = new JPanel();
        JLabel message2 = new JLabel(Bundle.getMessage(String.valueOf(startMessageId) + "LogixNGTableMessage2"));
        panel32.add(message2);
        panel3.add(panel31);
        panel3.add(panel32);
        contentPane.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(this::cancelAddPressed);
        cancel.setToolTipText(Bundle.getMessage("CancelLogixNGButtonHint"));
        this.addLogixNGFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LogixNGTableTableAction.this.cancelAddPressed(null);
            }
        });
        contentPane.add(panel5);
        this._autoSystemName.addItemListener(e -> this.autoSystemName());
        return panel5;
    }

    @Override
    protected void getListenerRefsIncludingChildren(NamedTable table, List<String> list) {
    }

    @Override
    protected boolean hasChildren(NamedTable table) {
        return false;
    }
}

