/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.UserPreferencesManager;
import jmri.configurexml.StoreMenu;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.ListedTableAction;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.gui.GuiLafPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListedTableFrame<E extends NamedBean>
extends BeanTableFrame<E> {
    ActionJList actionList;
    static ArrayList<TabbedTableItemListArray> tabbedTableItemListArrayArray = new ArrayList();
    ArrayList<TabbedTableItem<E>> tabbedTableArray = new ArrayList();
    final UserPreferencesManager pref = InstanceManager.getDefault(UserPreferencesManager.class);
    JSplitPane cardHolder;
    JList<String> list;
    JScrollPane listScroller;
    JPanel listPanel;
    JPanel detailPanel;
    static boolean init = false;
    TabbedTableItem<E> lastSelectedItem = null;
    private static final Logger log = LoggerFactory.getLogger(ListedTableFrame.class);

    public boolean isMultipleInstances() {
        return true;
    }

    public ListedTableFrame() {
        this(Bundle.getMessage("TitleListedTable"));
    }

    public ListedTableFrame(String s) {
        super(s);
        if (InstanceManager.getNullableDefault(ListedTableFrame.class) == null) {
            InstanceManager.store(this, ListedTableFrame.class);
        }
    }

    public void initTables() {
        if (!init) {
            this.addTable("jmri.jmrit.beantable.TurnoutTableTabAction", Bundle.getMessage("MenuItemTurnoutTable"), false);
            this.addTable("jmri.jmrit.beantable.SensorTableTabAction", Bundle.getMessage("MenuItemSensorTable"), false);
            this.addTable("jmri.jmrit.beantable.LightTableTabAction", Bundle.getMessage("MenuItemLightTable"), false);
            this.addTable("jmri.jmrit.beantable.SignalHeadTableAction", Bundle.getMessage("MenuItemSignalTable"), true);
            this.addTable("jmri.jmrit.beantable.SignalMastTableAction", Bundle.getMessage("MenuItemSignalMastTable"), true);
            this.addTable("jmri.jmrit.beantable.SignalGroupTableAction", Bundle.getMessage("MenuItemSignalGroupTable"), true);
            this.addTable("jmri.jmrit.beantable.SignalMastLogicTableAction", Bundle.getMessage("MenuItemSignalMastLogicTable"), true);
            this.addTable("jmri.jmrit.beantable.ReporterTableTabAction", Bundle.getMessage("MenuItemReporterTable"), false);
            this.addTable("jmri.jmrit.beantable.MemoryTableAction", Bundle.getMessage("MenuItemMemoryTable"), true);
            this.addTable("jmri.jmrit.beantable.RouteTableAction", Bundle.getMessage("MenuItemRouteTable"), true);
            this.addTable("jmri.jmrit.beantable.LRouteTableAction", Bundle.getMessage("MenuItemLRouteTable"), true);
            this.addTable("jmri.jmrit.beantable.LogixTableAction", Bundle.getMessage("MenuItemLogixTable"), true);
            this.addTable("jmri.jmrit.beantable.LogixNGTableAction", Bundle.getMessage("MenuItemLogixNGTable"), true);
            this.addTable("jmri.jmrit.beantable.LogixNGModuleTableAction", Bundle.getMessage("MenuItemLogixNGModuleTable"), true);
            this.addTable("jmri.jmrit.beantable.LogixNGTableTableAction", Bundle.getMessage("MenuItemLogixNGTableTable"), true);
            this.addTable("jmri.jmrit.beantable.BlockTableAction", Bundle.getMessage("MenuItemBlockTable"), true);
            if (InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed()) {
                this.addTable("jmri.jmrit.beantable.OBlockTableAction", Bundle.getMessage("MenuItemOBlockTable"), false);
            }
            this.addTable("jmri.jmrit.beantable.SectionTableAction", Bundle.getMessage("MenuItemSectionTable"), true);
            this.addTable("jmri.jmrit.beantable.TransitTableAction", Bundle.getMessage("MenuItemTransitTable"), true);
            this.addTable("jmri.jmrit.beantable.AudioTableAction", Bundle.getMessage("MenuItemAudioTable"), false);
            this.addTable("jmri.jmrit.beantable.IdTagTableTabAction", Bundle.getMessage("MenuItemIdTagTable"), false);
            this.addTable("jmri.jmrit.beantable.RailComTableAction", Bundle.getMessage("MenuItemRailComTable"), true);
            ListedTableFrame.setInit(true);
        }
    }

    @Override
    public void initComponents() {
        if (tabbedTableItemListArrayArray.isEmpty()) {
            log.error("No tables loaded: {}", (Object)this);
            return;
        }
        this.actionList = new ActionJList(this);
        this.detailPanel = new JPanel();
        this.detailPanel.setLayout(new CardLayout());
        this.tabbedTableArray = new ArrayList(tabbedTableItemListArrayArray.size());
        ArrayList<TabbedTableItemListArray> removeItem = new ArrayList<TabbedTableItemListArray>(5);
        for (TabbedTableItemListArray item : tabbedTableItemListArrayArray) {
            try {
                TabbedTableItem itemModel = new TabbedTableItem(item.getClassAsString(), item.getItemString(), item.getStandardTableModel());
                this.detailPanel.add((Component)itemModel.getPanel(), itemModel.getClassAsString());
                this.tabbedTableArray.add(itemModel);
                itemModel.getAAClass().addToFrame(this);
            }
            catch (Exception ex) {
                this.detailPanel.add((Component)this.errorPanel(item.getItemString()), item.getClassAsString());
                log.error("Error when adding {} to display", (Object)item.getClassAsString(), (Object)ex);
                removeItem.add(item);
            }
        }
        for (TabbedTableItemListArray dead : removeItem) {
            tabbedTableItemListArrayArray.remove(dead);
        }
        this.list = new JList<String>(new Vector<String>(ListedTableFrame.getChoices()));
        this.listScroller = new JScrollPane(this.list);
        this.list.setSelectionMode(1);
        this.list.setLayoutOrientation(0);
        this.list.addMouseListener(this.actionList);
        this.listPanel = new JPanel();
        this.listPanel.setLayout(new BorderLayout(5, 0));
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 1));
        this.listPanel.add(this.listScroller);
        this.listPanel.setMinimumSize(new Dimension(140, 400));
        this.buildMenus(this.tabbedTableArray.get(0));
        this.setTitle(this.tabbedTableArray.get(0).getItemString());
        this.cardHolder = new JSplitPane(1, this.listPanel, this.detailPanel);
        this.cardHolder.setDividerSize(8);
        if (this.getDividerLocation() != 0) {
            this.cardHolder.setDividerLocation(this.getDividerLocation());
        } else {
            this.cardHolder.setDividerLocation(this.listScroller.getPreferredSize().width);
        }
        this.cardHolder.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("dividerLocation")) {
                InstanceManager.getDefault(UserPreferencesManager.class).setProperty(ListedTableFrame.class.getName(), "dividerLocation", e.getNewValue());
            }
        });
        this.cardHolder.setOneTouchExpandable(true);
        this.getContentPane().add(this.cardHolder);
        this.pack();
        this.actionList.selectListItem(0);
    }

    JPanel errorPanel(String text) {
        JPanel error = new JPanel();
        error.add(new JLabel(Bundle.getMessage("ErrorAddingTable", text)));
        return error;
    }

    public void gotoListItem(String selection) {
        int x = 0;
        while (x < this.tabbedTableArray.size()) {
            try {
                if (this.tabbedTableArray.get(x).getClassAsString().equals(selection)) {
                    this.actionList.selectListItem(x);
                    return;
                }
            }
            catch (Exception ex) {
                log.error("An error occurred in the goto list for {}, {}", (Object)selection, (Object)ex.getMessage());
            }
            ++x;
        }
    }

    public void addTable(String aaClass, String choice, boolean stdModel) {
        TabbedTableItemListArray itemToAdd = null;
        for (TabbedTableItemListArray ttila : tabbedTableItemListArrayArray) {
            if (!ttila.getClassAsString().equals(aaClass)) continue;
            log.info("Class {} is already added", (Object)aaClass);
            itemToAdd = ttila;
            break;
        }
        if (itemToAdd == null) {
            itemToAdd = new TabbedTableItemListArray(aaClass, choice, stdModel);
            tabbedTableItemListArrayArray.add(itemToAdd);
        }
    }

    @Override
    public void dispose() {
        this.pref.setSaveAllowed(false);
        for (TabbedTableItem<E> tti : this.tabbedTableArray) {
            tti.dispose();
        }
        if (this.list != null && this.list.getListSelectionListeners().length > 0) {
            this.list.removeListSelectionListener(this.list.getListSelectionListeners()[0]);
        }
        super.dispose();
        this.pref.setSaveAllowed(true);
    }

    void buildMenus(TabbedTableItem<E> item) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        menuBar.add(fileMenu);
        JMenuItem newItem = new JMenuItem(Bundle.getMessage("MenuNewWindow"));
        fileMenu.add(newItem);
        newItem.addActionListener(e -> this.actionList.openNewTableWindow(this.list.getSelectedIndex()));
        fileMenu.add(new StoreMenu());
        JMenuItem printItem = new JMenuItem(Bundle.getMessage("PrintTable"));
        fileMenu.add(printItem);
        printItem.addActionListener(e -> {
            try {
                MessageFormat footerFormat = new MessageFormat(String.valueOf(this.getTitle()) + " page {0,number}");
                if (item.getStandardTableModel()) {
                    item.getDataTable().print(JTable.PrintMode.FIT_WIDTH, null, footerFormat);
                } else {
                    item.getAAClass().print(JTable.PrintMode.FIT_WIDTH, null, footerFormat);
                }
            }
            catch (PrinterException e1) {
                log.warn("Printing error", (Throwable)e1);
            }
            catch (NullPointerException nullPointerException) {
                log.error("Trying to print returned a NPE error");
            }
        });
        JMenu viewMenu = new JMenu(Bundle.getMessage("MenuView"));
        menuBar.add(viewMenu);
        for (TabbedTableItemListArray itemList : tabbedTableItemListArrayArray) {
            JMenuItem viewItem = new JMenuItem(itemList.getItemString());
            viewMenu.add(viewItem);
            viewItem.addActionListener(e -> this.gotoListItem(itemList.getClassAsString()));
        }
        this.setJMenuBar(menuBar);
        try {
            item.getAAClass().setMenuBar(this);
            this.addHelpMenu(item.getAAClass().helpTarget(), true);
        }
        catch (Exception ex) {
            log.error("Error when trying to set menu bar for {}", (Object)item.getClassAsString(), (Object)ex);
        }
        this.revalidate();
    }

    @Override
    protected void addToBottomBox(Component comp, String c) {
        for (TabbedTableItem<E> tti : this.tabbedTableArray) {
            if (!tti.getClassAsString().equals(c)) continue;
            tti.addToBottomBox(comp);
            return;
        }
    }

    protected static ArrayList<String> getChoices() {
        ArrayList<String> choices = new ArrayList<String>();
        for (TabbedTableItemListArray ttila : tabbedTableItemListArrayArray) {
            choices.add(ttila.getItemString());
        }
        return choices;
    }

    public void setDividerLocation(int loc) {
        if (loc == 0) {
            return;
        }
        this.cardHolder.setDividerLocation(loc);
        InstanceManager.getDefault(UserPreferencesManager.class).setProperty(ListedTableFrame.class.getName(), "dividerLocation", loc);
    }

    public int getDividerLocation() {
        try {
            return Integer.parseInt(InstanceManager.getDefault(UserPreferencesManager.class).getProperty(ListedTableFrame.class.getName(), "dividerLocation").toString());
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return 0;
        }
    }

    private static synchronized void setInit(boolean newVal) {
        init = newVal;
    }

    class ActionJList
    extends MouseAdapter {
        JPopupMenu popUp;
        JMenuItem menuItem;
        protected BeanTableFrame<E> frame;
        private int currentItemSelected;
        private int beforeClickIndex;
        private int mouseItem;

        ActionJList(BeanTableFrame<E> f) {
            this.frame = f;
            this.popUp = new JPopupMenu();
            this.menuItem = new JMenuItem(Bundle.getMessage("MenuOpenInNewWindow"));
            this.popUp.add(this.menuItem);
            this.menuItem.addActionListener(e -> this.openNewTableWindow(this.mouseItem));
            this.currentItemSelected = 0;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        void showPopup(MouseEvent e) {
            this.popUp.show(e.getComponent(), e.getX(), e.getY());
            this.mouseItem = ListedTableFrame.this.list.locationToIndex(e.getPoint());
        }

        void setCurrentItem(int current) {
            this.currentItemSelected = current;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.mouseItem = ListedTableFrame.this.list.locationToIndex(e.getPoint());
            if (this.popUp.isVisible()) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.showPopup(e);
                return;
            }
            if (e.getClickCount() == 1) {
                this.beforeClickIndex = this.currentItemSelected;
                this.selectListItem(this.mouseItem);
            } else if (e.getClickCount() == 2) {
                ListedTableFrame.this.list.setSelectedIndex(this.beforeClickIndex);
                this.selectListItem(this.beforeClickIndex);
                this.openNewTableWindow(this.mouseItem);
            }
        }

        void openNewTableWindow(int index) {
            TabbedTableItem item = ListedTableFrame.this.tabbedTableArray.get(index);
            class WindowMaker
            implements Runnable {
                final TabbedTableItem<E> item;

                WindowMaker(TabbedTableItem<E> tItem) {
                    this.item = tItem;
                }

                @Override
                public void run() {
                    ListedTableAction tmp = new ListedTableAction(this.item.getItemString(), this.item.getClassAsString(), ((ActionJList)ActionJList.this).ListedTableFrame.this.cardHolder.getDividerLocation());
                    tmp.actionPerformed();
                }
            }
            WindowMaker t = new WindowMaker(item);
            SwingUtilities.invokeLater(t);
        }

        void selectListItem(int index) {
            this.currentItemSelected = index;
            TabbedTableItem item = ListedTableFrame.this.tabbedTableArray.get(index);
            CardLayout cl = (CardLayout)ListedTableFrame.this.detailPanel.getLayout();
            cl.show(ListedTableFrame.this.detailPanel, item.getClassAsString());
            this.frame.setTitle(item.getItemString());
            this.frame.generateWindowRef();
            try {
                item.getAAClass().setFrame(this.frame);
                ListedTableFrame.this.buildMenus(item);
            }
            catch (Exception ex) {
                log.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
            ListedTableFrame.this.list.ensureIndexIsVisible(index);
            ListedTableFrame.this.list.setSelectedIndex(index);
        }
    }

    static class TabbedTableItem<E extends NamedBean> {
        AbstractTableAction<E> tableAction;
        String className;
        String itemText;
        BeanTableDataModel<E> dataModel;
        JTable dataTable;
        JScrollPane dataScroll;
        Box bottomBox;
        int bottomBoxIndex;
        static final int bottomStrutWidth = 20;
        boolean standardModel;
        final JPanel dataPanel = new JPanel();

        TabbedTableItem(String aaClass, String choice, boolean stdModel) {
            this.className = aaClass;
            this.itemText = choice;
            this.standardModel = stdModel;
            this.bottomBox = Box.createHorizontalBox();
            this.bottomBox.add(Box.createHorizontalGlue());
            this.bottomBoxIndex = 0;
            try {
                Class<?> cl = Class.forName(aaClass);
                Constructor<?> co = cl.getConstructor(String.class);
                this.tableAction = (AbstractTableAction)co.newInstance(choice);
            }
            catch (ClassNotFoundException | InstantiationException reflectiveOperationException) {
                log.error("Not a valid class : {}", (Object)aaClass);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.error("Not such method : {}", (Object)aaClass);
                return;
            }
            catch (ClassCastException classCastException) {
                log.error("Not part of the abstractTableActions : {}", (Object)aaClass);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                log.error("Exception accessing {}: {}", (Object)aaClass, (Object)e.getMessage());
                return;
            }
            this.dataPanel.setLayout(new BorderLayout());
            if (stdModel) {
                this.createDataModel();
            } else {
                this.addPanelModel();
            }
        }

        void createDataModel() {
            this.dataModel = this.tableAction.getTableDataModel();
            TableRowSorter<BeanTableDataModel<E>> sorter = new TableRowSorter<BeanTableDataModel<E>>(this.dataModel);
            this.dataTable = this.dataModel.makeJTable(String.valueOf(this.dataModel.getMasterClassName()) + ":" + this.getItemString(), this.dataModel, sorter);
            this.dataScroll = new JScrollPane(this.dataTable);
            RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
            sorter.setComparator(1, new AlphanumComparator());
            RowSorterUtil.setSortOrder(sorter, 1, SortOrder.ASCENDING);
            this.dataModel.configureTable(this.dataTable);
            Dimension dataTableSize = this.dataTable.getPreferredSize();
            dataTableSize.height = Math.max(dataTableSize.height, 400);
            this.dataScroll.getViewport().setPreferredSize(dataTableSize);
            this.dataScroll.setHorizontalScrollBarPolicy(32);
            this.dataScroll.setVerticalScrollBarPolicy(22);
            this.dataPanel.add((Component)this.dataScroll, "Center");
            this.dataPanel.add((Component)this.bottomBox, "South");
            if (this.tableAction.includeAddButton()) {
                JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
                this.addToBottomBox(addButton);
                addButton.addActionListener(e -> this.tableAction.addPressed(e));
            }
            if (this.dataModel.getPropertyColumnCount() > 0) {
                JCheckBox propertyVisible = new JCheckBox(Bundle.getMessage("ShowSystemSpecificProperties"));
                propertyVisible.setToolTipText(Bundle.getMessage("ShowSystemSpecificPropertiesToolTip"));
                this.addToBottomBox(propertyVisible);
                propertyVisible.addActionListener(e -> this.dataModel.setPropertyColumnsVisible(this.dataTable, propertyVisible.isSelected()));
                this.dataModel.setPropertyColumnsVisible(this.dataTable, false);
            }
            this.dataModel.persistTable(this.dataTable);
        }

        void addPanelModel() {
            try {
                this.dataPanel.add((Component)this.tableAction.getPanel(), "Center");
                this.dataPanel.add((Component)this.bottomBox, "South");
            }
            catch (NullPointerException e) {
                log.error("An error occurred while trying to create the table for {}", (Object)this.itemText, (Object)e);
            }
        }

        boolean getStandardTableModel() {
            return this.standardModel;
        }

        String getClassAsString() {
            return this.className;
        }

        String getItemString() {
            return this.itemText;
        }

        AbstractTableAction<E> getAAClass() {
            return this.tableAction;
        }

        JPanel getPanel() {
            return this.dataPanel;
        }

        JTable getDataTable() {
            return this.dataTable;
        }

        protected void addToBottomBox(Component comp) {
            this.bottomBox.add(Box.createHorizontalStrut(20), this.bottomBoxIndex);
            ++this.bottomBoxIndex;
            this.bottomBox.add(comp, this.bottomBoxIndex);
            ++this.bottomBoxIndex;
        }

        void dispose() {
            if (this.dataModel != null) {
                this.dataModel.stopPersistingTable(this.dataTable);
                this.dataModel.dispose();
            }
            if (this.tableAction != null) {
                this.tableAction.dispose();
            }
            this.dataModel = null;
            this.dataTable = null;
            this.dataScroll = null;
        }
    }

    static class TabbedTableItemListArray {
        String className;
        String itemText;
        boolean standardModel;

        TabbedTableItemListArray(String aaClass, String choice, boolean stdModel) {
            this.className = aaClass;
            this.itemText = choice;
            this.standardModel = stdModel;
        }

        boolean getStandardTableModel() {
            return this.standardModel;
        }

        String getClassAsString() {
            return this.className;
        }

        String getItemString() {
            return this.itemText;
        }
    }
}

