/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.ListedTableFrame;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListedTableAction
extends AbstractAction {
    String gotoListItem = null;
    String title = Bundle.getMessage("TitleListedTable");
    ListedTableFrame f;
    int dividerLocation = 0;
    private static final Logger log = LoggerFactory.getLogger(ListedTableAction.class);

    public ListedTableAction(String s, String selection) {
        super(s);
        this.title = s;
        this.gotoListItem = selection;
    }

    public ListedTableAction(String s, String selection, int divider) {
        super(s);
        this.title = s;
        this.gotoListItem = selection;
        this.dividerLocation = divider;
    }

    public ListedTableAction(String s, int divider) {
        super(s);
        this.title = s;
        this.dividerLocation = divider;
    }

    public ListedTableAction(String s) {
        super(s);
        this.title = s;
    }

    public ListedTableAction() {
        this(Bundle.getMessage("TitleListedTable"));
    }

    public void actionPerformed() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ListedTableAction.this.f = new ListedTableFrame(ListedTableAction.this.title);
                ListedTableAction.this.f.initTables();
                ListedTableAction.this.f.initComponents();
                ListedTableAction.this.addToFrame(ListedTableAction.this.f);
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        ListedTableAction.this.f.gotoListItem(ListedTableAction.this.gotoListItem);
                        ListedTableAction.this.f.pack();
                        ListedTableAction.this.f.setDividerLocation(ListedTableAction.this.dividerLocation);
                        ListedTableAction.this.f.setVisible(true);
                    });
                }
                catch (InvocationTargetException ex) {
                    log.error("failed to set ListedTable visible", (Throwable)ex);
                }
                catch (InterruptedException ex) {
                    log.error("interrupted while setting ListedTable visible", (Throwable)ex);
                }
            }
        };
        Thread thr = ThreadingUtil.newThread(r, "Listed Table Generation");
        thr.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed();
    }

    public void addToFrame(ListedTableFrame f) {
    }

    String helpTarget() {
        return "package.jmri.jmrit.beantable.ListedTableAction";
    }
}

