/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.Manager;
import jmri.SensorManager;
import jmri.SignalHeadManager;
import jmri.TurnoutManager;
import jmri.UserPreferencesManager;
import jmri.implementation.DefaultConditionalAction;
import jmri.jmrit.XmlFile;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.AlphanumComparator;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.NoArchiveFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRouteTableAction
extends AbstractTableAction<Logix> {
    static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.beantable.LRouteTableBundle");
    ConditionalManager _conditionalManager = null;
    LogixManager _logixManager = null;
    JTextField _systemName = new JTextField(15);
    JTextField _userName = new JTextField(25);
    JmriJFrame _addFrame = null;
    JTabbedPane _tabbedPane = null;
    RouteInputModel _inputModel;
    JScrollPane _inputScrollPane;
    JComboBox<String> _testStateCombo;
    JRadioButton _inputAllButton;
    boolean _showAllInput;
    RouteOutputModel _outputModel;
    JScrollPane _outputScrollPane;
    JComboBox<String> _setStateCombo;
    JRadioButton _outputAllButton;
    boolean _showAllOutput;
    AlignmentModel _alignModel;
    JComboBox<String> _alignCombo;
    JRadioButton _alignAllButton;
    boolean _showAllAlign;
    JCheckBox _lockCheckBox;
    boolean _lock = false;
    JPanel _typePanel;
    JRadioButton _newRouteButton;
    boolean _newRouteType = true;
    JRadioButton _initializeButton;
    boolean _initialize = false;
    JTextField soundFile = new JTextField(30);
    JTextField scriptFile = new JTextField(30);
    JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    JButton createButton = new JButton(Bundle.getMessage("ButtonCreate"));
    JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
    boolean routeDirty = false;
    ArrayList<RouteInputElement> _inputList;
    private HashMap<String, RouteInputElement> _inputMap;
    private HashMap<String, RouteInputElement> _inputUserMap;
    private ArrayList<RouteInputElement> _includedInputList;
    ArrayList<RouteOutputElement> _outputList;
    private HashMap<String, RouteOutputElement> _outputMap;
    private HashMap<String, RouteOutputElement> _outputUserMap;
    private ArrayList<RouteOutputElement> _includedOutputList;
    ArrayList<AlignElement> _alignList;
    private HashMap<String, AlignElement> _alignMap;
    private HashMap<String, AlignElement> _alignUserMap;
    private ArrayList<AlignElement> _includedAlignList;
    JFileChooser soundChooser = null;
    JFileChooser scriptChooser = null;
    public static final String CONDITIONAL_USER_PREFIX = "Route ";
    public static final int SENSOR_TYPE = 1;
    public static final int TURNOUT_TYPE = 2;
    public static final int LIGHT_TYPE = 3;
    public static final int SIGNAL_TYPE = 4;
    public static final int CONDITIONAL_TYPE = 5;
    public static final int ALL_TYPE = 6;
    public static final int VETO = 128;
    public static final int OFFSET = 48;
    public static final int SET_SIGNAL_HELD = 52;
    public static final int CLEAR_SIGNAL_HELD = 53;
    public static final int SET_SIGNAL_DARK = 54;
    public static final int SET_SIGNAL_LIT = 55;
    private static final String ALIGN_SENSOR = rbx.getString("AlignSensor");
    private static final String ALIGN_TURNOUT = rbx.getString("AlignTurnout");
    private static final String ALIGN_LIGHT = rbx.getString("AlignLight");
    private static final String ALIGN_SIGNAL = rbx.getString("AlignSignal");
    private static final String ALIGN_ALL = rbx.getString("AlignAll");
    private static final String ON_CHANGE = Bundle.getMessage("OnConditionChange");
    private static final String ON_ACTIVE = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SensorStateActive");
    private static final String ON_INACTIVE = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SensorStateInactive");
    private static final String VETO_ON_ACTIVE = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SensorStateActive");
    private static final String VETO_ON_INACTIVE = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SensorStateInactive");
    private static final String ON_THROWN = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("TurnoutStateThrown");
    private static final String ON_CLOSED = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("TurnoutStateClosed");
    private static final String VETO_ON_THROWN = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("TurnoutStateThrown");
    private static final String VETO_ON_CLOSED = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("TurnoutStateClosed");
    private static final String ON_LIT = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("ColumnHeadLit");
    private static final String ON_UNLIT = rbx.getString("OnUnLit");
    private static final String VETO_ON_LIT = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("ColumnHeadLit");
    private static final String VETO_ON_UNLIT = rbx.getString("VetoUnLit");
    private static final String ON_RED = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SignalHeadStateRed");
    private static final String ON_FLASHRED = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SignalHeadStateFlashingRed");
    private static final String ON_YELLOW = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SignalHeadStateYellow");
    private static final String ON_FLASHYELLOW = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SignalHeadStateFlashingYellow");
    private static final String ON_GREEN = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SignalHeadStateGreen");
    private static final String ON_FLASHGREEN = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SignalHeadStateFlashingGreen");
    private static final String ON_DARK = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SignalHeadStateDark");
    private static final String ON_SIGNAL_LIT = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("ColumnHeadLit");
    private static final String ON_SIGNAL_HELD = String.valueOf(Bundle.getMessage("OnCondition")) + " " + Bundle.getMessage("SignalHeadStateHeld");
    private static final String VETO_ON_RED = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SignalHeadStateRed");
    private static final String VETO_ON_FLASHRED = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SignalHeadStateFlashingRed");
    private static final String VETO_ON_YELLOW = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SignalHeadStateYellow");
    private static final String VETO_ON_FLASHYELLOW = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SignalHeadStateFlashingYellow");
    private static final String VETO_ON_GREEN = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SignalHeadStateGreen");
    private static final String VETO_ON_FLASHGREEN = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SignalHeadStateFlashingGreen");
    private static final String VETO_ON_DARK = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SignalHeadStateDark");
    private static final String VETO_ON_SIGNAL_LIT = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("ColumnHeadLit");
    private static final String VETO_ON_SIGNAL_HELD = "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SignalHeadStateHeld");
    private static final String SET_TO_ACTIVE = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSensor"), Bundle.getMessage("SensorStateActive"));
    private static final String SET_TO_INACTIVE = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSensor"), Bundle.getMessage("SensorStateInactive"));
    private static final String SET_TO_CLOSED = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameTurnout"), Bundle.getMessage("TurnoutStateClosed"));
    private static final String SET_TO_THROWN = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameTurnout"), Bundle.getMessage("TurnoutStateThrown"));
    private static final String SET_TO_TOGGLE = Bundle.getMessage("SetBeanState", "", Bundle.getMessage("Toggle"));
    private static final String SET_TO_ON = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameLight"), Bundle.getMessage("StateOn"));
    private static final String SET_TO_OFF = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameLight"), Bundle.getMessage("StateOff"));
    private static final String SET_TO_DARK = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("SignalHeadStateDark"));
    private static final String SET_TO_LIT = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("ColumnHeadLit"));
    private static final String SET_TO_HELD = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("SignalHeadStateHeld"));
    private static final String SET_TO_CLEAR = rbx.getString("SetClear");
    private static final String SET_TO_RED = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("SignalHeadStateRed"));
    private static final String SET_TO_FLASHRED = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("SignalHeadStateFlashingRed"));
    private static final String SET_TO_YELLOW = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("SignalHeadStateYellow"));
    private static final String SET_TO_FLASHYELLOW = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("SignalHeadStateFlashingYellow"));
    private static final String SET_TO_GREEN = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("SignalHeadStateGreen"));
    private static final String SET_TO_FLASHGREEN = Bundle.getMessage("SetBeanState", Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("SignalHeadStateFlashingGreen"));
    private static String[] ALIGNMENT_STATES = new String[]{ALIGN_SENSOR, ALIGN_TURNOUT, ALIGN_LIGHT, ALIGN_SIGNAL, ALIGN_ALL};
    private static String[] INPUT_SENSOR_STATES = new String[]{ON_ACTIVE, ON_INACTIVE, ON_CHANGE, VETO_ON_ACTIVE, VETO_ON_INACTIVE};
    private static String[] INPUT_TURNOUT_STATES = new String[]{ON_THROWN, ON_CLOSED, ON_CHANGE, VETO_ON_THROWN, VETO_ON_CLOSED};
    private static String[] INPUT_LIGHT_STATES = new String[]{ON_LIT, ON_UNLIT, ON_CHANGE, VETO_ON_LIT, VETO_ON_UNLIT};
    private static String[] INPUT_SIGNAL_STATES = new String[]{ON_RED, ON_FLASHRED, ON_YELLOW, ON_FLASHYELLOW, ON_GREEN, ON_FLASHGREEN, ON_DARK, ON_SIGNAL_LIT, ON_SIGNAL_HELD, VETO_ON_RED, VETO_ON_FLASHRED, VETO_ON_YELLOW, VETO_ON_FLASHYELLOW, VETO_ON_GREEN, VETO_ON_FLASHGREEN, VETO_ON_DARK, VETO_ON_SIGNAL_LIT, VETO_ON_SIGNAL_HELD};
    private static String[] OUTPUT_SENSOR_STATES = new String[]{SET_TO_ACTIVE, SET_TO_INACTIVE, SET_TO_TOGGLE};
    private static String[] OUTPUT_TURNOUT_STATES = new String[]{SET_TO_CLOSED, SET_TO_THROWN, SET_TO_TOGGLE};
    private static String[] OUTPUT_LIGHT_STATES = new String[]{SET_TO_ON, SET_TO_OFF, SET_TO_TOGGLE};
    private static String[] OUTPUT_SIGNAL_STATES = new String[]{SET_TO_DARK, SET_TO_LIT, SET_TO_HELD, SET_TO_CLEAR, SET_TO_RED, SET_TO_FLASHRED, SET_TO_YELLOW, SET_TO_FLASHYELLOW, SET_TO_GREEN, SET_TO_FLASHGREEN};
    private static final Logger log = LoggerFactory.getLogger(LRouteTableAction.class);

    public LRouteTableAction(String s) {
        super(s);
        this._logixManager = InstanceManager.getNullableDefault(LogixManager.class);
        this._conditionalManager = InstanceManager.getNullableDefault(ConditionalManager.class);
        if (this._logixManager == null || this._conditionalManager == null) {
            this.setEnabled(false);
        }
        this.createModel();
    }

    public LRouteTableAction() {
        this(Bundle.getMessage("TitleLRouteTable"));
    }

    @Override
    protected void createModel() {
        this.m = new LBeanTableDataModel();
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleLRouteTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.LRouteTable";
    }

    void buildLists() {
        TreeSet<RouteElement> inputTS = new TreeSet<RouteElement>(new RouteElementComparator());
        TreeSet<RouteElement> outputTS = new TreeSet<RouteElement>(new RouteElementComparator());
        TurnoutManager tm = InstanceManager.turnoutManagerInstance();
        tm.getNamedBeanSet().forEach(nb -> {
            String userName = nb.getUserName();
            String systemName = nb.getSystemName();
            inputTS.add(new RouteInputTurnout(systemName, userName));
            outputTS.add(new RouteOutputTurnout(systemName, userName));
        });
        TreeSet<RouteElement> alignTS = new TreeSet<RouteElement>(new RouteElementComparator());
        SensorManager sm = InstanceManager.sensorManagerInstance();
        sm.getNamedBeanSet().forEach(nb -> {
            String userName = nb.getUserName();
            String systemName = nb.getSystemName();
            inputTS.add(new RouteInputSensor(systemName, userName));
            outputTS.add(new RouteOutputSensor(systemName, userName));
            alignTS.add(new AlignElement(systemName, userName));
        });
        LightManager lm = InstanceManager.lightManagerInstance();
        lm.getNamedBeanSet().forEach(nb -> {
            String userName = nb.getUserName();
            String systemName = nb.getSystemName();
            inputTS.add(new RouteInputLight(systemName, userName));
            outputTS.add(new RouteOutputLight(systemName, userName));
        });
        SignalHeadManager shm = InstanceManager.getDefault(SignalHeadManager.class);
        shm.getNamedBeanSet().forEach(nb -> {
            String userName = nb.getUserName();
            String systemName = nb.getSystemName();
            inputTS.add(new RouteInputSignal(systemName, userName));
            outputTS.add(new RouteOutputSignal(systemName, userName));
        });
        this._includedInputList = new ArrayList();
        this._includedOutputList = new ArrayList();
        this._inputList = new ArrayList(inputTS.size());
        this._outputList = new ArrayList(outputTS.size());
        this._inputMap = new HashMap(inputTS.size());
        this._outputMap = new HashMap(outputTS.size());
        this._inputUserMap = new HashMap();
        this._outputUserMap = new HashMap();
        for (RouteInputElement routeInputElement : inputTS) {
            this._inputList.add(routeInputElement);
            String string = String.valueOf(routeInputElement.getType()) + routeInputElement.getSysName();
            this._inputMap.put(string, routeInputElement);
            String string2 = routeInputElement.getUserName();
            if (string2 == null) continue;
            String string3 = String.valueOf(routeInputElement.getType()) + string2;
            this._inputUserMap.put(string3, routeInputElement);
        }
        for (RouteOutputElement routeOutputElement : outputTS) {
            this._outputList.add(routeOutputElement);
            String string = String.valueOf(routeOutputElement.getType()) + routeOutputElement.getSysName();
            this._outputMap.put(string, routeOutputElement);
            String user = routeOutputElement.getUserName();
            if (user == null) continue;
            String string4 = String.valueOf(routeOutputElement.getType()) + user;
            this._outputUserMap.put(string4, routeOutputElement);
        }
        this._includedAlignList = new ArrayList();
        this._alignList = new ArrayList(alignTS.size());
        this._alignMap = new HashMap(alignTS.size());
        this._alignUserMap = new HashMap();
        for (AlignElement alignElement : alignTS) {
            this._alignList.add(alignElement);
            String key = String.valueOf(alignElement.getType()) + alignElement.getSysName();
            this._alignMap.put(key, alignElement);
            String user = alignElement.getUserName();
            if (user == null) continue;
            key = String.valueOf(alignElement.getType()) + user;
            this._alignUserMap.put(key, alignElement);
        }
    }

    void editPressed(String sName) {
        Logix logix = this._logixManager.getBySystemName(sName);
        if (logix == null) {
            log.error("Logix \"{}\" not Found.", (Object)sName);
            return;
        }
        this._systemName.setText(sName);
        Runnable t = () -> {
            this.setupEdit(null);
            this._addFrame.setVisible(true);
        };
        SwingUtilities.invokeLater(t);
    }

    void setupEdit(ActionEvent e) {
        this.makeEditWindow();
        Logix logix = this.checkNamesOK();
        if (logix == null) {
            return;
        }
        logix.deActivateLogix();
        this._systemName.setEnabled(false);
        this._userName.setEnabled(false);
        this._systemName.setText(logix.getSystemName());
        this._userName.setText(logix.getUserName());
        String logixSysName = logix.getSystemName();
        int numConditionals = logix.getNumConditionals();
        log.debug("setupEdit: logixSysName= {}, numConditionals= {}", (Object)logixSysName, (Object)numConditionals);
        int i = 0;
        while (i < numConditionals) {
            String cSysName = logix.getConditionalByNumberOrder(i);
            switch (this.getRouteConditionalType(logixSysName, cSysName)) {
                case 'T': {
                    this.getControlsAndActions(cSysName);
                    break;
                }
                case 'A': {
                    this.getAlignmentSensors(cSysName);
                    break;
                }
                case 'L': {
                    this.getLockConditions(cSysName);
                    break;
                }
                default: {
                    log.warn("Unexpected getRouteConditionalType {}", (Object)Character.valueOf(this.getRouteConditionalType(logixSysName, cSysName)));
                }
            }
            ++i;
        }
        this.deleteButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.updateButton.setVisible(true);
        this._typePanel.setVisible(false);
        this._initialize = LRouteTableAction.getLogixInitializer().equals(logixSysName);
        if (this._initialize) {
            this._initializeButton.doClick();
        } else {
            this._newRouteButton.doClick();
        }
        this.createButton.setVisible(false);
        this._addFrame.setTitle(rbx.getString("LRouteEditTitle"));
    }

    char getRouteConditionalType(String logixSysName, String cSysName) {
        if (cSysName.startsWith(logixSysName)) {
            char[] chNum = cSysName.substring(logixSysName.length()).toCharArray();
            int i = 0;
            while (Character.isDigit(chNum[i])) {
                ++i;
            }
            return chNum[i];
        }
        return '\u0000';
    }

    void getControlsAndActions(String cSysName) {
        block33: {
            Conditional c = this._conditionalManager.getBySystemName(cSysName);
            if (c == null) break block33;
            List<ConditionalAction> actionList = c.getCopyOfActions();
            boolean onChange = false;
            int k = 0;
            while (k < actionList.size()) {
                block34: {
                    int type;
                    ConditionalAction action = actionList.get(k);
                    switch (action.getType()) {
                        case SET_SENSOR: {
                            type = 1;
                            break;
                        }
                        case SET_TURNOUT: {
                            type = 2;
                            break;
                        }
                        case SET_LIGHT: {
                            type = 3;
                            break;
                        }
                        case SET_SIGNAL_APPEARANCE: 
                        case SET_SIGNAL_HELD: 
                        case CLEAR_SIGNAL_HELD: 
                        case SET_SIGNAL_DARK: 
                        case SET_SIGNAL_LIT: {
                            type = 4;
                            break;
                        }
                        case RUN_SCRIPT: {
                            this.scriptFile.setText(action.getActionString());
                            break block34;
                        }
                        case PLAY_SOUND: {
                            this.soundFile.setText(action.getActionString());
                            break block34;
                        }
                        default: {
                            JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("TypeWarn"), action.toString(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                            break block34;
                        }
                    }
                    String name = action.getDeviceName();
                    String key = String.valueOf(type) + name;
                    RouteOutputElement elt = this._outputUserMap.get(key);
                    if (elt == null) {
                        elt = this._outputMap.get(key);
                    }
                    if (elt == null) {
                        JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("TypeWarn"), action.toString(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                    } else {
                        boolean change;
                        elt.setIncluded(true);
                        elt.setState(action.getActionData());
                        boolean bl = change = action.getOption() == 3;
                        if (k == 0) {
                            onChange = change;
                        } else if (change != onChange) {
                            JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("OnChangeWarn"), action.toString(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                        }
                    }
                }
                ++k;
            }
            List<ConditionalVariable> varList = c.getCopyOfStateVariables();
            int k2 = 0;
            while (k2 < varList.size()) {
                block35: {
                    int type;
                    ConditionalVariable variable = varList.get(k2);
                    Conditional.Type testState = variable.getType();
                    switch (testState) {
                        case SENSOR_ACTIVE: {
                            type = 1;
                            break;
                        }
                        case SENSOR_INACTIVE: {
                            type = 1;
                            break;
                        }
                        case TURNOUT_CLOSED: {
                            type = 2;
                            break;
                        }
                        case TURNOUT_THROWN: {
                            type = 2;
                            break;
                        }
                        case LIGHT_ON: {
                            type = 3;
                            break;
                        }
                        case LIGHT_OFF: {
                            type = 3;
                            break;
                        }
                        case SIGNAL_HEAD_RED: 
                        case SIGNAL_HEAD_YELLOW: 
                        case SIGNAL_HEAD_GREEN: 
                        case SIGNAL_HEAD_DARK: 
                        case SIGNAL_HEAD_FLASHRED: 
                        case SIGNAL_HEAD_FLASHYELLOW: 
                        case SIGNAL_HEAD_FLASHGREEN: 
                        case SIGNAL_HEAD_LIT: 
                        case SIGNAL_HEAD_HELD: {
                            type = 4;
                            break;
                        }
                        default: {
                            if (!LRouteTableAction.getLogixInitializer().equals(variable.getName())) {
                                JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("TypeWarnVar"), variable.toString(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                            }
                            break block35;
                        }
                    }
                    int testStateInt = testState.getIntValue();
                    Conditional.Operator opern = variable.getOpern();
                    if (k2 != 0 && opern == Conditional.Operator.AND) {
                        testStateInt += 128;
                    } else if (onChange) {
                        testStateInt = 32;
                    }
                    String name = variable.getName();
                    String key = String.valueOf(type) + name;
                    RouteInputElement elt = this._inputUserMap.get(key);
                    if (elt == null) {
                        elt = this._inputMap.get(key);
                    }
                    if (elt == null) {
                        if (!LRouteTableAction.getLogixInitializer().equals(name)) {
                            JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("TypeWarnVar"), variable.toString(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                        }
                    } else {
                        elt.setIncluded(true);
                        elt.setState(testStateInt);
                    }
                }
                ++k2;
            }
        }
    }

    void getAlignmentSensors(String cSysName) {
        block19: {
            Conditional c = this._conditionalManager.getBySystemName(cSysName);
            if (c == null) break block19;
            RouteElement element = null;
            List<ConditionalAction> actionList = c.getCopyOfActions();
            int k = 0;
            while (k < actionList.size()) {
                ConditionalAction action = actionList.get(k);
                if (action.getType() != Conditional.Action.SET_SENSOR) {
                    JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("AlignWarn1"), action.toString(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                } else {
                    String name = action.getDeviceName();
                    String key = String.valueOf(1) + name;
                    element = this._alignUserMap.get(key);
                    if (element == null) {
                        element = this._alignMap.get(key);
                    }
                    if (element == null) {
                        JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("TypeWarn"), action.toString(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                    } else if (!name.equals(action.getDeviceName())) {
                        JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("AlignWarn2"), action.toString(), action.getDeviceName(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                    } else {
                        element.setIncluded(true);
                    }
                }
                ++k;
            }
            List<ConditionalVariable> varList = c.getCopyOfStateVariables();
            int atype = 0;
            int k2 = 0;
            while (k2 < varList.size()) {
                block20: {
                    int type;
                    ConditionalVariable variable = varList.get(k2);
                    Conditional.Type testState = variable.getType();
                    switch (testState) {
                        case SENSOR_ACTIVE: 
                        case SENSOR_INACTIVE: {
                            type = 1;
                            break;
                        }
                        case TURNOUT_THROWN: 
                        case TURNOUT_CLOSED: {
                            type = 2;
                            break;
                        }
                        case LIGHT_ON: 
                        case LIGHT_OFF: {
                            type = 3;
                            break;
                        }
                        case SIGNAL_HEAD_RED: 
                        case SIGNAL_HEAD_YELLOW: 
                        case SIGNAL_HEAD_GREEN: 
                        case SIGNAL_HEAD_DARK: 
                        case SIGNAL_HEAD_FLASHRED: 
                        case SIGNAL_HEAD_FLASHYELLOW: 
                        case SIGNAL_HEAD_FLASHGREEN: 
                        case SIGNAL_HEAD_LIT: 
                        case SIGNAL_HEAD_HELD: {
                            type = 4;
                            break;
                        }
                        default: {
                            if (LRouteTableAction.getLogixInitializer().equals(variable.getName())) break block20;
                            JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("TypeWarnVar"), variable.toString(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                            break block20;
                        }
                    }
                    if (k2 == 0) {
                        atype = type;
                    } else if (atype != type) {
                        atype = 6;
                        break;
                    }
                }
                ++k2;
            }
            if (element != null) {
                element.setState(atype);
            }
        }
    }

    void getLockConditions(String cSysName) {
        Conditional c = this._conditionalManager.getBySystemName(cSysName);
        if (c != null) {
            this._lock = true;
            ArrayList<RouteOutputElement> tList = this.makeTurnoutLockList();
            List<ConditionalAction> actionList = c.getCopyOfActions();
            if (actionList.size() != tList.size()) {
                JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("LockWarn1"), Integer.toString(tList.size()), c.getSystemName(), Integer.toString(actionList.size())), rbx.getString("EditDiff"), 2);
            }
            int k = 0;
            while (k < actionList.size()) {
                ConditionalAction action = actionList.get(k);
                if (action.getType() != Conditional.Action.LOCK_TURNOUT) {
                    JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("LockWarn2"), action.getDeviceName(), c.getSystemName()), rbx.getString("EditDiff"), 2);
                } else {
                    String name = action.getDeviceName();
                    boolean found = false;
                    ArrayList<RouteOutputElement> lockList = this.makeTurnoutLockList();
                    int j = 0;
                    while (j < lockList.size()) {
                        RouteOutputElement elt = lockList.get(j);
                        if (name.equals(elt.getUserName()) || name.equals(elt.getSysName())) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("LockWarn3"), name, c.getSystemName()), rbx.getString("EditDiff"), 2);
                    }
                }
                ++k;
            }
        }
    }

    void cancelPressed(ActionEvent e) {
        Logix logix;
        if (this._addFrame.getTitle().equals(rbx.getString("LRouteEditTitle")) && (logix = this.checkNamesOK()) != null) {
            logix.activateLogix();
        }
        this.clearPage();
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.makeEditWindow();
        this._tabbedPane.setSelectedIndex(0);
        this.createButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this._typePanel.setVisible(true);
        this._addFrame.setVisible(true);
        this._systemName.setEnabled(true);
        this._userName.setEnabled(true);
        this._addFrame.setTitle(rbx.getString("LRouteAddTitle"));
        this._addFrame.setEscapeKeyClosesWindow(true);
        this._addFrame.getRootPane().setDefaultButton(this.createButton);
    }

    void makeEditWindow() {
        this.buildLists();
        if (this._addFrame == null) {
            this._addFrame = new JmriJFrame(rbx.getString("LRouteAddTitle"), false, false);
            this._addFrame.addHelpMenu("package.jmri.jmrit.beantable.LRouteAddEdit", true);
            this._addFrame.setLocation(100, 30);
            this._tabbedPane = new JTabbedPane();
            JPanel tab1 = new JPanel();
            tab1.setLayout(new BoxLayout(tab1, 1));
            tab1.add(Box.createVerticalStrut(10));
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(new JLabel(Bundle.getMessage("LabelSystemName")));
            p.add(this._systemName);
            this._systemName.setToolTipText(rbx.getString("SystemNameHint"));
            tab1.add(p);
            p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(new JLabel(Bundle.getMessage("LabelUserName")));
            p.add(this._userName);
            this._userName.setToolTipText(rbx.getString("UserNameHint"));
            tab1.add(p);
            JPanel pa = new JPanel();
            p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(new JLabel(rbx.getString("Guide1")));
            p.add(new JLabel(rbx.getString("Guide2")));
            p.add(new JLabel(rbx.getString("Guide3")));
            p.add(new JLabel(rbx.getString("Guide4")));
            pa.add(p);
            tab1.add(pa);
            this._newRouteButton = new JRadioButton(rbx.getString("NewRoute"), true);
            JRadioButton oldRoute = new JRadioButton(rbx.getString("OldRoute"), false);
            this._initializeButton = new JRadioButton(rbx.getString("Initialize"), false);
            this._newRouteButton.setToolTipText(rbx.getString("NewRouteHint"));
            this._newRouteButton.addActionListener(e -> {
                this._newRouteType = true;
                this._systemName.setEnabled(true);
            });
            oldRoute.setToolTipText(rbx.getString("OldRouteHint"));
            oldRoute.addActionListener(e -> {
                this._newRouteType = false;
                this._systemName.setEnabled(true);
            });
            this._initializeButton.setToolTipText(rbx.getString("InitializeHint"));
            this._initializeButton.addActionListener(e -> {
                this._initialize = true;
                this._newRouteType = true;
                this._systemName.setEnabled(false);
                this._systemName.setText(LRouteTableAction.getLogixInitializer());
            });
            this._typePanel = this.makeShowButtons(this._newRouteButton, oldRoute, this._initializeButton, String.valueOf(rbx.getString("LRouteType")) + ":");
            this._typePanel.setBorder(BorderFactory.createEtchedBorder());
            tab1.add(this._typePanel);
            tab1.add(Box.createVerticalGlue());
            JPanel pb = new JPanel();
            pb.setLayout(new FlowLayout());
            pb.add(this.cancelButton);
            this.cancelButton.addActionListener(this::cancelPressed);
            this.cancelButton.setToolTipText(Bundle.getMessage("TooltipCancelRoute"));
            this.cancelButton.setName("CancelButton");
            pb.add(this.createButton);
            this.createButton.addActionListener(this::createPressed);
            this.createButton.setToolTipText(rbx.getString("CreateHint"));
            this.createButton.setName("CreateButton");
            pb.add(this.deleteButton);
            this.deleteButton.addActionListener(this::deletePressed);
            this.deleteButton.setToolTipText(rbx.getString("DeleteHint"));
            pb.add(this.updateButton);
            this.updateButton.addActionListener(e -> this.updatePressed());
            this.updateButton.setToolTipText(rbx.getString("UpdateHint"));
            this.updateButton.setName("UpdateButton");
            this.cancelButton.setVisible(true);
            this.updateButton.setVisible(false);
            this.createButton.setVisible(false);
            this.deleteButton.setVisible(false);
            tab1.add(pb);
            tab1.setVisible(true);
            this._tabbedPane.addTab(rbx.getString("BasicTab"), null, tab1, rbx.getString("BasicTabHint"));
            JPanel tab2 = new JPanel();
            tab2.setLayout(new BoxLayout(tab2, 1));
            tab2.add(new JLabel(String.valueOf(rbx.getString("OutputTitle")) + ":"));
            this._outputAllButton = new JRadioButton(Bundle.getMessage("All"), true);
            JRadioButton includedOutputButton = new JRadioButton(Bundle.getMessage("Included"), false);
            tab2.add(this.makeShowButtons(this._outputAllButton, includedOutputButton, null, String.valueOf(Bundle.getMessage("Show")) + ":"));
            this._outputAllButton.addActionListener(e -> {
                if (!this._showAllOutput) {
                    this._showAllOutput = true;
                    this._outputModel.fireTableDataChanged();
                }
            });
            includedOutputButton.addActionListener(e -> {
                if (this._showAllOutput) {
                    this._showAllOutput = false;
                    this.initializeIncludedOutputList();
                    this._outputModel.fireTableDataChanged();
                }
            });
            tab2.add(new JLabel(rbx.getString("PickOutput")));
            this._outputModel = new RouteOutputModel();
            JTable routeOutputTable = new JTable(this._outputModel);
            this._outputScrollPane = this.makeColumns(routeOutputTable, this._setStateCombo, true);
            tab2.add((Component)this._outputScrollPane, "Center");
            tab2.setVisible(true);
            this._tabbedPane.addTab(rbx.getString("ActionTab"), null, tab2, rbx.getString("ActionTabHint"));
            JPanel tab3 = new JPanel();
            tab3.setLayout(new BoxLayout(tab3, 1));
            tab3.add(new JLabel(String.valueOf(rbx.getString("InputTitle")) + ":"));
            this._inputAllButton = new JRadioButton(Bundle.getMessage("All"), true);
            JRadioButton includedInputButton = new JRadioButton(Bundle.getMessage("Included"), false);
            tab3.add(this.makeShowButtons(this._inputAllButton, includedInputButton, null, String.valueOf(Bundle.getMessage("Show")) + ":"));
            this._inputAllButton.addActionListener(e -> {
                if (!this._showAllInput) {
                    this._showAllInput = true;
                    this._inputModel.fireTableDataChanged();
                }
            });
            includedInputButton.addActionListener(e -> {
                if (this._showAllInput) {
                    this._showAllInput = false;
                    this.initializeIncludedInputList();
                    this._inputModel.fireTableDataChanged();
                }
            });
            tab3.add(new JLabel(rbx.getString("PickInput")));
            this._inputModel = new RouteInputModel();
            JTable routeInputTable = new JTable(this._inputModel);
            this._inputScrollPane = this.makeColumns(routeInputTable, this._testStateCombo, true);
            tab3.add((Component)this._inputScrollPane, "Center");
            tab3.setVisible(true);
            this._tabbedPane.addTab(rbx.getString("TriggerTab"), null, tab3, rbx.getString("TriggerTabHint"));
            JPanel tab4 = new JPanel();
            tab4.setLayout(new BoxLayout(tab4, 1));
            tab4.add(new JLabel(String.valueOf(rbx.getString("MiscTitle")) + ":"));
            JPanel p25 = new JPanel();
            p25.setLayout(new FlowLayout());
            p25.add(new JLabel(Bundle.getMessage("LabelPlaySound")));
            JButton ss = new JButton("...");
            ss.addActionListener(e -> this.setSoundPressed());
            p25.add(ss);
            p25.add(this.soundFile);
            tab4.add(p25);
            p25 = new JPanel();
            p25.setLayout(new FlowLayout());
            p25.add(new JLabel(Bundle.getMessage("LabelRunScript")));
            ss = new JButton("...");
            ss.addActionListener(e -> this.setScriptPressed());
            p25.add(ss);
            p25.add(this.scriptFile);
            tab4.add(p25);
            p25 = new JPanel();
            p25.setLayout(new FlowLayout());
            p25.add(new JLabel(String.valueOf(rbx.getString("SetLocks")) + ":"));
            this._lockCheckBox = new JCheckBox(rbx.getString("Lock"), true);
            this._lockCheckBox.addActionListener(e -> {
                this._lock = this._lockCheckBox.isSelected();
            });
            p25.add(this._lockCheckBox);
            tab4.add(p25);
            this._alignAllButton = new JRadioButton(Bundle.getMessage("All"), true);
            JRadioButton includedAlignButton = new JRadioButton(Bundle.getMessage("Included"), false);
            tab4.add(this.makeShowButtons(this._alignAllButton, includedAlignButton, null, String.valueOf(Bundle.getMessage("Show")) + ":"));
            this._alignAllButton.addActionListener(e -> {
                if (!this._showAllAlign) {
                    this._showAllAlign = true;
                    this._alignModel.fireTableDataChanged();
                }
            });
            includedAlignButton.addActionListener(e -> {
                if (this._showAllAlign) {
                    this._showAllAlign = false;
                    this.initializeIncludedAlignList();
                    this._alignModel.fireTableDataChanged();
                }
            });
            tab4.add(new JLabel(rbx.getString("PickAlign")));
            this._alignModel = new AlignmentModel();
            JTable alignTable = new JTable(this._alignModel);
            this._alignCombo = new JComboBox();
            String[] stringArray = ALIGNMENT_STATES;
            int n = ALIGNMENT_STATES.length;
            int n2 = 0;
            while (n2 < n) {
                String state = stringArray[n2];
                this._alignCombo.addItem(state);
                ++n2;
            }
            JScrollPane alignScrollPane = this.makeColumns(alignTable, this._alignCombo, false);
            this._alignCombo = new JComboBox();
            String[] stringArray2 = ALIGNMENT_STATES;
            int n3 = ALIGNMENT_STATES.length;
            n = 0;
            while (n < n3) {
                String state = stringArray2[n];
                this._alignCombo.addItem(state);
                ++n;
            }
            tab4.add((Component)alignScrollPane, "Center");
            tab4.setVisible(true);
            this._tabbedPane.addTab(rbx.getString("MiscTab"), null, tab4, rbx.getString("MiscTabHint"));
            Container contentPane = this._addFrame.getContentPane();
            JPanel pt = new JPanel();
            pt.add(this._tabbedPane);
            contentPane.add(pt);
            this._addFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (LRouteTableAction.this.routeDirty) {
                        LRouteTableAction.this.showReminderMessage();
                    }
                    LRouteTableAction.this.clearPage();
                    LRouteTableAction.this._addFrame.setVisible(false);
                    LRouteTableAction.this._inputModel.dispose();
                    LRouteTableAction.this._outputModel.dispose();
                    LRouteTableAction.this.routeDirty = false;
                }
            });
            this._addFrame.pack();
            this._inputAllButton.doClick();
            this._outputAllButton.doClick();
            this._alignAllButton.doClick();
            this._newRouteButton.doClick();
            if (this._initialize) {
                this._initializeButton.doClick();
            }
        } else {
            this._addFrame.setVisible(true);
        }
    }

    void showReminderMessage() {
        InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("BeanNameLRoute")), this.getClassName(), "remindSaveRoute");
    }

    JPanel makeShowButtons(JRadioButton allButton, JRadioButton includeButton, JRadioButton extraButton, String msg) {
        JPanel panel = new JPanel();
        panel.add(new JLabel(msg));
        panel.add(allButton);
        panel.add(includeButton);
        ButtonGroup selGroup = new ButtonGroup();
        selGroup.add(allButton);
        selGroup.add(includeButton);
        if (extraButton != null) {
            panel.add(extraButton);
            selGroup.add(extraButton);
        }
        return panel;
    }

    JScrollPane makeColumns(JTable table, JComboBox<String> box, boolean specialBox) {
        table.setRowSelectionAllowed(false);
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn sNameColumnT = columnModel.getColumn(0);
        sNameColumnT.setResizable(true);
        sNameColumnT.setMinWidth(75);
        TableColumn uNameColumnT = columnModel.getColumn(1);
        uNameColumnT.setResizable(true);
        uNameColumnT.setMinWidth(75);
        TableColumn typeColumnT = columnModel.getColumn(2);
        typeColumnT.setResizable(true);
        typeColumnT.setMinWidth(50);
        TableColumn includeColumnT = columnModel.getColumn(3);
        includeColumnT.setResizable(false);
        includeColumnT.setMinWidth(30);
        includeColumnT.setMaxWidth(60);
        TableColumn stateColumnT = columnModel.getColumn(4);
        if (specialBox) {
            box = new JComboBox();
            stateColumnT.setCellEditor(new ComboBoxCellEditor(box));
        } else {
            stateColumnT.setCellEditor(new DefaultCellEditor(box));
        }
        stateColumnT.setResizable(false);
        stateColumnT.setMinWidth(75);
        return new JScrollPane(table);
    }

    void initializeIncludedInputList() {
        this._includedInputList = new ArrayList();
        int i = 0;
        while (i < this._inputList.size()) {
            if (this._inputList.get(i).isIncluded()) {
                this._includedInputList.add(this._inputList.get(i));
            }
            ++i;
        }
    }

    void initializeIncludedOutputList() {
        this._includedOutputList = new ArrayList();
        int i = 0;
        while (i < this._outputList.size()) {
            if (this._outputList.get(i).isIncluded()) {
                this._includedOutputList.add(this._outputList.get(i));
            }
            ++i;
        }
    }

    void initializeIncludedAlignList() {
        this._includedAlignList = new ArrayList();
        int i = 0;
        while (i < this._alignList.size()) {
            if (this._alignList.get(i).isIncluded()) {
                this._includedAlignList.add(this._alignList.get(i));
            }
            ++i;
        }
    }

    ArrayList<RouteOutputElement> makeTurnoutLockList() {
        ArrayList<RouteOutputElement> list = new ArrayList<RouteOutputElement>();
        int i = 0;
        while (i < this._outputList.size()) {
            RouteOutputElement elt;
            if (this._outputList.get(i).isIncluded() && (elt = this._outputList.get(i)).getType() == 2 && elt.getState() != 8) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    void showMessage(String msg) {
        JOptionPane.showMessageDialog(this._addFrame, rbx.getString(msg), Bundle.getMessage("WarningTitle"), 2);
    }

    boolean checkNewNamesOK() {
        String sName = this._systemName.getText();
        if (sName.length() == 0 || sName.equals(LRouteTableAction.getLogixSystemPrefix())) {
            this.showMessage("EnterNames");
            return false;
        }
        if (!sName.startsWith(LRouteTableAction.getLogixSystemPrefix())) {
            sName = String.valueOf(LRouteTableAction.getLogixSystemPrefix()) + sName;
        }
        if (this._logixManager.getBySystemName(sName) != null) {
            this.showMessage("DuplicateSys");
            this.updateButton.setVisible(true);
            return false;
        }
        String uName = this._userName.getText();
        if (!uName.isEmpty()) {
            if (this._logixManager.getByUserName(uName) != null) {
                this.showMessage("DuplicateUser");
                this.updateButton.setVisible(true);
                return false;
            }
            return true;
        }
        this._systemName.setText(sName);
        return true;
    }

    Logix checkNamesOK() {
        String sName = this._systemName.getText();
        if (sName.length() == 0) {
            this.showMessage("EnterNames");
            return null;
        }
        Logix logix = this._logixManager.getBySystemName(sName);
        if (!sName.startsWith(LRouteTableAction.getLogixSystemPrefix())) {
            sName = String.valueOf(LRouteTableAction.getLogixSystemPrefix()) + sName;
        }
        if (logix != null) {
            return logix;
        }
        String uName = this._userName.getText();
        if (uName.length() != 0 && (logix = this._logixManager.getByUserName(uName)) != null) {
            return logix;
        }
        logix = this._logixManager.createNewLogix(sName, uName);
        if (logix == null) {
            log.error("Unknown failure to create Route with System Name: {}", (Object)sName);
        }
        return logix;
    }

    void setSoundPressed() {
        if (this.soundChooser == null) {
            this.soundChooser = new JFileChooser(FileUtil.getUserFilesPath());
            this.soundChooser.setFileFilter(new NoArchiveFileFilter());
        }
        this.soundChooser.rescanCurrentDirectory();
        int retVal = this.soundChooser.showOpenDialog(null);
        if (retVal == 0) {
            try {
                this.soundFile.setText(FileUtil.getPortableFilename(this.soundChooser.getSelectedFile().getCanonicalPath()));
            }
            catch (IOException e) {
                log.error("exception setting sound file: {}", (Throwable)e);
            }
        }
    }

    void setScriptPressed() {
        if (this.scriptChooser == null) {
            this.scriptChooser = XmlFile.userFileChooser("Python script files", "py");
        }
        this.scriptChooser.rescanCurrentDirectory();
        int retVal = this.scriptChooser.showOpenDialog(null);
        if (retVal == 0) {
            try {
                this.scriptFile.setText(FileUtil.getPortableFilename(this.scriptChooser.getSelectedFile().getCanonicalPath()));
            }
            catch (IOException e) {
                log.error("exception setting script file: {}", (Throwable)e);
            }
        }
    }

    void createPressed(ActionEvent e) {
        if (!this.checkNewNamesOK()) {
            return;
        }
        this.updatePressed();
    }

    void deletePressed(ActionEvent e) {
        Logix l = this.checkNamesOK();
        if (l != null) {
            l.deActivateLogix();
            this._logixManager.deleteLogix(l);
        }
        this.finishUpdate();
    }

    void updatePressed() {
        ArrayList<ConditionalVariable> vList;
        int i;
        Logix logix = this.checkNamesOK();
        if (logix == null) {
            log.error("No Logix found!");
            return;
        }
        String sName = logix.getSystemName();
        String uName = this._userName.getText();
        logix.setUserName(uName);
        this.initializeIncludedInputList();
        this.initializeIncludedOutputList();
        this.initializeIncludedAlignList();
        if (log.isDebugEnabled()) {
            log.debug("updatePressed: _includedInputList.size()= {}, _includedOutputList.size()= {}, _includedAlignList.size()= {}", new Object[]{this._includedInputList.size(), this._includedOutputList.size(), this._includedAlignList.size()});
        }
        ArrayList<ConditionalAction> actionList = new ArrayList<ConditionalAction>();
        int i2 = 0;
        while (i2 < this._includedOutputList.size()) {
            RouteOutputElement elt = this._includedOutputList.get(i2);
            String name = elt.getUserName();
            if (name == null || name.length() == 0) {
                name = elt.getSysName();
            }
            int state = elt.getState();
            Conditional.Action actionType = Conditional.Action.NONE;
            String params = "";
            switch (elt.getType()) {
                case 1: {
                    actionType = Conditional.Action.SET_SENSOR;
                    break;
                }
                case 2: {
                    actionType = Conditional.Action.SET_TURNOUT;
                    break;
                }
                case 3: {
                    actionType = Conditional.Action.SET_LIGHT;
                    break;
                }
                case 4: {
                    actionType = Conditional.Action.SET_SIGNAL_APPEARANCE;
                    if (state <= 48) break;
                    actionType = Conditional.Action.getOperatorFromIntValue(state & 0xFFFFFFCF);
                    break;
                }
                default: {
                    log.debug("updatePressed: Unknown action type {}", (Object)elt.getType());
                }
            }
            actionList.add(new DefaultConditionalAction(1, actionType, name, state, params));
            ++i2;
        }
        String file = this.scriptFile.getText();
        if (file.length() > 0) {
            actionList.add(new DefaultConditionalAction(1, Conditional.Action.RUN_SCRIPT, "", -1, file));
        }
        if ((file = this.soundFile.getText()).length() > 0) {
            actionList.add(new DefaultConditionalAction(1, Conditional.Action.PLAY_SOUND, "", -1, file));
        }
        ArrayList<ConditionalAction> onChangeList = this.cloneActionList(actionList, 3);
        ArrayList<ConditionalVariable> vetoList = new ArrayList<ConditionalVariable>();
        if (!this._initialize) {
            int i3 = 0;
            while (i3 < this._includedInputList.size()) {
                int state;
                RouteInputElement elt = this._includedInputList.get(i3);
                String name = elt.getUserName();
                if (name == null || name.length() == 0) {
                    name = elt.getSysName();
                }
                Conditional.Operator opern = Conditional.Operator.AND;
                if (i3 == 0) {
                    opern = Conditional.Operator.NONE;
                }
                if (128 < (state = elt.getState())) {
                    vetoList.add(new ConditionalVariable(true, opern, Conditional.Type.getOperatorFromIntValue(state & 0xFFFFFF7F), name, this._newRouteType));
                }
                ++i3;
            }
        }
        ArrayList<ConditionalVariable> oneTriggerList = new ArrayList<ConditionalVariable>();
        ArrayList<ConditionalVariable> twoTriggerList = new ArrayList<ConditionalVariable>();
        if (!this._initialize) {
            int i4 = 0;
            while (i4 < this._includedInputList.size()) {
                int type;
                Conditional.Operator opern;
                RouteInputElement elt = this._includedInputList.get(i4);
                String name = elt.getUserName();
                if (name == null || name.length() == 0) {
                    name = elt.getSysName();
                }
                Conditional.Operator operator = opern = this._newRouteType ? Conditional.Operator.OR : Conditional.Operator.AND;
                if (i4 == 0) {
                    opern = Conditional.Operator.NONE;
                }
                if (128 > (type = elt.getState())) {
                    if (32 == type) {
                        switch (elt.getType()) {
                            case 1: {
                                type = 1;
                                break;
                            }
                            case 2: {
                                type = 4;
                                break;
                            }
                            case 3: {
                                type = 7;
                                break;
                            }
                            case 4: {
                                type = 18;
                                break;
                            }
                            default: {
                                log.debug("updatePressed: Unknown state variable type {}", (Object)elt.getType());
                            }
                        }
                        twoTriggerList.add(new ConditionalVariable(false, opern, Conditional.Type.getOperatorFromIntValue(type), name, true));
                    } else {
                        oneTriggerList.add(new ConditionalVariable(false, opern, Conditional.Type.getOperatorFromIntValue(type), name, true));
                    }
                }
                ++i4;
            }
            if (actionList.isEmpty()) {
                JOptionPane.showMessageDialog(this._addFrame, rbx.getString("noAction"), rbx.getString("addErr"), 0);
                return;
            }
        } else {
            oneTriggerList.add(new ConditionalVariable(false, Conditional.Operator.NONE, Conditional.Type.NONE, LRouteTableAction.getLogixInitializer(), true));
        }
        if (log.isDebugEnabled()) {
            log.debug("actionList.size()= {}, oneTriggerList.size()= {}, twoTriggerList.size()= {}, onChangeList.size()= {}, vetoList.size()= {}", new Object[]{actionList.size(), oneTriggerList.size(), twoTriggerList.size(), onChangeList.size(), vetoList.size()});
        }
        logix.deActivateLogix();
        char[] ch = sName.toCharArray();
        int hash = 0;
        int i5 = 0;
        while (i5 < ch.length) {
            hash += ch[i5];
            ++i5;
        }
        String cSystemName = String.valueOf(this.getConditionalSystemPrefix()) + "T" + hash;
        this.removeConditionals(cSystemName, logix);
        cSystemName = String.valueOf(this.getConditionalSystemPrefix()) + "F" + hash;
        this.removeConditionals(cSystemName, logix);
        cSystemName = String.valueOf(this.getConditionalSystemPrefix()) + "A" + hash;
        this.removeConditionals(cSystemName, logix);
        cSystemName = String.valueOf(this.getConditionalSystemPrefix()) + "L" + hash;
        this.removeConditionals(cSystemName, logix);
        int n = 0;
        while (this.removeConditionals(cSystemName = String.valueOf(sName) + ++n + "A", logix)) {
        }
        n = 0;
        while (this.removeConditionals(cSystemName = String.valueOf(sName) + ++n + "T", logix)) {
        }
        cSystemName = String.valueOf(sName) + "L";
        this.removeConditionals(cSystemName, logix);
        int numConds = 1;
        if (this._newRouteType) {
            numConds = this.makeRouteConditional(numConds, actionList, oneTriggerList, vetoList, logix, sName, uName, "T");
            if (!this._initialize && twoTriggerList.size() > 0) {
                numConds = this.makeRouteConditional(numConds, onChangeList, twoTriggerList, null, logix, sName, uName, "T");
            }
        } else {
            i = 0;
            while (i < oneTriggerList.size()) {
                vList = new ArrayList<ConditionalVariable>();
                vList.add(oneTriggerList.get(i));
                numConds = this.makeRouteConditional(numConds, actionList, vList, vetoList, logix, sName, uName, "T");
                ++i;
            }
            i = 0;
            while (i < twoTriggerList.size()) {
                vList = new ArrayList();
                vList.add((ConditionalVariable)twoTriggerList.get(i));
                numConds = this.makeRouteConditional(numConds, onChangeList, vList, vetoList, logix, sName, uName, "T");
                ++i;
            }
        }
        if (numConds == 1) {
            JOptionPane.showMessageDialog(this._addFrame, rbx.getString("noVars"), rbx.getString("addErr"), 0);
            return;
        }
        numConds = 1;
        i = 0;
        while (i < this._includedAlignList.size()) {
            vList = new ArrayList();
            ArrayList<ConditionalAction> aList = new ArrayList<ConditionalAction>();
            AlignElement sensor = this._includedAlignList.get(i);
            String name = sensor.getUserName();
            if (name == null || name.length() == 0) {
                name = sensor.getSysName();
            }
            aList.add(new DefaultConditionalAction(1, Conditional.Action.SET_SENSOR, name, 2, ""));
            aList.add(new DefaultConditionalAction(2, Conditional.Action.SET_SENSOR, name, 4, ""));
            int alignType = sensor.getState();
            int k = 0;
            while (k < this._includedOutputList.size()) {
                RouteOutputElement elt = this._includedOutputList.get(k);
                Conditional.Type varType = Conditional.Type.NONE;
                boolean add = 6 == alignType;
                block12 : switch (elt.getType()) {
                    case 1: {
                        if (alignType == 1) {
                            add = true;
                        }
                        switch (elt.getState()) {
                            case 4: {
                                varType = Conditional.Type.SENSOR_INACTIVE;
                                break block12;
                            }
                            case 2: {
                                varType = Conditional.Type.SENSOR_ACTIVE;
                                break block12;
                            }
                            case 8: {
                                add = false;
                                break block12;
                            }
                        }
                        log.warn("Unexpected state {} from elt.getState() in SENSOR_TYPE", (Object)elt.getState());
                        break;
                    }
                    case 2: {
                        if (alignType == 2) {
                            add = true;
                        }
                        switch (elt.getState()) {
                            case 2: {
                                varType = Conditional.Type.TURNOUT_CLOSED;
                                break block12;
                            }
                            case 4: {
                                varType = Conditional.Type.TURNOUT_THROWN;
                                break block12;
                            }
                            case 8: {
                                add = false;
                                break block12;
                            }
                        }
                        log.warn("Unexpected state {} from elt.getState() in TURNOUT_TYPE", (Object)elt.getState());
                        break;
                    }
                    case 3: {
                        if (alignType == 3) {
                            add = true;
                        }
                        switch (elt.getState()) {
                            case 2: {
                                varType = Conditional.Type.LIGHT_ON;
                                break block12;
                            }
                            case 4: {
                                varType = Conditional.Type.LIGHT_OFF;
                                break block12;
                            }
                            case 8: {
                                add = false;
                                break block12;
                            }
                        }
                        log.warn("Unexpected state {} from elt.getState() in LIGHT_TYPE", (Object)elt.getState());
                        break;
                    }
                    case 4: {
                        if (alignType == 4) {
                            add = true;
                        }
                        switch (elt.getState()) {
                            case 0: 
                            case 54: {
                                varType = Conditional.Type.SIGNAL_HEAD_DARK;
                                break block12;
                            }
                            case 1: {
                                varType = Conditional.Type.SIGNAL_HEAD_RED;
                                break block12;
                            }
                            case 2: {
                                varType = Conditional.Type.SIGNAL_HEAD_FLASHRED;
                                break block12;
                            }
                            case 4: {
                                varType = Conditional.Type.SIGNAL_HEAD_YELLOW;
                                break block12;
                            }
                            case 8: {
                                varType = Conditional.Type.SIGNAL_HEAD_FLASHYELLOW;
                                break block12;
                            }
                            case 16: {
                                varType = Conditional.Type.SIGNAL_HEAD_GREEN;
                                break block12;
                            }
                            case 32: {
                                varType = Conditional.Type.SIGNAL_HEAD_FLASHGREEN;
                                break block12;
                            }
                            case 52: {
                                varType = Conditional.Type.SIGNAL_HEAD_HELD;
                                break block12;
                            }
                            case 53: {
                                add = false;
                                break block12;
                            }
                            case 55: {
                                varType = Conditional.Type.SIGNAL_HEAD_LIT;
                                break block12;
                            }
                        }
                        log.warn("Unexpected state {} from elt.getState() in SIGNAL_TYPE", (Object)elt.getState());
                        break;
                    }
                    default: {
                        log.debug("updatePressed: Unknown Alignment state variable type {}", (Object)elt.getType());
                    }
                }
                if (add && !this._initialize) {
                    String eltName = elt.getUserName();
                    if (eltName == null || eltName.length() == 0) {
                        eltName = elt.getSysName();
                    }
                    vList.add(new ConditionalVariable(false, Conditional.Operator.AND, varType, eltName, true));
                }
                ++k;
            }
            if (vList.size() > 0) {
                numConds = this.makeAlignConditional(numConds, aList, vList, logix, sName, uName);
            } else {
                JOptionPane.showMessageDialog(this._addFrame, MessageFormat.format(rbx.getString("NoAlign"), name, sensor.getAlignType()), Bundle.getMessage("WarningTitle"), 2);
            }
            ++i;
        }
        if (this._lock) {
            ArrayList<ConditionalAction> aList = new ArrayList<ConditionalAction>();
            int k = 0;
            while (k < this._includedOutputList.size()) {
                RouteOutputElement elt = this._includedOutputList.get(k);
                if (elt.getType() == 2 && elt.getState() != 8) {
                    String eltName = elt.getUserName();
                    if (eltName == null || eltName.length() == 0) {
                        eltName = elt.getSysName();
                    }
                    aList.add(new DefaultConditionalAction(1, Conditional.Action.LOCK_TURNOUT, eltName, 1, ""));
                    aList.add(new DefaultConditionalAction(2, Conditional.Action.LOCK_TURNOUT, eltName, 0, ""));
                }
                ++k;
            }
            this.makeRouteConditional(numConds, aList, oneTriggerList, vetoList, logix, sName, uName, "L");
        }
        log.debug("Conditionals added= {}", (Object)logix.getNumConditionals());
        i = 0;
        while (i < logix.getNumConditionals()) {
            log.debug("Conditional SysName= \"{}\"", (Object)logix.getConditionalByNumberOrder(i));
            ++i;
        }
        logix.activateLogix();
        log.debug("Conditionals added= {}", (Object)logix.getNumConditionals());
        i = 0;
        while (i < logix.getNumConditionals()) {
            log.debug("Conditional SysName= \"{}\"", (Object)logix.getConditionalByNumberOrder(i));
            ++i;
        }
        this.finishUpdate();
    }

    boolean removeConditionals(String cSystemName, Logix logix) {
        Conditional c = this._conditionalManager.getBySystemName(cSystemName);
        if (c != null) {
            logix.deleteConditional(cSystemName);
            return true;
        }
        return false;
    }

    int makeRouteConditional(int numConds, ArrayList<ConditionalAction> actionList, ArrayList<ConditionalVariable> triggerList, ArrayList<ConditionalVariable> vetoList, Logix logix, String sName, String uName, String type) {
        if (log.isDebugEnabled()) {
            log.debug("makeRouteConditional: numConds= {}, triggerList.size()= {}", (Object)numConds, (Object)triggerList.size());
        }
        if (triggerList.isEmpty() && (vetoList == null || vetoList.isEmpty())) {
            return numConds;
        }
        StringBuilder antecedent = new StringBuilder();
        ArrayList<ConditionalVariable> varList = new ArrayList<ConditionalVariable>();
        int tSize = triggerList.size();
        if (tSize > 0) {
            if (tSize > 1) {
                antecedent.append("(");
            }
            antecedent.append("R1");
            int i = 1;
            while (i < tSize) {
                antecedent.append(" ").append(Bundle.getMessage("LogicOR")).append(" R").append(i + 1);
                ++i;
            }
            if (tSize > 1) {
                antecedent.append(")");
            }
            i = 0;
            while (i < triggerList.size()) {
                varList.add(triggerList.get(i));
                ++i;
            }
        }
        if (vetoList != null && vetoList.size() > 0) {
            int vSize = vetoList.size();
            if (tSize > 0) {
                antecedent.append(" ").append(Bundle.getMessage("LogicAND")).append(" ");
            }
            if (vSize > 1) {
                antecedent.append("(");
            }
            antecedent.append(Bundle.getMessage("LogicNOT")).append(" R").append(1 + tSize);
            int i = 1;
            while (i < vSize) {
                antecedent.append(" ").append(Bundle.getMessage("LogicAND")).append(" ").append(Bundle.getMessage("LogicNOT")).append(" R").append(i + 1 + tSize);
                ++i;
            }
            if (vSize > 1) {
                antecedent.append(")");
            }
            i = 0;
            while (i < vetoList.size()) {
                varList.add(vetoList.get(i));
                ++i;
            }
        }
        String cSystemName = String.valueOf(sName) + numConds + type;
        String cUserName = CONDITIONAL_USER_PREFIX + numConds + "C " + uName;
        Conditional c = null;
        try {
            c = this._conditionalManager.createNewConditional(cSystemName, cUserName);
        }
        catch (Exception exception) {
            this.handleCreateException(sName);
            throw new IllegalArgumentException("user input no good");
        }
        c.setStateVariables(varList);
        c.setAction(actionList);
        Conditional.AntecedentOperator logicType = this._newRouteType ? Conditional.AntecedentOperator.MIXED : Conditional.AntecedentOperator.ALL_AND;
        c.setLogicType(logicType, antecedent.toString());
        logix.addConditional(cSystemName, 0);
        log.debug("Conditional added: SysName= \"{}\"", (Object)cSystemName);
        c.calculate(true, null);
        return ++numConds;
    }

    void handleCreateException(String sysName) {
        JOptionPane.showMessageDialog(this._addFrame, String.valueOf(Bundle.getMessage("ErrorLRouteAddFailed", sysName)) + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), Bundle.getMessage("ErrorTitle"), 0);
    }

    int makeAlignConditional(int numConds, ArrayList<ConditionalAction> actionList, ArrayList<ConditionalVariable> triggerList, Logix logix, String sName, String uName) {
        if (triggerList.isEmpty()) {
            return numConds;
        }
        String cSystemName = String.valueOf(sName) + numConds + "A";
        String cUserName = CONDITIONAL_USER_PREFIX + numConds + "A " + uName;
        Conditional c = null;
        try {
            c = this._conditionalManager.createNewConditional(cSystemName, cUserName);
        }
        catch (Exception exception) {
            this.handleCreateException(sName);
            throw new IllegalArgumentException("user input no good");
        }
        c.setStateVariables(triggerList);
        c.setAction(actionList);
        c.setLogicType(Conditional.AntecedentOperator.ALL_AND, "");
        logix.addConditional(cSystemName, 0);
        log.debug("Conditional added: SysName= \"{}\"", (Object)cSystemName);
        c.calculate(true, null);
        return ++numConds;
    }

    ArrayList<ConditionalAction> cloneActionList(ArrayList<ConditionalAction> actionList, int option) {
        ArrayList<ConditionalAction> list = new ArrayList<ConditionalAction>();
        int i = 0;
        while (i < actionList.size()) {
            ConditionalAction action = actionList.get(i);
            DefaultConditionalAction clone = new DefaultConditionalAction();
            clone.setType(action.getType());
            clone.setOption(option);
            clone.setDeviceName(action.getDeviceName());
            clone.setActionData(action.getActionData());
            clone.setActionString(action.getActionString());
            list.add(clone);
            ++i;
        }
        return list;
    }

    void finishUpdate() {
        this.routeDirty = true;
        this.clearPage();
    }

    void clearPage() {
        this.cancelIncludedOnly();
        this.deleteButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.updateButton.setVisible(false);
        this.createButton.setVisible(false);
        this._systemName.setText("");
        this._userName.setText("");
        this.soundFile.setText("");
        this.scriptFile.setText("");
        int i = this._inputList.size() - 1;
        while (i >= 0) {
            this._inputList.get(i).setIncluded(false);
            --i;
        }
        i = this._outputList.size() - 1;
        while (i >= 0) {
            this._outputList.get(i).setIncluded(false);
            --i;
        }
        i = this._alignList.size() - 1;
        while (i >= 0) {
            this._alignList.get(i).setIncluded(false);
            --i;
        }
        this._lock = false;
        this._newRouteType = true;
        this._newRouteButton.doClick();
        this._lockCheckBox.setSelected(this._lock);
        if (this.routeDirty) {
            this.showReminderMessage();
            this.routeDirty = false;
        }
        this._addFrame.setVisible(false);
    }

    void cancelIncludedOnly() {
        if (!this._showAllInput) {
            this._inputAllButton.doClick();
        }
        if (!this._showAllOutput) {
            this._outputAllButton.doClick();
        }
        if (!this._showAllAlign) {
            this._alignAllButton.doClick();
        }
    }

    private String[] getInputComboBoxItems(int type) {
        switch (type) {
            case 1: {
                return INPUT_SENSOR_STATES;
            }
            case 2: {
                return INPUT_TURNOUT_STATES;
            }
            case 3: {
                return INPUT_LIGHT_STATES;
            }
            case 4: {
                return INPUT_SIGNAL_STATES;
            }
        }
        log.warn("Unhandled object type: {}", (Object)type);
        return new String[0];
    }

    private String[] getOutputComboBoxItems(int type) {
        switch (type) {
            case 1: {
                return OUTPUT_SENSOR_STATES;
            }
            case 2: {
                return OUTPUT_TURNOUT_STATES;
            }
            case 3: {
                return OUTPUT_LIGHT_STATES;
            }
            case 4: {
                return OUTPUT_SIGNAL_STATES;
            }
        }
        log.warn("Unhandled type: {}", (Object)type);
        return new String[0];
    }

    private static String getLogixSystemPrefix() {
        return String.valueOf(InstanceManager.getDefault(LogixManager.class).getSystemNamePrefix()) + ":RTX";
    }

    public static String getLogixInitializer() {
        return String.valueOf(LRouteTableAction.getLogixSystemPrefix()) + "INITIALIZER";
    }

    private String getConditionalSystemPrefix() {
        return String.valueOf(LRouteTableAction.getLogixSystemPrefix()) + "C";
    }

    @Override
    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "remindSaveRoute", Bundle.getMessage("HideSaveReminder"));
        super.setMessagePreferencesDetails();
    }

    @Override
    protected String getClassName() {
        return LRouteTableAction.class.getName();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleLRouteTable");
    }

    class AlignElement
    extends RouteElement {
        AlignElement(String sysName, String userName) {
            super(sysName, userName, 1);
            this.setState(2);
        }

        String getAlignType() {
            switch (this._state) {
                case 1: {
                    return ALIGN_SENSOR;
                }
                case 2: {
                    return ALIGN_TURNOUT;
                }
                case 3: {
                    return ALIGN_LIGHT;
                }
                case 4: {
                    return ALIGN_SIGNAL;
                }
                case 6: {
                    return ALIGN_ALL;
                }
            }
            log.warn("Unhandled align type state: {}", (Object)this._state);
            return "";
        }

        void setAlignType(String state) {
            if (ALIGN_SENSOR.equals(state)) {
                this._state = 1;
            } else if (ALIGN_TURNOUT.equals(state)) {
                this._state = 2;
            } else if (ALIGN_LIGHT.equals(state)) {
                this._state = 3;
            } else if (ALIGN_SIGNAL.equals(state)) {
                this._state = 4;
            } else if (ALIGN_ALL.equals(state)) {
                this._state = 6;
            }
        }
    }

    class AlignmentModel
    extends RouteElementModel {
        AlignmentModel() {
        }

        @Override
        public boolean isInput() {
            return false;
        }

        @Override
        public String getColumnName(int c) {
            if (c == 4) {
                return rbx.getString("Alignment");
            }
            return super.getColumnName(c);
        }

        @Override
        public int getRowCount() {
            if (LRouteTableAction.this._showAllAlign) {
                return LRouteTableAction.this._alignList.size();
            }
            return LRouteTableAction.this._includedAlignList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            ArrayList alignList = LRouteTableAction.this._showAllAlign ? LRouteTableAction.this._alignList : LRouteTableAction.this._includedAlignList;
            if (r >= alignList.size()) {
                log.debug("row out of range");
                return null;
            }
            switch (c) {
                case 0: {
                    return ((AlignElement)alignList.get(r)).getSysName();
                }
                case 1: {
                    return ((AlignElement)alignList.get(r)).getUserName();
                }
                case 3: {
                    return ((AlignElement)alignList.get(r)).isIncluded();
                }
                case 2: {
                    return Bundle.getMessage("BeanNameSensor");
                }
                case 4: {
                    return ((AlignElement)alignList.get(r)).getAlignType();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            ArrayList alignList = LRouteTableAction.this._showAllAlign ? LRouteTableAction.this._alignList : LRouteTableAction.this._includedAlignList;
            switch (c) {
                case 3: {
                    ((AlignElement)alignList.get(r)).setIncluded((Boolean)type);
                    break;
                }
                case 4: {
                    ((AlignElement)alignList.get(r)).setAlignType((String)type);
                    break;
                }
                default: {
                    log.warn("Unexpected column {} in setValueAt", (Object)c);
                }
            }
        }
    }

    public class ComboBoxCellEditor
    extends DefaultCellEditor {
        ComboBoxCellEditor() {
            super(new JComboBox());
        }

        ComboBoxCellEditor(JComboBox<String> comboBox) {
            super(comboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String[] items;
            RouteElement elt;
            RouteElementModel model = (RouteElementModel)table.getModel();
            if (model.isInput()) {
                elt = LRouteTableAction.this._showAllInput ? (RouteElement)LRouteTableAction.this._inputList.get(row) : (RouteElement)LRouteTableAction.this._includedInputList.get(row);
                items = LRouteTableAction.this.getInputComboBoxItems(elt.getType());
            } else {
                elt = LRouteTableAction.this._showAllOutput ? (RouteElement)LRouteTableAction.this._outputList.get(row) : (RouteElement)LRouteTableAction.this._includedOutputList.get(row);
                items = LRouteTableAction.this.getOutputComboBoxItems(elt.getType());
            }
            JComboBox comboBox = (JComboBox)this.getComponent();
            comboBox.removeAllItems();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                comboBox.addItem(item);
                ++n2;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class LBeanTableDataModel
    extends BeanTableDataModel<Logix> {
        public static final int ENABLECOL = 2;
        public static final int EDITCOL = 4;
        protected String enabledString = Bundle.getMessage("ColumnHeadEnabled");

        LBeanTableDataModel() {
        }

        @Override
        protected synchronized void updateNameList() {
            if (this.sysNameList != null) {
                int i = 0;
                while (i < this.sysNameList.size()) {
                    Logix b2 = this.getBySystemName((String)this.sysNameList.get(i));
                    if (b2 != null) {
                        b2.removePropertyChangeListener(this);
                    }
                    ++i;
                }
            }
            this.sysNameList = new ArrayList();
            this.getManager().getNamedBeanSet().forEach(b -> {
                if (b.getSystemName().startsWith(LRouteTableAction.getLogixSystemPrefix())) {
                    this.sysNameList.add(b.getSystemName());
                    b.addPropertyChangeListener(this);
                }
            });
            log.debug("updateNameList: sysNameList size= {}", (Object)this.sysNameList.size());
        }

        @Override
        public String getColumnName(int col) {
            if (col == 4) {
                return "";
            }
            if (col == 2) {
                return this.enabledString;
            }
            return super.getColumnName(col);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 4) {
                return JButton.class;
            }
            if (col == 2) {
                return Boolean.class;
            }
            return super.getColumnClass(col);
        }

        @Override
        public int getPreferredWidth(int col) {
            if (col == 0) {
                return new JTextField((int)20).getPreferredSize().width;
            }
            if (col == 1) {
                return new JTextField((int)25).getPreferredSize().width;
            }
            if (col == 4) {
                return new JTextField((String)Bundle.getMessage((String)"ButtonEdit")).getPreferredSize().width + 4;
            }
            if (col == 2) {
                return new JTextField((int)5).getPreferredSize().width;
            }
            if (col == 3) {
                return new JTextField((int)25).getPreferredSize().width;
            }
            return super.getPreferredWidth(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 4) {
                return true;
            }
            if (col == 2) {
                return true;
            }
            return super.isCellEditable(row, col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 4: {
                    return Bundle.getMessage("ButtonEdit");
                }
                case 2: {
                    return ((Logix)this.getValueAt(row, 0)).getEnabled();
                }
            }
            return super.getValueAt(row, col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 4: {
                    String sName = ((Logix)this.getValueAt(row, 0)).getSystemName();
                    LRouteTableAction.this.editPressed(sName);
                    break;
                }
                case 2: {
                    Logix x = (Logix)this.getValueAt(row, 0);
                    boolean v = x.getEnabled();
                    x.setEnabled(!v);
                    break;
                }
                default: {
                    super.setValueAt(value, row, col);
                }
            }
        }

        @Override
        protected void doDelete(Logix logix) {
            if (logix != null) {
                logix.deActivateLogix();
                LRouteTableAction.this._logixManager.deleteLogix(logix);
            }
        }

        @Override
        protected boolean matchPropertyName(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(this.enabledString)) {
                return true;
            }
            return super.matchPropertyName(e);
        }

        @Override
        public Manager<Logix> getManager() {
            return LRouteTableAction.this._logixManager;
        }

        @Override
        public Logix getBySystemName(@Nonnull String name) {
            return LRouteTableAction.this._logixManager.getBySystemName(name);
        }

        @Override
        public Logix getByUserName(@Nonnull String name) {
            return LRouteTableAction.this._logixManager.getByUserName(name);
        }

        @Override
        protected String getMasterClassName() {
            return LRouteTableAction.this.getClassName();
        }

        @Override
        public void configureTable(JTable table) {
            table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
            table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
            table.setDefaultEditor(JComboBox.class, new ValueEditor());
            super.configureTable(table);
        }

        @Override
        public void clickOn(Logix t) {
        }

        @Override
        public String getValue(String s) {
            return "";
        }

        @Override
        protected void configDeleteColumn(JTable table) {
            this.setColumnToHoldButton(table, 4, new JButton(Bundle.getMessage("ButtonEdit")));
        }

        @Override
        protected void configValueColumn(JTable table) {
        }

        @Override
        protected String getBeanType() {
            return "LRoute";
        }
    }

    static class RouteElement {
        String _sysName;
        String _userName;
        int _type;
        String _typeString;
        boolean _included;
        int _state;

        RouteElement(String sysName, String userName, int type) {
            this._sysName = sysName;
            this._userName = userName;
            this._type = type;
            this._included = false;
            switch (type) {
                case 1: {
                    this._typeString = Bundle.getMessage("BeanNameSensor");
                    break;
                }
                case 2: {
                    this._typeString = Bundle.getMessage("BeanNameTurnout");
                    break;
                }
                case 3: {
                    this._typeString = Bundle.getMessage("BeanNameLight");
                    break;
                }
                case 4: {
                    this._typeString = Bundle.getMessage("BeanNameSignalHead");
                    break;
                }
                case 5: {
                    this._typeString = Bundle.getMessage("BeanNameConditional");
                    break;
                }
                default: {
                    log.warn("Unexpected type {} in RouteElement constructor", (Object)type);
                }
            }
        }

        String getSysName() {
            return this._sysName;
        }

        String getUserName() {
            return this._userName;
        }

        int getType() {
            return this._type;
        }

        String getTypeString() {
            return this._typeString;
        }

        boolean isIncluded() {
            return this._included;
        }

        void setIncluded(boolean include) {
            this._included = include;
        }

        int getState() {
            return this._state;
        }

        void setState(int state) {
            this._state = state;
        }
    }

    public static class RouteElementComparator
    implements Comparator<RouteElement> {
        static AlphanumComparator ac = new AlphanumComparator();

        RouteElementComparator() {
        }

        @Override
        public int compare(RouteElement e1, RouteElement e2) {
            char c2;
            String s1 = e1.getSysName();
            String s2 = e2.getSysName();
            int p1len = Manager.getSystemPrefixLength(s1);
            int p2len = Manager.getSystemPrefixLength(s2);
            int comp = ac.compare(s1.substring(0, p1len), s2.substring(0, p2len));
            if (comp != 0) {
                return comp;
            }
            char c1 = s1.charAt(p1len);
            if (c1 == (c2 = s2.charAt(p2len))) {
                return ac.compare(s1.substring(p1len + 1), s2.substring(p2len + 1));
            }
            return c1 > c2 ? 1 : -1;
        }
    }

    public abstract class RouteElementModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SNAME_COLUMN = 0;
        public static final int UNAME_COLUMN = 1;
        public static final int TYPE_COLUMN = 2;
        public static final int INCLUDE_COLUMN = 3;
        public static final int STATE_COLUMN = 4;

        public abstract boolean isInput();

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 3) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return Bundle.getMessage("ColumnSystemName");
                }
                case 1: {
                    return Bundle.getMessage("ColumnUserName");
                }
                case 2: {
                    return rbx.getString("Type");
                }
                case 3: {
                    return Bundle.getMessage("Include");
                }
            }
            log.warn("Unhandled column type: {}", (Object)c);
            return "";
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 3 || c == 4;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        public void dispose() {
            InstanceManager.turnoutManagerInstance().removePropertyChangeListener(this);
        }
    }

    abstract class RouteInputElement
    extends RouteElement {
        RouteInputElement(String sysName, String userName, int type) {
            super(sysName, userName, type);
        }

        abstract String getTestState();

        abstract void setTestState(String var1);
    }

    class RouteInputLight
    extends RouteInputElement {
        RouteInputLight(String sysName, String userName) {
            super(sysName, userName, 3);
            this.setState(8);
        }

        @Override
        String getTestState() {
            switch (this._state) {
                case 8: {
                    return ON_UNLIT;
                }
                case 7: {
                    return ON_LIT;
                }
                case 32: {
                    return ON_CHANGE;
                }
                case 136: {
                    return VETO_ON_UNLIT;
                }
                case 135: {
                    return VETO_ON_LIT;
                }
            }
            log.warn("Unhandled test state: {}", (Object)this._state);
            return "";
        }

        @Override
        void setTestState(String state) {
            if (ON_UNLIT.equals(state)) {
                this._state = 8;
            } else if (ON_LIT.equals(state)) {
                this._state = 7;
            } else if (ON_CHANGE.equals(state)) {
                this._state = 32;
            } else if (VETO_ON_UNLIT.equals(state)) {
                this._state = 136;
            } else if (VETO_ON_LIT.equals(state)) {
                this._state = 135;
            }
        }
    }

    class RouteInputModel
    extends RouteElementModel {
        RouteInputModel() {
        }

        @Override
        public boolean isInput() {
            return true;
        }

        @Override
        public String getColumnName(int c) {
            if (c == 4) {
                return rbx.getString("SetTrigger");
            }
            return super.getColumnName(c);
        }

        @Override
        public int getRowCount() {
            if (LRouteTableAction.this._showAllInput) {
                return LRouteTableAction.this._inputList.size();
            }
            return LRouteTableAction.this._includedInputList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            ArrayList inputList = LRouteTableAction.this._showAllInput ? LRouteTableAction.this._inputList : LRouteTableAction.this._includedInputList;
            if (r >= inputList.size()) {
                log.debug("row out of range");
                return null;
            }
            switch (c) {
                case 0: {
                    return ((RouteInputElement)inputList.get(r)).getSysName();
                }
                case 1: {
                    return ((RouteInputElement)inputList.get(r)).getUserName();
                }
                case 2: {
                    return ((RouteInputElement)inputList.get(r)).getTypeString();
                }
                case 3: {
                    return ((RouteInputElement)inputList.get(r)).isIncluded();
                }
                case 4: {
                    return ((RouteInputElement)inputList.get(r)).getTestState();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            ArrayList inputList = LRouteTableAction.this._showAllInput ? LRouteTableAction.this._inputList : LRouteTableAction.this._includedInputList;
            switch (c) {
                case 3: {
                    ((RouteInputElement)inputList.get(r)).setIncluded((Boolean)type);
                    break;
                }
                case 4: {
                    ((RouteInputElement)inputList.get(r)).setTestState((String)type);
                    break;
                }
                default: {
                    log.warn("Unexpected column {} in setValueAt", (Object)c);
                }
            }
        }
    }

    class RouteInputSensor
    extends RouteInputElement {
        RouteInputSensor(String sysName, String userName) {
            super(sysName, userName, 1);
            this.setState(1);
        }

        @Override
        String getTestState() {
            switch (this._state) {
                case 2: {
                    return ON_INACTIVE;
                }
                case 1: {
                    return ON_ACTIVE;
                }
                case 32: {
                    return ON_CHANGE;
                }
                case 130: {
                    return VETO_ON_INACTIVE;
                }
                case 129: {
                    return VETO_ON_ACTIVE;
                }
            }
            log.error("Unhandled test state type: {}", (Object)this._state);
            return "";
        }

        @Override
        void setTestState(String state) {
            if (ON_INACTIVE.equals(state)) {
                this._state = 2;
            } else if (ON_ACTIVE.equals(state)) {
                this._state = 1;
            } else if (ON_CHANGE.equals(state)) {
                this._state = 32;
            } else if (VETO_ON_INACTIVE.equals(state)) {
                this._state = 130;
            } else if (VETO_ON_ACTIVE.equals(state)) {
                this._state = 129;
            }
        }
    }

    class RouteInputSignal
    extends RouteInputElement {
        RouteInputSignal(String sysName, String userName) {
            super(sysName, userName, 4);
            this.setState(18);
        }

        @Override
        String getTestState() {
            switch (this._state) {
                case 11: {
                    return ON_RED;
                }
                case 15: {
                    return ON_FLASHRED;
                }
                case 12: {
                    return ON_YELLOW;
                }
                case 16: {
                    return ON_FLASHYELLOW;
                }
                case 13: {
                    return ON_GREEN;
                }
                case 17: {
                    return ON_FLASHGREEN;
                }
                case 14: {
                    return ON_DARK;
                }
                case 18: {
                    return ON_SIGNAL_LIT;
                }
                case 19: {
                    return ON_SIGNAL_HELD;
                }
                case 139: {
                    return VETO_ON_RED;
                }
                case 143: {
                    return VETO_ON_FLASHRED;
                }
                case 140: {
                    return VETO_ON_YELLOW;
                }
                case 144: {
                    return VETO_ON_FLASHYELLOW;
                }
                case 141: {
                    return VETO_ON_GREEN;
                }
                case 145: {
                    return VETO_ON_FLASHGREEN;
                }
                case 142: {
                    return VETO_ON_DARK;
                }
                case 146: {
                    return VETO_ON_SIGNAL_LIT;
                }
                case 147: {
                    return VETO_ON_SIGNAL_HELD;
                }
            }
            log.warn("Unhandled test state: {}", (Object)this._state);
            return "";
        }

        @Override
        void setTestState(String state) {
            if (ON_RED.equals(state)) {
                this._state = 11;
            } else if (ON_FLASHRED.equals(state)) {
                this._state = 15;
            } else if (ON_YELLOW.equals(state)) {
                this._state = 12;
            } else if (ON_FLASHYELLOW.equals(state)) {
                this._state = 16;
            } else if (ON_GREEN.equals(state)) {
                this._state = 13;
            } else if (ON_FLASHGREEN.equals(state)) {
                this._state = 17;
            } else if (ON_DARK.equals(state)) {
                this._state = 14;
            } else if (ON_SIGNAL_LIT.equals(state)) {
                this._state = 18;
            } else if (ON_SIGNAL_HELD.equals(state)) {
                this._state = 19;
            } else if (VETO_ON_RED.equals(state)) {
                this._state = 139;
            } else if (VETO_ON_FLASHRED.equals(state)) {
                this._state = 143;
            } else if (VETO_ON_YELLOW.equals(state)) {
                this._state = 140;
            } else if (VETO_ON_FLASHYELLOW.equals(state)) {
                this._state = 144;
            } else if (VETO_ON_GREEN.equals(state)) {
                this._state = 141;
            } else if (VETO_ON_FLASHGREEN.equals(state)) {
                this._state = 145;
            } else if (VETO_ON_DARK.equals(state)) {
                this._state = 142;
            } else if (VETO_ON_SIGNAL_LIT.equals(state)) {
                this._state = 146;
            } else if (VETO_ON_SIGNAL_HELD.equals(state)) {
                this._state = 147;
            }
        }
    }

    class RouteInputTurnout
    extends RouteInputElement {
        RouteInputTurnout(String sysName, String userName) {
            super(sysName, userName, 2);
            this.setState(4);
        }

        @Override
        String getTestState() {
            switch (this._state) {
                case 4: {
                    return ON_CLOSED;
                }
                case 3: {
                    return ON_THROWN;
                }
                case 32: {
                    return ON_CHANGE;
                }
                case 132: {
                    return VETO_ON_CLOSED;
                }
                case 131: {
                    return VETO_ON_THROWN;
                }
            }
            log.warn("Unhandled test state type: {}", (Object)this._state);
            return "";
        }

        @Override
        void setTestState(String state) {
            if (ON_CLOSED.equals(state)) {
                this._state = 4;
            } else if (ON_THROWN.equals(state)) {
                this._state = 3;
            } else if (ON_CHANGE.equals(state)) {
                this._state = 32;
            } else if (VETO_ON_CLOSED.equals(state)) {
                this._state = 132;
            } else if (VETO_ON_THROWN.equals(state)) {
                this._state = 131;
            }
        }
    }

    abstract class RouteOutputElement
    extends RouteElement {
        RouteOutputElement(String sysName, String userName, int type) {
            super(sysName, userName, type);
        }

        abstract String getSetToState();

        abstract void setSetToState(String var1);
    }

    class RouteOutputLight
    extends RouteOutputElement {
        RouteOutputLight(String sysName, String userName) {
            super(sysName, userName, 3);
            this.setState(2);
        }

        @Override
        String getSetToState() {
            switch (this._state) {
                case 2: {
                    return SET_TO_ON;
                }
                case 4: {
                    return SET_TO_OFF;
                }
                case 8: {
                    return SET_TO_TOGGLE;
                }
            }
            log.warn("Unhandled set to state: {}", (Object)this._state);
            return "";
        }

        @Override
        void setSetToState(String state) {
            if (SET_TO_ON.equals(state)) {
                this._state = 2;
            } else if (SET_TO_OFF.equals(state)) {
                this._state = 4;
            } else if (SET_TO_TOGGLE.equals(state)) {
                this._state = 8;
            }
        }
    }

    class RouteOutputModel
    extends RouteElementModel {
        RouteOutputModel() {
        }

        @Override
        public boolean isInput() {
            return false;
        }

        @Override
        public String getColumnName(int c) {
            if (c == 4) {
                return rbx.getString("SetAction");
            }
            return super.getColumnName(c);
        }

        @Override
        public int getRowCount() {
            if (LRouteTableAction.this._showAllOutput) {
                return LRouteTableAction.this._outputList.size();
            }
            return LRouteTableAction.this._includedOutputList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            ArrayList outputList = LRouteTableAction.this._showAllOutput ? LRouteTableAction.this._outputList : LRouteTableAction.this._includedOutputList;
            if (r >= outputList.size()) {
                log.debug("row out of range");
                return null;
            }
            switch (c) {
                case 0: {
                    return ((RouteOutputElement)outputList.get(r)).getSysName();
                }
                case 1: {
                    return ((RouteOutputElement)outputList.get(r)).getUserName();
                }
                case 3: {
                    return ((RouteOutputElement)outputList.get(r)).isIncluded();
                }
                case 2: {
                    return ((RouteOutputElement)outputList.get(r)).getTypeString();
                }
                case 4: {
                    return ((RouteOutputElement)outputList.get(r)).getSetToState();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            ArrayList outputList = LRouteTableAction.this._showAllOutput ? LRouteTableAction.this._outputList : LRouteTableAction.this._includedOutputList;
            switch (c) {
                case 3: {
                    ((RouteOutputElement)outputList.get(r)).setIncluded((Boolean)type);
                    break;
                }
                case 4: {
                    ((RouteOutputElement)outputList.get(r)).setSetToState((String)type);
                    break;
                }
                default: {
                    log.warn("Unexpected column {} in setValueAt", (Object)c);
                }
            }
        }
    }

    class RouteOutputSensor
    extends RouteOutputElement {
        RouteOutputSensor(String sysName, String userName) {
            super(sysName, userName, 1);
            this.setState(2);
        }

        @Override
        String getSetToState() {
            switch (this._state) {
                case 4: {
                    return SET_TO_INACTIVE;
                }
                case 2: {
                    return SET_TO_ACTIVE;
                }
                case 8: {
                    return SET_TO_TOGGLE;
                }
            }
            log.warn("Unhandled set to state: {}", (Object)this._state);
            return "";
        }

        @Override
        void setSetToState(String state) {
            if (SET_TO_INACTIVE.equals(state)) {
                this._state = 4;
            } else if (SET_TO_ACTIVE.equals(state)) {
                this._state = 2;
            } else if (SET_TO_TOGGLE.equals(state)) {
                this._state = 8;
            }
        }
    }

    class RouteOutputSignal
    extends RouteOutputElement {
        RouteOutputSignal(String sysName, String userName) {
            super(sysName, userName, 4);
            this.setState(1);
        }

        @Override
        String getSetToState() {
            switch (this._state) {
                case 0: {
                    return SET_TO_DARK;
                }
                case 1: {
                    return SET_TO_RED;
                }
                case 2: {
                    return SET_TO_FLASHRED;
                }
                case 4: {
                    return SET_TO_YELLOW;
                }
                case 8: {
                    return SET_TO_FLASHYELLOW;
                }
                case 16: {
                    return SET_TO_GREEN;
                }
                case 32: {
                    return SET_TO_FLASHGREEN;
                }
                case 53: {
                    return SET_TO_CLEAR;
                }
                case 55: {
                    return SET_TO_LIT;
                }
                case 52: {
                    return SET_TO_HELD;
                }
            }
            log.warn("Unhandled set to state: {}", (Object)this._state);
            return "";
        }

        @Override
        void setSetToState(String state) {
            if (SET_TO_DARK.equals(state)) {
                this._state = 0;
            } else if (SET_TO_RED.equals(state)) {
                this._state = 1;
            } else if (SET_TO_FLASHRED.equals(state)) {
                this._state = 2;
            } else if (SET_TO_YELLOW.equals(state)) {
                this._state = 4;
            } else if (SET_TO_FLASHYELLOW.equals(state)) {
                this._state = 8;
            } else if (SET_TO_GREEN.equals(state)) {
                this._state = 16;
            } else if (SET_TO_FLASHGREEN.equals(state)) {
                this._state = 32;
            } else if (SET_TO_CLEAR.equals(state)) {
                this._state = 53;
            } else if (SET_TO_LIT.equals(state)) {
                this._state = 55;
            } else if (SET_TO_HELD.equals(state)) {
                this._state = 52;
            }
        }
    }

    class RouteOutputTurnout
    extends RouteOutputElement {
        RouteOutputTurnout(String sysName, String userName) {
            super(sysName, userName, 2);
            this.setState(2);
        }

        @Override
        String getSetToState() {
            switch (this._state) {
                case 2: {
                    return SET_TO_CLOSED;
                }
                case 4: {
                    return SET_TO_THROWN;
                }
                case 8: {
                    return SET_TO_TOGGLE;
                }
            }
            log.warn("Unhandled set to state: {}", (Object)this._state);
            return "";
        }

        @Override
        void setSetToState(String state) {
            if (SET_TO_CLOSED.equals(state)) {
                this._state = 2;
            } else if (SET_TO_THROWN.equals(state)) {
                this._state = 4;
            } else if (SET_TO_TOGGLE.equals(state)) {
                this._state = 8;
            }
        }
    }
}

