/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableRowSorter;
import jmri.NamedBean;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.swing.RowSorterUtil;
import jmri.util.swing.JmriPanel;

public class BeanTablePane<E extends NamedBean>
extends JmriPanel {
    BeanTableDataModel<E> dataModel;
    JTable dataTable;
    JScrollPane dataScroll;
    Box bottomBox;
    int bottomBoxIndex;
    static final int bottomStrutWidth = 20;

    public void init(BeanTableDataModel<E> model) {
        this.dataModel = model;
        TableRowSorter<BeanTableDataModel<E>> sorter = new TableRowSorter<BeanTableDataModel<E>>(this.dataModel);
        this.dataTable = this.dataModel.makeJTable(this.dataModel.getMasterClassName(), this.dataModel, sorter);
        this.dataScroll = new JScrollPane(this.dataTable);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        this.dataTable.setRowSorter(sorter);
        this.dataModel.configureTable(this.dataTable);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.dataScroll);
        this.bottomBox = Box.createHorizontalBox();
        this.bottomBox.add(Box.createHorizontalGlue());
        this.bottomBoxIndex = 0;
        this.add(this.bottomBox);
        this.extras();
        Dimension dataTableSize = this.dataTable.getPreferredSize();
        dataTableSize.height = Math.max(dataTableSize.height, 400);
        this.dataScroll.getViewport().setPreferredSize(dataTableSize);
        this.dataScroll.setHorizontalScrollBarPolicy(32);
        this.dataScroll.setVerticalScrollBarPolicy(22);
    }

    void extras() {
    }

    protected Box getBottomBox() {
        return this.bottomBox;
    }

    protected void addToBottomBox(Component comp) {
        this.bottomBox.add(Box.createHorizontalStrut(20), this.bottomBoxIndex);
        ++this.bottomBoxIndex;
        this.bottomBox.add(comp, this.bottomBoxIndex);
        ++this.bottomBoxIndex;
    }

    @Override
    public void dispose() {
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
        this.dataModel = null;
        this.dataTable = null;
        this.dataScroll = null;
    }
}

