/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableRowSorter;
import jmri.NamedBean;
import jmri.configurexml.StoreMenu;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanTableFrame<E extends NamedBean>
extends JmriJFrame {
    BeanTableDataModel<E> dataModel;
    JTable dataTable;
    JScrollPane dataScroll;
    Box bottomBox;
    int bottomBoxIndex;
    static final int bottomStrutWidth = 20;
    private static final Logger log = LoggerFactory.getLogger(BeanTableFrame.class);

    public BeanTableFrame() {
    }

    public BeanTableFrame(String s) {
        super(s);
    }

    public BeanTableFrame(BeanTableDataModel<E> model, String helpTarget, JTable dataTab) {
        this.dataModel = model;
        this.dataTable = dataTab;
        this.dataScroll = new JScrollPane(this.dataTable);
        TableRowSorter<BeanTableDataModel<E>> sorter = new TableRowSorter<BeanTableDataModel<E>>(this.dataModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        sorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(sorter, 1, SortOrder.ASCENDING);
        this.dataTable.setRowSorter(sorter);
        this.dataModel.configureTable(this.dataTable);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        menuBar.add(fileMenu);
        fileMenu.add(new StoreMenu());
        JMenuItem printItem = new JMenuItem(Bundle.getMessage("PrintTable"));
        fileMenu.add(printItem);
        printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MessageFormat footerFormat = new MessageFormat(String.valueOf(BeanTableFrame.this.getTitle()) + " page {0,number}");
                    BeanTableFrame.this.dataTable.print(JTable.PrintMode.FIT_WIDTH, null, footerFormat);
                }
                catch (PrinterException e1) {
                    log.warn("error printing: {}", (Object)e1, (Object)e1);
                }
            }
        });
        this.setJMenuBar(menuBar);
        this.addHelpMenu(helpTarget, true);
        this.getContentPane().add(this.dataScroll);
        this.bottomBox = Box.createHorizontalBox();
        this.bottomBox.add(Box.createHorizontalGlue());
        this.bottomBoxIndex = 0;
        this.getContentPane().add(this.bottomBox);
        this.extras();
        Dimension dataTableSize = this.dataTable.getPreferredSize();
        dataTableSize.height = Math.max(dataTableSize.height, 400);
        this.dataScroll.getViewport().setPreferredSize(dataTableSize);
        this.dataScroll.setHorizontalScrollBarPolicy(32);
        this.dataScroll.setVerticalScrollBarPolicy(22);
        this.dataModel.persistTable(this.dataTable);
    }

    void extras() {
    }

    protected Box getBottomBox() {
        return this.bottomBox;
    }

    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="param c is required in the listedtableframe")
    protected void addToBottomBox(Component comp, String c) {
        this.bottomBox.add(Box.createHorizontalStrut(20), this.bottomBoxIndex);
        ++this.bottomBoxIndex;
        this.bottomBox.add(comp, this.bottomBoxIndex);
        ++this.bottomBoxIndex;
    }

    @Override
    public void dispose() {
        if (this.dataModel != null) {
            this.dataModel.stopPersistingTable(this.dataTable);
            this.dataModel.dispose();
        }
        this.dataModel = null;
        this.dataTable = null;
        this.dataScroll = null;
        super.dispose();
    }
}

